/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactNodeSelector;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ArtifactNodeSelectorImpl
implements ArtifactNodeSelector {
    private static final Logger LOG = Logger.getLogger(ArtifactNodeSelectorImpl.class.getName());

    public void select(final NBVersionInfo artifact) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                TopComponent tab = WindowManager.getDefault().findTopComponent("services");
                if (tab == null) {
                    LOG.fine("No ServicesTab found");
                    return;
                }
                tab.open();
                tab.requestActive();
                if (!(tab instanceof ExplorerManager.Provider)) {
                    LOG.fine("ServicesTab not an ExplorerManager.Provider");
                    return;
                }
                final ExplorerManager mgr = ((ExplorerManager.Provider)tab).getExplorerManager();
                final Node root = mgr.getRootContext();
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        Node _selected;
                        try {
                            _selected = NodeOp.findPath((Node)root, (String[])new String[]{"M2RepositoryBrowser", artifact.getRepoId(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()});
                        }
                        catch (NodeNotFoundException x) {
                            LOG.log(Level.FINE, "Could not find subnode", x);
                            _selected = x.getClosestNode();
                        }
                        final Node selected = _selected;
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    mgr.setSelectedNodes(new Node[]{selected});
                                }
                                catch (PropertyVetoException x) {
                                    LOG.log(Level.FINE, "Could not select path", x);
                                }
                            }
                        });
                    }
                });
            }
        });
    }
}

