/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.modules.j2ee.ejbverification.rules.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;

public final class BeanImplementsBI {
    private BeanImplementsBI() {
    }

    public static Collection<ErrorDescription> run(HintContext hintContext) {
        ArrayList<ErrorDescription> problems = new ArrayList<ErrorDescription>();
        EJBProblemContext ctx = HintsUtils.getOrCacheContext(hintContext);
        if (ctx != null && ctx.getEjb() instanceof Session) {
            ArrayList<String> businessInterFaces = new ArrayList<String>();
            BeanImplementsBI.processAnnotation(businessInterFaces, ctx.getClazz(), "javax.ejb.Local");
            BeanImplementsBI.processAnnotation(businessInterFaces, ctx.getClazz(), "jakarta.ejb.Local");
            BeanImplementsBI.processAnnotation(businessInterFaces, ctx.getClazz(), "javax.ejb.Remote");
            BeanImplementsBI.processAnnotation(businessInterFaces, ctx.getClazz(), "jakarta.ejb.Remote");
            if (businessInterFaces.size() > 0) {
                TreeSet<String> implementedInterfaces = new TreeSet<String>();
                for (TypeMirror typeMirror : ctx.getClazz().getInterfaces()) {
                    String iface = JavaUtils.extractClassNameFromType(typeMirror);
                    if (iface == null) continue;
                    implementedInterfaces.add(iface);
                }
                for (String string : businessInterFaces) {
                    if (implementedInterfaces.contains(string)) continue;
                    ErrorDescription err = HintsUtils.createProblem((Element)ctx.getClazz(), hintContext.getInfo(), Bundle.BeanImplementsBI_err(), Severity.WARNING);
                    return Collections.singletonList(err);
                }
            }
        }
        return problems;
    }

    private static void processAnnotation(Collection<String> businessInterFaces, TypeElement clazz, String annotClass) {
        AnnotationMirror annLocal = JavaUtils.findAnnotation(clazz, annotClass);
        AnnotationValue value = JavaUtils.getAnnotationAttrValue(annLocal, "value");
        if (value != null) {
            for (AnnotationValue ifaceAttr : (List)value.getValue()) {
                if (!(ifaceAttr.getValue() instanceof TypeMirror)) continue;
                String className = JavaUtils.extractClassNameFromType((TypeMirror)ifaceAttr.getValue());
                businessInterFaces.add(className);
            }
        }
    }
}

