/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.team.commons.LogUtils;

public class ValidateCommand
extends BugtrackingCommand {
    private final TaskRepository taskRepository;

    public ValidateCommand(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    public void execute() throws CoreException {
        this.log();
        try {
            BugzillaClient client = Bugzilla.getInstance().getRepositoryConnector().getClientManager().getClient(this.taskRepository, (IProgressMonitor)new NullProgressMonitor());
            client.validate((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidateCommand [repository=");
        sb.append(this.taskRepository.getUrl());
        sb.append("]");
        return sb.toString();
    }

    String getUrl() {
        return this.taskRepository.getUrl();
    }

    String getUser() {
        return this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getUserName();
    }

    private void log() {
        Bugzilla.LOG.log(Level.INFO, "validating [{0},{1},{2},{3}]", new Object[]{this.taskRepository.getUrl(), this.getCredentialsString(this.taskRepository.getCredentials(AuthenticationType.REPOSITORY)), this.getCredentialsString(this.taskRepository.getCredentials(AuthenticationType.HTTP)), this.getCredentialsString(this.taskRepository.getCredentials(AuthenticationType.PROXY))});
    }

    private String getCredentialsString(AuthenticationCredentials c) {
        if (c == null) {
            return "null, null";
        }
        return c.getUserName() + "," + LogUtils.getPasswordLog((char[])c.getPassword().toCharArray());
    }
}

