/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryQuery;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HgQueueHookPanel;
import org.netbeans.modules.bugtracking.vcs.HookImpl;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.bugtracking.vcs.VCSQueueHooksConfig;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.HgQueueHook;
import org.netbeans.modules.versioning.hooks.HgQueueHookContext;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HgQueueHookImpl
extends HgQueueHook {
    private static final String[] SUPPORTED_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORTED_REVISION_VARIABLES = new String[]{"changeset", "author", "date", "message"};
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private HgQueueHookPanel panel;
    private final VCSQueueHooksConfig config;
    private final String name = NbBundle.getMessage(HgQueueHookImpl.class, (String)"LBL_VCSHook");
    private static final String HOOK_NAME = "HG";
    private final VCSHooksConfig globalConfig = VCSHooksConfig.getInstance(VCSHooksConfig.HookType.HG);
    private static final Set<Issue> cachedIssues = Collections.newSetFromMap(new WeakHashMap());
    private VCSHooksConfig.Format issueMessageTemplate;

    public HgQueueHookImpl() {
        this.config = VCSQueueHooksConfig.getInstance(VCSQueueHooksConfig.HookType.HG);
    }

    public String getDisplayName() {
        return this.name;
    }

    public HgQueueHookContext beforePatchRefresh(HgQueueHookContext context) throws IOException {
        File[] files = context.getFiles();
        if (files.length == 0) {
            HookImpl.LOG.warning("calling beforePatchRefresh for zero files");
            return null;
        }
        String msg = context.getMessage();
        File file = files[0];
        if (this.isLinkSelected()) {
            VCSHooksConfig.Format format = this.globalConfig.getIssueInfoTemplate();
            String formatString = format.getFormat();
            formatString = HookUtils.prepareFormatString(formatString, SUPPORTED_ISSUE_INFO_VARIABLES);
            Issue issue = this.getIssue();
            if (issue == null) {
                HookImpl.LOG.log(Level.FINE, " no issue set for {0}", file);
                return null;
            }
            this.cacheIssue(issue);
            String issueInfo = new MessageFormat(formatString).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            HookImpl.LOG.log(Level.FINER, " commit hook issue info ''{0}''", issueInfo);
            msg = format.isAbove() ? issueInfo + "\n" + msg : msg + "\n" + issueInfo;
            return new HgQueueHookContext(context.getFiles(), msg, context.getPatchId(), new HgHookContext.LogEntry[0]);
        }
        return null;
    }

    public void afterPatchRefresh(HgQueueHookContext context) {
        this.clearSettings(context.getPatchId());
        File[] files = context.getFiles();
        if (this.panel == null) {
            HookImpl.LOG.fine("no settings for afterPatchRefresh");
            return;
        }
        if (files.length == 0) {
            HookImpl.LOG.warning("calling afterPatchRefresh for zero files");
            return;
        }
        String patchId = context.getPatchId();
        if (patchId == null || patchId.isEmpty()) {
            HookImpl.LOG.warning("calling afterPatchRefresh with no patchId");
            return;
        }
        File file = files[0];
        HookImpl.LOG.log(Level.FINE, "afterPatchRefresh start for {0}", file);
        Issue issue = this.getIssue();
        if (issue == null) {
            HookImpl.LOG.log(Level.FINE, " no issue set for {0}", file);
            return;
        }
        this.cacheIssue(issue);
        this.globalConfig.setLink(this.isLinkSelected());
        this.globalConfig.setResolve(this.isResolveSelected());
        this.config.setAfterRefresh(this.isCommitSelected());
        if (this.isLinkSelected() || this.isResolveSelected()) {
            HookImpl.LOG.log(Level.FINER, " commit hook message will be set after qfinish");
            if (this.isCommitSelected()) {
                this.config.setFinishPatchAction(context.getPatchId(), new VCSQueueHooksConfig.FinishPatchOperation(issue.getID(), this.issueMessageTemplate.getFormat(), this.isResolveSelected(), this.isLinkSelected(), false));
                HookImpl.LOG.log(Level.FINE, "scheduling issue {0} for file {1} after qfinish", new Object[]{issue.getID(), file});
            } else {
                this.config.setFinishPatchAction(context.getPatchId(), new VCSQueueHooksConfig.FinishPatchOperation(issue.getID(), this.issueMessageTemplate.getFormat(), this.isResolveSelected(), this.isLinkSelected(), true));
                HookImpl.LOG.log(Level.FINE, "scheduling push preparations for issue {0} for file {1} after qfinish", new Object[]{issue.getID(), file});
            }
        } else {
            HookImpl.LOG.log(Level.FINER, " nothing to do in afterPatchRefresh for {0}", file);
            return;
        }
        HookImpl.LOG.log(Level.FINE, "afterCommit end for {0}", file);
        VCSHooksConfig.logHookUsage(HOOK_NAME, this.getSelectedRepository());
    }

    public HgQueueHookContext beforePatchFinish(HgQueueHookContext context) throws IOException {
        return super.beforePatchFinish(context);
    }

    public void afterPatchFinish(HgQueueHookContext context) {
        String patchId = context.getPatchId();
        if (patchId == null) {
            HookImpl.LOG.fine("no patchId in afterPatchFinish");
            return;
        }
        File[] files = context.getFiles();
        if (files.length == 0) {
            HookImpl.LOG.warning("calling afterPatchFinish for zero files");
            return;
        }
        VCSQueueHooksConfig.FinishPatchOperation op = this.config.popFinishPatchAction(patchId, true);
        if (op == null || !op.isAddInfo() && !op.isClose()) {
            HookImpl.LOG.fine("no settings for afterPatchFinish");
            return;
        }
        File file = files[0];
        HookImpl.LOG.log(Level.FINE, "afterPatchFinish start for {0}", file);
        Repository repository = RepositoryQuery.getRepository((FileObject)FileUtil.toFileObject((File)file), (boolean)true);
        if (repository == null) {
            HookImpl.LOG.log(Level.FINE, " no issue repository for {0}:{1}", new Object[]{op.getIssueID(), file});
            return;
        }
        Issue issue = this.getIssue(repository, op.getIssueID());
        if (issue == null) {
            HookImpl.LOG.log(Level.FINE, " no issue found for {0}", op.getIssueID());
            return;
        }
        String msg = null;
        String changeset = context.getLogEntries()[0].getChangeset();
        if (op.isAddInfo()) {
            String formatString = op.getMsg();
            formatString = HookUtils.prepareFormatString(formatString, SUPPORTED_REVISION_VARIABLES);
            Date date = context.getLogEntries()[0].getDate();
            msg = new MessageFormat(formatString).format(new Object[]{changeset, context.getLogEntries()[0].getAuthor(), date == null ? "" : CC_DATE_FORMAT.format(date), context.getLogEntries()[0].getMessage()}, new StringBuffer(), (FieldPosition)null).toString();
            HookImpl.LOG.log(Level.FINER, " afterPatchFinish message ''{0}''", msg);
        }
        HookImpl.LOG.log(Level.FINER, " commit hook message ''{0}'', resolved {1}", new Object[]{msg, op.isClose()});
        if (op.isAfterPush()) {
            HookImpl.LOG.log(Level.FINER, " commit hook message will be set after push");
            this.globalConfig.setPushAction(changeset, new VCSHooksConfig.PushOperation(issue.getID(), msg, op.isClose()));
            HookImpl.LOG.log(Level.FINE, "schedulig issue {0} for file {1}", new Object[]{issue.getID(), file});
        } else {
            issue.addComment(msg, this.isResolveSelected());
            issue.open();
        }
        HookImpl.LOG.log(Level.FINE, "afterPatchFinish end for {0}", file);
        VCSHooksConfig.logHookUsage(HOOK_NAME, this.getSelectedRepository());
    }

    public JPanel createComponent(HgQueueHookContext context) {
        File referenceFile;
        HookImpl.LOG.finer("HookImpl.createComponent()");
        File[] files = context.getFiles();
        if (files.length == 0) {
            referenceFile = null;
            HookImpl.LOG.warning("creating hook component for zero files");
        } else {
            referenceFile = files[0];
        }
        this.panel = new HgQueueHookPanel(FileUtil.toFileObject((File)referenceFile), this.globalConfig.getLink(), this.globalConfig.getResolve(), this.config.getAfterRefresh());
        this.panel.commitRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookImpl.class, (String)"CTL_HgQueueHookImpl.commitRadioButton.ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.panel.commitRadioButton, (String)NbBundle.getMessage(HgQueueHookImpl.class, (String)"CTL_HgQueueHookImpl.commitRadioButton.text"));
        String patchId = context.getPatchId();
        this.issueMessageTemplate = this.globalConfig.getRevisionTemplate();
        if (patchId != null) {
            final VCSQueueHooksConfig.FinishPatchOperation op = this.config.popFinishPatchAction(patchId, false);
            if (referenceFile != null && op != null) {
                this.issueMessageTemplate = new VCSHooksConfig.Format(false, op.getMsg());
                this.panel.putClientProperty("prop.requestOpened", true);
                final String issueId = op.getIssueID();
                if (issueId != null) {
                    this.panel.enableIssueField(false);
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Issue fIssue;
                            Issue issue = null;
                            Repository repository = null;
                            try {
                                repository = RepositoryQuery.getRepository((FileObject)FileUtil.toFileObject((File)referenceFile), (boolean)false);
                                issue = repository == null ? null : HgQueueHookImpl.this.getIssue(repository, issueId);
                                fIssue = issue;
                            }
                            catch (Throwable throwable) {
                                Issue fIssue2 = issue;
                                EventQueue.invokeLater(new Runnable(){
                                    final /* synthetic */ Issue val$fIssue;
                                    {
                                        this.val$fIssue = issue;
                                    }

                                    @Override
                                    public void run() {
                                        HgQueueHookImpl.this.panel.enableIssueField(true);
                                        if (this.val$fIssue != null) {
                                            HgQueueHookImpl.this.panel.setIssue(this.val$fIssue);
                                            ((HgQueueHookImpl)HgQueueHookImpl.this).panel.pushRadioButton.setSelected(op.isAfterPush());
                                            ((HgQueueHookImpl)HgQueueHookImpl.this).panel.commitRadioButton.setSelected(!op.isAfterPush());
                                            ((HgQueueHookImpl)HgQueueHookImpl.this).panel.linkCheckBox.setSelected(op.isAddInfo());
                                            ((HgQueueHookImpl)HgQueueHookImpl.this).panel.resolveCheckBox.setSelected(op.isClose());
                                        }
                                    }
                                });
                                throw throwable;
                            }
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            }
        }
        this.panel.changeFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatPanel p = new FormatPanel(HgQueueHookImpl.this.issueMessageTemplate, HgQueueHookImpl.this.globalConfig.getDefaultRevisionTemplate(), SUPPORTED_REVISION_VARIABLES, HgQueueHookImpl.this.globalConfig.getIssueInfoTemplate(), HgQueueHookImpl.this.globalConfig.getDefaultIssueInfoTemplate(), SUPPORTED_ISSUE_INFO_VARIABLES);
                if (HookUtils.show(p, NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"), new HelpCtx(HgQueueHookImpl.this.panel.getClass()))) {
                    HgQueueHookImpl.this.issueMessageTemplate = p.getIssueFormat();
                    HgQueueHookImpl.this.globalConfig.setRevisionTemplate(p.getIssueFormat());
                    HgQueueHookImpl.this.globalConfig.setIssueInfoTemplate(p.getCommitFormat());
                }
            }
        });
        return this.panel;
    }

    private boolean isLinkSelected() {
        return this.panel != null && this.panel.linkCheckBox.isSelected();
    }

    private boolean isResolveSelected() {
        return this.panel != null && this.panel.resolveCheckBox.isSelected();
    }

    private boolean isCommitSelected() {
        return this.panel != null && this.panel.commitRadioButton.isSelected();
    }

    private Repository getSelectedRepository() {
        Issue issue = this.getIssue();
        return issue == null ? null : issue.getRepository();
    }

    private Issue getIssue() {
        return this.panel != null ? this.panel.getIssue() : null;
    }

    private void clearSettings(String patchId) {
        this.config.clearFinishPatchAction(patchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Issue getIssue(Repository repository, String issueID) {
        Set<Issue> set = cachedIssues;
        synchronized (set) {
            for (Issue issue : cachedIssues) {
                if (!repository.equals(issue.getRepository()) || !issueID.equals(issue.getID())) continue;
                return issue;
            }
        }
        Issue[] issues = repository.getIssues(new String[]{issueID});
        if (issues != null && issues.length > 0) {
            Set<Issue> set2 = cachedIssues;
            synchronized (set2) {
                cachedIssues.add(issues[0]);
            }
        }
        return issues[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheIssue(Issue issue) {
        Set<Issue> set = cachedIssues;
        synchronized (set) {
            cachedIssues.add(issue);
        }
    }
}

