/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.textmate.lexer.TextmateTokenId;
import org.openide.filesystems.FileObject;

public class HyperlinkProviderImpl
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        if (doc.getProperty(HyperlinkProviderImpl.class) != Boolean.TRUE) {
            return null;
        }
        BaseDocument document = (BaseDocument)doc;
        document.readLock();
        try {
            int[] ident = Utilities.getIdentifierBlock((BaseDocument)document, (int)offset);
            if (ident == null) {
                int[] nArray = null;
                return nArray;
            }
            TokenSequence ts = TokenHierarchy.get((Document)doc).tokenSequence();
            if (ts == null) {
                int[] nArray = ident;
                return nArray;
            }
            ts.move(offset);
            if (ts.moveNext() && ts.token().id() == TextmateTokenId.TEXTMATE) {
                int[] nArray = new int[]{ts.offset(), ts.offset() + ts.token().length()};
                return nArray;
            }
            int[] nArray = ident;
            return nArray;
        }
        catch (BadLocationException ex) {
            int[] nArray = null;
            return nArray;
        }
        finally {
            document.readUnlock();
        }
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        if (file == null) {
            return;
        }
        String uri = Utils.toURI(file);
        ArrayList foundLocations = new ArrayList();
        Utils.handleBindings(LSPBindings.getBindings(file), capa -> Utils.isEnabled(capa.getDefinitionProvider()), () -> new DefinitionParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, offset)), (server, params) -> server.getTextDocumentService().definition((DefinitionParams)params), (server, locations) -> {
            if (locations == null) {
                return;
            }
            if (locations.isLeft()) {
                foundLocations.addAll((Collection)locations.getLeft());
            } else if (locations.isRight()) {
                ((List)locations.getRight()).stream().map(ll -> new Location(ll.getTargetUri(), ll.getTargetRange())).forEach(foundLocations::add);
            }
        });
        if (!foundLocations.isEmpty()) {
            if (foundLocations.size() == 1) {
                Location location = (Location)foundLocations.get(0);
                Utils.open(location.getUri(), location.getRange());
            } else {
                Location location = (Location)foundLocations.get(0);
                Utils.open(location.getUri(), location.getRange());
            }
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return null;
    }
}

