/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.prep.editor.CPCslElementHandle;
import org.netbeans.modules.css.prep.editor.model.CPElement;
import org.netbeans.modules.css.prep.editor.model.CPElementHandle;

public abstract class CPStructureItem
implements StructureItem {
    private CPElementHandle handle;
    private CPCslElementHandle cslHandle;
    private OffsetRange range;

    public CPStructureItem(CPElement element) {
        this.handle = element.getHandle();
        this.range = element.getRange();
        this.cslHandle = new CPCslElementHandle(this.handle.getFile(), this.handle.getName(), element.getRange(), element.getType());
    }

    public long getPosition() {
        return this.range.getStart();
    }

    public long getEndPosition() {
        return this.range.getEnd();
    }

    public boolean isLeaf() {
        return true;
    }

    public String getName() {
        return this.handle.getName();
    }

    public ElementHandle getElementHandle() {
        return this.cslHandle;
    }

    public String getSortText() {
        return this.getName();
    }

    public String getHtml(HtmlFormatter formatter) {
        switch (this.handle.getType()) {
            case VARIABLE_GLOBAL_DECLARATION: {
                formatter.emphasis(true);
            }
        }
        formatter.appendText(this.getName());
        switch (this.handle.getType()) {
            case VARIABLE_GLOBAL_DECLARATION: {
                formatter.emphasis(false);
            }
        }
        return formatter.getText();
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    public List<? extends StructureItem> getNestedItems() {
        return Collections.emptyList();
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.handle.getName());
        hash = 37 * hash + Objects.hashCode((Object)this.handle.getType());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CPStructureItem other = (CPStructureItem)obj;
        if (!Objects.equals(this.handle.getName(), other.handle.getName())) {
            return false;
        }
        return Objects.equals((Object)this.handle.getType(), (Object)other.handle.getType());
    }

    public static class Variable
    extends CPStructureItem {
        public Variable(CPElement element) {
            super(element);
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }
    }

    public static class Mixin
    extends CPStructureItem {
        public Mixin(CPElement element) {
            super(element);
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }
    }
}

