/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.openide.util.Parameters;

public final class QualifiedName {
    private final QualifiedNameKind kind;
    private final List<String> segments;

    public String getName() {
        return this.toName().toString();
    }

    public String getNamespaceName() {
        return this.toNamespaceName().toString();
    }

    public static QualifiedName getPrefix(QualifiedName fullName, QualifiedName suffix, boolean isOverlapingRequired) {
        return QualifiedName.getRemainingName(fullName, suffix, true, isOverlapingRequired);
    }

    public static QualifiedName getSuffix(QualifiedName fullName, QualifiedName prefix, boolean isOverlapingRequired) {
        if (fullName.segments.size() >= prefix.segments.size()) {
            return QualifiedName.getRemainingName(fullName, prefix, false, isOverlapingRequired);
        }
        return null;
    }

    private static QualifiedName getRemainingName(QualifiedName fullName, QualifiedName fragmentName, boolean prefixRequired, boolean isOverlapingRequired) {
        QualifiedName test;
        ArrayList<String> fullSegments = new ArrayList<String>(fullName.getSegments());
        ArrayList<String> fragmentSegments = new ArrayList<String>(fragmentName.getSegments());
        if (prefixRequired) {
            Collections.reverse(fullSegments);
            Collections.reverse(fragmentSegments);
        }
        ArrayList<String> retvalSegments = new ArrayList<String>();
        String lastEqualSegment = null;
        for (int i = 0; i < fullSegments.size(); ++i) {
            String segment = (String)fullSegments.get(i);
            if (i < fragmentSegments.size() && segment.equalsIgnoreCase(lastEqualSegment = (String)fragmentSegments.get(i))) continue;
            if (isOverlapingRequired && retvalSegments.isEmpty() && lastEqualSegment != null) {
                retvalSegments.add(lastEqualSegment);
            }
            retvalSegments.add(segment);
        }
        if (isOverlapingRequired && retvalSegments.isEmpty() && lastEqualSegment != null) {
            retvalSegments.add(lastEqualSegment);
        }
        if (prefixRequired) {
            Collections.reverse(retvalSegments);
        }
        QualifiedName retval = QualifiedName.create(false, retvalSegments);
        QualifiedName qualifiedName = test = prefixRequired ? retval : fragmentName;
        if (isOverlapingRequired) {
            test = test.toNamespaceName();
        }
        LinkedList<String> qnSegments = prefixRequired ? fragmentName.getSegments() : retval.getSegments();
        for (String qnseg : qnSegments) {
            test = test.append(qnseg);
        }
        return fullName.toFullyQualified().equals(test.toFullyQualified()) ? retval : null;
    }

    @CheckForNull
    public static QualifiedName createUnqualifiedNameInClassContext(Expression expression, ClassScope clsScope) {
        NamespaceName namespaceName;
        if (expression instanceof Identifier) {
            return QualifiedName.createUnqualifiedNameInClassContext((Identifier)expression, clsScope);
        }
        if (expression instanceof NamespaceName && (namespaceName = (NamespaceName)expression).getSegments().size() == 1 && !namespaceName.isGlobal()) {
            return QualifiedName.createUnqualifiedNameInClassContext(namespaceName.getSegments().get(0).getName(), clsScope);
        }
        return QualifiedName.create(expression);
    }

    @CheckForNull
    public static QualifiedName create(Expression expression) {
        Expression e;
        if (expression instanceof NullableType) {
            e = ((NullableType)expression).getType();
            assert (e instanceof NamespaceName || e instanceof Identifier);
        } else {
            e = expression;
        }
        if (e instanceof NamespaceName) {
            return QualifiedName.create((NamespaceName)e);
        }
        if (e instanceof Identifier) {
            return QualifiedName.createUnqualifiedName((Identifier)e);
        }
        return null;
    }

    public static List<QualifiedName> create(UnionType unionType) {
        ArrayList<QualifiedName> qualifiedNames = new ArrayList<QualifiedName>();
        for (Expression type : unionType.getTypes()) {
            if (type instanceof IntersectionType) {
                qualifiedNames.addAll(QualifiedName.create((IntersectionType)type));
                continue;
            }
            QualifiedName qualifiedName = QualifiedName.create(type);
            if (qualifiedName == null) continue;
            qualifiedNames.add(qualifiedName);
        }
        return qualifiedNames;
    }

    public static List<QualifiedName> create(IntersectionType intersectionType) {
        ArrayList<QualifiedName> qualifiedNames = new ArrayList<QualifiedName>();
        for (Expression type : intersectionType.getTypes()) {
            QualifiedName qualifiedName = QualifiedName.create(type);
            if (qualifiedName == null) continue;
            qualifiedNames.add(qualifiedName);
        }
        return qualifiedNames;
    }

    public static QualifiedName create(boolean isFullyQualified, List<String> segments) {
        return new QualifiedName(isFullyQualified, segments);
    }

    public static QualifiedName create(NamespaceScope namespaceScope) {
        return QualifiedName.create(namespaceScope.getName());
    }

    public static QualifiedName create(NamespaceName namespaceName) {
        return new QualifiedName(namespaceName);
    }

    public static QualifiedName createUnqualifiedNameInClassContext(Identifier identifier, ClassScope clsScope) {
        return QualifiedName.createUnqualifiedNameInClassContext(identifier.getName(), clsScope);
    }

    public static QualifiedName createUnqualifiedName(Identifier identifier) {
        return new QualifiedName(identifier);
    }

    public static QualifiedName createUnqualifiedNameInClassContext(String name, ClassScope clsScope) {
        if (clsScope != null) {
            switch (name) {
                case "self": {
                    name = clsScope.getName();
                    break;
                }
                case "parent": {
                    String superClsName = ModelUtils.getFirst(clsScope.getSuperClassNames());
                    if (superClsName == null) break;
                    name = superClsName;
                    break;
                }
            }
        }
        return QualifiedName.createUnqualifiedName(name);
    }

    public static QualifiedName createForDefaultNamespaceName() {
        return QualifiedName.createUnqualifiedName("");
    }

    public static QualifiedName createUnqualifiedName(String name) {
        QualifiedNameKind kind = QualifiedNameKind.resolveKind(name);
        assert (kind.equals((Object)QualifiedNameKind.UNQUALIFIED)) : name;
        return new QualifiedName(false, Collections.singletonList(name));
    }

    public static QualifiedName createFullyQualified(String name, String namespaceName) {
        ArrayList<String> list = new ArrayList<String>();
        if (name.startsWith("\\") || name.endsWith("\\")) {
            throw new IllegalArgumentException();
        }
        if (namespaceName != null && namespaceName.trim().length() > 0) {
            if (namespaceName.startsWith("\\") || namespaceName.endsWith("\\")) {
                throw new IllegalArgumentException();
            }
            String[] segments = namespaceName.split("\\\\");
            list.addAll(Arrays.asList(segments));
        }
        list.add(name);
        return new QualifiedName(true, list);
    }

    public static QualifiedName create(String name) {
        List<String> list;
        QualifiedNameKind kind = QualifiedNameKind.resolveKind(name = name.trim());
        if (kind.isUnqualified()) {
            return QualifiedName.createUnqualifiedName(name);
        }
        if (kind.isFullyQualified()) {
            name = name.substring(1);
        }
        String[] segments = name.split("[\\\\]+");
        if (name.endsWith("\\")) {
            list = new ArrayList<String>(Arrays.asList(segments));
            list.add("");
        } else {
            list = Arrays.asList(segments);
        }
        return new QualifiedName(kind.isFullyQualified(), list);
    }

    private QualifiedName(NamespaceName namespaceName) {
        this.kind = QualifiedNameKind.resolveKind(namespaceName);
        this.segments = new ArrayList<String>();
        for (Identifier identifier : namespaceName.getSegments()) {
            this.segments.add(identifier.getName());
        }
    }

    private QualifiedName(Identifier identifier) {
        this.kind = QualifiedNameKind.resolveKind(identifier);
        this.segments = new ArrayList<String>(Collections.singleton(identifier.getName()));
        assert (this.kind.isUnqualified());
    }

    private QualifiedName(boolean isFullyQualified, List<String> segments) {
        this.segments = new ArrayList<String>(segments.isEmpty() ? Collections.singleton("") : segments);
        this.kind = isFullyQualified ? QualifiedNameKind.FULLYQUALIFIED : QualifiedNameKind.resolveKind(this.segments);
    }

    public LinkedList<String> getSegments() {
        return new LinkedList<String>(this.segments);
    }

    public QualifiedNameKind getKind() {
        return this.kind;
    }

    public String toString() {
        return this.toString(this.segments.size() - 1);
    }

    public String toString(int numberOfSegments) {
        if (numberOfSegments >= this.segments.size()) {
            throw new IllegalArgumentException("n >= segments.size()");
        }
        StringBuilder sb = new StringBuilder();
        QualifiedNameKind k = this.getKind();
        for (int i = 0; i <= numberOfSegments; ++i) {
            String oneSegment = this.segments.get(i);
            if (sb.length() > 0 || k != null && k.isFullyQualified()) {
                sb.append("\\");
            }
            sb.append(oneSegment);
        }
        return sb.toString();
    }

    public QualifiedName append(String name) {
        return this.append(QualifiedName.createUnqualifiedName(name));
    }

    public QualifiedName append(QualifiedName qualifiedName) {
        return this.append(qualifiedName, this.getKind().isFullyQualified());
    }

    private QualifiedName append(QualifiedName qualifiedName, boolean isFullyQualified) {
        ArrayList<String> list = this.isDefaultNamespace() ? new ArrayList<String>() : new ArrayList<String>(this.getSegments());
        list.addAll(qualifiedName.getSegments());
        return new QualifiedName(isFullyQualified, list);
    }

    public QualifiedName toFullyQualified() {
        return this.getKind().isFullyQualified() ? this : new QualifiedName(true, this.getSegments());
    }

    public QualifiedName toNotFullyQualified() {
        return this.getKind().isFullyQualified() ? new QualifiedName(false, this.getSegments()) : this;
    }

    @CheckForNull
    public QualifiedName toFullyQualified(QualifiedName namespaceName) {
        Parameters.notNull((CharSequence)"namespaceName", (Object)namespaceName);
        return namespaceName.append(this, true);
    }

    @CheckForNull
    public QualifiedName toFullyQualified(NamespaceScope namespaceScope) {
        Parameters.notNull((CharSequence)"namespaceScope", (Object)namespaceScope);
        return this.getKind().isFullyQualified() ? this : namespaceScope.getQualifiedName().append(this).toFullyQualified();
    }

    public QualifiedName toName() {
        return QualifiedName.createUnqualifiedName(this.getSegments().getLast());
    }

    public QualifiedName toNamespaceName(boolean fullyQualified) {
        LinkedList<String> list = new LinkedList<String>(this.getSegments());
        list.removeLast();
        return new QualifiedName(fullyQualified, list);
    }

    public QualifiedName toNamespaceName() {
        return this.toNamespaceName(false);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedName other = (QualifiedName)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.segments.size() != other.segments.size()) {
            return false;
        }
        return this.segments.equals(other.segments);
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + this.kind.hashCode();
        hash = 73 * hash + (this.segments != null ? this.segments.hashCode() : 0);
        return hash;
    }

    public boolean isDefaultNamespace() {
        return this.getSegments().size() == 1 && this.getSegments().get(0).equals("");
    }
}

