/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.rotation;

import java.security.Key;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;

public interface KeyLocator
extends Iterable<Key> {
    public Key getKey(String var1) throws KeyManagementException;

    default public Key getKey(Key key) throws KeyManagementException {
        if (key == null) {
            return null;
        }
        for (Key k : this) {
            if (!k.getAlgorithm().equals(key.getAlgorithm()) || !MessageDigest.isEqual(k.getEncoded(), key.getEncoded())) continue;
            return key;
        }
        return null;
    }

    default public Key getKey(KeyInfo info) throws KeyManagementException {
        if (info == null) {
            return null;
        }
        Key key = null;
        for (XMLStructure xs : info.getContent()) {
            if (xs instanceof KeyName) {
                key = this.getKey(((KeyName)xs).getName());
            } else if (xs instanceof X509Data) {
                for (Object content : ((X509Data)xs).getContent()) {
                    if (!(content instanceof X509Certificate)) continue;
                    key = this.getKey(((X509Certificate)content).getPublicKey());
                    if (key != null) {
                        return key;
                    }
                    break;
                }
            } else if (xs instanceof KeyValue) {
                try {
                    key = this.getKey(((KeyValue)xs).getPublicKey());
                }
                catch (KeyException e) {
                    throw new KeyManagementException(e);
                }
            }
            if (key == null) continue;
            return key;
        }
        return null;
    }

    public void refreshKeyCache();

    public static class KeyHash {
        private final Key key;
        private final int keyHash;

        public KeyHash(Key key) {
            this.key = key;
            this.keyHash = Arrays.hashCode(key.getEncoded());
        }

        public int hashCode() {
            return this.keyHash;
        }

        public boolean equals(Object o) {
            if (o instanceof KeyHash) {
                KeyHash other = (KeyHash)o;
                return this.keyHash == other.keyHash && this.key.getAlgorithm().equals(other.key.getAlgorithm()) && MessageDigest.isEqual(this.key.getEncoded(), other.key.getEncoded());
            }
            return false;
        }
    }
}

