/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.util.Properties;
import org.eigenbase.util.property.Property;

public class IntegerProperty
extends Property {
    private final int minValue;
    private final int maxValue;

    public IntegerProperty(Properties properties, String string, int n) {
        this(properties, string, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerProperty(Properties properties, String string) {
        this(properties, string, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerProperty(Properties properties, String string, int n, int n2, int n3) {
        super(properties, string, Integer.toString(n));
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException("invalid default value " + n);
        }
        this.minValue = n2;
        this.maxValue = n3;
    }

    public IntegerProperty(Properties properties, String string, int n, int n2) {
        super(properties, string, null);
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        this.minValue = n;
        this.maxValue = n2;
    }

    public int get() {
        String string = this.getInternal(null, false);
        if (string == null) {
            return this.noValue();
        }
        int n = Integer.parseInt(string);
        return this.limit(n);
    }

    public int get(int n) {
        String string = this.getInternal(Integer.toString(n), false);
        if (string == null) {
            return this.limit(n);
        }
        int n2 = Integer.parseInt(string);
        return this.limit(n2);
    }

    public int set(int n) {
        String string = this.setString(Integer.toString(this.limit(n)));
        if (string == null && (string = this.getDefaultValue()) == null) {
            return this.noValue();
        }
        int n2 = Integer.parseInt(string);
        return this.limit(n2);
    }

    private int limit(int n) {
        return Math.min(Math.max(n, this.minValue), this.maxValue);
    }

    private int noValue() {
        if (this.minValue <= 0 && this.maxValue >= 0) {
            return 0;
        }
        return this.minValue;
    }
}

