/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.exception.InvalidTransportHandlerStateException;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class ClientTcpTransportHandler
extends TransportHandler {
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 60000;
    protected Socket socket;
    protected String hostname;
    protected int port;
    protected long connectionTimeout;

    public ClientTcpTransportHandler(Connection connection) {
        this(60000L, connection.getTimeout().intValue(), connection.getIp(), connection.getPort());
    }

    public ClientTcpTransportHandler(long timeout, String hostname, int port) {
        this(60000L, timeout, hostname, port);
    }

    public ClientTcpTransportHandler(long connectionTimeout, long timeout, String hostname, int port) {
        super(timeout, ConnectionEndType.CLIENT);
        this.hostname = hostname;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.socket == null) {
            throw new IOException("Transporthandler is not initalized!");
        }
        this.socket.close();
    }

    @Override
    public void initialize() throws IOException {
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(this.hostname, this.port), (int)this.connectionTimeout);
        if (!this.socket.isConnected()) {
            throw new IOException("Could not connect to " + this.hostname + ":port");
        }
        this.setStreams(new PushbackInputStream(this.socket.getInputStream()), this.socket.getOutputStream());
        this.socket.setSoTimeout(1);
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.socket.isClosed() || this.socket.isInputShutdown();
    }

    @Override
    public void closeClientConnection() throws IOException {
        this.closeConnection();
    }

    public SocketState getSocketState() throws InvalidTransportHandlerStateException {
        try {
            if (this.socket.getInputStream().available() > 0) {
                return SocketState.DATA_AVAILABLE;
            }
            int read = this.socket.getInputStream().read();
            if (read == -1) {
                return SocketState.CLOSED;
            }
            throw new InvalidTransportHandlerStateException("Received Data during SocketState check");
        }
        catch (SocketTimeoutException ex) {
            return SocketState.TIMEOUT;
        }
        catch (SocketException ex) {
            return SocketState.SOCKET_EXCEPTION;
        }
        catch (IOException ex) {
            return SocketState.IO_EXCEPTION;
        }
    }
}

