/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.dialogs;

import de.escape.quincunx.dxf.dialogs.LengthChooser;
import de.escape.quincunx.dxf.dialogs.PaperPreviewArea;
import de.escape.quincunx.dxf.dialogs.PostScriptOutputInfo;
import de.escape.quincunx.gimmicks.BasicPaperFormat;
import de.escape.quincunx.gimmicks.LengthUnit;
import de.escape.quincunx.gimmicks.MultiLineLabel;
import de.escape.quincunx.gimmicks.PaperFormat;
import de.escape.quincunx.gimmicks.PhysicalLength;
import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.RCheckbox;
import de.escape.quincunx.i18n.RChoice;
import de.escape.quincunx.i18n.RLabel;
import de.escape.quincunx.i18n.RPanel;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

public class PaperFormatPanel
extends Panel {
    private RChoice formatChoice;
    private Hashtable papers = new Hashtable();
    private LengthChooser widthChooser;
    private LengthChooser heightChooser;
    private LengthChooser leftMarginChooser;
    private LengthChooser rightMarginChooser;
    private LengthChooser topMarginChooser;
    private LengthChooser bottomMarginChooser;
    private PaperPreviewArea preview;
    private Choice horizontalAlign;
    private Choice verticalAlign;
    private Checkbox rotate;
    private Checkbox monochrome;

    public PaperFormatPanel(PostScriptOutputInfo initInfo) {
        super(new BorderLayout());
        RPanel left = new RPanel();
        this.add("West", left);
        this.formatChoice = new RChoice();
        this.addPaper(new NamedPaper("user defined", null));
        this.addPaper(new NamedPaper("Letter/US (portrait)", BasicPaperFormat.LETTER_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("Letter/US (landscape)", BasicPaperFormat.LETTER_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("Legal/US (portrait)", BasicPaperFormat.LEGAL_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("Legal/US (landscape)", BasicPaperFormat.LEGAL_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("Executive/US (portrait)", BasicPaperFormat.EXECUTIVE_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("Executive/US (landscape)", BasicPaperFormat.EXECUTIVE_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("Tabloid/US (portrait)", BasicPaperFormat.TABLOID_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("Tabloid/US (landscape)", BasicPaperFormat.TABLOID_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("A4 (portrait)", BasicPaperFormat.A4_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("A4 (landscape)", BasicPaperFormat.A4_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("A3 (portrait)", BasicPaperFormat.A3_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("A3 (landscape)", BasicPaperFormat.A3_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("A2 (portrait)", BasicPaperFormat.A2_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("A2 (landscape)", BasicPaperFormat.A2_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("A1 (portrait)", BasicPaperFormat.A1_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("A1 (landscape)", BasicPaperFormat.A1_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("A0 (portrait)", BasicPaperFormat.A0_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("A0 (landscape)", BasicPaperFormat.A0_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("B5 (portrait)", BasicPaperFormat.B5_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("B5 (landscape)", BasicPaperFormat.B5_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("B4 (portrait)", BasicPaperFormat.B4_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("B4 (landscape)", BasicPaperFormat.B4_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("B3 (portrait)", BasicPaperFormat.B3_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("B3 (landscape)", BasicPaperFormat.B3_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("B2 (portrait)", BasicPaperFormat.B2_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("B2 (landscape)", BasicPaperFormat.B2_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("B1 (portrait)", BasicPaperFormat.B1_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("B1 (landscape)", BasicPaperFormat.B1_PAPER_LANDSCAPE));
        this.addPaper(new NamedPaper("B0 (portrait)", BasicPaperFormat.B0_PAPER_PORTRAIT));
        this.addPaper(new NamedPaper("B0 (landscape)", BasicPaperFormat.B0_PAPER_LANDSCAPE));
        this.formatChoice.select(0);
        String formatName = initInfo.getPaperFormat().getName();
        if (formatName != null) {
            int i = this.formatChoice.getItemCount() - 1;
            while (i >= 0) {
                PaperFormat format = ((NamedPaper)this.papers.get((Object)this.formatChoice.getTag((int)i))).paper;
                if (format != null && formatName.equals(format.getName())) {
                    this.formatChoice.select(i);
                    break;
                }
                --i;
            }
        }
        this.formatChoice.addItemListener(new 1(initInfo, this));
        this.widthChooser = new LengthChooser(initInfo.getPaperFormat().getWidth(), initInfo.getMeasurementUnit());
        this.widthChooser.addPropertyChangeListener(new 2(initInfo));
        this.widthChooser.setEnabled(this.formatChoice.getSelectedIndex() == 0);
        this.heightChooser = new LengthChooser(initInfo.getPaperFormat().getHeight(), initInfo.getMeasurementUnit());
        this.heightChooser.addPropertyChangeListener(new 3(initInfo));
        this.heightChooser.setEnabled(this.formatChoice.getSelectedIndex() == 0);
        this.leftMarginChooser = new LengthChooser(initInfo.getLeftMargin(), initInfo.getMeasurementUnit(), LengthChooser.DEFAULT_UNITS);
        this.leftMarginChooser.addPropertyChangeListener(new 4(initInfo));
        this.rightMarginChooser = new LengthChooser(initInfo.getLeftMargin(), initInfo.getMeasurementUnit());
        this.rightMarginChooser.addPropertyChangeListener(new 5(initInfo));
        this.topMarginChooser = new LengthChooser(initInfo.getLeftMargin(), initInfo.getMeasurementUnit());
        this.topMarginChooser.addPropertyChangeListener(new 6(initInfo));
        this.bottomMarginChooser = new LengthChooser(initInfo.getLeftMargin(), initInfo.getMeasurementUnit());
        this.bottomMarginChooser.addPropertyChangeListener(new 7(initInfo));
        initInfo.addPropertyChangeListener(new 8());
        this.rotate = new RCheckbox("rotate image", initInfo.isRotated());
        this.rotate.addItemListener(new 9(initInfo, this));
        this.monochrome = new RCheckbox("paint monochrome", initInfo.isMonochrome());
        this.monochrome.addItemListener(new 10(initInfo, this));
        this.horizontalAlign = new RChoice();
        this.horizontalAlign.add("Left");
        this.horizontalAlign.add("Center");
        this.horizontalAlign.add("Right");
        this.horizontalAlign.addItemListener(new 11(initInfo, this));
        this.horizontalAlign.select(initInfo.getHorizontalAlignment() + 1);
        this.verticalAlign = new RChoice();
        this.verticalAlign.add("Top");
        this.verticalAlign.add("Center");
        this.verticalAlign.add("Bottom");
        this.verticalAlign.addItemListener(new 12(initInfo, this));
        this.verticalAlign.select(initInfo.getVerticalAlignment() + 1);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        left.setLayout(gbl);
        RLabel label = new RLabel("Paper format:");
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.formatChoice, c);
        left.add(this.formatChoice);
        label = new RLabel("Paper width:");
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.widthChooser, c);
        left.add(this.widthChooser);
        label = new RLabel("Paper height:");
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.heightChooser, c);
        left.add(this.heightChooser);
        label = new RLabel("Left margin:");
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.leftMarginChooser, c);
        left.add(this.leftMarginChooser);
        label = new RLabel("Right margin:");
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.rightMarginChooser, c);
        left.add(this.rightMarginChooser);
        label = new RLabel("Top margin:");
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.topMarginChooser, c);
        left.add(this.topMarginChooser);
        label = new RLabel("Bottom margin:");
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.bottomMarginChooser, c);
        left.add(this.bottomMarginChooser);
        label = new RLabel("Horizontal alignment:");
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.horizontalAlign, c);
        left.add(this.horizontalAlign);
        label = new RLabel("Vertical alignment:");
        c.fill = 0;
        c.gridwidth = -1;
        gbl.setConstraints(label, c);
        left.add(label);
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.verticalAlign, c);
        left.add(this.verticalAlign);
        c.fill = 0;
        c.anchor = 17;
        c.gridwidth = 0;
        gbl.setConstraints(this.rotate, c);
        left.add(this.rotate);
        gbl.setConstraints(this.monochrome, c);
        left.add(this.monochrome);
        this.preview = new PaperPreviewArea(initInfo);
        this.add("Center", this.preview);
        MultiLineLabel footnote = new MultiLineLabel(I18n.format("Format Footnote", I18n.getString("rotate image")), 0);
        this.add("South", footnote);
        Font font = footnote.getFont();
        if (font != null) {
            ((Component)footnote).setFont(new Font(font.getFamily(), font.getSize() * 2 / 3, font.getStyle()));
        } else {
            ((Component)footnote).setFont(new Font("SansSerif", 0, 10));
        }
    }

    private void addPaper(NamedPaper paper) {
        this.papers.put(paper.toString(), paper);
        this.formatChoice.add(paper.toString());
    }

    public boolean isValid() {
        return this.widthChooser.isValid() && this.heightChooser.isValid() && this.leftMarginChooser.isValid() && this.rightMarginChooser.isValid() && this.topMarginChooser.isValid() && this.bottomMarginChooser.isValid();
    }

    public void addValidityListener(PropertyChangeListener listener) {
        this.widthChooser.addPropertyChangeListener(listener);
        this.heightChooser.addPropertyChangeListener(listener);
        this.leftMarginChooser.addPropertyChangeListener(listener);
        this.rightMarginChooser.addPropertyChangeListener(listener);
        this.topMarginChooser.addPropertyChangeListener(listener);
        this.bottomMarginChooser.addPropertyChangeListener(listener);
    }

    public void removeValidityListener(PropertyChangeListener listener) {
        this.widthChooser.removePropertyChangeListener(listener);
        this.heightChooser.removePropertyChangeListener(listener);
        this.leftMarginChooser.removePropertyChangeListener(listener);
        this.rightMarginChooser.removePropertyChangeListener(listener);
        this.topMarginChooser.removePropertyChangeListener(listener);
        this.bottomMarginChooser.removePropertyChangeListener(listener);
    }

    private static class NamedPaper {
        PaperFormat paper;
        String name;

        public NamedPaper(String name, PaperFormat paper) {
            this.name = name;
            this.paper = paper;
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class 1
    implements ItemListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;
        private final /* synthetic */ PaperFormatPanel this$0;

        public void itemStateChanged(ItemEvent e) {
            boolean userDefined;
            NamedPaper namePaper = (NamedPaper)this.this$0.papers.get(this.this$0.formatChoice.getSelectedTag());
            boolean bl = userDefined = namePaper.paper == null;
            if (!userDefined) {
                this.this$0.widthChooser.setLength(namePaper.paper.getWidth());
                this.this$0.heightChooser.setLength(namePaper.paper.getHeight());
                this.val$initInfo.setPaperFormat(new BasicPaperFormat(namePaper.paper, this.val$initInfo.getLeftMargin(), this.val$initInfo.getRightMargin(), this.val$initInfo.getTopMargin(), this.val$initInfo.getBottomMargin()));
            }
            this.this$0.widthChooser.setEnabled(userDefined);
            this.this$0.heightChooser.setEnabled(userDefined);
        }

        /* synthetic */ 1(PostScriptOutputInfo val$initInfo, PaperFormatPanel this$0) {
            this.val$initInfo = val$initInfo;
            this.this$0 = this$0;
        }
    }

    private static final class 2
    implements PropertyChangeListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("VALUE")) {
                PaperFormat oldPaper = this.val$initInfo.getPaperFormat();
                BasicPaperFormat paper = new BasicPaperFormat((PhysicalLength)e.getNewValue(), oldPaper.getHeight(), oldPaper.getLeftMargin(), oldPaper.getRightMargin(), oldPaper.getTopMargin(), oldPaper.getBottomMargin());
                this.val$initInfo.setPaperFormat(paper);
            }
        }

        /* synthetic */ 2(PostScriptOutputInfo val$initInfo) {
            this.val$initInfo = val$initInfo;
        }
    }

    private static final class 3
    implements PropertyChangeListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("VALUE")) {
                PaperFormat oldPaper = this.val$initInfo.getPaperFormat();
                BasicPaperFormat paper = new BasicPaperFormat(oldPaper.getWidth(), (PhysicalLength)e.getNewValue(), oldPaper.getLeftMargin(), oldPaper.getRightMargin(), oldPaper.getTopMargin(), oldPaper.getBottomMargin());
                this.val$initInfo.setPaperFormat(paper);
            }
        }

        /* synthetic */ 3(PostScriptOutputInfo val$initInfo) {
            this.val$initInfo = val$initInfo;
        }
    }

    private static final class 4
    implements PropertyChangeListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("VALUE")) {
                this.val$initInfo.setLeftMargin((PhysicalLength)e.getNewValue());
            } else if (e.getPropertyName().equals("UNIT")) {
                LengthUnit einheit = (LengthUnit)e.getNewValue();
                this.val$initInfo.setMeasurementUnit(einheit);
            }
        }

        /* synthetic */ 4(PostScriptOutputInfo val$initInfo) {
            this.val$initInfo = val$initInfo;
        }
    }

    private static final class 5
    implements PropertyChangeListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("VALUE")) {
                this.val$initInfo.setRightMargin((PhysicalLength)e.getNewValue());
            }
        }

        /* synthetic */ 5(PostScriptOutputInfo val$initInfo) {
            this.val$initInfo = val$initInfo;
        }
    }

    private static final class 6
    implements PropertyChangeListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("VALUE")) {
                this.val$initInfo.setTopMargin((PhysicalLength)e.getNewValue());
            }
        }

        /* synthetic */ 6(PostScriptOutputInfo val$initInfo) {
            this.val$initInfo = val$initInfo;
        }
    }

    private static final class 7
    implements PropertyChangeListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("VALUE")) {
                this.val$initInfo.setBottomMargin((PhysicalLength)e.getNewValue());
            }
        }

        /* synthetic */ 7(PostScriptOutputInfo val$initInfo) {
            this.val$initInfo = val$initInfo;
        }
    }

    private final class 8
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("LENGTH_UNIT")) {
                LengthUnit unit = (LengthUnit)e.getNewValue();
                PaperFormatPanel.this.widthChooser.setUnit(unit);
                PaperFormatPanel.this.heightChooser.setUnit(unit);
                PaperFormatPanel.this.leftMarginChooser.setUnit(unit);
                PaperFormatPanel.this.rightMarginChooser.setUnit(unit);
                PaperFormatPanel.this.topMarginChooser.setUnit(unit);
                PaperFormatPanel.this.bottomMarginChooser.setUnit(unit);
            }
        }

        /* synthetic */ 8() {
        }
    }

    private static final class 9
    implements ItemListener {
        private final /* synthetic */ PaperFormatPanel this$0;
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;

        public void itemStateChanged(ItemEvent e) {
            this.val$initInfo.setRotated(this.this$0.rotate.getState());
        }

        /* synthetic */ 9(PostScriptOutputInfo val$initInfo, PaperFormatPanel this$0) {
            this.val$initInfo = val$initInfo;
            this.this$0 = this$0;
        }
    }

    private static final class 10
    implements ItemListener {
        private final /* synthetic */ PaperFormatPanel this$0;
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;

        public void itemStateChanged(ItemEvent e) {
            this.val$initInfo.setMonochrome(this.this$0.monochrome.getState());
        }

        /* synthetic */ 10(PostScriptOutputInfo val$initInfo, PaperFormatPanel this$0) {
            this.val$initInfo = val$initInfo;
            this.this$0 = this$0;
        }
    }

    private static final class 11
    implements ItemListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;
        private final /* synthetic */ PaperFormatPanel this$0;

        public void itemStateChanged(ItemEvent e) {
            int align = 0;
            switch (this.this$0.horizontalAlign.getSelectedIndex()) {
                case 0: {
                    align = -1;
                    break;
                }
                case 1: {
                    align = 0;
                    break;
                }
                case 2: {
                    align = 1;
                    break;
                }
            }
            this.val$initInfo.setHorizontalAlignment(align);
        }

        /* synthetic */ 11(PostScriptOutputInfo val$initInfo, PaperFormatPanel this$0) {
            this.val$initInfo = val$initInfo;
            this.this$0 = this$0;
        }
    }

    private static final class 12
    implements ItemListener {
        private final /* synthetic */ PostScriptOutputInfo val$initInfo;
        private final /* synthetic */ PaperFormatPanel this$0;

        public void itemStateChanged(ItemEvent e) {
            int align = 0;
            switch (this.this$0.verticalAlign.getSelectedIndex()) {
                case 0: {
                    align = -1;
                    break;
                }
                case 1: {
                    align = 0;
                    break;
                }
                case 2: {
                    align = 1;
                    break;
                }
            }
            this.val$initInfo.setVerticalAlignment(align);
        }

        /* synthetic */ 12(PostScriptOutputInfo val$initInfo, PaperFormatPanel this$0) {
            this.val$initInfo = val$initInfo;
            this.this$0 = this$0;
        }
    }
}

