/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidNavigatorViewException;
import javax.help.JHelpNavigator;
import javax.help.NavigatorView;
import javax.help.SearchView;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;

public class JHelpSearchNavigator
extends JHelpNavigator {
    private MergingSearchEngine search;
    private static final boolean debug = false;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Hashtable;

    public JHelpSearchNavigator(HelpSet helpSet, String string, String string2, URL uRL) throws InvalidNavigatorViewException {
        super(new SearchView(helpSet, string, string2, JHelpNavigator.createParams(uRL)));
    }

    public JHelpSearchNavigator(NavigatorView navigatorView) {
        super(navigatorView, null);
    }

    public JHelpSearchNavigator(NavigatorView navigatorView, HelpModel helpModel) {
        super(navigatorView, helpModel);
    }

    public boolean canMerge(NavigatorView navigatorView) {
        if (navigatorView instanceof SearchView && this.getNavigatorName().equals(navigatorView.getName())) {
            JHelpSearchNavigator.debug("canMerge: true");
            return true;
        }
        JHelpSearchNavigator.debug("canMerge: false");
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static void debug(String string) {
    }

    protected String getDefaultQueryEngine() {
        return "com.sun.java.help.search.DefaultSearchEngine";
    }

    public SearchEngine getSearchEngine() {
        if (this.search == null) {
            this.search = new MergingSearchEngine(this.getNavigatorView());
        }
        return this.search;
    }

    public String getUIClassID() {
        return "HelpSearchNavigatorUI";
    }

    private SearchEngine makeEngine(NavigatorView navigatorView) {
        Constructor<?> constructor;
        Class<?> clazz;
        Hashtable hashtable = navigatorView.getParameters();
        if (hashtable == null || hashtable != null && !hashtable.containsKey("data")) {
            return null;
        }
        String string = (String)hashtable.get("engine");
        HelpSet helpSet = navigatorView.getHelpSet();
        URL uRL = helpSet.getHelpSetURL();
        ClassLoader classLoader = helpSet.getLoader();
        if (string == null) {
            string = this.getDefaultQueryEngine();
            hashtable.put("engine", string);
        }
        SearchEngine searchEngine = null;
        Class[] classArray = new Class[]{class$java$net$URL != null ? class$java$net$URL : (class$java$net$URL = JHelpSearchNavigator.class$("java.net.URL")), class$java$util$Hashtable != null ? class$java$util$Hashtable : (class$java$util$Hashtable = JHelpSearchNavigator.class$("java.util.Hashtable"))};
        Object[] objectArray = new Object[]{uRL, hashtable};
        JHelpSearchNavigator.debug("makeEngine");
        JHelpSearchNavigator.debug("  base: " + uRL);
        JHelpSearchNavigator.debug("  params: " + hashtable);
        try {
            clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            throw new Error("Could not load engine named " + string + " for view: " + navigatorView);
        }
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Throwable throwable) {
            throw new Error("Could not find constructor for " + string + ". For view: " + navigatorView);
        }
        try {
            searchEngine = (SearchEngine)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new Error("InvocationTargetException while creating engine named " + string + " for view: " + navigatorView);
        }
        catch (Throwable throwable) {
            throw new Error("Could not create engine named " + string + " for view: " + navigatorView);
        }
        return searchEngine;
    }

    public void merge(NavigatorView navigatorView) {
        JHelpSearchNavigator.debug("JHelpSearchNavigator.merge invoked");
        JHelpSearchNavigator.debug("  params: " + navigatorView.getParameters());
        if (this.search == null) {
            this.search = (MergingSearchEngine)this.getSearchEngine();
        }
        this.search.merge(navigatorView);
        JHelpSearchNavigator.debug("merge: " + navigatorView);
        this.getUI().merge(navigatorView);
    }

    public void remove(NavigatorView navigatorView) {
        JHelpSearchNavigator.debug("JHelpSearchNavigator.remove invoked");
        JHelpSearchNavigator.debug("  params: " + navigatorView.getParameters());
        if (this.search == null) {
            this.search = (MergingSearchEngine)this.getSearchEngine();
        }
        this.search.remove(navigatorView);
        JHelpSearchNavigator.debug("remove: " + navigatorView);
        this.getUI().remove(navigatorView);
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.search = new MergingSearchEngine(searchEngine);
    }

    private class MergingSearchEngine
    extends SearchEngine {
        private Vector engines;
        private Hashtable enginePerView = new Hashtable();

        public MergingSearchEngine(NavigatorView navigatorView) {
            this.engines = new Vector();
            SearchEngine searchEngine = JHelpSearchNavigator.this.makeEngine(navigatorView);
            this.engines.addElement(searchEngine);
        }

        public MergingSearchEngine(SearchEngine searchEngine) {
            this.engines = new Vector();
            this.engines.addElement(searchEngine);
        }

        public SearchQuery createQuery() {
            return new MergingSearchQuery(this);
        }

        public Enumeration getEngines() {
            return this.engines.elements();
        }

        public void merge(NavigatorView navigatorView) {
            SearchEngine searchEngine = JHelpSearchNavigator.this.makeEngine(navigatorView);
            if (searchEngine == null) {
                return;
            }
            this.engines.addElement(searchEngine);
            this.enginePerView.put(navigatorView, searchEngine);
        }

        public void remove(NavigatorView navigatorView) {
            SearchEngine searchEngine = (SearchEngine)this.enginePerView.get(navigatorView);
            if (searchEngine != null) {
                this.engines.removeElement(searchEngine);
                this.enginePerView.remove(searchEngine);
            }
        }
    }

    private class MergingSearchQuery
    extends SearchQuery
    implements SearchListener {
        private MergingSearchEngine mhs;
        private Vector queries;
        private String searchparams;

        public MergingSearchQuery(SearchEngine searchEngine) {
            super(searchEngine);
            if (searchEngine instanceof MergingSearchEngine) {
                this.mhs = (MergingSearchEngine)searchEngine;
            }
        }

        public SearchEngine getSearchEngine() {
            return this.mhs;
        }

        public boolean isActive() {
            if (this.queries == null) {
                return false;
            }
            Enumeration enumeration = this.queries.elements();
            while (enumeration.hasMoreElements()) {
                SearchQuery searchQuery = (SearchQuery)enumeration.nextElement();
                if (!searchQuery.isActive()) continue;
                return true;
            }
            return false;
        }

        public synchronized void itemsFound(SearchEvent searchEvent) {
            SearchQuery searchQuery = (SearchQuery)searchEvent.getSource();
            if (this.queries != null) {
                Enumeration enumeration = this.queries.elements();
                while (enumeration.hasMoreElements()) {
                    SearchQuery searchQuery2 = (SearchQuery)enumeration.nextElement();
                    if (searchQuery2 != searchQuery) continue;
                    this.fireItemsFound(searchEvent);
                }
            }
        }

        public synchronized void searchFinished(SearchEvent searchEvent) {
            SearchQuery searchQuery = (SearchQuery)searchEvent.getSource();
            if (this.queries != null) {
                Enumeration enumeration = this.queries.elements();
                while (enumeration.hasMoreElements()) {
                    SearchQuery searchQuery2 = (SearchQuery)enumeration.nextElement();
                    if (searchQuery2 != searchQuery) continue;
                    searchQuery.removeSearchListener(this);
                    this.queries.removeElement(searchQuery2);
                }
                if (this.queries.isEmpty()) {
                    this.queries = null;
                    this.fireSearchFinished();
                }
            }
        }

        public void searchStarted(SearchEvent searchEvent) {
        }

        public synchronized void start(String string, Locale locale) throws IllegalArgumentException, IllegalStateException {
            Object object;
            JHelpSearchNavigator.debug("startSearch()");
            if (this.isActive()) {
                throw new IllegalStateException();
            }
            super.start(string, locale);
            this.queries = new Vector();
            Enumeration enumeration = this.mhs.getEngines();
            while (enumeration.hasMoreElements()) {
                object = (SearchEngine)enumeration.nextElement();
                if (object == null) continue;
                this.queries.addElement(((SearchEngine)object).createQuery());
            }
            object = this.queries.elements();
            while (object.hasMoreElements()) {
                SearchQuery searchQuery = (SearchQuery)object.nextElement();
                searchQuery.addSearchListener(this);
                searchQuery.start(string, locale);
            }
        }

        public synchronized void stop() throws IllegalStateException {
            if (this.queries == null) {
                return;
            }
            this.queries = null;
        }
    }
}

