/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.graalvm.libgraal;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.charts.ChartFactory;
import org.graalvm.visualvm.charts.SimpleXYChartDescriptor;
import org.graalvm.visualvm.charts.SimpleXYChartSupport;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.NotSupportedDisplayer;
import org.graalvm.visualvm.graalvm.libgraal.MemoryModel;
import org.openide.util.NbBundle;

class MemoryViewComponent
extends JPanel {
    private static final String UNKNOWN = NbBundle.getMessage(MemoryViewComponent.class, (String)"LBL_Unknown");
    private boolean liveModel;
    private boolean memoryMonitoringSupported;
    private String heapName;
    private SimpleXYChartSupport chartSupport;

    MemoryViewComponent(MemoryModel model) {
        this.initModels(model);
        this.initComponents();
        this.refresh(model);
    }

    DataViewComponent.DetailsView getDetailsView() {
        return new DataViewComponent.DetailsView(this.heapName, null, 10, (JComponent)this, null);
    }

    private void refresh(MemoryModel model) {
        if (this.memoryMonitoringSupported) {
            long heapCapacity = model.getHeapCapacity();
            long heapUsed = model.getHeapUsed();
            long maxHeap = model.getMaxHeap();
            if (this.liveModel) {
                this.chartSupport.addValues(model.getTimestamp(), new long[]{heapCapacity, heapUsed});
            }
            this.chartSupport.updateDetails(new String[]{this.chartSupport.formatBytes(heapCapacity), this.chartSupport.formatBytes(heapUsed), this.chartSupport.formatBytes(maxHeap)});
        }
    }

    private void initModels(final MemoryModel model) {
        this.liveModel = model.isLive();
        this.memoryMonitoringSupported = true;
        String string = this.heapName = this.memoryMonitoringSupported ? model.getHeapName() : NbBundle.getMessage(MemoryViewComponent.class, (String)"LBL_Memory");
        if (this.memoryMonitoringSupported) {
            String HEAP_SIZE = NbBundle.getMessage(MemoryViewComponent.class, (String)"LBL_Heap_size");
            String HEAP_SIZE_LEG = NbBundle.getMessage(MemoryViewComponent.class, (String)"LBL_Heap_size_leg", (Object)this.heapName);
            String USED_HEAP = NbBundle.getMessage(MemoryViewComponent.class, (String)"LBL_Used_heap");
            String USED_HEAP_LEG = NbBundle.getMessage(MemoryViewComponent.class, (String)"LBL_Used_heap_leg", (Object)this.heapName.toLowerCase());
            String MAX_HEAP = NbBundle.getMessage(MemoryViewComponent.class, (String)"LBL_Max_Heap");
            SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0xA00000L, (boolean)false, (int)model.getChartCache());
            chartDescriptor.addLineFillItems(new String[]{HEAP_SIZE_LEG, USED_HEAP_LEG});
            chartDescriptor.setDetailsItems(new String[]{HEAP_SIZE, USED_HEAP, MAX_HEAP});
            chartDescriptor.setLimitYValue(model.getMaxHeap());
            this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
            model.registerHeapChartSupport(this.chartSupport);
            this.chartSupport.setZoomingEnabled(!this.liveModel);
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MemoryViewComponent.this.refresh(model);
                }
            });
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        if (this.memoryMonitoringSupported) {
            this.add((Component)this.chartSupport.getChart(), "Center");
            this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN});
        } else {
            this.add((Component)new NotSupportedDisplayer(NotSupportedDisplayer.JVM), "Center");
        }
    }
}

