/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.codec.video.vp8;

import org.jitsi.rtp.extensions.ByteKt;
import org.jitsi.utils.ByteArrayBuffer;

public class DePacketizer {
    public static boolean isKeyFrame(byte[] buf, int off, int len) {
        if (!VP8PayloadDescriptor.isValid(buf, off, len)) {
            return false;
        }
        if (!VP8PayloadDescriptor.isStartOfFrame(buf, off)) {
            return false;
        }
        int szVP8PayloadDescriptor = VP8PayloadDescriptor.getSize(buf, off, len);
        return VP8PayloadHeader.isKeyFrame(buf, off + szVP8PayloadDescriptor);
    }

    public static class VP8KeyframeHeader {
        public static int getHeight(byte[] buf, int off) {
            return ((buf[off + 6] & 0xFF) << 8 | buf[off + 5] & 0xFF) & 0x3FFF;
        }
    }

    public static class VP8PayloadHeader {
        private static final byte S_BIT = 1;

        public static boolean isKeyFrame(byte[] input, int offset) {
            return (input[offset] & 1) == 0;
        }

        public static void setKeyFrame(byte[] input, int offset, boolean keyFrame) {
            input[offset] = ByteKt.putBitWithMask(input[offset], (byte)1, !keyFrame);
        }
    }

    public static class VP8PayloadDescriptor {
        private static final byte I_BIT = -128;
        private static final byte K_BIT = 16;
        private static final byte L_BIT = 64;
        private static final byte M_BIT = -128;
        public static final int MAX_LENGTH = 6;
        private static final byte S_BIT = 16;
        private static final byte T_BIT = 32;
        private static final byte X_BIT = -128;
        private static final byte N_BIT = 32;

        public static boolean hasTemporalLayerIndex(byte[] buf, int off, int len) {
            return VP8PayloadDescriptor.getTemporalLayerIndex(buf, off, len) != -1;
        }

        public static int getTemporalLayerIndex(byte[] buf, int off, int len) {
            if (buf == null || buf.length < off + len || len < 2) {
                return -1;
            }
            if ((buf[off] & 0xFFFFFF80) == 0 || (buf[off + 1] & 0x20) == 0) {
                return -1;
            }
            int sz = VP8PayloadDescriptor.getSize(buf, off, len);
            if (buf.length < off + sz || sz < 1) {
                return -1;
            }
            return (buf[off + sz - 1] & 0xC0) >> 6;
        }

        public static boolean setTemporalLayerIndex(byte[] buf, int off, int len, int tid) {
            if (tid < 0 || tid > 3) {
                throw new IllegalArgumentException("Bad tid value " + tid);
            }
            if (buf == null || buf.length < off + len || len < 2) {
                return false;
            }
            if ((buf[off] & 0xFFFFFF80) == 0 || (buf[off + 1] & 0x20) == 0) {
                return false;
            }
            int sz = VP8PayloadDescriptor.getSize(buf, off, len);
            if (buf.length < off + sz || sz < 1) {
                return false;
            }
            buf[off + sz - 1] = (byte)(tid << 6 | buf[off + sz - 1] & 0x3F);
            return true;
        }

        public static byte[] create(boolean startOfPartition) {
            byte[] pd = new byte[]{startOfPartition ? (byte)16 : 0};
            return pd;
        }

        public static int getSize(ByteArrayBuffer baf) {
            if (baf == null) {
                return -1;
            }
            return VP8PayloadDescriptor.getSize(baf.getBuffer(), baf.getOffset(), baf.getLength());
        }

        public static int getSize(byte[] input, int offset, int length) {
            if (!VP8PayloadDescriptor.isValid(input, offset, length)) {
                return -1;
            }
            if ((input[offset] & 0xFFFFFF80) == 0) {
                return 1;
            }
            int size = 2;
            if ((input[offset + 1] & 0xFFFFFF80) != 0) {
                ++size;
                if ((input[offset + 2] & 0xFFFFFF80) != 0) {
                    ++size;
                }
            }
            if ((input[offset + 1] & 0x40) != 0) {
                ++size;
            }
            if ((input[offset + 1] & 0x30) != 0) {
                ++size;
            }
            return size;
        }

        public static boolean hasPictureId(byte[] buf, int off, int len) {
            return VP8PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 0xFFFFFF80) != 0 && (buf[off + 1] & 0xFFFFFF80) != 0;
        }

        public static boolean hasExtendedPictureId(byte[] buf, int off, int len) {
            return VP8PayloadDescriptor.hasPictureId(buf, off, len) && (buf[off + 2] & 0xFFFFFF80) != 0;
        }

        public static boolean hasTL0PICIDX(byte[] buf, int off, int len) {
            return VP8PayloadDescriptor.getLByteOffset(buf, off, len) >= 0;
        }

        public static int getPictureId(byte[] input, int offset) {
            boolean isLong;
            if (input == null || !VP8PayloadDescriptor.hasPictureId(input, offset, input.length - offset)) {
                return -1;
            }
            boolean bl = isLong = (input[offset + 2] & 0xFFFFFF80) != 0;
            if (isLong) {
                return (input[offset + 2] & 0x7F) << 8 | input[offset + 3] & 0xFF;
            }
            return input[offset + 2] & 0x7F;
        }

        public static boolean setExtendedPictureId(byte[] buf, int off, int len, int val) {
            if (!VP8PayloadDescriptor.hasExtendedPictureId(buf, off, len)) {
                return false;
            }
            buf[off + 2] = (byte)(0x80 | val >> 8 & 0x7F);
            buf[off + 3] = (byte)(val & 0xFF);
            return true;
        }

        public static boolean setTL0PICIDX(byte[] buf, int off, int len, int val) {
            int offL = VP8PayloadDescriptor.getLByteOffset(buf, off, len);
            if (offL < 0) {
                return false;
            }
            buf[off + offL] = (byte)val;
            return true;
        }

        public static boolean isValid(byte[] buf, int off, int len) {
            return buf != null && buf.length >= off + len && off > -1 && len > 0;
        }

        public static boolean isStartOfPartition(byte[] input, int offset) {
            return (input[offset] & 0x10) != 0;
        }

        public static void setStartOfPartition(byte[] input, int offset, boolean start2) {
            input[offset] = ByteKt.putBitWithMask(input[offset], (byte)16, start2);
        }

        public static boolean isStartOfFrame(byte[] input, int offset) {
            return VP8PayloadDescriptor.isStartOfPartition(input, offset) && VP8PayloadDescriptor.getPartitionId(input, offset) == 0;
        }

        public static int getPartitionId(byte[] input, int offset) {
            return input[offset] & 7;
        }

        public static boolean isReference(byte[] buf, int off, int len) {
            return (buf[off] & 0x20) == 0;
        }

        public static int getTL0PICIDX(byte[] buf, int off, int len) {
            int offL = VP8PayloadDescriptor.getLByteOffset(buf, off, len);
            if (offL < 0) {
                return -1;
            }
            return buf[off + offL] & 0xFF;
        }

        private static int getLByteOffset(byte[] buf, int off, int len) {
            if (!VP8PayloadDescriptor.isValid(buf, off, len) || (buf[off] & 0xFFFFFF80) == 0 || (buf[off + 1] & 0x40) == 0) {
                return -1;
            }
            int offL = 2;
            if ((buf[off + 1] & 0xFFFFFF80) != 0) {
                ++offL;
                if ((buf[off + 2] & 0xFFFFFF80) != 0) {
                    ++offL;
                }
            }
            return offL;
        }
    }
}

