/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharIterators;

public abstract class AbstractCharCollection
extends AbstractCollection<Character>
implements CharCollection {
    protected AbstractCharCollection() {
    }

    @Override
    public abstract CharIterator iterator();

    @Override
    public boolean add(char k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(char k) {
        CharIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextChar()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(char k) {
        CharIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextChar()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Character key) {
        return CharCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return CharCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return CharCollection.super.remove(key);
    }

    public char[] toArray(char[] a) {
        int size = this.size();
        if (a == null) {
            a = new char[size];
        } else if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        CharIterators.unwrap(this.iterator(), a);
        return a;
    }

    @Override
    public char[] toCharArray() {
        return this.toArray((char[])null);
    }

    public boolean addAll(CharCollection c) {
        boolean retVal = false;
        CharIterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.add(i.nextChar())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Character> c) {
        if (c instanceof CharCollection) {
            return this.addAll((CharCollection)c);
        }
        return super.addAll(c);
    }

    public boolean containsAll(CharCollection c) {
        CharIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.nextChar())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.containsAll((CharCollection)c);
        }
        return super.containsAll(c);
    }

    public boolean removeAll(CharCollection c) {
        boolean retVal = false;
        CharIterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.rem(i.nextChar())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.removeAll((CharCollection)c);
        }
        return super.removeAll(c);
    }

    public boolean retainAll(CharCollection c) {
        boolean retVal = false;
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.nextChar())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll((CharCollection)c);
        }
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        CharIterator i = this.iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            char k = i.nextChar();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

