/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.EmptyFileTree;
import org.gradle.api.internal.file.FileCollectionExecutionTimeValue;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;

final class EmptyFileCollection
extends AbstractFileCollection {
    public static final FileCollectionInternal INSTANCE = new EmptyFileCollection("file collection");
    private final String displayName;

    public EmptyFileCollection(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Set<File> getFiles() {
        return ImmutableSet.of();
    }

    @Override
    protected void visitContents(FileCollectionStructureVisitor visitor) {
    }

    @Override
    public FileTreeInternal getAsFileTree() {
        return new EmptyFileTree("file tree");
    }

    @Override
    public Optional<FileCollectionExecutionTimeValue> calculateExecutionTimeValue() {
        EmptyExecutionTimeValue executionTimeValue = this.displayName.equals("file collection") ? EmptyExecutionTimeValue.INSTANCE : new EmptyExecutionTimeValue(this.displayName);
        return Optional.of(executionTimeValue);
    }

    private static class EmptyExecutionTimeValue
    implements FileCollectionExecutionTimeValue {
        private static final EmptyExecutionTimeValue INSTANCE = new EmptyExecutionTimeValue("file collection");
        private final String displayName;

        public EmptyExecutionTimeValue(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public FileCollectionInternal toFileCollection(FileCollectionFactory fileCollectionFactory) {
            return FileCollectionFactory.empty(this.displayName);
        }
    }
}

