/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.nodes.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public interface TruffleObjectReferenceNode<O extends TruffleObject> {
    public FieldValue getField();

    public String getFieldName();

    public static class Renderer
    extends MultiRenderer
    implements HeapViewerRenderer {
        private final NormalBoldGrayRenderer fieldRenderer;
        private final LabelRenderer inRenderer;
        private final LabelRenderer loopToRenderer;
        private final TruffleObjectNode.Renderer dobjectRenderer;
        private final ProfilerRenderer[] renderers;
        private final Heap heap;

        public Renderer(Heap heap, Icon icon) {
            this(heap, icon, "in");
        }

        public Renderer(Heap heap, Icon icon, String divider) {
            this.heap = heap;
            this.fieldRenderer = new NormalBoldGrayRenderer(){

                public void setValue(Object value, int row) {
                    TruffleObjectReferenceNode node = (TruffleObjectReferenceNode)value;
                    String name = node.getFieldName();
                    if (name.startsWith("static ")) {
                        this.setNormalValue("static ");
                        this.setBoldValue(name.substring("static ".length()));
                    } else {
                        this.setNormalValue("");
                        this.setBoldValue(name);
                    }
                    this.setIcon(Icons.getIcon((String)"ProfilerIcons.NodeReverse"));
                }
            };
            this.inRenderer = new LabelRenderer(){

                public String toString() {
                    return " " + this.getText() + " ";
                }
            };
            this.inRenderer.setText(divider);
            this.inRenderer.setMargin(3, 0, 3, 0);
            this.loopToRenderer = new LabelRenderer(){

                public void setValue(Object value, int row) {
                    this.setVisible(value != null);
                }

                public String toString() {
                    return this.getText() + " ";
                }
            };
            this.loopToRenderer.setText(Bundle.TruffleObjectReferenceNodeRenderer_LoopTo());
            this.dobjectRenderer = new TruffleObjectNode.Renderer(heap, icon);
            this.renderers = new ProfilerRenderer[]{this.fieldRenderer, this.inRenderer, this.loopToRenderer, this.dobjectRenderer};
        }

        protected ProfilerRenderer[] valueRenderers() {
            return this.renderers;
        }

        public void setValue(Object value, int row) {
            HeapViewerNode node = (HeapViewerNode)value;
            HeapViewerNode loop = (HeapViewerNode)HeapViewerNode.getValue((HeapViewerNode)node, (DataType)DataType.LOOP, (Heap)this.heap);
            if (loop != null) {
                node = loop;
            }
            this.fieldRenderer.setValue((Object)node, row);
            this.loopToRenderer.setValue((Object)loop, row);
            this.dobjectRenderer.setValue(node, row);
            if (this.loopToRenderer.isVisible()) {
                this.dobjectRenderer.flagLoopTo();
            }
        }

        public Icon getIcon() {
            return this.fieldRenderer.getIcon();
        }

        public String getShortName() {
            return this.fieldRenderer.toString();
        }
    }

    public static abstract class InstanceBased<O extends TruffleObject.InstanceBased>
    extends TruffleObjectNode.InstanceBased<O>
    implements TruffleObjectReferenceNode<O> {
        private FieldValue field;
        private String fieldName;

        public InstanceBased(O object, String type, FieldValue value) {
            super(object, type);
            this.field = value;
        }

        @Override
        public String getName() {
            return this.getFieldName() + " in " + this.getObjectName();
        }

        @Override
        public FieldValue getField() {
            return this.field;
        }

        @Override
        public String getFieldName() {
            if (this.fieldName == null) {
                this.fieldName = (this.field.getField().isStatic() ? "static " : "") + this.field.getField().getName();
            }
            return this.fieldName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceBased)) {
                return false;
            }
            return this.field.equals(((InstanceBased)o).field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public InstanceNode createCopy() {
            return null;
        }

        protected void setupCopy(InstanceBased copy) {
            super.setupCopy(copy);
            copy.field = this.field;
            copy.fieldName = this.fieldName;
        }
    }
}

