/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class PricolProtocolDecoder
extends BaseProtocolDecoder {
    public PricolProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, buf.readSlice(7).toString(StandardCharsets.US_ASCII));
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("eventType", buf.readUnsignedByte());
        position.set("packetVersion", buf.readUnsignedByte());
        position.set("status", buf.readUnsignedByte());
        position.set("rssi", buf.readUnsignedByte());
        position.set("gps", buf.readUnsignedByte());
        position.setTime(new DateBuilder().setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).getDate());
        position.setValid(true);
        double lat = buf.getUnsignedShort(buf.readerIndex()) / 100;
        position.setLatitude(buf.readUnsignedByte() == 83 ? -lat : (lat += (double)(buf.readUnsignedShort() % 100 * 10000 + buf.readUnsignedShort()) / 600000.0));
        double lon = buf.getUnsignedMedium(buf.readerIndex()) / 100;
        position.setLongitude(buf.readUnsignedByte() == 87 ? -lon : (lon += (double)(buf.readUnsignedMedium() % 100 * 10000 + buf.readUnsignedShort()) / 600000.0));
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        position.set("input", buf.readUnsignedShort());
        position.set("output", buf.readUnsignedByte());
        position.set("analogAlerts", buf.readUnsignedByte());
        position.set("customAlertTypes", buf.readUnsignedShort());
        for (int i = 1; i <= 5; ++i) {
            position.set("adc" + i, buf.readUnsignedShort());
        }
        position.set("odometer", buf.readUnsignedMedium());
        position.set("rpm", buf.readUnsignedShort());
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)"ACK", (Charset)StandardCharsets.US_ASCII), remoteAddress));
        }
        return position;
    }
}

