/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 / vec3(-0.03, -0.85, -0.94)) => vec3(-0.0, -0.0, -0.0)
 * (0.0 / vec3(1.67, 0.66, 1.87)) => vec3(0.0, 0.0, 0.0)
 * (-1.33 / vec3(-0.03, -0.85, -0.94)) => vec3(44.333336, 1.5647058, 1.4148936)
 * (-1.33 / vec3(1.67, 0.66, 1.87)) => vec3(-0.7964072, -2.0151515, -0.71123)
 * (0.85 / vec3(-0.03, -0.85, -0.94)) => vec3(-28.333334, -1.0, -0.90425533)
 * (0.85 / vec3(1.67, 0.66, 1.87)) => vec3(0.50898206, 1.2878788, 0.45454547)
 */
#version 120

void main()
{
  float[distance((0.0 / vec3(-0.03, -0.85, -0.94)), vec3(-0.0, -0.0, -0.0)) <= 0.0 ? 1 : -1] array0;
  float[distance((0.0 / vec3(1.67, 0.66, 1.87)), vec3(0.0, 0.0, 0.0)) <= 0.0 ? 1 : -1] array1;
  float[distance((-1.33 / vec3(-0.03, -0.85, -0.94)), vec3(44.333336, 1.5647058, 1.4148936)) <= 0.000443835 ? 1 : -1] array2;
  float[distance((-1.33 / vec3(1.67, 0.66, 1.87)), vec3(-0.7964072, -2.0151515, -0.71123)) <= 2.2805587e-05 ? 1 : -1] array3;
  float[distance((0.85 / vec3(-0.03, -0.85, -0.94)), vec3(-28.333334, -1.0, -0.90425533)) <= 0.00028365394 ? 1 : -1] array4;
  float[distance((0.85 / vec3(1.67, 0.66, 1.87)), vec3(0.50898206, 1.2878788, 0.45454547)) <= 1.4574999e-05 ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
