%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/center-text-below-hairpin-dynamics.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: 0cc270b871321ae5aa8622cea8d8262aafd16641
  texidocja = "
この例はヘアピンの (デ) クレッシェンドの下に @qq{molto} や @qq{poco}
のようなテキストを追加する機能を提供しています。@c
テキストの向きは、ヘアピンの向きに応じて変更されます。ヘアピンは DynamicText
に揃えられます。

この例は Scheme コードを用いて、オブジェクトが通常どのように表示されるかを@c
変更する方法も示しています。
"
  doctitleja = "ヘアピンの下にテキストを中央揃えする"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
La fonction comprise dans l'extrait suivant permet d'ajouter du texte
-- comme « molto » ou « poco » -- en dessous d'un soufflet de
(de)crescendo.  Cet exemple présente aussi comment, à l'aide de code
Scheme, influencer la manière dont un objet est normalement imprimé.
"

  doctitlefr = "Texte centré sous un soufflet"

%% Translation of GIT committish: 00f0ca84dbb015617f8ce36dd13db59bbfef8f11
  texidoces = "
Este ejemplo proporciona una función para tipografiar un regulador con
texto por debajo, como @qq{molto} o @qq{poco}.  El texto añadido
cambia la dirección de acuerdo con la del regulador.  El objeto
Hairpin está alineado con DynamicText.

El ejemplo ilustra también cómo modificar la manera en que se imprime
normalmente un objeto, utilizando código de Scheme.

"
  doctitlees = "Centrar texto debajo de un regulador"

%% Translation of GIT committish: 46821fda434ae17eccc778bd1a0276e785fffdf6
  texidocca = "
Aquest exemple proporciona una funció per escriure un regulador
amb text a sota, com @qq{molto} o @qq{poco}.  El text afegit
canvia la direcció d'acord amb la del regulador.  L'objecte
hairpin està alineat amb DynamicText.

L'exemple il·lustra també com modificar la manera en la qual 
s'imprimeix normalment un object, utilitzat codi de l'Scheme.

"
  doctitleca = "Centrar text a sota d'un regulador"

  lsrtags = "expressive-marks, really-cool, scheme-language, text"

  texidoc = "
This example provides a function to typeset a hairpin (de)crescendo
with some additional text below it, such as @qq{molto} or @qq{poco}. The
added text will change the direction according to the direction of the
hairpin. The Hairpin is aligned to DynamicText.

The example also illustrates how to modify the way an object is
normally printed, using some Scheme code.
"

  doctitle = "Center text below hairpin dynamics"
} % begin verbatim


\paper { tagline = ##f }

hairpinWithCenteredText =
#(define-music-function (text) (markup?)
  #{
    \once \override Voice.Hairpin.after-line-breaking =
      #(lambda (grob)
        (let* ((stencil (ly:hairpin::print grob))
               (par-y (ly:grob-parent grob Y))
               (dir (ly:grob-property par-y 'direction))
               (staff-line-thickness
                 (ly:output-def-lookup (ly:grob-layout grob) 'line-thickness))
               (new-stencil (ly:stencil-aligned-to
                 (ly:stencil-combine-at-edge
                   (ly:stencil-aligned-to stencil X CENTER)
                   Y dir
                   (ly:stencil-aligned-to
                     (grob-interpret-markup
                       grob
                       (make-fontsize-markup
                         (magnification->font-size
                           (+ (ly:staff-symbol-staff-space grob)
                              (/ staff-line-thickness 2)))
                           text)) X CENTER))
                 X LEFT))
               (staff-space (ly:output-def-lookup
                 (ly:grob-layout grob) 'staff-space))
               (par-x (ly:grob-parent grob X))
               (dyn-text (grob::has-interface par-x 'dynamic-text-interface))
               (dyn-text-stencil-x-length
                 (if dyn-text
                   (interval-length
                     (ly:stencil-extent (ly:grob-property par-x 'stencil) X))
                   0))
               (x-shift
                 (if dyn-text
                   (-
                     (+ staff-space dyn-text-stencil-x-length)
                     (* 0.5 staff-line-thickness)) 0)))

        (ly:grob-set-property! grob 'Y-offset 0)
        (ly:grob-set-property! grob 'stencil
           (ly:stencil-translate-axis
            new-stencil
            x-shift X))))
  #})

hairpinMolto =
\hairpinWithCenteredText \markup { \italic molto }

hairpinMore =
\hairpinWithCenteredText \markup { \larger moltissimo }

\layout { ragged-right = ##f }

\relative c' {
  \hairpinMolto
  c2\< c\f
  \hairpinMore
  c2\ppppp\< c\f
  \break
  \hairpinMolto
  c2^\< c\f
  \hairpinMore
  c2\ppppp\< c\f
}



% ****************************************************************
% end ly snippet
% ****************************************************************
