/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.provider.JingleContentTransportProvider;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;

public class JingleS5BTransportProvider
extends JingleContentTransportProvider<JingleS5BTransport> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public JingleS5BTransport parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        JingleS5BTransport.Builder builder2 = JingleS5BTransport.getBuilder();
        String streamId = parser2.getAttributeValue(null, "sid");
        builder2.setStreamId(streamId);
        String dstAddr = parser2.getAttributeValue(null, "dstaddr");
        builder2.setDestinationAddress(dstAddr);
        String mode = parser2.getAttributeValue(null, "mode");
        if (mode != null) {
            builder2.setMode(mode.equals(Bytestream.Mode.udp.toString()) ? Bytestream.Mode.udp : Bytestream.Mode.tcp);
        }
        while (true) {
            XmlPullParser.TagEvent tag = parser2.nextTag();
            block0 : switch (tag) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "candidate": {
                            String typeString;
                            JingleS5BTransportCandidate.Builder cb = JingleS5BTransportCandidate.getBuilder();
                            cb.setCandidateId(parser2.getAttributeValue(null, "cid"));
                            cb.setHost(ParserUtils.getInternetAddressIngoringZoneIdAttribute(parser2, "host"));
                            cb.setJid(parser2.getAttributeValue(null, "jid"));
                            cb.setPriority(Integer.parseInt(parser2.getAttributeValue(null, "priority")));
                            String portString = parser2.getAttributeValue(null, "port");
                            if (portString != null) {
                                cb.setPort(Integer.parseInt(portString));
                            }
                            if ((typeString = parser2.getAttributeValue(null, "type")) != null) {
                                cb.setType(JingleS5BTransportCandidate.Type.fromString(typeString));
                            }
                            builder2.addTransportCandidate(cb.build());
                            break block0;
                        }
                        case "activated": {
                            builder2.setTransportInfo(new JingleS5BTransportInfo.CandidateActivated(parser2.getAttributeValue(null, "cid")));
                            break block0;
                        }
                        case "candidate-used": {
                            builder2.setTransportInfo(new JingleS5BTransportInfo.CandidateUsed(parser2.getAttributeValue(null, "cid")));
                            break block0;
                        }
                        case "candidate-error": {
                            builder2.setTransportInfo(JingleS5BTransportInfo.CandidateError.INSTANCE);
                            break block0;
                        }
                        case "proxy-error": {
                            builder2.setTransportInfo(JingleS5BTransportInfo.ProxyError.INSTANCE);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return builder2.build();
                }
            }
        }
    }
}

