/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.command;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.MulticastMessage;
import com.google.firebase.messaging.SendResponse;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.traccar.command.CommandSender;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Command;
import org.traccar.model.Device;

@Singleton
public class FirebaseCommandSender
implements CommandSender {
    private final FirebaseMessaging firebaseMessaging;

    @Inject
    public FirebaseCommandSender(Config config) throws IOException {
        ByteArrayInputStream serviceAccount = new ByteArrayInputStream(config.getString(Keys.COMMAND_CLIENT_SERVICE_ACCOUNT).getBytes());
        FirebaseOptions options = FirebaseOptions.builder().setCredentials(GoogleCredentials.fromStream((InputStream)serviceAccount)).build();
        this.firebaseMessaging = FirebaseMessaging.getInstance((FirebaseApp)FirebaseApp.initializeApp((FirebaseOptions)options, (String)"client"));
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return List.of("positionSingle", "positionPeriodic", "positionStop", "factoryReset");
    }

    @Override
    public void sendCommand(Device device, Command command) throws Exception {
        if (!device.hasAttribute("notificationTokens")) {
            throw new RuntimeException("Missing device notification tokens");
        }
        ArrayList<String> registrationTokens = new ArrayList<String>(Arrays.asList(device.getString("notificationTokens").split("[, ]")));
        AndroidConfig androidConfig = AndroidConfig.builder().setPriority(AndroidConfig.Priority.HIGH).build();
        ApnsConfig apnsConfig = ApnsConfig.builder().setAps(Aps.builder().setContentAvailable(true).build()).putHeader("apns-push-type", "background").putHeader("apns-priority", "10").build();
        MulticastMessage message = MulticastMessage.builder().putData("command", command.getType()).setAndroidConfig(androidConfig).setApnsConfig(apnsConfig).addAllTokens(registrationTokens).build();
        BatchResponse result = this.firebaseMessaging.sendEachForMulticast(message);
        if (result.getFailureCount() > 0) {
            throw ((SendResponse)result.getResponses().iterator().next()).getException();
        }
    }
}

