/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.ipatuura_user_spi;

import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.ipatuura_user_spi.Ipatuura;
import org.keycloak.ipatuura_user_spi.IpatuuraUserStorageProvider;
import org.keycloak.ipatuura_user_spi.authenticator.IpatuuraAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProviderFactory;

public class IpatuuraUserStorageProviderFactory
implements UserStorageProviderFactory<IpatuuraUserStorageProvider>,
EnvironmentDependentProviderFactory {
    private static final Logger logger = Logger.getLogger(IpatuuraUserStorageProviderFactory.class);
    public static final String PROVIDER_NAME = "ipatuura";
    protected static final List<String> PROVIDERS = new LinkedList<String>();
    protected static final List<ProviderConfigProperty> configMetadata;

    public List<ProviderConfigProperty> getConfigProperties() {
        return configMetadata;
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        Ipatuura ipatuura = new Ipatuura(session, config);
        try {
            SimpleHttp.Response response = ipatuura.clientRequest("", "GET", null);
            response.close();
        }
        catch (Exception e) {
            throw new ComponentValidationException("Cannot connect to provided URL!", (Throwable)e);
        }
    }

    public String getId() {
        return PROVIDER_NAME;
    }

    public IpatuuraUserStorageProvider create(KeycloakSession session, ComponentModel model) {
        Ipatuura ipatuura = new Ipatuura(session, model);
        return new IpatuuraUserStorageProvider(session, model, ipatuura, this);
    }

    protected IpatuuraAuthenticator createSCIMAuthenticator() {
        return new IpatuuraAuthenticator();
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.IPA_TUURA_FEDERATION);
    }

    static {
        PROVIDERS.add("ipa");
        PROVIDERS.add("ad");
        PROVIDERS.add("ldap");
        configMetadata = ProviderConfigurationBuilder.create().property().name("scimurl").type("String").label("Ipatuura Server URL").helpText("Backend ipatuura server URL in the format: server.example.com:8080").add().property().name("loginusername").type("String").label("Login username").helpText("Username to authenticate through the server").add().property().name("loginpassword").type("Password").label("Login password").helpText("password to authenticate through the server").secret(true).add().build();
    }
}

