/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.annotations.Recorder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;

@Recorder
public class PreloadClassesRecorder {
    public static final String QUARKUS_GENERATED_PRELOAD_CLASSES_FILE = "quarkus-generated-preload-classes.txt";

    public static void preloadClass(String classname, boolean initialize) {
        try {
            Class.forName(classname, initialize, PreloadClassesRecorder.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void preloadClasses(boolean initialize) {
        InputStream is;
        try {
            Enumeration<URL> files = PreloadClassesRecorder.class.getClassLoader().getResources("META-INF/quarkus-preload-classes.txt");
            while (files.hasMoreElements()) {
                URL url = files.nextElement();
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                InputStream is2 = conn.getInputStream();
                PreloadClassesRecorder.preloadClassesFromStream(is2, initialize);
            }
        }
        catch (IOException files) {
            // empty catch block
        }
        if ((is = PreloadClassesRecorder.class.getResourceAsStream("/META-INF/quarkus-generated-preload-classes.txt")) != null) {
            PreloadClassesRecorder.preloadClassesFromStream(is, initialize);
        }
    }

    public static void preloadClassesFromStream(InputStream is, boolean initialize) {
        try (InputStream inputStream = is;
             InputStreamReader isr = new InputStreamReader(is);
             BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                String className;
                int idx = line.indexOf(35);
                if (idx != -1) {
                    line = line.substring(0, idx);
                }
                if ((className = line.stripTrailing()).isBlank()) continue;
                PreloadClassesRecorder.preloadClass(className, initialize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void invokePreloadClasses(boolean initialize) {
        PreloadClassesRecorder.preloadClasses(initialize);
    }
}

