/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.PrintStream;

class IntegerArray {
    private int[] _array;
    private int _size;
    private int _free = 0;
    private static final int InitialSize = 128;

    public IntegerArray() {
        this._size = 128;
        this._array = new int[128];
    }

    public IntegerArray(int n) {
        this._size = n;
        this._array = new int[this._size];
    }

    public void add(int n) {
        if (this._free == this._size) {
            this.growArray(this._size * 2);
        }
        this._array[this._free++] = n;
    }

    public int at(int n) {
        return this._array[n];
    }

    public int cardinality() {
        return this._free;
    }

    public void clear() {
        this._free = 0;
    }

    private void growArray(int n) {
        this._size = n;
        int[] nArray = new int[this._size];
        System.arraycopy(this._array, 0, nArray, 0, this._free);
        this._array = nArray;
    }

    public int indexOf(int n) {
        int n2 = 0;
        int n3 = this._free;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            if (this._array[n4] < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n < this._array[n4]) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -1;
    }

    public int popLast() {
        return this._array[--this._free];
    }

    public void print(PrintStream printStream) {
        int n = 0;
        while (n < this._free - 1) {
            printStream.print(this._array[n]);
            printStream.print(' ');
            ++n;
        }
        printStream.println(this._array[this._free - 1]);
    }

    public void toDifferences(IntegerArray integerArray) {
        if (integerArray._size < this._size) {
            integerArray.growArray(this._size);
        }
        if ((integerArray._free = this._free) > 0) {
            integerArray._array[0] = this._array[0];
            int n = 1;
            while (n < this._free) {
                integerArray._array[n] = this._array[n] - this._array[n - 1];
                ++n;
            }
        }
    }
}

