/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;

public class ExecutorFactory {
    public static ScheduledExecutorService createSingleThreadScheduledExecutor(String threadNamePrefix, int threadKeepAliveTime, TimeUnit timeUnit) {
        return ExecutorFactory.createScheduledExecutor(1, threadNamePrefix, threadKeepAliveTime, timeUnit);
    }

    public static ScheduledExecutorService createCPUBoundScheduledExecutor(String threadNamePrefix, int threadKeepAliveTime, TimeUnit timeUnit) {
        return ExecutorFactory.createScheduledExecutor(Runtime.getRuntime().availableProcessors(), threadNamePrefix, threadKeepAliveTime, timeUnit);
    }

    private static ScheduledExecutorService createScheduledExecutor(int poolSize, String threadNamePrefix, int threadKeepAliveTime, TimeUnit timeUnit) {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(threadNamePrefix, true);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(poolSize, threadFactory);
        executor.setKeepAliveTime(threadKeepAliveTime, timeUnit);
        executor.allowCoreThreadTimeOut(true);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public static ExecutorService createFixedThreadPool(int threadsLimit, String threadNamePrefix) {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(threadNamePrefix, true);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadsLimit, threadsLimit, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), threadFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ExecutorService createCachedThreadPool(String threadNamePrefix) {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(threadNamePrefix, true);
        return Executors.newCachedThreadPool(threadFactory);
    }
}

