////////////////////////////////////////////////////////////////////////////
// Name:        wx/stc/stc.h
// Purpose:     A wxWidgets implementation of Scintilla.  This class is the
//              one meant to be used directly by wx applications.  It does not
//              derive directly from the Scintilla classes, and in fact there
//              is no mention of Scintilla classes at all in this header.
//              This class delegates all method calls and events to the
//              Scintilla objects and so forth.  This allows the use of
//              Scintilla without polluting the namespace with all the
//              classes and identifiers from Scintilla.
//
// Author:      Robin Dunn
//
// Created:     13-Jan-2000
// Copyright:   (c) 2000 by Total Control Software
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

/*
    IMPORTANT: include/wx/stc/stc.h is generated by src/stc/gen_iface.py from
               src/stc/stc.h.in, don't edit stc.h file as your changes will be
               lost after the next regeneration, edit stc.h.in and rerun the
               gen_iface.py script instead!

               Parts of this file generated by the script are found in between
               the special "{{{" and "}}}" markers, the rest of it is copied
               verbatim from src.h.in.
 */

#ifndef __WXSCINTILLA_H__
#define __WXSCINTILLA_H__

#include <wx/defs.h>

/* C::B -> Don't forget to change version number here and in wxscintilla.cpp at the bottom */
#define wxSCINTILLA_VERSION _T("3.75.0")

#include <wx/control.h>
#include <wx/dnd.h>
#include <wx/stopwatch.h>
/* C::B begin */
#include <wx/scrolbar.h>
#if wxCHECK_VERSION(3, 0, 0)
#include <wx/versioninfo.h>
#endif

#ifdef WXMAKINGDLL_SCI
    #define WXDLLIMPEXP_SCI WXEXPORT
#elif defined(WXUSINGDLL_SCI) || defined(WXUSINGDLL)
    #define WXDLLIMPEXP_SCI WXIMPORT
#else // not making nor using DLL
    #define WXDLLIMPEXP_SCI
#endif
/* C::B end */

class WXDLLIMPEXP_FWD_CORE wxScrollBar;

// SWIG can't handle "#if" type of conditionals, only "#ifdef"
#ifdef SWIG
#define SCI_USE_DND 1
#else
#if wxUSE_DRAG_AND_DROP
#define SCI_USE_DND 1
#endif
#endif

//----------------------------------------------------------------------
// SCI constants generated section {{{

#define wxSCI_INVALID_POSITION -1

/// Define start of Scintilla messages to be greater than all Windows edit (EM_*) messages
/// as many EM_ messages can be used although that use is deprecated.
#define wxSCI_START 2000
#define wxSCI_OPTIONAL_START 3000
#define wxSCI_LEXER_START 4000
#define wxSCI_WS_INVISIBLE 0
#define wxSCI_WS_VISIBLEALWAYS 1
#define wxSCI_WS_VISIBLEAFTERINDENT 2
#define wxSCI_WS_VISIBLEONLYININDENT 3
#define wxSCI_TD_LONGARROW 0
#define wxSCI_TD_STRIKEOUT 1
#define wxSCI_EOL_CRLF 0
#define wxSCI_EOL_CR 1
#define wxSCI_EOL_LF 2

/// The SC_CP_UTF8 value can be used to enter Unicode mode.
/// This is the same value as CP_UTF8 in Windows
#define wxSCI_CP_UTF8 65001
#define wxSCI_IME_WINDOWED 0
#define wxSCI_IME_INLINE 1
#define wxSCI_MARKER_MAX 31
#define wxSCI_MARK_CIRCLE 0
#define wxSCI_MARK_ROUNDRECT 1
#define wxSCI_MARK_ARROW 2
#define wxSCI_MARK_SMALLRECT 3
#define wxSCI_MARK_SHORTARROW 4
#define wxSCI_MARK_EMPTY 5
#define wxSCI_MARK_ARROWDOWN 6
#define wxSCI_MARK_MINUS 7
#define wxSCI_MARK_PLUS 8

/// Shapes used for outlining column.
#define wxSCI_MARK_VLINE 9
#define wxSCI_MARK_LCORNER 10
#define wxSCI_MARK_TCORNER 11
#define wxSCI_MARK_BOXPLUS 12
#define wxSCI_MARK_BOXPLUSCONNECTED 13
#define wxSCI_MARK_BOXMINUS 14
#define wxSCI_MARK_BOXMINUSCONNECTED 15
#define wxSCI_MARK_LCORNERCURVE 16
#define wxSCI_MARK_TCORNERCURVE 17
#define wxSCI_MARK_CIRCLEPLUS 18
#define wxSCI_MARK_CIRCLEPLUSCONNECTED 19
#define wxSCI_MARK_CIRCLEMINUS 20
#define wxSCI_MARK_CIRCLEMINUSCONNECTED 21

/// Invisible mark that only sets the line background colour.
#define wxSCI_MARK_BACKGROUND 22
#define wxSCI_MARK_DOTDOTDOT 23
#define wxSCI_MARK_ARROWS 24
#define wxSCI_MARK_PIXMAP 25
#define wxSCI_MARK_FULLRECT 26
#define wxSCI_MARK_LEFTRECT 27
#define wxSCI_MARK_AVAILABLE 28
#define wxSCI_MARK_UNDERLINE 29
#define wxSCI_MARK_RGBAIMAGE 30
#define wxSCI_MARK_BOOKMARK 31
#define wxSCI_MARK_CHARACTER 10000

/* C::B begin */
#define wxSCI_MARKNUM_LASTUNUSED 22
/* C::B end */
/* CHANGEBAR begin */
// Markers used for outlining and changed column.
#define wxSCI_MARKNUM_CHANGEUNSAVED 23
#define wxSCI_MARKNUM_CHANGESAVED 24
/* CHANGEBAR end */
#define wxSCI_MARKNUM_FOLDEREND 25
#define wxSCI_MARKNUM_FOLDEROPENMID 26
#define wxSCI_MARKNUM_FOLDERMIDTAIL 27
#define wxSCI_MARKNUM_FOLDERTAIL 28
#define wxSCI_MARKNUM_FOLDERSUB 29
#define wxSCI_MARKNUM_FOLDER 30
#define wxSCI_MARKNUM_FOLDEROPEN 31
/* CHANGEBAR begin */
#define wxSCI_MASK_FOLDERS 0xFF800000
/* CHANGEBAR end */
#define wxSCI_MAX_MARGIN 4
#define wxSCI_MARGIN_SYMBOL 0
#define wxSCI_MARGIN_NUMBER 1
#define wxSCI_MARGIN_BACK 2
#define wxSCI_MARGIN_FORE 3
#define wxSCI_MARGIN_TEXT 4
#define wxSCI_MARGIN_RTEXT 5
#define wxSCI_MARGIN_COLOUR 6
/* CHANGEBAR begin */
#define wxSCI_MARGIN_CHANGED 7
/* CHANGEBAR end */

/// Styles in range 32..38 are predefined for parts of the UI and are not used as normal styles.
/// Style 39 is for future use.
#define wxSCI_STYLE_DEFAULT 32
#define wxSCI_STYLE_LINENUMBER 33
#define wxSCI_STYLE_BRACELIGHT 34
#define wxSCI_STYLE_BRACEBAD 35
#define wxSCI_STYLE_CONTROLCHAR 36
#define wxSCI_STYLE_INDENTGUIDE 37
#define wxSCI_STYLE_CALLTIP 38
#define wxSCI_STYLE_FOLDDISPLAYTEXT 39
#define wxSCI_STYLE_LASTPREDEFINED 39
#define wxSCI_STYLE_MAX 255

/// Character set identifiers are used in StyleSetCharacterSet.
/// The values are the same as the Windows *_CHARSET values.
#define wxSCI_CHARSET_ANSI 0
#define wxSCI_CHARSET_DEFAULT 1
#define wxSCI_CHARSET_BALTIC 186
#define wxSCI_CHARSET_CHINESEBIG5 136
#define wxSCI_CHARSET_EASTEUROPE 238
#define wxSCI_CHARSET_GB2312 134
#define wxSCI_CHARSET_GREEK 161
#define wxSCI_CHARSET_HANGUL 129
#define wxSCI_CHARSET_MAC 77
#define wxSCI_CHARSET_OEM 255
#define wxSCI_CHARSET_RUSSIAN 204
#define wxSCI_CHARSET_OEM866 866
#define wxSCI_CHARSET_CYRILLIC 1251
#define wxSCI_CHARSET_SHIFTJIS 128
#define wxSCI_CHARSET_SYMBOL 2
#define wxSCI_CHARSET_TURKISH 162
#define wxSCI_CHARSET_JOHAB 130
#define wxSCI_CHARSET_HEBREW 177
#define wxSCI_CHARSET_ARABIC 178
#define wxSCI_CHARSET_VIETNAMESE 163
#define wxSCI_CHARSET_THAI 222
#define wxSCI_CHARSET_8859_15 1000
#define wxSCI_CASE_MIXED 0
#define wxSCI_CASE_UPPER 1
#define wxSCI_CASE_LOWER 2
#define wxSCI_CASE_CAMEL 3
#define wxSCI_FONT_SIZE_MULTIPLIER 100
#define wxSCI_WEIGHT_NORMAL 400
#define wxSCI_WEIGHT_SEMIBOLD 600
#define wxSCI_WEIGHT_BOLD 700

/// Indicator style enumeration and some constants
#define wxSCI_INDIC_PLAIN 0
#define wxSCI_INDIC_SQUIGGLE 1
#define wxSCI_INDIC_TT 2
#define wxSCI_INDIC_DIAGONAL 3
#define wxSCI_INDIC_STRIKE 4
#define wxSCI_INDIC_HIDDEN 5
#define wxSCI_INDIC_BOX 6
#define wxSCI_INDIC_ROUNDBOX 7
#define wxSCI_INDIC_STRAIGHTBOX 8
#define wxSCI_INDIC_DASH 9
#define wxSCI_INDIC_DOTS 10
#define wxSCI_INDIC_SQUIGGLELOW 11
#define wxSCI_INDIC_DOTBOX 12
#define wxSCI_INDIC_SQUIGGLEPIXMAP 13
#define wxSCI_INDIC_COMPOSITIONTHICK 14
#define wxSCI_INDIC_COMPOSITIONTHIN 15
#define wxSCI_INDIC_FULLBOX 16
#define wxSCI_INDIC_TEXTFORE 17
#define wxSCI_INDIC_POINT 18
#define wxSCI_INDIC_POINTCHARACTER 19
/* C::B begin INDIC_HIGHLIGHT */
#define wxSCI_INDIC_HIGHLIGHT 31 // please change also in wxscintilla.h !!
/* C::B end */
#define wxSCI_INDIC_IME 32
#define wxSCI_INDIC_IME_MAX 35
#define wxSCI_INDIC_MAX 35
#define wxSCI_INDIC_CONTAINER 8
#define wxSCI_INDICVALUEBIT 0x1000000
#define wxSCI_INDICVALUEMASK 0xFFFFFF
#define wxSCI_INDICFLAG_VALUEFORE 1
#define wxSCI_IV_NONE 0
#define wxSCI_IV_REAL 1
#define wxSCI_IV_LOOKFORWARD 2
#define wxSCI_IV_LOOKBOTH 3

/// PrintColourMode - use same colours as screen.
#define wxSCI_PRINT_NORMAL 0

/// PrintColourMode - invert the light value of each style for printing.
#define wxSCI_PRINT_INVERTLIGHT 1

/// PrintColourMode - force black text on white background for printing.
#define wxSCI_PRINT_BLACKONWHITE 2

/// PrintColourMode - text stays coloured, but all background is forced to be white for printing.
#define wxSCI_PRINT_COLOURONWHITE 3

/// PrintColourMode - only the default-background is forced to be white for printing.
#define wxSCI_PRINT_COLOURONWHITEDEFAULTBG 4
#define wxSCI_FIND_WHOLEWORD 0x2
#define wxSCI_FIND_MATCHCASE 0x4
#define wxSCI_FIND_WORDSTART 0x00100000
#define wxSCI_FIND_REGEXP 0x00200000
#define wxSCI_FIND_POSIX 0x00400000
#define wxSCI_FIND_CXX11REGEX 0x00800000
#define wxSCI_FOLDLEVELBASE 0x400
#define wxSCI_FOLDLEVELWHITEFLAG 0x1000
#define wxSCI_FOLDLEVELHEADERFLAG 0x2000
#define wxSCI_FOLDLEVELNUMBERMASK 0x0FFF
#define wxSCI_FOLDDISPLAYTEXT_HIDDEN 0
#define wxSCI_FOLDDISPLAYTEXT_STANDARD 1
#define wxSCI_FOLDDISPLAYTEXT_BOXED 2
#define wxSCI_FOLDACTION_CONTRACT 0
#define wxSCI_FOLDACTION_EXPAND 1
#define wxSCI_FOLDACTION_TOGGLE 2
#define wxSCI_AUTOMATICFOLD_SHOW 0x0001
#define wxSCI_AUTOMATICFOLD_CLICK 0x0002
#define wxSCI_AUTOMATICFOLD_CHANGE 0x0004
#define wxSCI_FOLDFLAG_LINEBEFORE_EXPANDED 0x0002
#define wxSCI_FOLDFLAG_LINEBEFORE_CONTRACTED 0x0004
#define wxSCI_FOLDFLAG_LINEAFTER_EXPANDED 0x0008
#define wxSCI_FOLDFLAG_LINEAFTER_CONTRACTED 0x0010
#define wxSCI_FOLDFLAG_LEVELNUMBERS 0x0040
#define wxSCI_FOLDFLAG_LINESTATE 0x0080
#define wxSCI_TIME_FOREVER 10000000
#define wxSCI_IDLESTYLING_NONE 0
#define wxSCI_IDLESTYLING_TOVISIBLE 1
#define wxSCI_IDLESTYLING_AFTERVISIBLE 2
#define wxSCI_IDLESTYLING_ALL 3
#define wxSCI_WRAP_NONE 0
#define wxSCI_WRAP_WORD 1
#define wxSCI_WRAP_CHAR 2
#define wxSCI_WRAP_WHITESPACE 3
#define wxSCI_WRAPVISUALFLAG_NONE 0x0000
#define wxSCI_WRAPVISUALFLAG_END 0x0001
#define wxSCI_WRAPVISUALFLAG_START 0x0002
#define wxSCI_WRAPVISUALFLAG_MARGIN 0x0004
#define wxSCI_WRAPVISUALFLAGLOC_DEFAULT 0x0000
#define wxSCI_WRAPVISUALFLAGLOC_END_BY_TEXT 0x0001
#define wxSCI_WRAPVISUALFLAGLOC_START_BY_TEXT 0x0002
#define wxSCI_WRAPINDENT_FIXED 0
#define wxSCI_WRAPINDENT_SAME 1
#define wxSCI_WRAPINDENT_INDENT 2
#define wxSCI_CACHE_NONE 0
#define wxSCI_CACHE_CARET 1
#define wxSCI_CACHE_PAGE 2
#define wxSCI_CACHE_DOCUMENT 3
#define wxSCI_PHASES_ONE 0
#define wxSCI_PHASES_TWO 1
#define wxSCI_PHASES_MULTIPLE 2

/// Control font anti-aliasing.
#define wxSCI_EFF_QUALITY_MASK 0xF
#define wxSCI_EFF_QUALITY_DEFAULT 0
#define wxSCI_EFF_QUALITY_NON_ANTIALIASED 1
#define wxSCI_EFF_QUALITY_ANTIALIASED 2
#define wxSCI_EFF_QUALITY_LCD_OPTIMIZED 3
#define wxSCI_MULTIPASTE_ONCE 0
#define wxSCI_MULTIPASTE_EACH 1
#define wxSCI_EDGE_NONE 0
#define wxSCI_EDGE_LINE 1
#define wxSCI_EDGE_BACKGROUND 2
#define wxSCI_EDGE_MULTILINE 3
#define wxSCI_POPUP_NEVER 0
#define wxSCI_POPUP_ALL 1
#define wxSCI_POPUP_TEXT 2
#define wxSCI_STATUS_OK 0
#define wxSCI_STATUS_FAILURE 1
#define wxSCI_STATUS_BADALLOC 2
#define wxSCI_STATUS_WARN_START 1000
#define wxSCI_STATUS_WARN_REGEX 1001
#define wxSCI_CURSORNORMAL -1
#define wxSCI_CURSORARROW 2
#define wxSCI_CURSORWAIT 4
#define wxSCI_CURSORREVERSEARROW 7

/// Constants for use with SetVisiblePolicy, similar to SetCaretPolicy.
#define wxSCI_VISIBLE_SLOP 0x01
#define wxSCI_VISIBLE_STRICT 0x04

/// Caret policy, used by SetXCaretPolicy and SetYCaretPolicy.
/// If CARET_SLOP is set, we can define a slop value: caretSlop.
/// This value defines an unwanted zone (UZ) where the caret is... unwanted.
/// This zone is defined as a number of pixels near the vertical margins,
/// and as a number of lines near the horizontal margins.
/// By keeping the caret away from the edges, it is seen within its context,
/// so it is likely that the identifier that the caret is on can be completely seen,
/// and that the current line is seen with some of the lines following it which are
/// often dependent on that line.
#define wxSCI_CARET_SLOP 0x01

/// If CARET_STRICT is set, the policy is enforced... strictly.
/// The caret is centred on the display if slop is not set,
/// and cannot go in the UZ if slop is set.
#define wxSCI_CARET_STRICT 0x04

/// If CARET_JUMPS is set, the display is moved more energetically
/// so the caret can move in the same direction longer before the policy is applied again.
#define wxSCI_CARET_JUMPS 0x10

/// If CARET_EVEN is not set, instead of having symmetrical UZs,
/// the left and bottom UZs are extended up to right and top UZs respectively.
/// This way, we favour the displaying of useful information: the beginning of lines,
/// where most code reside, and the lines after the caret, eg. the body of a function.
#define wxSCI_CARET_EVEN 0x08
#define wxSCI_SEL_STREAM 0
#define wxSCI_SEL_RECTANGLE 1
#define wxSCI_SEL_LINES 2
#define wxSCI_SEL_THIN 3
#define wxSCI_CASEINSENSITIVEBEHAVIOUR_RESPECTCASE 0
#define wxSCI_CASEINSENSITIVEBEHAVIOUR_IGNORECASE 1
#define wxSCI_MULTIAUTOC_ONCE 0
#define wxSCI_MULTIAUTOC_EACH 1
#define wxSCI_ORDER_PRESORTED 0
#define wxSCI_ORDER_PERFORMSORT 1
#define wxSCI_ORDER_CUSTOM 2
#define wxSCI_CARETSTICKY_OFF 0
#define wxSCI_CARETSTICKY_ON 1
#define wxSCI_CARETSTICKY_WHITESPACE 2
#define wxSCI_ALPHA_TRANSPARENT 0
#define wxSCI_ALPHA_OPAQUE 255
#define wxSCI_ALPHA_NOALPHA 256
#define wxSCI_CARETSTYLE_INVISIBLE 0
#define wxSCI_CARETSTYLE_LINE 1
#define wxSCI_CARETSTYLE_BLOCK 2
#define wxSCI_MARGINOPTION_NONE 0
#define wxSCI_MARGINOPTION_SUBLINESELECT 1
#define wxSCI_ANNOTATION_HIDDEN 0
#define wxSCI_ANNOTATION_STANDARD 1
#define wxSCI_ANNOTATION_BOXED 2
#define wxSCI_ANNOTATION_INDENTED 3
#define wxSCI_UNDO_MAY_COALESCE 1
#define wxSCI_VS_NONE 0
#define wxSCI_VS_RECTANGULARSELECTION 1
#define wxSCI_VS_USERACCESSIBLE 2
#define wxSCI_VS_NOWRAPLINESTART 4
#define wxSCI_TECHNOLOGY_DEFAULT 0
#define wxSCI_TECHNOLOGY_DIRECTWRITE 1

/// Line end types which may be used in addition to LF, CR, and CRLF
/// SC_LINE_END_TYPE_UNICODE includes U+2028 Line Separator,
/// U+2029 Paragraph Separator, and U+0085 Next Line
#define wxSCI_LINE_END_TYPE_DEFAULT 0
#define wxSCI_LINE_END_TYPE_UNICODE 1

/// Maximum value of keywordSet parameter of SetKeyWords.
#define wxSCI_KEYWORDSET_MAX 8
#define wxSCI_TYPE_BOOLEAN 0
#define wxSCI_TYPE_INTEGER 1
#define wxSCI_TYPE_STRING 2

/// Notifications
/// Type of modification and the action which caused the modification.
/// These are defined as a bit mask to make it easy to specify which notifications are wanted.
/// One bit is set from each of SC_MOD_* and SC_PERFORMED_*.
#define wxSCI_MOD_INSERTTEXT 0x1
#define wxSCI_MOD_DELETETEXT 0x2
#define wxSCI_MOD_CHANGESTYLE 0x4
#define wxSCI_MOD_CHANGEFOLD 0x8
#define wxSCI_PERFORMED_USER 0x10
#define wxSCI_PERFORMED_UNDO 0x20
#define wxSCI_PERFORMED_REDO 0x40
#define wxSCI_MULTISTEPUNDOREDO 0x80
#define wxSCI_LASTSTEPINUNDOREDO 0x100
#define wxSCI_MOD_CHANGEMARKER 0x200
#define wxSCI_MOD_BEFOREINSERT 0x400
#define wxSCI_MOD_BEFOREDELETE 0x800
#define wxSCI_MULTILINEUNDOREDO 0x1000
#define wxSCI_STARTACTION 0x2000
#define wxSCI_MOD_CHANGEINDICATOR 0x4000
#define wxSCI_MOD_CHANGELINESTATE 0x8000
#define wxSCI_MOD_CHANGEMARGIN 0x10000
#define wxSCI_MOD_CHANGEANNOTATION 0x20000
#define wxSCI_MOD_CONTAINER 0x40000
#define wxSCI_MOD_LEXERSTATE 0x80000
#define wxSCI_MOD_INSERTCHECK 0x100000
#define wxSCI_MOD_CHANGETABSTOPS 0x200000
#define wxSCI_MODEVENTMASKALL 0x3FFFFF
#define wxSCI_UPDATE_CONTENT 0x1
#define wxSCI_UPDATE_SELECTION 0x2
#define wxSCI_UPDATE_V_SCROLL 0x4
#define wxSCI_UPDATE_H_SCROLL 0x8

/// Symbolic key codes and modifier flags.
/// ASCII and other printable characters below 256.
/// Extended keys above 300.
#define wxSCI_KEY_DOWN 300
#define wxSCI_KEY_UP 301
#define wxSCI_KEY_LEFT 302
#define wxSCI_KEY_RIGHT 303
#define wxSCI_KEY_HOME 304
#define wxSCI_KEY_END 305
#define wxSCI_KEY_PRIOR 306
#define wxSCI_KEY_NEXT 307
#define wxSCI_KEY_DELETE 308
#define wxSCI_KEY_INSERT 309
#define wxSCI_KEY_ESCAPE 7
#define wxSCI_KEY_BACK 8
#define wxSCI_KEY_TAB 9
#define wxSCI_KEY_RETURN 13
#define wxSCI_KEY_ADD 310
#define wxSCI_KEY_SUBTRACT 311
#define wxSCI_KEY_DIVIDE 312
#define wxSCI_KEY_WIN 313
#define wxSCI_KEY_RWIN 314
#define wxSCI_KEY_MENU 315
#define wxSCI_KEYMOD_NORM 0
#define wxSCI_KEYMOD_SHIFT 1
#define wxSCI_KEYMOD_CTRL 2
#define wxSCI_KEYMOD_ALT 4
#define wxSCI_KEYMOD_SUPER 8
#define wxSCI_KEYMOD_META 16
#define wxSCI_AC_FILLUP 1
#define wxSCI_AC_DOUBLECLICK 2
#define wxSCI_AC_TAB 3
#define wxSCI_AC_NEWLINE 4
#define wxSCI_AC_COMMAND 5

/// For SciLexer.h
#define wxSCI_LEX_CONTAINER 0
#define wxSCI_LEX_NULL 1
#define wxSCI_LEX_PYTHON 2
#define wxSCI_LEX_CPP 3
#define wxSCI_LEX_HTML 4
#define wxSCI_LEX_XML 5
#define wxSCI_LEX_PERL 6
#define wxSCI_LEX_SQL 7
#define wxSCI_LEX_VB 8
#define wxSCI_LEX_PROPERTIES 9
#define wxSCI_LEX_ERRORLIST 10
#define wxSCI_LEX_MAKEFILE 11
#define wxSCI_LEX_BATCH 12
#define wxSCI_LEX_XCODE 13
#define wxSCI_LEX_LATEX 14
#define wxSCI_LEX_LUA 15
#define wxSCI_LEX_DIFF 16
#define wxSCI_LEX_CONF 17
#define wxSCI_LEX_PASCAL 18
#define wxSCI_LEX_AVE 19
#define wxSCI_LEX_ADA 20
#define wxSCI_LEX_LISP 21
#define wxSCI_LEX_RUBY 22
#define wxSCI_LEX_EIFFEL 23
#define wxSCI_LEX_EIFFELKW 24
#define wxSCI_LEX_TCL 25
#define wxSCI_LEX_NNCRONTAB 26
#define wxSCI_LEX_BULLANT 27
#define wxSCI_LEX_VBSCRIPT 28
#define wxSCI_LEX_BAAN 31
#define wxSCI_LEX_MATLAB 32
#define wxSCI_LEX_SCRIPTOL 33
#define wxSCI_LEX_ASM 34
#define wxSCI_LEX_CPPNOCASE 35
#define wxSCI_LEX_FORTRAN 36
#define wxSCI_LEX_F77 37
#define wxSCI_LEX_CSS 38
#define wxSCI_LEX_POV 39
#define wxSCI_LEX_LOUT 40
#define wxSCI_LEX_ESCRIPT 41
#define wxSCI_LEX_PS 42
#define wxSCI_LEX_NSIS 43
#define wxSCI_LEX_MMIXAL 44
#define wxSCI_LEX_CLW 45
#define wxSCI_LEX_CLWNOCASE 46
#define wxSCI_LEX_LOT 47
#define wxSCI_LEX_YAML 48
#define wxSCI_LEX_TEX 49
#define wxSCI_LEX_METAPOST 50
#define wxSCI_LEX_POWERBASIC 51
#define wxSCI_LEX_FORTH 52
#define wxSCI_LEX_ERLANG 53
#define wxSCI_LEX_OCTAVE 54
#define wxSCI_LEX_MSSQL 55
#define wxSCI_LEX_VERILOG 56
#define wxSCI_LEX_KIX 57
#define wxSCI_LEX_GUI4CLI 58
#define wxSCI_LEX_SPECMAN 59
#define wxSCI_LEX_AU3 60
#define wxSCI_LEX_APDL 61
#define wxSCI_LEX_BASH 62
#define wxSCI_LEX_ASN1 63
#define wxSCI_LEX_VHDL 64
#define wxSCI_LEX_CAML 65
#define wxSCI_LEX_BLITZBASIC 66
#define wxSCI_LEX_PUREBASIC 67
#define wxSCI_LEX_HASKELL 68
#define wxSCI_LEX_PHPSCRIPT 69
#define wxSCI_LEX_TADS3 70
#define wxSCI_LEX_REBOL 71
#define wxSCI_LEX_SMALLTALK 72
#define wxSCI_LEX_FLAGSHIP 73
#define wxSCI_LEX_CSOUND 74
#define wxSCI_LEX_FREEBASIC 75
#define wxSCI_LEX_INNOSETUP 76
#define wxSCI_LEX_OPAL 77
#define wxSCI_LEX_SPICE 78
#define wxSCI_LEX_D 79
#define wxSCI_LEX_CMAKE 80
#define wxSCI_LEX_GAP 81
#define wxSCI_LEX_PLM 82
#define wxSCI_LEX_PROGRESS 83
#define wxSCI_LEX_ABAQUS 84
#define wxSCI_LEX_ASYMPTOTE 85
#define wxSCI_LEX_R 86
#define wxSCI_LEX_MAGIK 87
#define wxSCI_LEX_POWERSHELL 88
#define wxSCI_LEX_MYSQL 89
#define wxSCI_LEX_PO 90
#define wxSCI_LEX_TAL 91
#define wxSCI_LEX_COBOL 92
#define wxSCI_LEX_TACL 93
#define wxSCI_LEX_SORCUS 94
#define wxSCI_LEX_POWERPRO 95
#define wxSCI_LEX_NIMROD 96
#define wxSCI_LEX_SML 97
#define wxSCI_LEX_MARKDOWN 98
#define wxSCI_LEX_TXT2TAGS 99
#define wxSCI_LEX_A68K 100
#define wxSCI_LEX_MODULA 101
#define wxSCI_LEX_COFFEESCRIPT 102
#define wxSCI_LEX_TCMD 103
#define wxSCI_LEX_AVS 104
#define wxSCI_LEX_ECL 105
#define wxSCI_LEX_OSCRIPT 106
#define wxSCI_LEX_VISUALPROLOG 107
#define wxSCI_LEX_LITERATEHASKELL 108
#define wxSCI_LEX_STTXT 109
#define wxSCI_LEX_KVIRC 110
#define wxSCI_LEX_RUST 111
#define wxSCI_LEX_DMAP 112
#define wxSCI_LEX_AS 113
#define wxSCI_LEX_DMIS 114
#define wxSCI_LEX_REGISTRY 115
#define wxSCI_LEX_BIBTEX 116
#define wxSCI_LEX_SREC 117
#define wxSCI_LEX_IHEX 118
#define wxSCI_LEX_TEHEX 119
#define wxSCI_LEX_JSON 120
#define wxSCI_LEX_EDIFACT 121
#define wxSCI_LEX_INDENT 122
/* C::B begin */
#define wxSCI_LEX_LAST wxSCI_LEX_INDENT // update if the above gets extended!
/* C::B end */

/// When a lexer specifies its language as SCLEX_AUTOMATIC it receives a
/// value assigned in sequence from SCLEX_AUTOMATIC+1.
#define wxSCI_LEX_AUTOMATIC 1000

/// Lexical states for SCLEX_PYTHON
#define wxSCI_P_DEFAULT 0
#define wxSCI_P_COMMENTLINE 1
#define wxSCI_P_NUMBER 2
#define wxSCI_P_STRING 3
#define wxSCI_P_CHARACTER 4
#define wxSCI_P_WORD 5
#define wxSCI_P_TRIPLE 6
#define wxSCI_P_TRIPLEDOUBLE 7
#define wxSCI_P_CLASSNAME 8
#define wxSCI_P_DEFNAME 9
#define wxSCI_P_OPERATOR 10
#define wxSCI_P_IDENTIFIER 11
#define wxSCI_P_COMMENTBLOCK 12
#define wxSCI_P_STRINGEOL 13
#define wxSCI_P_WORD2 14
#define wxSCI_P_DECORATOR 15
#define wxSCI_P_FSTRING 16
#define wxSCI_P_FCHARACTER 17
#define wxSCI_P_FTRIPLE 18
#define wxSCI_P_FTRIPLEDOUBLE 19

/// Lexical states for SCLEX_CPP, SCLEX_BULLANT, SCLEX_COBOL, SCLEX_TACL, SCLEX_TAL
#define wxSCI_C_DEFAULT 0
#define wxSCI_C_COMMENT 1
#define wxSCI_C_COMMENTLINE 2
#define wxSCI_C_COMMENTDOC 3
#define wxSCI_C_NUMBER 4
#define wxSCI_C_WORD 5
#define wxSCI_C_STRING 6
#define wxSCI_C_CHARACTER 7
#define wxSCI_C_UUID 8
#define wxSCI_C_PREPROCESSOR 9
#define wxSCI_C_OPERATOR 10
#define wxSCI_C_IDENTIFIER 11
#define wxSCI_C_STRINGEOL 12
#define wxSCI_C_VERBATIM 13
#define wxSCI_C_REGEX 14
#define wxSCI_C_COMMENTLINEDOC 15
#define wxSCI_C_WORD2 16
#define wxSCI_C_COMMENTDOCKEYWORD 17
#define wxSCI_C_COMMENTDOCKEYWORDERROR 18
#define wxSCI_C_GLOBALCLASS 19
#define wxSCI_C_STRINGRAW 20
#define wxSCI_C_TRIPLEVERBATIM 21
#define wxSCI_C_HASHQUOTEDSTRING 22
#define wxSCI_C_PREPROCESSORCOMMENT 23
#define wxSCI_C_PREPROCESSORCOMMENTDOC 24
#define wxSCI_C_USERLITERAL 25
#define wxSCI_C_TASKMARKER 26
#define wxSCI_C_ESCAPESEQUENCE 27

/// WXSMITH begin #
/// Keep in sync with wxscinilla.h  -> wxSCI_C_WXSMITH
/// Keep in sync with SciLexer.h    -> SCE_C_WXSMITH
/// Keep in sync with lexer_cpp.xml -> Style name="wxSmith-generated code"
/// Notice that due to the "activeFlag" in LexCPP.cxx, the index must be < 64 (0x40).
#define wxSCI_C_WXSMITH 50

/// WXSMITH end #
/// Lexical states for SCLEX_D
#define wxSCI_D_DEFAULT 0
#define wxSCI_D_COMMENT 1
#define wxSCI_D_COMMENTLINE 2
#define wxSCI_D_COMMENTDOC 3
#define wxSCI_D_COMMENTNESTED 4
#define wxSCI_D_NUMBER 5
#define wxSCI_D_WORD 6
#define wxSCI_D_WORD2 7
#define wxSCI_D_WORD3 8
#define wxSCI_D_TYPEDEF 9
#define wxSCI_D_STRING 10
#define wxSCI_D_STRINGEOL 11
#define wxSCI_D_CHARACTER 12
#define wxSCI_D_OPERATOR 13
#define wxSCI_D_IDENTIFIER 14
#define wxSCI_D_COMMENTLINEDOC 15
#define wxSCI_D_COMMENTDOCKEYWORD 16
#define wxSCI_D_COMMENTDOCKEYWORDERROR 17
#define wxSCI_D_STRINGB 18
#define wxSCI_D_STRINGR 19
#define wxSCI_D_WORD5 20
#define wxSCI_D_WORD6 21
#define wxSCI_D_WORD7 22

/// Lexical states for SCLEX_TCL
#define wxSCI_TCL_DEFAULT 0
#define wxSCI_TCL_COMMENT 1
#define wxSCI_TCL_COMMENTLINE 2
#define wxSCI_TCL_NUMBER 3
#define wxSCI_TCL_WORD_IN_QUOTE 4
#define wxSCI_TCL_IN_QUOTE 5
#define wxSCI_TCL_OPERATOR 6
#define wxSCI_TCL_IDENTIFIER 7
#define wxSCI_TCL_SUBSTITUTION 8
#define wxSCI_TCL_SUB_BRACE 9
#define wxSCI_TCL_MODIFIER 10
#define wxSCI_TCL_EXPAND 11
#define wxSCI_TCL_WORD 12
#define wxSCI_TCL_WORD2 13
#define wxSCI_TCL_WORD3 14
#define wxSCI_TCL_WORD4 15
#define wxSCI_TCL_WORD5 16
#define wxSCI_TCL_WORD6 17
#define wxSCI_TCL_WORD7 18
#define wxSCI_TCL_WORD8 19
#define wxSCI_TCL_COMMENT_BOX 20
#define wxSCI_TCL_BLOCK_COMMENT 21

/// Lexical states for SCLEX_HTML, SCLEX_XML
#define wxSCI_H_DEFAULT 0
#define wxSCI_H_TAG 1
#define wxSCI_H_TAGUNKNOWN 2
#define wxSCI_H_ATTRIBUTE 3
#define wxSCI_H_ATTRIBUTEUNKNOWN 4
#define wxSCI_H_NUMBER 5
#define wxSCI_H_DOUBLESTRING 6
#define wxSCI_H_SINGLESTRING 7
#define wxSCI_H_OTHER 8
#define wxSCI_H_COMMENT 9
#define wxSCI_H_ENTITY 10

/// XML and ASP
#define wxSCI_H_TAGEND 11
#define wxSCI_H_XMLSTART 12
#define wxSCI_H_XMLEND 13
#define wxSCI_H_SCRIPT 14
#define wxSCI_H_ASP 15
#define wxSCI_H_ASPAT 16
#define wxSCI_H_CDATA 17
#define wxSCI_H_QUESTION 18

/// More HTML
#define wxSCI_H_VALUE 19

/// X-Code
#define wxSCI_H_XCCOMMENT 20

/// SGML
#define wxSCI_H_SGML_DEFAULT 21
#define wxSCI_H_SGML_COMMAND 22
#define wxSCI_H_SGML_1ST_PARAM 23
#define wxSCI_H_SGML_DOUBLESTRING 24
#define wxSCI_H_SGML_SIMPLESTRING 25
#define wxSCI_H_SGML_ERROR 26
#define wxSCI_H_SGML_SPECIAL 27
#define wxSCI_H_SGML_ENTITY 28
#define wxSCI_H_SGML_COMMENT 29
#define wxSCI_H_SGML_1ST_PARAM_COMMENT 30
#define wxSCI_H_SGML_BLOCK_DEFAULT 31

/// Embedded Javascript
#define wxSCI_HJ_START 40
#define wxSCI_HJ_DEFAULT 41
#define wxSCI_HJ_COMMENT 42
#define wxSCI_HJ_COMMENTLINE 43
#define wxSCI_HJ_COMMENTDOC 44
#define wxSCI_HJ_NUMBER 45
#define wxSCI_HJ_WORD 46
#define wxSCI_HJ_KEYWORD 47
#define wxSCI_HJ_DOUBLESTRING 48
#define wxSCI_HJ_SINGLESTRING 49
#define wxSCI_HJ_SYMBOLS 50
#define wxSCI_HJ_STRINGEOL 51
#define wxSCI_HJ_REGEX 52

/// ASP Javascript
#define wxSCI_HJA_START 55
#define wxSCI_HJA_DEFAULT 56
#define wxSCI_HJA_COMMENT 57
#define wxSCI_HJA_COMMENTLINE 58
#define wxSCI_HJA_COMMENTDOC 59
#define wxSCI_HJA_NUMBER 60
#define wxSCI_HJA_WORD 61
#define wxSCI_HJA_KEYWORD 62
#define wxSCI_HJA_DOUBLESTRING 63
#define wxSCI_HJA_SINGLESTRING 64
#define wxSCI_HJA_SYMBOLS 65
#define wxSCI_HJA_STRINGEOL 66
#define wxSCI_HJA_REGEX 67

/// Embedded VBScript
#define wxSCI_HB_START 70
#define wxSCI_HB_DEFAULT 71
#define wxSCI_HB_COMMENTLINE 72
#define wxSCI_HB_NUMBER 73
#define wxSCI_HB_WORD 74
#define wxSCI_HB_STRING 75
#define wxSCI_HB_IDENTIFIER 76
#define wxSCI_HB_STRINGEOL 77

/// ASP VBScript
#define wxSCI_HBA_START 80
#define wxSCI_HBA_DEFAULT 81
#define wxSCI_HBA_COMMENTLINE 82
#define wxSCI_HBA_NUMBER 83
#define wxSCI_HBA_WORD 84
#define wxSCI_HBA_STRING 85
#define wxSCI_HBA_IDENTIFIER 86
#define wxSCI_HBA_STRINGEOL 87

/// Embedded Python
#define wxSCI_HP_START 90
#define wxSCI_HP_DEFAULT 91
#define wxSCI_HP_COMMENTLINE 92
#define wxSCI_HP_NUMBER 93
#define wxSCI_HP_STRING 94
#define wxSCI_HP_CHARACTER 95
#define wxSCI_HP_WORD 96
#define wxSCI_HP_TRIPLE 97
#define wxSCI_HP_TRIPLEDOUBLE 98
#define wxSCI_HP_CLASSNAME 99
#define wxSCI_HP_DEFNAME 100
#define wxSCI_HP_OPERATOR 101
#define wxSCI_HP_IDENTIFIER 102

/// PHP
#define wxSCI_HPHP_COMPLEX_VARIABLE 104

/// ASP Python
#define wxSCI_HPA_START 105
#define wxSCI_HPA_DEFAULT 106
#define wxSCI_HPA_COMMENTLINE 107
#define wxSCI_HPA_NUMBER 108
#define wxSCI_HPA_STRING 109
#define wxSCI_HPA_CHARACTER 110
#define wxSCI_HPA_WORD 111
#define wxSCI_HPA_TRIPLE 112
#define wxSCI_HPA_TRIPLEDOUBLE 113
#define wxSCI_HPA_CLASSNAME 114
#define wxSCI_HPA_DEFNAME 115
#define wxSCI_HPA_OPERATOR 116
#define wxSCI_HPA_IDENTIFIER 117

/// PHP
#define wxSCI_HPHP_DEFAULT 118
#define wxSCI_HPHP_HSTRING 119
#define wxSCI_HPHP_SIMPLESTRING 120
#define wxSCI_HPHP_WORD 121
#define wxSCI_HPHP_NUMBER 122
#define wxSCI_HPHP_VARIABLE 123
#define wxSCI_HPHP_COMMENT 124
#define wxSCI_HPHP_COMMENTLINE 125
#define wxSCI_HPHP_HSTRING_VARIABLE 126
#define wxSCI_HPHP_OPERATOR 127

/// Lexical states for SCLEX_PERL
#define wxSCI_PL_DEFAULT 0
#define wxSCI_PL_ERROR 1
#define wxSCI_PL_COMMENTLINE 2
#define wxSCI_PL_POD 3
#define wxSCI_PL_NUMBER 4
#define wxSCI_PL_WORD 5
#define wxSCI_PL_STRING 6
#define wxSCI_PL_CHARACTER 7
#define wxSCI_PL_PUNCTUATION 8
#define wxSCI_PL_PREPROCESSOR 9
#define wxSCI_PL_OPERATOR 10
#define wxSCI_PL_IDENTIFIER 11
#define wxSCI_PL_SCALAR 12
#define wxSCI_PL_ARRAY 13
#define wxSCI_PL_HASH 14
#define wxSCI_PL_SYMBOLTABLE 15
#define wxSCI_PL_VARIABLE_INDEXER 16
#define wxSCI_PL_REGEX 17
#define wxSCI_PL_REGSUBST 18
#define wxSCI_PL_LONGQUOTE 19
#define wxSCI_PL_BACKTICKS 20
#define wxSCI_PL_DATASECTION 21
#define wxSCI_PL_HERE_DELIM 22
#define wxSCI_PL_HERE_Q 23
#define wxSCI_PL_HERE_QQ 24
#define wxSCI_PL_HERE_QX 25
#define wxSCI_PL_STRING_Q 26
#define wxSCI_PL_STRING_QQ 27
#define wxSCI_PL_STRING_QX 28
#define wxSCI_PL_STRING_QR 29
#define wxSCI_PL_STRING_QW 30
#define wxSCI_PL_POD_VERB 31
#define wxSCI_PL_SUB_PROTOTYPE 40
#define wxSCI_PL_FORMAT_IDENT 41
#define wxSCI_PL_FORMAT 42
#define wxSCI_PL_STRING_VAR 43
#define wxSCI_PL_XLAT 44
#define wxSCI_PL_REGEX_VAR 54
#define wxSCI_PL_REGSUBST_VAR 55
#define wxSCI_PL_BACKTICKS_VAR 57
#define wxSCI_PL_HERE_QQ_VAR 61
#define wxSCI_PL_HERE_QX_VAR 62
#define wxSCI_PL_STRING_QQ_VAR 64
#define wxSCI_PL_STRING_QX_VAR 65
#define wxSCI_PL_STRING_QR_VAR 66

/// Lexical states for SCLEX_RUBY
#define wxSCI_RB_DEFAULT 0
#define wxSCI_RB_ERROR 1
#define wxSCI_RB_COMMENTLINE 2
#define wxSCI_RB_POD 3
#define wxSCI_RB_NUMBER 4
#define wxSCI_RB_WORD 5
#define wxSCI_RB_STRING 6
#define wxSCI_RB_CHARACTER 7
#define wxSCI_RB_CLASSNAME 8
#define wxSCI_RB_DEFNAME 9
#define wxSCI_RB_OPERATOR 10
#define wxSCI_RB_IDENTIFIER 11
#define wxSCI_RB_REGEX 12
#define wxSCI_RB_GLOBAL 13
#define wxSCI_RB_SYMBOL 14
#define wxSCI_RB_MODULE_NAME 15
#define wxSCI_RB_INSTANCE_VAR 16
#define wxSCI_RB_CLASS_VAR 17
#define wxSCI_RB_BACKTICKS 18
#define wxSCI_RB_DATASECTION 19
#define wxSCI_RB_HERE_DELIM 20
#define wxSCI_RB_HERE_Q 21
#define wxSCI_RB_HERE_QQ 22
#define wxSCI_RB_HERE_QX 23
#define wxSCI_RB_STRING_Q 24
#define wxSCI_RB_STRING_QQ 25
#define wxSCI_RB_STRING_QX 26
#define wxSCI_RB_STRING_QR 27
#define wxSCI_RB_STRING_QW 28
#define wxSCI_RB_WORD_DEMOTED 29
#define wxSCI_RB_STDIN 30
#define wxSCI_RB_STDOUT 31
#define wxSCI_RB_STDERR 40
#define wxSCI_RB_UPPER_BOUND 41

/// Lexical states for SCLEX_VB, SCLEX_VBSCRIPT, SCLEX_POWERBASIC, SCLEX_BLITZBASIC, SCLEX_PUREBASIC, SCLEX_FREEBASIC
#define wxSCI_B_DEFAULT 0
#define wxSCI_B_COMMENT 1
#define wxSCI_B_NUMBER 2
#define wxSCI_B_KEYWORD 3
#define wxSCI_B_STRING 4
#define wxSCI_B_PREPROCESSOR 5
#define wxSCI_B_OPERATOR 6
#define wxSCI_B_IDENTIFIER 7
#define wxSCI_B_DATE 8
#define wxSCI_B_STRINGEOL 9
#define wxSCI_B_KEYWORD2 10
#define wxSCI_B_KEYWORD3 11
#define wxSCI_B_KEYWORD4 12
#define wxSCI_B_CONSTANT 13
#define wxSCI_B_ASM 14
#define wxSCI_B_LABEL 15
#define wxSCI_B_ERROR 16
#define wxSCI_B_HEXNUMBER 17
#define wxSCI_B_BINNUMBER 18
#define wxSCI_B_COMMENTBLOCK 19
#define wxSCI_B_DOCLINE 20
#define wxSCI_B_DOCBLOCK 21
#define wxSCI_B_DOCKEYWORD 22

/// Lexical states for SCLEX_PROPERTIES
#define wxSCI_PROPS_DEFAULT 0
#define wxSCI_PROPS_COMMENT 1
#define wxSCI_PROPS_SECTION 2
#define wxSCI_PROPS_ASSIGNMENT 3
#define wxSCI_PROPS_DEFVAL 4
#define wxSCI_PROPS_KEY 5

/// Lexical states for SCLEX_LATEX
#define wxSCI_L_DEFAULT 0
#define wxSCI_L_COMMAND 1
#define wxSCI_L_TAG 2
#define wxSCI_L_MATH 3
#define wxSCI_L_COMMENT 4
#define wxSCI_L_TAG2 5
#define wxSCI_L_MATH2 6
#define wxSCI_L_COMMENT2 7
#define wxSCI_L_VERBATIM 8
#define wxSCI_L_SHORTCMD 9
#define wxSCI_L_SPECIAL 10
#define wxSCI_L_CMDOPT 11
#define wxSCI_L_ERROR 12

/// Lexical states for SCLEX_LUA
#define wxSCI_LUA_DEFAULT 0
#define wxSCI_LUA_COMMENT 1
#define wxSCI_LUA_COMMENTLINE 2
#define wxSCI_LUA_COMMENTDOC 3
#define wxSCI_LUA_NUMBER 4
#define wxSCI_LUA_WORD 5
#define wxSCI_LUA_STRING 6
#define wxSCI_LUA_CHARACTER 7
#define wxSCI_LUA_LITERALSTRING 8
#define wxSCI_LUA_PREPROCESSOR 9
#define wxSCI_LUA_OPERATOR 10
#define wxSCI_LUA_IDENTIFIER 11
#define wxSCI_LUA_STRINGEOL 12
#define wxSCI_LUA_WORD2 13
#define wxSCI_LUA_WORD3 14
#define wxSCI_LUA_WORD4 15
#define wxSCI_LUA_WORD5 16
#define wxSCI_LUA_WORD6 17
#define wxSCI_LUA_WORD7 18
#define wxSCI_LUA_WORD8 19
#define wxSCI_LUA_LABEL 20

/// Lexical states for SCLEX_ERRORLIST
#define wxSCI_ERR_DEFAULT 0
#define wxSCI_ERR_PYTHON 1
#define wxSCI_ERR_GCC 2
#define wxSCI_ERR_MS 3
#define wxSCI_ERR_CMD 4
#define wxSCI_ERR_BORLAND 5
#define wxSCI_ERR_PERL 6
#define wxSCI_ERR_NET 7
#define wxSCI_ERR_LUA 8
#define wxSCI_ERR_CTAG 9
#define wxSCI_ERR_DIFF_CHANGED 10
#define wxSCI_ERR_DIFF_ADDITION 11
#define wxSCI_ERR_DIFF_DELETION 12
#define wxSCI_ERR_DIFF_MESSAGE 13
#define wxSCI_ERR_PHP 14
#define wxSCI_ERR_ELF 15
#define wxSCI_ERR_IFC 16
#define wxSCI_ERR_IFORT 17
#define wxSCI_ERR_ABSF 18
#define wxSCI_ERR_TIDY 19
#define wxSCI_ERR_JAVA_STACK 20
#define wxSCI_ERR_VALUE 21
#define wxSCI_ERR_GCC_INCLUDED_FROM 22
#define wxSCI_ERR_ESCSEQ 23
#define wxSCI_ERR_ESCSEQ_UNKNOWN 24
#define wxSCI_ERR_ES_BLACK 40
#define wxSCI_ERR_ES_RED 41
#define wxSCI_ERR_ES_GREEN 42
#define wxSCI_ERR_ES_BROWN 43
#define wxSCI_ERR_ES_BLUE 44
#define wxSCI_ERR_ES_MAGENTA 45
#define wxSCI_ERR_ES_CYAN 46
#define wxSCI_ERR_ES_GRAY 47
#define wxSCI_ERR_ES_DARK_GRAY 48
#define wxSCI_ERR_ES_BRIGHT_RED 49
#define wxSCI_ERR_ES_BRIGHT_GREEN 50
#define wxSCI_ERR_ES_YELLOW 51
#define wxSCI_ERR_ES_BRIGHT_BLUE 52
#define wxSCI_ERR_ES_BRIGHT_MAGENTA 53
#define wxSCI_ERR_ES_BRIGHT_CYAN 54
#define wxSCI_ERR_ES_WHITE 55

/// Lexical states for SCLEX_BATCH
#define wxSCI_BAT_DEFAULT 0
#define wxSCI_BAT_COMMENT 1
#define wxSCI_BAT_WORD 2
#define wxSCI_BAT_LABEL 3
#define wxSCI_BAT_HIDE 4
#define wxSCI_BAT_COMMAND 5
#define wxSCI_BAT_IDENTIFIER 6
#define wxSCI_BAT_OPERATOR 7

/// Lexical states for SCLEX_TCMD
#define wxSCI_TCMD_DEFAULT 0
#define wxSCI_TCMD_COMMENT 1
#define wxSCI_TCMD_WORD 2
#define wxSCI_TCMD_LABEL 3
#define wxSCI_TCMD_HIDE 4
#define wxSCI_TCMD_COMMAND 5
#define wxSCI_TCMD_IDENTIFIER 6
#define wxSCI_TCMD_OPERATOR 7
#define wxSCI_TCMD_ENVIRONMENT 8
#define wxSCI_TCMD_EXPANSION 9
#define wxSCI_TCMD_CLABEL 10

/// Lexical states for SCLEX_MAKEFILE
#define wxSCI_MAKE_DEFAULT 0
#define wxSCI_MAKE_COMMENT 1
#define wxSCI_MAKE_PREPROCESSOR 2
#define wxSCI_MAKE_IDENTIFIER 3
#define wxSCI_MAKE_OPERATOR 4
#define wxSCI_MAKE_TARGET 5
#define wxSCI_MAKE_IDEOL 9

/// Lexical states for SCLEX_DIFF
#define wxSCI_DIFF_DEFAULT 0
#define wxSCI_DIFF_COMMENT 1
#define wxSCI_DIFF_COMMAND 2
#define wxSCI_DIFF_HEADER 3
#define wxSCI_DIFF_POSITION 4
#define wxSCI_DIFF_DELETED 5
#define wxSCI_DIFF_ADDED 6
#define wxSCI_DIFF_CHANGED 7

/// Lexical states for SCLEX_CONF (Apache Configuration Files Lexer)
#define wxSCI_CONF_DEFAULT 0
#define wxSCI_CONF_COMMENT 1
#define wxSCI_CONF_NUMBER 2
#define wxSCI_CONF_IDENTIFIER 3
#define wxSCI_CONF_EXTENSION 4
#define wxSCI_CONF_PARAMETER 5
#define wxSCI_CONF_STRING 6
#define wxSCI_CONF_OPERATOR 7
#define wxSCI_CONF_IP 8
#define wxSCI_CONF_DIRECTIVE 9

/// Lexical states for SCLEX_AVE, Avenue
#define wxSCI_AVE_DEFAULT 0
#define wxSCI_AVE_COMMENT 1
#define wxSCI_AVE_NUMBER 2
#define wxSCI_AVE_WORD 3
#define wxSCI_AVE_STRING 6
#define wxSCI_AVE_ENUM 7
#define wxSCI_AVE_STRINGEOL 8
#define wxSCI_AVE_IDENTIFIER 9
#define wxSCI_AVE_OPERATOR 10
#define wxSCI_AVE_WORD1 11
#define wxSCI_AVE_WORD2 12
#define wxSCI_AVE_WORD3 13
#define wxSCI_AVE_WORD4 14
#define wxSCI_AVE_WORD5 15
#define wxSCI_AVE_WORD6 16

/// Lexical states for SCLEX_ADA
#define wxSCI_ADA_DEFAULT 0
#define wxSCI_ADA_WORD 1
#define wxSCI_ADA_IDENTIFIER 2
#define wxSCI_ADA_NUMBER 3
#define wxSCI_ADA_DELIMITER 4
#define wxSCI_ADA_CHARACTER 5
#define wxSCI_ADA_CHARACTEREOL 6
#define wxSCI_ADA_STRING 7
#define wxSCI_ADA_STRINGEOL 8
#define wxSCI_ADA_LABEL 9
#define wxSCI_ADA_COMMENTLINE 10
#define wxSCI_ADA_ILLEGAL 11

/// Lexical states for SCLEX_BAAN
#define wxSCI_BAAN_DEFAULT 0
#define wxSCI_BAAN_COMMENT 1
#define wxSCI_BAAN_COMMENTDOC 2
#define wxSCI_BAAN_NUMBER 3
#define wxSCI_BAAN_WORD 4
#define wxSCI_BAAN_STRING 5
#define wxSCI_BAAN_PREPROCESSOR 6
#define wxSCI_BAAN_OPERATOR 7
#define wxSCI_BAAN_IDENTIFIER 8
#define wxSCI_BAAN_STRINGEOL 9
#define wxSCI_BAAN_WORD2 10
#define wxSCI_BAAN_WORD3 11
#define wxSCI_BAAN_WORD4 12
#define wxSCI_BAAN_WORD5 13
#define wxSCI_BAAN_WORD6 14
#define wxSCI_BAAN_WORD7 15
#define wxSCI_BAAN_WORD8 16
#define wxSCI_BAAN_WORD9 17
#define wxSCI_BAAN_TABLEDEF 18
#define wxSCI_BAAN_TABLESQL 19
#define wxSCI_BAAN_FUNCTION 20
#define wxSCI_BAAN_DOMDEF 21
#define wxSCI_BAAN_FUNCDEF 22
#define wxSCI_BAAN_OBJECTDEF 23
#define wxSCI_BAAN_DEFINEDEF 24

/// Lexical states for SCLEX_LISP
#define wxSCI_LISP_DEFAULT 0
#define wxSCI_LISP_COMMENT 1
#define wxSCI_LISP_NUMBER 2
#define wxSCI_LISP_KEYWORD 3
#define wxSCI_LISP_KEYWORD_KW 4
#define wxSCI_LISP_SYMBOL 5
#define wxSCI_LISP_STRING 6
#define wxSCI_LISP_STRINGEOL 8
#define wxSCI_LISP_IDENTIFIER 9
#define wxSCI_LISP_OPERATOR 10
#define wxSCI_LISP_SPECIAL 11
#define wxSCI_LISP_MULTI_COMMENT 12

/// Lexical states for SCLEX_EIFFEL and SCLEX_EIFFELKW
#define wxSCI_EIFFEL_DEFAULT 0
#define wxSCI_EIFFEL_COMMENTLINE 1
#define wxSCI_EIFFEL_NUMBER 2
#define wxSCI_EIFFEL_WORD 3
#define wxSCI_EIFFEL_STRING 4
#define wxSCI_EIFFEL_CHARACTER 5
#define wxSCI_EIFFEL_OPERATOR 6
#define wxSCI_EIFFEL_IDENTIFIER 7
#define wxSCI_EIFFEL_STRINGEOL 8

/// Lexical states for SCLEX_NNCRONTAB (nnCron crontab Lexer)
#define wxSCI_NNCRONTAB_DEFAULT 0
#define wxSCI_NNCRONTAB_COMMENT 1
#define wxSCI_NNCRONTAB_TASK 2
#define wxSCI_NNCRONTAB_SECTION 3
#define wxSCI_NNCRONTAB_KEYWORD 4
#define wxSCI_NNCRONTAB_MODIFIER 5
#define wxSCI_NNCRONTAB_ASTERISK 6
#define wxSCI_NNCRONTAB_NUMBER 7
#define wxSCI_NNCRONTAB_STRING 8
#define wxSCI_NNCRONTAB_ENVIRONMENT 9
#define wxSCI_NNCRONTAB_IDENTIFIER 10

/// Lexical states for SCLEX_FORTH (Forth Lexer)
#define wxSCI_FORTH_DEFAULT 0
#define wxSCI_FORTH_COMMENT 1
#define wxSCI_FORTH_COMMENT_ML 2
#define wxSCI_FORTH_IDENTIFIER 3
#define wxSCI_FORTH_CONTROL 4
#define wxSCI_FORTH_KEYWORD 5
#define wxSCI_FORTH_DEFWORD 6
#define wxSCI_FORTH_PREWORD1 7
#define wxSCI_FORTH_PREWORD2 8
#define wxSCI_FORTH_NUMBER 9
#define wxSCI_FORTH_STRING 10
#define wxSCI_FORTH_LOCALE 11

/// Lexical states for SCLEX_MATLAB
#define wxSCI_MATLAB_DEFAULT 0
#define wxSCI_MATLAB_COMMENT 1
#define wxSCI_MATLAB_COMMAND 2
#define wxSCI_MATLAB_NUMBER 3
#define wxSCI_MATLAB_KEYWORD 4

/// single quoted string
#define wxSCI_MATLAB_STRING 5
#define wxSCI_MATLAB_OPERATOR 6
#define wxSCI_MATLAB_IDENTIFIER 7
#define wxSCI_MATLAB_DOUBLEQUOTESTRING 8

/// Lexical states for SCLEX_SCRIPTOL
#define wxSCI_SCRIPTOL_DEFAULT 0
#define wxSCI_SCRIPTOL_WHITE 1
#define wxSCI_SCRIPTOL_COMMENTLINE 2
#define wxSCI_SCRIPTOL_PERSISTENT 3
#define wxSCI_SCRIPTOL_CSTYLE 4
#define wxSCI_SCRIPTOL_COMMENTBLOCK 5
#define wxSCI_SCRIPTOL_NUMBER 6
#define wxSCI_SCRIPTOL_STRING 7
#define wxSCI_SCRIPTOL_CHARACTER 8
#define wxSCI_SCRIPTOL_STRINGEOL 9
#define wxSCI_SCRIPTOL_KEYWORD 10
#define wxSCI_SCRIPTOL_OPERATOR 11
#define wxSCI_SCRIPTOL_IDENTIFIER 12
#define wxSCI_SCRIPTOL_TRIPLE 13
#define wxSCI_SCRIPTOL_CLASSNAME 14
#define wxSCI_SCRIPTOL_PREPROCESSOR 15

/// Lexical states for SCLEX_ASM, SCLEX_AS
#define wxSCI_ASM_DEFAULT 0
#define wxSCI_ASM_COMMENT 1
#define wxSCI_ASM_NUMBER 2
#define wxSCI_ASM_STRING 3
#define wxSCI_ASM_OPERATOR 4
#define wxSCI_ASM_IDENTIFIER 5
#define wxSCI_ASM_CPUINSTRUCTION 6
#define wxSCI_ASM_MATHINSTRUCTION 7
#define wxSCI_ASM_REGISTER 8
#define wxSCI_ASM_DIRECTIVE 9
#define wxSCI_ASM_DIRECTIVEOPERAND 10
#define wxSCI_ASM_COMMENTBLOCK 11
#define wxSCI_ASM_CHARACTER 12
#define wxSCI_ASM_STRINGEOL 13
#define wxSCI_ASM_EXTINSTRUCTION 14
#define wxSCI_ASM_COMMENTDIRECTIVE 15

/// Lexical states for SCLEX_FORTRAN
#define wxSCI_F_DEFAULT 0
#define wxSCI_F_COMMENT 1
#define wxSCI_F_NUMBER 2
#define wxSCI_F_STRING1 3
#define wxSCI_F_STRING2 4
#define wxSCI_F_STRINGEOL 5
#define wxSCI_F_OPERATOR 6
#define wxSCI_F_IDENTIFIER 7
#define wxSCI_F_WORD 8
#define wxSCI_F_WORD2 9
#define wxSCI_F_WORD3 10
#define wxSCI_F_PREPROCESSOR 11
#define wxSCI_F_OPERATOR2 12
#define wxSCI_F_LABEL 13
#define wxSCI_F_CONTINUATION 14

/// Lexical states for SCLEX_CSS
#define wxSCI_CSS_DEFAULT 0
#define wxSCI_CSS_TAG 1
#define wxSCI_CSS_CLASS 2
#define wxSCI_CSS_PSEUDOCLASS 3
#define wxSCI_CSS_UNKNOWN_PSEUDOCLASS 4
#define wxSCI_CSS_OPERATOR 5
#define wxSCI_CSS_IDENTIFIER 6
#define wxSCI_CSS_UNKNOWN_IDENTIFIER 7
#define wxSCI_CSS_VALUE 8
#define wxSCI_CSS_COMMENT 9
#define wxSCI_CSS_ID 10
#define wxSCI_CSS_IMPORTANT 11
#define wxSCI_CSS_DIRECTIVE 12
#define wxSCI_CSS_DOUBLESTRING 13
#define wxSCI_CSS_SINGLESTRING 14
#define wxSCI_CSS_IDENTIFIER2 15
#define wxSCI_CSS_ATTRIBUTE 16
#define wxSCI_CSS_IDENTIFIER3 17
#define wxSCI_CSS_PSEUDOELEMENT 18
#define wxSCI_CSS_EXTENDED_IDENTIFIER 19
#define wxSCI_CSS_EXTENDED_PSEUDOCLASS 20
#define wxSCI_CSS_EXTENDED_PSEUDOELEMENT 21
#define wxSCI_CSS_MEDIA 22
#define wxSCI_CSS_VARIABLE 23

/// Lexical states for SCLEX_POV
#define wxSCI_POV_DEFAULT 0
#define wxSCI_POV_COMMENT 1
#define wxSCI_POV_COMMENTLINE 2
#define wxSCI_POV_NUMBER 3
#define wxSCI_POV_OPERATOR 4
#define wxSCI_POV_IDENTIFIER 5
#define wxSCI_POV_STRING 6
#define wxSCI_POV_STRINGEOL 7
#define wxSCI_POV_DIRECTIVE 8
#define wxSCI_POV_BADDIRECTIVE 9
#define wxSCI_POV_WORD2 10
#define wxSCI_POV_WORD3 11
#define wxSCI_POV_WORD4 12
#define wxSCI_POV_WORD5 13
#define wxSCI_POV_WORD6 14
#define wxSCI_POV_WORD7 15
#define wxSCI_POV_WORD8 16

/// Lexical states for SCLEX_LOUT
#define wxSCI_LOUT_DEFAULT 0
#define wxSCI_LOUT_COMMENT 1
#define wxSCI_LOUT_NUMBER 2
#define wxSCI_LOUT_WORD 3
#define wxSCI_LOUT_WORD2 4
#define wxSCI_LOUT_WORD3 5
#define wxSCI_LOUT_WORD4 6
#define wxSCI_LOUT_STRING 7
#define wxSCI_LOUT_OPERATOR 8
#define wxSCI_LOUT_IDENTIFIER 9
#define wxSCI_LOUT_STRINGEOL 10

/// Lexical states for SCLEX_ESCRIPT
#define wxSCI_ESCRIPT_DEFAULT 0
#define wxSCI_ESCRIPT_COMMENT 1
#define wxSCI_ESCRIPT_COMMENTLINE 2
#define wxSCI_ESCRIPT_COMMENTDOC 3
#define wxSCI_ESCRIPT_NUMBER 4
#define wxSCI_ESCRIPT_WORD 5
#define wxSCI_ESCRIPT_STRING 6
#define wxSCI_ESCRIPT_OPERATOR 7
#define wxSCI_ESCRIPT_IDENTIFIER 8
#define wxSCI_ESCRIPT_BRACE 9
#define wxSCI_ESCRIPT_WORD2 10
#define wxSCI_ESCRIPT_WORD3 11

/// Lexical states for SCLEX_PS
#define wxSCI_PS_DEFAULT 0
#define wxSCI_PS_COMMENT 1
#define wxSCI_PS_DSC_COMMENT 2
#define wxSCI_PS_DSC_VALUE 3
#define wxSCI_PS_NUMBER 4
#define wxSCI_PS_NAME 5
#define wxSCI_PS_KEYWORD 6
#define wxSCI_PS_LITERAL 7
#define wxSCI_PS_IMMEVAL 8
#define wxSCI_PS_PAREN_ARRAY 9
#define wxSCI_PS_PAREN_DICT 10
#define wxSCI_PS_PAREN_PROC 11
#define wxSCI_PS_TEXT 12
#define wxSCI_PS_HEXSTRING 13
#define wxSCI_PS_BASE85STRING 14
#define wxSCI_PS_BADSTRINGCHAR 15

/// Lexical states for SCLEX_NSIS
#define wxSCI_NSIS_DEFAULT 0
#define wxSCI_NSIS_COMMENT 1
#define wxSCI_NSIS_STRINGDQ 2
#define wxSCI_NSIS_STRINGLQ 3
#define wxSCI_NSIS_STRINGRQ 4
#define wxSCI_NSIS_FUNCTION 5
#define wxSCI_NSIS_VARIABLE 6
#define wxSCI_NSIS_LABEL 7
#define wxSCI_NSIS_USERDEFINED 8
#define wxSCI_NSIS_SECTIONDEF 9
#define wxSCI_NSIS_SUBSECTIONDEF 10
#define wxSCI_NSIS_IFDEFINEDEF 11
#define wxSCI_NSIS_MACRODEF 12
#define wxSCI_NSIS_STRINGVAR 13
#define wxSCI_NSIS_NUMBER 14
#define wxSCI_NSIS_SECTIONGROUP 15
#define wxSCI_NSIS_PAGEEX 16
#define wxSCI_NSIS_FUNCTIONDEF 17
#define wxSCI_NSIS_COMMENTBOX 18

/// Lexical states for SCLEX_MMIXAL
#define wxSCI_MMIXAL_LEADWS 0
#define wxSCI_MMIXAL_COMMENT 1
#define wxSCI_MMIXAL_LABEL 2
#define wxSCI_MMIXAL_OPCODE 3
#define wxSCI_MMIXAL_OPCODE_PRE 4
#define wxSCI_MMIXAL_OPCODE_VALID 5
#define wxSCI_MMIXAL_OPCODE_UNKNOWN 6
#define wxSCI_MMIXAL_OPCODE_POST 7
#define wxSCI_MMIXAL_OPERANDS 8
#define wxSCI_MMIXAL_NUMBER 9
#define wxSCI_MMIXAL_REF 10
#define wxSCI_MMIXAL_CHAR 11
#define wxSCI_MMIXAL_STRING 12
#define wxSCI_MMIXAL_REGISTER 13
#define wxSCI_MMIXAL_HEX 14
#define wxSCI_MMIXAL_OPERATOR 15
#define wxSCI_MMIXAL_SYMBOL 16
#define wxSCI_MMIXAL_INCLUDE 17

/// Lexical states for SCLEX_CLW
#define wxSCI_CLW_DEFAULT 0
#define wxSCI_CLW_LABEL 1
#define wxSCI_CLW_COMMENT 2
#define wxSCI_CLW_STRING 3
#define wxSCI_CLW_USER_IDENTIFIER 4
#define wxSCI_CLW_INTEGER_CONSTANT 5
#define wxSCI_CLW_REAL_CONSTANT 6
#define wxSCI_CLW_PICTURE_STRING 7
#define wxSCI_CLW_KEYWORD 8
#define wxSCI_CLW_COMPILER_DIRECTIVE 9
#define wxSCI_CLW_RUNTIME_EXPRESSIONS 10
#define wxSCI_CLW_BUILTIN_PROCEDURES_FUNCTION 11
#define wxSCI_CLW_STRUCTURE_DATA_TYPE 12
#define wxSCI_CLW_ATTRIBUTE 13
#define wxSCI_CLW_STANDARD_EQUATE 14
#define wxSCI_CLW_ERROR 15
#define wxSCI_CLW_DEPRECATED 16

/// Lexical states for SCLEX_LOT
#define wxSCI_LOT_DEFAULT 0
#define wxSCI_LOT_HEADER 1
#define wxSCI_LOT_BREAK 2
#define wxSCI_LOT_SET 3
#define wxSCI_LOT_PASS 4
#define wxSCI_LOT_FAIL 5
#define wxSCI_LOT_ABORT 6

/// Lexical states for SCLEX_YAML
#define wxSCI_YAML_DEFAULT 0
#define wxSCI_YAML_COMMENT 1
#define wxSCI_YAML_IDENTIFIER 2
#define wxSCI_YAML_KEYWORD 3
#define wxSCI_YAML_NUMBER 4
#define wxSCI_YAML_REFERENCE 5
#define wxSCI_YAML_DOCUMENT 6
#define wxSCI_YAML_TEXT 7
#define wxSCI_YAML_ERROR 8
#define wxSCI_YAML_OPERATOR 9

/// Lexical states for SCLEX_TEX
#define wxSCI_TEX_DEFAULT 0
#define wxSCI_TEX_SPECIAL 1
#define wxSCI_TEX_GROUP 2
#define wxSCI_TEX_SYMBOL 3
#define wxSCI_TEX_COMMAND 4
#define wxSCI_TEX_TEXT 5
#define wxSCI_METAPOST_DEFAULT 0
#define wxSCI_METAPOST_SPECIAL 1
#define wxSCI_METAPOST_GROUP 2
#define wxSCI_METAPOST_SYMBOL 3
#define wxSCI_METAPOST_COMMAND 4
#define wxSCI_METAPOST_TEXT 5
#define wxSCI_METAPOST_EXTRA 6

/// Lexical states for SCLEX_ERLANG
#define wxSCI_ERLANG_DEFAULT 0
#define wxSCI_ERLANG_COMMENT 1
#define wxSCI_ERLANG_VARIABLE 2
#define wxSCI_ERLANG_NUMBER 3
#define wxSCI_ERLANG_KEYWORD 4
#define wxSCI_ERLANG_STRING 5
#define wxSCI_ERLANG_OPERATOR 6
#define wxSCI_ERLANG_ATOM 7
#define wxSCI_ERLANG_FUNCTION_NAME 8
#define wxSCI_ERLANG_CHARACTER 9
#define wxSCI_ERLANG_MACRO 10
#define wxSCI_ERLANG_RECORD 11
#define wxSCI_ERLANG_PREPROC 12
#define wxSCI_ERLANG_NODE_NAME 13
#define wxSCI_ERLANG_COMMENT_FUNCTION 14
#define wxSCI_ERLANG_COMMENT_MODULE 15
#define wxSCI_ERLANG_COMMENT_DOC 16
#define wxSCI_ERLANG_COMMENT_DOC_MACRO 17
#define wxSCI_ERLANG_ATOM_QUOTED 18
#define wxSCI_ERLANG_MACRO_QUOTED 19
#define wxSCI_ERLANG_RECORD_QUOTED 20
#define wxSCI_ERLANG_NODE_NAME_QUOTED 21
#define wxSCI_ERLANG_BIFS 22
#define wxSCI_ERLANG_MODULES 23
#define wxSCI_ERLANG_MODULES_ATT 24
#define wxSCI_ERLANG_UNKNOWN 31

/// Lexical states for SCLEX_OCTAVE are identical to MatLab
/// Lexical states for SCLEX_MSSQL
#define wxSCI_MSSQL_DEFAULT 0
#define wxSCI_MSSQL_COMMENT 1
#define wxSCI_MSSQL_LINE_COMMENT 2
#define wxSCI_MSSQL_NUMBER 3
#define wxSCI_MSSQL_STRING 4
#define wxSCI_MSSQL_OPERATOR 5
#define wxSCI_MSSQL_IDENTIFIER 6
#define wxSCI_MSSQL_VARIABLE 7
#define wxSCI_MSSQL_COLUMN_NAME 8
#define wxSCI_MSSQL_STATEMENT 9
#define wxSCI_MSSQL_DATATYPE 10
#define wxSCI_MSSQL_SYSTABLE 11
#define wxSCI_MSSQL_GLOBAL_VARIABLE 12
#define wxSCI_MSSQL_FUNCTION 13
#define wxSCI_MSSQL_STORED_PROCEDURE 14
#define wxSCI_MSSQL_DEFAULT_PREF_DATATYPE 15
#define wxSCI_MSSQL_COLUMN_NAME_2 16

/// Lexical states for SCLEX_VERILOG
#define wxSCI_V_DEFAULT 0
#define wxSCI_V_COMMENT 1
#define wxSCI_V_COMMENTLINE 2
#define wxSCI_V_COMMENTLINEBANG 3
#define wxSCI_V_NUMBER 4
#define wxSCI_V_WORD 5
#define wxSCI_V_STRING 6
#define wxSCI_V_WORD2 7
#define wxSCI_V_WORD3 8
#define wxSCI_V_PREPROCESSOR 9
#define wxSCI_V_OPERATOR 10
#define wxSCI_V_IDENTIFIER 11
#define wxSCI_V_STRINGEOL 12
#define wxSCI_V_USER 19
#define wxSCI_V_COMMENT_WORD 20
#define wxSCI_V_INPUT 21
#define wxSCI_V_OUTPUT 22
#define wxSCI_V_INOUT 23
#define wxSCI_V_PORT_CONNECT 24

/// Lexical states for SCLEX_KIX
#define wxSCI_KIX_DEFAULT 0
#define wxSCI_KIX_COMMENT 1
#define wxSCI_KIX_STRING1 2
#define wxSCI_KIX_STRING2 3
#define wxSCI_KIX_NUMBER 4
#define wxSCI_KIX_VAR 5
#define wxSCI_KIX_MACRO 6
#define wxSCI_KIX_KEYWORD 7
#define wxSCI_KIX_FUNCTIONS 8
#define wxSCI_KIX_OPERATOR 9
#define wxSCI_KIX_COMMENTSTREAM 10
#define wxSCI_KIX_IDENTIFIER 31

/// Lexical states for SCLEX_GUI4CLI
#define wxSCI_GC_DEFAULT 0
#define wxSCI_GC_COMMENTLINE 1
#define wxSCI_GC_COMMENTBLOCK 2
#define wxSCI_GC_GLOBAL 3
#define wxSCI_GC_EVENT 4
#define wxSCI_GC_ATTRIBUTE 5
#define wxSCI_GC_CONTROL 6
#define wxSCI_GC_COMMAND 7
#define wxSCI_GC_STRING 8
#define wxSCI_GC_OPERATOR 9

/// Lexical states for SCLEX_SPECMAN
#define wxSCI_SN_DEFAULT 0
#define wxSCI_SN_CODE 1
#define wxSCI_SN_COMMENTLINE 2
#define wxSCI_SN_COMMENTLINEBANG 3
#define wxSCI_SN_NUMBER 4
#define wxSCI_SN_WORD 5
#define wxSCI_SN_STRING 6
#define wxSCI_SN_WORD2 7
#define wxSCI_SN_WORD3 8
#define wxSCI_SN_PREPROCESSOR 9
#define wxSCI_SN_OPERATOR 10
#define wxSCI_SN_IDENTIFIER 11
#define wxSCI_SN_STRINGEOL 12
#define wxSCI_SN_REGEXTAG 13
#define wxSCI_SN_SIGNAL 14
#define wxSCI_SN_USER 19

/// Lexical states for SCLEX_AU3
#define wxSCI_AU3_DEFAULT 0
#define wxSCI_AU3_COMMENT 1
#define wxSCI_AU3_COMMENTBLOCK 2
#define wxSCI_AU3_NUMBER 3
#define wxSCI_AU3_FUNCTION 4
#define wxSCI_AU3_KEYWORD 5
#define wxSCI_AU3_MACRO 6
#define wxSCI_AU3_STRING 7
#define wxSCI_AU3_OPERATOR 8
#define wxSCI_AU3_VARIABLE 9
#define wxSCI_AU3_SENT 10
#define wxSCI_AU3_PREPROCESSOR 11
#define wxSCI_AU3_SPECIAL 12
#define wxSCI_AU3_EXPAND 13
#define wxSCI_AU3_COMOBJ 14
#define wxSCI_AU3_UDF 15

/// Lexical states for SCLEX_APDL
#define wxSCI_APDL_DEFAULT 0
#define wxSCI_APDL_COMMENT 1
#define wxSCI_APDL_COMMENTBLOCK 2
#define wxSCI_APDL_NUMBER 3
#define wxSCI_APDL_STRING 4
#define wxSCI_APDL_OPERATOR 5
#define wxSCI_APDL_WORD 6
#define wxSCI_APDL_PROCESSOR 7
#define wxSCI_APDL_COMMAND 8
#define wxSCI_APDL_SLASHCOMMAND 9
#define wxSCI_APDL_STARCOMMAND 10
#define wxSCI_APDL_ARGUMENT 11
#define wxSCI_APDL_FUNCTION 12

/// Lexical states for SCLEX_BASH
#define wxSCI_SH_DEFAULT 0
#define wxSCI_SH_ERROR 1
#define wxSCI_SH_COMMENTLINE 2
#define wxSCI_SH_NUMBER 3
#define wxSCI_SH_WORD 4
#define wxSCI_SH_STRING 5
#define wxSCI_SH_CHARACTER 6
#define wxSCI_SH_OPERATOR 7
#define wxSCI_SH_IDENTIFIER 8
#define wxSCI_SH_SCALAR 9
#define wxSCI_SH_PARAM 10
#define wxSCI_SH_BACKTICKS 11
#define wxSCI_SH_HERE_DELIM 12
#define wxSCI_SH_HERE_Q 13

/// Lexical states for SCLEX_ASN1
#define wxSCI_ASN1_DEFAULT 0
#define wxSCI_ASN1_COMMENT 1
#define wxSCI_ASN1_IDENTIFIER 2
#define wxSCI_ASN1_STRING 3
#define wxSCI_ASN1_OID 4
#define wxSCI_ASN1_SCALAR 5
#define wxSCI_ASN1_KEYWORD 6
#define wxSCI_ASN1_ATTRIBUTE 7
#define wxSCI_ASN1_DESCRIPTOR 8
#define wxSCI_ASN1_TYPE 9
#define wxSCI_ASN1_OPERATOR 10

/// Lexical states for SCLEX_VHDL
#define wxSCI_VHDL_DEFAULT 0
#define wxSCI_VHDL_COMMENT 1
#define wxSCI_VHDL_COMMENTLINEBANG 2
#define wxSCI_VHDL_NUMBER 3
#define wxSCI_VHDL_STRING 4
#define wxSCI_VHDL_OPERATOR 5
#define wxSCI_VHDL_IDENTIFIER 6
#define wxSCI_VHDL_STRINGEOL 7
#define wxSCI_VHDL_KEYWORD 8
#define wxSCI_VHDL_STDOPERATOR 9
#define wxSCI_VHDL_ATTRIBUTE 10
#define wxSCI_VHDL_STDFUNCTION 11
#define wxSCI_VHDL_STDPACKAGE 12
#define wxSCI_VHDL_STDTYPE 13
#define wxSCI_VHDL_USERWORD 14
#define wxSCI_VHDL_BLOCK_COMMENT 15

/// Lexical states for SCLEX_CAML
#define wxSCI_CAML_DEFAULT 0
#define wxSCI_CAML_IDENTIFIER 1
#define wxSCI_CAML_TAGNAME 2
#define wxSCI_CAML_KEYWORD 3
#define wxSCI_CAML_KEYWORD2 4
#define wxSCI_CAML_KEYWORD3 5
#define wxSCI_CAML_LINENUM 6
#define wxSCI_CAML_OPERATOR 7
#define wxSCI_CAML_NUMBER 8
#define wxSCI_CAML_CHAR 9
#define wxSCI_CAML_WHITE 10
#define wxSCI_CAML_STRING 11
#define wxSCI_CAML_COMMENT 12
#define wxSCI_CAML_COMMENT1 13
#define wxSCI_CAML_COMMENT2 14
#define wxSCI_CAML_COMMENT3 15

/// Lexical states for SCLEX_HASKELL
#define wxSCI_HA_DEFAULT 0
#define wxSCI_HA_IDENTIFIER 1
#define wxSCI_HA_KEYWORD 2
#define wxSCI_HA_NUMBER 3
#define wxSCI_HA_STRING 4
#define wxSCI_HA_CHARACTER 5
#define wxSCI_HA_CLASS 6
#define wxSCI_HA_MODULE 7
#define wxSCI_HA_CAPITAL 8
#define wxSCI_HA_DATA 9
#define wxSCI_HA_IMPORT 10
#define wxSCI_HA_OPERATOR 11
#define wxSCI_HA_INSTANCE 12
#define wxSCI_HA_COMMENTLINE 13
#define wxSCI_HA_COMMENTBLOCK 14
#define wxSCI_HA_COMMENTBLOCK2 15
#define wxSCI_HA_COMMENTBLOCK3 16
#define wxSCI_HA_PRAGMA 17
#define wxSCI_HA_PREPROCESSOR 18
#define wxSCI_HA_STRINGEOL 19
#define wxSCI_HA_RESERVED_OPERATOR 20
#define wxSCI_HA_LITERATE_COMMENT 21
#define wxSCI_HA_LITERATE_CODEDELIM 22

/// Lexical states of SCLEX_TADS3
#define wxSCI_T3_DEFAULT 0
#define wxSCI_T3_X_DEFAULT 1
#define wxSCI_T3_PREPROCESSOR 2
#define wxSCI_T3_BLOCK_COMMENT 3
#define wxSCI_T3_LINE_COMMENT 4
#define wxSCI_T3_OPERATOR 5
#define wxSCI_T3_KEYWORD 6
#define wxSCI_T3_NUMBER 7
#define wxSCI_T3_IDENTIFIER 8
#define wxSCI_T3_S_STRING 9
#define wxSCI_T3_D_STRING 10
#define wxSCI_T3_X_STRING 11
#define wxSCI_T3_LIB_DIRECTIVE 12
#define wxSCI_T3_MSG_PARAM 13
#define wxSCI_T3_HTML_TAG 14
#define wxSCI_T3_HTML_DEFAULT 15
#define wxSCI_T3_HTML_STRING 16
#define wxSCI_T3_USER1 17
#define wxSCI_T3_USER2 18
#define wxSCI_T3_USER3 19
#define wxSCI_T3_BRACE 20

/// Lexical states for SCLEX_REBOL
#define wxSCI_REBOL_DEFAULT 0
#define wxSCI_REBOL_COMMENTLINE 1
#define wxSCI_REBOL_COMMENTBLOCK 2
#define wxSCI_REBOL_PREFACE 3
#define wxSCI_REBOL_OPERATOR 4
#define wxSCI_REBOL_CHARACTER 5
#define wxSCI_REBOL_QUOTEDSTRING 6
#define wxSCI_REBOL_BRACEDSTRING 7
#define wxSCI_REBOL_NUMBER 8
#define wxSCI_REBOL_PAIR 9
#define wxSCI_REBOL_TUPLE 10
#define wxSCI_REBOL_BINARY 11
#define wxSCI_REBOL_MONEY 12
#define wxSCI_REBOL_ISSUE 13
#define wxSCI_REBOL_TAG 14
#define wxSCI_REBOL_FILE 15
#define wxSCI_REBOL_EMAIL 16
#define wxSCI_REBOL_URL 17
#define wxSCI_REBOL_DATE 18
#define wxSCI_REBOL_TIME 19
#define wxSCI_REBOL_IDENTIFIER 20
#define wxSCI_REBOL_WORD 21
#define wxSCI_REBOL_WORD2 22
#define wxSCI_REBOL_WORD3 23
#define wxSCI_REBOL_WORD4 24
#define wxSCI_REBOL_WORD5 25
#define wxSCI_REBOL_WORD6 26
#define wxSCI_REBOL_WORD7 27
#define wxSCI_REBOL_WORD8 28

/// Lexical states for SCLEX_SQL
#define wxSCI_SQL_DEFAULT 0
#define wxSCI_SQL_COMMENT 1
#define wxSCI_SQL_COMMENTLINE 2
#define wxSCI_SQL_COMMENTDOC 3
#define wxSCI_SQL_NUMBER 4
#define wxSCI_SQL_WORD 5
#define wxSCI_SQL_STRING 6
#define wxSCI_SQL_CHARACTER 7
#define wxSCI_SQL_SQLPLUS 8
#define wxSCI_SQL_SQLPLUS_PROMPT 9
#define wxSCI_SQL_OPERATOR 10
#define wxSCI_SQL_IDENTIFIER 11
#define wxSCI_SQL_SQLPLUS_COMMENT 13
#define wxSCI_SQL_COMMENTLINEDOC 15
#define wxSCI_SQL_WORD2 16
#define wxSCI_SQL_COMMENTDOCKEYWORD 17
#define wxSCI_SQL_COMMENTDOCKEYWORDERROR 18
#define wxSCI_SQL_USER1 19
#define wxSCI_SQL_USER2 20
#define wxSCI_SQL_USER3 21
#define wxSCI_SQL_USER4 22
#define wxSCI_SQL_QUOTEDIDENTIFIER 23
#define wxSCI_SQL_QOPERATOR 24

/// Lexical states for SCLEX_SMALLTALK
#define wxSCI_ST_DEFAULT 0
#define wxSCI_ST_STRING 1
#define wxSCI_ST_NUMBER 2
#define wxSCI_ST_COMMENT 3
#define wxSCI_ST_SYMBOL 4
#define wxSCI_ST_BINARY 5
#define wxSCI_ST_BOOL 6
#define wxSCI_ST_SELF 7
#define wxSCI_ST_SUPER 8
#define wxSCI_ST_NIL 9
#define wxSCI_ST_GLOBAL 10
#define wxSCI_ST_RETURN 11
#define wxSCI_ST_SPECIAL 12
#define wxSCI_ST_KWSEND 13
#define wxSCI_ST_ASSIGN 14
#define wxSCI_ST_CHARACTER 15
#define wxSCI_ST_SPEC_SEL 16

/// Lexical states for SCLEX_FLAGSHIP (clipper)
#define wxSCI_FS_DEFAULT 0
#define wxSCI_FS_COMMENT 1
#define wxSCI_FS_COMMENTLINE 2
#define wxSCI_FS_COMMENTDOC 3
#define wxSCI_FS_COMMENTLINEDOC 4
#define wxSCI_FS_COMMENTDOCKEYWORD 5
#define wxSCI_FS_COMMENTDOCKEYWORDERROR 6
#define wxSCI_FS_KEYWORD 7
#define wxSCI_FS_KEYWORD2 8
#define wxSCI_FS_KEYWORD3 9
#define wxSCI_FS_KEYWORD4 10
#define wxSCI_FS_NUMBER 11
#define wxSCI_FS_STRING 12
#define wxSCI_FS_PREPROCESSOR 13
#define wxSCI_FS_OPERATOR 14
#define wxSCI_FS_IDENTIFIER 15
#define wxSCI_FS_DATE 16
#define wxSCI_FS_STRINGEOL 17
#define wxSCI_FS_CONSTANT 18
#define wxSCI_FS_WORDOPERATOR 19
#define wxSCI_FS_DISABLEDCODE 20
#define wxSCI_FS_DEFAULT_C 21
#define wxSCI_FS_COMMENTDOC_C 22
#define wxSCI_FS_COMMENTLINEDOC_C 23
#define wxSCI_FS_KEYWORD_C 24
#define wxSCI_FS_KEYWORD2_C 25
#define wxSCI_FS_NUMBER_C 26
#define wxSCI_FS_STRING_C 27
#define wxSCI_FS_PREPROCESSOR_C 28
#define wxSCI_FS_OPERATOR_C 29
#define wxSCI_FS_IDENTIFIER_C 30
#define wxSCI_FS_STRINGEOL_C 31

/// Lexical states for SCLEX_CSOUND
#define wxSCI_CSOUND_DEFAULT 0
#define wxSCI_CSOUND_COMMENT 1
#define wxSCI_CSOUND_NUMBER 2
#define wxSCI_CSOUND_OPERATOR 3
#define wxSCI_CSOUND_INSTR 4
#define wxSCI_CSOUND_IDENTIFIER 5
#define wxSCI_CSOUND_OPCODE 6
#define wxSCI_CSOUND_HEADERSTMT 7
#define wxSCI_CSOUND_USERKEYWORD 8
#define wxSCI_CSOUND_COMMENTBLOCK 9
#define wxSCI_CSOUND_PARAM 10
#define wxSCI_CSOUND_ARATE_VAR 11
#define wxSCI_CSOUND_KRATE_VAR 12
#define wxSCI_CSOUND_IRATE_VAR 13
#define wxSCI_CSOUND_GLOBAL_VAR 14
#define wxSCI_CSOUND_STRINGEOL 15

/// Lexical states for SCLEX_INNOSETUP
#define wxSCI_INNO_DEFAULT 0
#define wxSCI_INNO_COMMENT 1
#define wxSCI_INNO_KEYWORD 2
#define wxSCI_INNO_PARAMETER 3
#define wxSCI_INNO_SECTION 4
#define wxSCI_INNO_PREPROC 5
#define wxSCI_INNO_INLINE_EXPANSION 6
#define wxSCI_INNO_COMMENT_PASCAL 7
#define wxSCI_INNO_KEYWORD_PASCAL 8
#define wxSCI_INNO_KEYWORD_USER 9
#define wxSCI_INNO_STRING_DOUBLE 10
#define wxSCI_INNO_STRING_SINGLE 11
#define wxSCI_INNO_IDENTIFIER 12

/// Lexical states for SCLEX_OPAL
#define wxSCI_OPAL_SPACE 0
#define wxSCI_OPAL_COMMENT_BLOCK 1
#define wxSCI_OPAL_COMMENT_LINE 2
#define wxSCI_OPAL_INTEGER 3
#define wxSCI_OPAL_KEYWORD 4
#define wxSCI_OPAL_SORT 5
#define wxSCI_OPAL_STRING 6
#define wxSCI_OPAL_PAR 7
#define wxSCI_OPAL_BOOL_CONST 8
#define wxSCI_OPAL_DEFAULT 32

/// Lexical states for SCLEX_SPICE
#define wxSCI_SPICE_DEFAULT 0
#define wxSCI_SPICE_IDENTIFIER 1
#define wxSCI_SPICE_KEYWORD 2
#define wxSCI_SPICE_KEYWORD2 3
#define wxSCI_SPICE_KEYWORD3 4
#define wxSCI_SPICE_NUMBER 5
#define wxSCI_SPICE_DELIMITER 6
#define wxSCI_SPICE_VALUE 7
#define wxSCI_SPICE_COMMENTLINE 8

/// Lexical states for SCLEX_CMAKE
#define wxSCI_CMAKE_DEFAULT 0
#define wxSCI_CMAKE_COMMENT 1
#define wxSCI_CMAKE_STRINGDQ 2
#define wxSCI_CMAKE_STRINGLQ 3
#define wxSCI_CMAKE_STRINGRQ 4
#define wxSCI_CMAKE_COMMANDS 5
#define wxSCI_CMAKE_PARAMETERS 6
#define wxSCI_CMAKE_VARIABLE 7
#define wxSCI_CMAKE_USERDEFINED 8
#define wxSCI_CMAKE_WHILEDEF 9
#define wxSCI_CMAKE_FOREACHDEF 10
#define wxSCI_CMAKE_IFDEFINEDEF 11
#define wxSCI_CMAKE_MACRODEF 12
#define wxSCI_CMAKE_STRINGVAR 13
#define wxSCI_CMAKE_NUMBER 14

/// Lexical states for SCLEX_GAP
#define wxSCI_GAP_DEFAULT 0
#define wxSCI_GAP_IDENTIFIER 1
#define wxSCI_GAP_KEYWORD 2
#define wxSCI_GAP_KEYWORD2 3
#define wxSCI_GAP_KEYWORD3 4
#define wxSCI_GAP_KEYWORD4 5
#define wxSCI_GAP_STRING 6
#define wxSCI_GAP_CHAR 7
#define wxSCI_GAP_OPERATOR 8
#define wxSCI_GAP_COMMENT 9
#define wxSCI_GAP_NUMBER 10
#define wxSCI_GAP_STRINGEOL 11

/// Lexical state for SCLEX_PLM
#define wxSCI_PLM_DEFAULT 0
#define wxSCI_PLM_COMMENT 1
#define wxSCI_PLM_STRING 2
#define wxSCI_PLM_NUMBER 3
#define wxSCI_PLM_IDENTIFIER 4
#define wxSCI_PLM_OPERATOR 5
#define wxSCI_PLM_CONTROL 6
#define wxSCI_PLM_KEYWORD 7

/// Lexical state for SCLEX_PROGRESS
#define wxSCI_ABL_DEFAULT 0
#define wxSCI_ABL_NUMBER 1
#define wxSCI_ABL_WORD 2
#define wxSCI_ABL_STRING 3
#define wxSCI_ABL_CHARACTER 4
#define wxSCI_ABL_PREPROCESSOR 5
#define wxSCI_ABL_OPERATOR 6
#define wxSCI_ABL_IDENTIFIER 7
#define wxSCI_ABL_BLOCK 8
#define wxSCI_ABL_END 9
#define wxSCI_ABL_COMMENT 10
#define wxSCI_ABL_TASKMARKER 11
#define wxSCI_ABL_LINECOMMENT 12

/// Lexical states for SCLEX_ABAQUS
#define wxSCI_ABAQUS_DEFAULT 0
#define wxSCI_ABAQUS_COMMENT 1
#define wxSCI_ABAQUS_COMMENTBLOCK 2
#define wxSCI_ABAQUS_NUMBER 3
#define wxSCI_ABAQUS_STRING 4
#define wxSCI_ABAQUS_OPERATOR 5
#define wxSCI_ABAQUS_WORD 6
#define wxSCI_ABAQUS_PROCESSOR 7
#define wxSCI_ABAQUS_COMMAND 8
#define wxSCI_ABAQUS_SLASHCOMMAND 9
#define wxSCI_ABAQUS_STARCOMMAND 10
#define wxSCI_ABAQUS_ARGUMENT 11
#define wxSCI_ABAQUS_FUNCTION 12

/// Lexical states for SCLEX_ASYMPTOTE
#define wxSCI_ASY_DEFAULT 0
#define wxSCI_ASY_COMMENT 1
#define wxSCI_ASY_COMMENTLINE 2
#define wxSCI_ASY_NUMBER 3
#define wxSCI_ASY_WORD 4
#define wxSCI_ASY_STRING 5
#define wxSCI_ASY_CHARACTER 6
#define wxSCI_ASY_OPERATOR 7
#define wxSCI_ASY_IDENTIFIER 8
#define wxSCI_ASY_STRINGEOL 9
#define wxSCI_ASY_COMMENTLINEDOC 10
#define wxSCI_ASY_WORD2 11

/// Lexical states for SCLEX_R
#define wxSCI_R_DEFAULT 0
#define wxSCI_R_COMMENT 1
#define wxSCI_R_KWORD 2
#define wxSCI_R_BASEKWORD 3
#define wxSCI_R_OTHERKWORD 4
#define wxSCI_R_NUMBER 5
#define wxSCI_R_STRING 6
#define wxSCI_R_STRING2 7
#define wxSCI_R_OPERATOR 8
#define wxSCI_R_IDENTIFIER 9
#define wxSCI_R_INFIX 10
#define wxSCI_R_INFIXEOL 11

/// Lexical state for SCLEX_MAGIK
#define wxSCI_MAGIK_DEFAULT 0
#define wxSCI_MAGIK_COMMENT 1
#define wxSCI_MAGIK_HYPER_COMMENT 16
#define wxSCI_MAGIK_STRING 2
#define wxSCI_MAGIK_CHARACTER 3
#define wxSCI_MAGIK_NUMBER 4
#define wxSCI_MAGIK_IDENTIFIER 5
#define wxSCI_MAGIK_OPERATOR 6
#define wxSCI_MAGIK_FLOW 7
#define wxSCI_MAGIK_CONTAINER 8
#define wxSCI_MAGIK_BRACKET_BLOCK 9
#define wxSCI_MAGIK_BRACE_BLOCK 10
#define wxSCI_MAGIK_SQBRACKET_BLOCK 11
#define wxSCI_MAGIK_UNKNOWN_KEYWORD 12
#define wxSCI_MAGIK_KEYWORD 13
#define wxSCI_MAGIK_PRAGMA 14
#define wxSCI_MAGIK_SYMBOL 15

/// Lexical state for SCLEX_POWERSHELL
#define wxSCI_POWERSHELL_DEFAULT 0
#define wxSCI_POWERSHELL_COMMENT 1
#define wxSCI_POWERSHELL_STRING 2
#define wxSCI_POWERSHELL_CHARACTER 3
#define wxSCI_POWERSHELL_NUMBER 4
#define wxSCI_POWERSHELL_VARIABLE 5
#define wxSCI_POWERSHELL_OPERATOR 6
#define wxSCI_POWERSHELL_IDENTIFIER 7
#define wxSCI_POWERSHELL_KEYWORD 8
#define wxSCI_POWERSHELL_CMDLET 9
#define wxSCI_POWERSHELL_ALIAS 10
#define wxSCI_POWERSHELL_FUNCTION 11
#define wxSCI_POWERSHELL_USER1 12
#define wxSCI_POWERSHELL_COMMENTSTREAM 13
#define wxSCI_POWERSHELL_HERE_STRING 14
#define wxSCI_POWERSHELL_HERE_CHARACTER 15
#define wxSCI_POWERSHELL_COMMENTDOCKEYWORD 16

/// Lexical state for SCLEX_MYSQL
#define wxSCI_MYSQL_DEFAULT 0
#define wxSCI_MYSQL_COMMENT 1
#define wxSCI_MYSQL_COMMENTLINE 2
#define wxSCI_MYSQL_VARIABLE 3
#define wxSCI_MYSQL_SYSTEMVARIABLE 4
#define wxSCI_MYSQL_KNOWNSYSTEMVARIABLE 5
#define wxSCI_MYSQL_NUMBER 6
#define wxSCI_MYSQL_MAJORKEYWORD 7
#define wxSCI_MYSQL_KEYWORD 8
#define wxSCI_MYSQL_DATABASEOBJECT 9
#define wxSCI_MYSQL_PROCEDUREKEYWORD 10
#define wxSCI_MYSQL_STRING 11
#define wxSCI_MYSQL_SQSTRING 12
#define wxSCI_MYSQL_DQSTRING 13
#define wxSCI_MYSQL_OPERATOR 14
#define wxSCI_MYSQL_FUNCTION 15
#define wxSCI_MYSQL_IDENTIFIER 16
#define wxSCI_MYSQL_QUOTEDIDENTIFIER 17
#define wxSCI_MYSQL_USER1 18
#define wxSCI_MYSQL_USER2 19
#define wxSCI_MYSQL_USER3 20
#define wxSCI_MYSQL_HIDDENCOMMAND 21
#define wxSCI_MYSQL_PLACEHOLDER 22

/// Lexical state for SCLEX_PO
#define wxSCI_PO_DEFAULT 0
#define wxSCI_PO_COMMENT 1
#define wxSCI_PO_MSGID 2
#define wxSCI_PO_MSGID_TEXT 3
#define wxSCI_PO_MSGSTR 4
#define wxSCI_PO_MSGSTR_TEXT 5
#define wxSCI_PO_MSGCTXT 6
#define wxSCI_PO_MSGCTXT_TEXT 7
#define wxSCI_PO_FUZZY 8
#define wxSCI_PO_PROGRAMMER_COMMENT 9
#define wxSCI_PO_REFERENCE 10
#define wxSCI_PO_FLAGS 11
#define wxSCI_PO_MSGID_TEXT_EOL 12
#define wxSCI_PO_MSGSTR_TEXT_EOL 13
#define wxSCI_PO_MSGCTXT_TEXT_EOL 14
#define wxSCI_PO_ERROR 15

/// Lexical states for SCLEX_PASCAL
#define wxSCI_PAS_DEFAULT 0
#define wxSCI_PAS_IDENTIFIER 1
#define wxSCI_PAS_COMMENT 2
#define wxSCI_PAS_COMMENT2 3
#define wxSCI_PAS_COMMENTLINE 4
#define wxSCI_PAS_PREPROCESSOR 5
#define wxSCI_PAS_PREPROCESSOR2 6
#define wxSCI_PAS_NUMBER 7
#define wxSCI_PAS_HEXNUMBER 8
#define wxSCI_PAS_WORD 9
#define wxSCI_PAS_STRING 10
#define wxSCI_PAS_STRINGEOL 11
#define wxSCI_PAS_CHARACTER 12
#define wxSCI_PAS_OPERATOR 13
#define wxSCI_PAS_ASM 14

/// Lexical state for SCLEX_SORCUS
#define wxSCI_SORCUS_DEFAULT 0
#define wxSCI_SORCUS_COMMAND 1
#define wxSCI_SORCUS_PARAMETER 2
#define wxSCI_SORCUS_COMMENTLINE 3
#define wxSCI_SORCUS_STRING 4
#define wxSCI_SORCUS_STRINGEOL 5
#define wxSCI_SORCUS_IDENTIFIER 6
#define wxSCI_SORCUS_OPERATOR 7
#define wxSCI_SORCUS_NUMBER 8
#define wxSCI_SORCUS_CONSTANT 9

/// Lexical state for SCLEX_POWERPRO
#define wxSCI_POWERPRO_DEFAULT 0
#define wxSCI_POWERPRO_COMMENTBLOCK 1
#define wxSCI_POWERPRO_COMMENTLINE 2
#define wxSCI_POWERPRO_NUMBER 3
#define wxSCI_POWERPRO_WORD 4
#define wxSCI_POWERPRO_WORD2 5
#define wxSCI_POWERPRO_WORD3 6
#define wxSCI_POWERPRO_WORD4 7
#define wxSCI_POWERPRO_DOUBLEQUOTEDSTRING 8
#define wxSCI_POWERPRO_SINGLEQUOTEDSTRING 9
#define wxSCI_POWERPRO_LINECONTINUE 10
#define wxSCI_POWERPRO_OPERATOR 11
#define wxSCI_POWERPRO_IDENTIFIER 12
#define wxSCI_POWERPRO_STRINGEOL 13
#define wxSCI_POWERPRO_VERBATIM 14
#define wxSCI_POWERPRO_ALTQUOTE 15
#define wxSCI_POWERPRO_FUNCTION 16

/// Lexical states for SCLEX_SML
#define wxSCI_SML_DEFAULT 0
#define wxSCI_SML_IDENTIFIER 1
#define wxSCI_SML_TAGNAME 2
#define wxSCI_SML_KEYWORD 3
#define wxSCI_SML_KEYWORD2 4
#define wxSCI_SML_KEYWORD3 5
#define wxSCI_SML_LINENUM 6
#define wxSCI_SML_OPERATOR 7
#define wxSCI_SML_NUMBER 8
#define wxSCI_SML_CHAR 9
#define wxSCI_SML_STRING 11
#define wxSCI_SML_COMMENT 12
#define wxSCI_SML_COMMENT1 13
#define wxSCI_SML_COMMENT2 14
#define wxSCI_SML_COMMENT3 15

/// Lexical state for SCLEX_MARKDOWN
#define wxSCI_MARKDOWN_DEFAULT 0
#define wxSCI_MARKDOWN_LINE_BEGIN 1
#define wxSCI_MARKDOWN_STRONG1 2
#define wxSCI_MARKDOWN_STRONG2 3
#define wxSCI_MARKDOWN_EM1 4
#define wxSCI_MARKDOWN_EM2 5
#define wxSCI_MARKDOWN_HEADER1 6
#define wxSCI_MARKDOWN_HEADER2 7
#define wxSCI_MARKDOWN_HEADER3 8
#define wxSCI_MARKDOWN_HEADER4 9
#define wxSCI_MARKDOWN_HEADER5 10
#define wxSCI_MARKDOWN_HEADER6 11
#define wxSCI_MARKDOWN_PRECHAR 12
#define wxSCI_MARKDOWN_ULIST_ITEM 13
#define wxSCI_MARKDOWN_OLIST_ITEM 14
#define wxSCI_MARKDOWN_BLOCKQUOTE 15
#define wxSCI_MARKDOWN_STRIKEOUT 16
#define wxSCI_MARKDOWN_HRULE 17
#define wxSCI_MARKDOWN_LINK 18
#define wxSCI_MARKDOWN_CODE 19
#define wxSCI_MARKDOWN_CODE2 20
#define wxSCI_MARKDOWN_CODEBK 21

/// Lexical state for SCLEX_TXT2TAGS
#define wxSCI_TXT2TAGS_DEFAULT 0
#define wxSCI_TXT2TAGS_LINE_BEGIN 1
#define wxSCI_TXT2TAGS_STRONG1 2
#define wxSCI_TXT2TAGS_STRONG2 3
#define wxSCI_TXT2TAGS_EM1 4
#define wxSCI_TXT2TAGS_EM2 5
#define wxSCI_TXT2TAGS_HEADER1 6
#define wxSCI_TXT2TAGS_HEADER2 7
#define wxSCI_TXT2TAGS_HEADER3 8
#define wxSCI_TXT2TAGS_HEADER4 9
#define wxSCI_TXT2TAGS_HEADER5 10
#define wxSCI_TXT2TAGS_HEADER6 11
#define wxSCI_TXT2TAGS_PRECHAR 12
#define wxSCI_TXT2TAGS_ULIST_ITEM 13
#define wxSCI_TXT2TAGS_OLIST_ITEM 14
#define wxSCI_TXT2TAGS_BLOCKQUOTE 15
#define wxSCI_TXT2TAGS_STRIKEOUT 16
#define wxSCI_TXT2TAGS_HRULE 17
#define wxSCI_TXT2TAGS_LINK 18
#define wxSCI_TXT2TAGS_CODE 19
#define wxSCI_TXT2TAGS_CODE2 20
#define wxSCI_TXT2TAGS_CODEBK 21
#define wxSCI_TXT2TAGS_COMMENT 22
#define wxSCI_TXT2TAGS_OPTION 23
#define wxSCI_TXT2TAGS_PREPROC 24
#define wxSCI_TXT2TAGS_POSTPROC 25

/// Lexical states for SCLEX_A68K
#define wxSCI_A68K_DEFAULT 0
#define wxSCI_A68K_COMMENT 1
#define wxSCI_A68K_NUMBER_DEC 2
#define wxSCI_A68K_NUMBER_BIN 3
#define wxSCI_A68K_NUMBER_HEX 4
#define wxSCI_A68K_STRING1 5
#define wxSCI_A68K_OPERATOR 6
#define wxSCI_A68K_CPUINSTRUCTION 7
#define wxSCI_A68K_EXTINSTRUCTION 8
#define wxSCI_A68K_REGISTER 9
#define wxSCI_A68K_DIRECTIVE 10
#define wxSCI_A68K_MACRO_ARG 11
#define wxSCI_A68K_LABEL 12
#define wxSCI_A68K_STRING2 13
#define wxSCI_A68K_IDENTIFIER 14
#define wxSCI_A68K_MACRO_DECLARATION 15
#define wxSCI_A68K_COMMENT_WORD 16
#define wxSCI_A68K_COMMENT_SPECIAL 17
#define wxSCI_A68K_COMMENT_DOXYGEN 18

/// Lexical states for SCLEX_MODULA
#define wxSCI_MODULA_DEFAULT 0
#define wxSCI_MODULA_COMMENT 1
#define wxSCI_MODULA_DOXYCOMM 2
#define wxSCI_MODULA_DOXYKEY 3
#define wxSCI_MODULA_KEYWORD 4
#define wxSCI_MODULA_RESERVED 5
#define wxSCI_MODULA_NUMBER 6
#define wxSCI_MODULA_BASENUM 7
#define wxSCI_MODULA_FLOAT 8
#define wxSCI_MODULA_STRING 9
#define wxSCI_MODULA_STRSPEC 10
#define wxSCI_MODULA_CHAR 11
#define wxSCI_MODULA_CHARSPEC 12
#define wxSCI_MODULA_PROC 13
#define wxSCI_MODULA_PRAGMA 14
#define wxSCI_MODULA_PRGKEY 15
#define wxSCI_MODULA_OPERATOR 16
#define wxSCI_MODULA_BADSTR 17

/// Lexical states for SCLEX_COFFEESCRIPT
#define wxSCI_COFFEESCRIPT_DEFAULT 0
#define wxSCI_COFFEESCRIPT_COMMENT 1
#define wxSCI_COFFEESCRIPT_COMMENTLINE 2
#define wxSCI_COFFEESCRIPT_COMMENTDOC 3
#define wxSCI_COFFEESCRIPT_NUMBER 4
#define wxSCI_COFFEESCRIPT_WORD 5
#define wxSCI_COFFEESCRIPT_STRING 6
#define wxSCI_COFFEESCRIPT_CHARACTER 7
#define wxSCI_COFFEESCRIPT_UUID 8
#define wxSCI_COFFEESCRIPT_PREPROCESSOR 9
#define wxSCI_COFFEESCRIPT_OPERATOR 10
#define wxSCI_COFFEESCRIPT_IDENTIFIER 11
#define wxSCI_COFFEESCRIPT_STRINGEOL 12
#define wxSCI_COFFEESCRIPT_VERBATIM 13
#define wxSCI_COFFEESCRIPT_REGEX 14
#define wxSCI_COFFEESCRIPT_COMMENTLINEDOC 15
#define wxSCI_COFFEESCRIPT_WORD2 16
#define wxSCI_COFFEESCRIPT_COMMENTDOCKEYWORD 17
#define wxSCI_COFFEESCRIPT_COMMENTDOCKEYWORDERROR 18
#define wxSCI_COFFEESCRIPT_GLOBALCLASS 19
#define wxSCI_COFFEESCRIPT_STRINGRAW 20
#define wxSCI_COFFEESCRIPT_TRIPLEVERBATIM 21
#define wxSCI_COFFEESCRIPT_COMMENTBLOCK 22
#define wxSCI_COFFEESCRIPT_VERBOSE_REGEX 23
#define wxSCI_COFFEESCRIPT_VERBOSE_REGEX_COMMENT 24
#define wxSCI_COFFEESCRIPT_INSTANCEPROPERTY 25

/// Lexical states for SCLEX_AVS
#define wxSCI_AVS_DEFAULT 0
#define wxSCI_AVS_COMMENTBLOCK 1
#define wxSCI_AVS_COMMENTBLOCKN 2
#define wxSCI_AVS_COMMENTLINE 3
#define wxSCI_AVS_NUMBER 4
#define wxSCI_AVS_OPERATOR 5
#define wxSCI_AVS_IDENTIFIER 6
#define wxSCI_AVS_STRING 7
#define wxSCI_AVS_TRIPLESTRING 8
#define wxSCI_AVS_KEYWORD 9
#define wxSCI_AVS_FILTER 10
#define wxSCI_AVS_PLUGIN 11
#define wxSCI_AVS_FUNCTION 12
#define wxSCI_AVS_CLIPPROP 13
#define wxSCI_AVS_USERDFN 14

/// Lexical states for SCLEX_ECL
#define wxSCI_ECL_DEFAULT 0
#define wxSCI_ECL_COMMENT 1
#define wxSCI_ECL_COMMENTLINE 2
#define wxSCI_ECL_NUMBER 3
#define wxSCI_ECL_STRING 4
#define wxSCI_ECL_WORD0 5
#define wxSCI_ECL_OPERATOR 6
#define wxSCI_ECL_CHARACTER 7
#define wxSCI_ECL_UUID 8
#define wxSCI_ECL_PREPROCESSOR 9
#define wxSCI_ECL_UNKNOWN 10
#define wxSCI_ECL_IDENTIFIER 11
#define wxSCI_ECL_STRINGEOL 12
#define wxSCI_ECL_VERBATIM 13
#define wxSCI_ECL_REGEX 14
#define wxSCI_ECL_COMMENTLINEDOC 15
#define wxSCI_ECL_WORD1 16
#define wxSCI_ECL_COMMENTDOCKEYWORD 17
#define wxSCI_ECL_COMMENTDOCKEYWORDERROR 18
#define wxSCI_ECL_WORD2 19
#define wxSCI_ECL_WORD3 20
#define wxSCI_ECL_WORD4 21
#define wxSCI_ECL_WORD5 22
#define wxSCI_ECL_COMMENTDOC 23
#define wxSCI_ECL_ADDED 24
#define wxSCI_ECL_DELETED 25
#define wxSCI_ECL_CHANGED 26
#define wxSCI_ECL_MOVED 27

/// Lexical states for SCLEX_OSCRIPT
#define wxSCI_OSCRIPT_DEFAULT 0
#define wxSCI_OSCRIPT_LINE_COMMENT 1
#define wxSCI_OSCRIPT_BLOCK_COMMENT 2
#define wxSCI_OSCRIPT_DOC_COMMENT 3
#define wxSCI_OSCRIPT_PREPROCESSOR 4
#define wxSCI_OSCRIPT_NUMBER 5
#define wxSCI_OSCRIPT_SINGLEQUOTE_STRING 6
#define wxSCI_OSCRIPT_DOUBLEQUOTE_STRING 7
#define wxSCI_OSCRIPT_CONSTANT 8
#define wxSCI_OSCRIPT_IDENTIFIER 9
#define wxSCI_OSCRIPT_GLOBAL 10
#define wxSCI_OSCRIPT_KEYWORD 11
#define wxSCI_OSCRIPT_OPERATOR 12
#define wxSCI_OSCRIPT_LABEL 13
#define wxSCI_OSCRIPT_TYPE 14
#define wxSCI_OSCRIPT_FUNCTION 15
#define wxSCI_OSCRIPT_OBJECT 16
#define wxSCI_OSCRIPT_PROPERTY 17
#define wxSCI_OSCRIPT_METHOD 18

/// Lexical states for SCLEX_VISUALPROLOG
#define wxSCI_VISUALPROLOG_DEFAULT 0
#define wxSCI_VISUALPROLOG_KEY_MAJOR 1
#define wxSCI_VISUALPROLOG_KEY_MINOR 2
#define wxSCI_VISUALPROLOG_KEY_DIRECTIVE 3
#define wxSCI_VISUALPROLOG_COMMENT_BLOCK 4
#define wxSCI_VISUALPROLOG_COMMENT_LINE 5
#define wxSCI_VISUALPROLOG_COMMENT_KEY 6
#define wxSCI_VISUALPROLOG_COMMENT_KEY_ERROR 7
#define wxSCI_VISUALPROLOG_IDENTIFIER 8
#define wxSCI_VISUALPROLOG_VARIABLE 9
#define wxSCI_VISUALPROLOG_ANONYMOUS 10
#define wxSCI_VISUALPROLOG_NUMBER 11
#define wxSCI_VISUALPROLOG_OPERATOR 12
#define wxSCI_VISUALPROLOG_CHARACTER 13
#define wxSCI_VISUALPROLOG_CHARACTER_TOO_MANY 14
#define wxSCI_VISUALPROLOG_CHARACTER_ESCAPE_ERROR 15
#define wxSCI_VISUALPROLOG_STRING 16
#define wxSCI_VISUALPROLOG_STRING_ESCAPE 17
#define wxSCI_VISUALPROLOG_STRING_ESCAPE_ERROR 18
#define wxSCI_VISUALPROLOG_STRING_EOL_OPEN 19
#define wxSCI_VISUALPROLOG_STRING_VERBATIM 20
#define wxSCI_VISUALPROLOG_STRING_VERBATIM_SPECIAL 21
#define wxSCI_VISUALPROLOG_STRING_VERBATIM_EOL 22

/// Lexical states for SCLEX_STTXT
#define wxSCI_STTXT_DEFAULT 0
#define wxSCI_STTXT_COMMENT 1
#define wxSCI_STTXT_COMMENTLINE 2
#define wxSCI_STTXT_KEYWORD 3
#define wxSCI_STTXT_TYPE 4
#define wxSCI_STTXT_FUNCTION 5
#define wxSCI_STTXT_FB 6
#define wxSCI_STTXT_NUMBER 7
#define wxSCI_STTXT_HEXNUMBER 8
#define wxSCI_STTXT_PRAGMA 9
#define wxSCI_STTXT_OPERATOR 10
#define wxSCI_STTXT_CHARACTER 11
#define wxSCI_STTXT_STRING1 12
#define wxSCI_STTXT_STRING2 13
#define wxSCI_STTXT_STRINGEOL 14
#define wxSCI_STTXT_IDENTIFIER 15
#define wxSCI_STTXT_DATETIME 16
#define wxSCI_STTXT_VARS 17
#define wxSCI_STTXT_PRAGMAS 18

/// Lexical states for SCLEX_KVIRC
#define wxSCI_KVIRC_DEFAULT 0
#define wxSCI_KVIRC_COMMENT 1
#define wxSCI_KVIRC_COMMENTBLOCK 2
#define wxSCI_KVIRC_STRING 3
#define wxSCI_KVIRC_WORD 4
#define wxSCI_KVIRC_KEYWORD 5
#define wxSCI_KVIRC_FUNCTION_KEYWORD 6
#define wxSCI_KVIRC_FUNCTION 7
#define wxSCI_KVIRC_VARIABLE 8
#define wxSCI_KVIRC_NUMBER 9
#define wxSCI_KVIRC_OPERATOR 10
#define wxSCI_KVIRC_STRING_FUNCTION 11
#define wxSCI_KVIRC_STRING_VARIABLE 12

/// Lexical states for SCLEX_RUST
#define wxSCI_RUST_DEFAULT 0
#define wxSCI_RUST_COMMENTBLOCK 1
#define wxSCI_RUST_COMMENTLINE 2
#define wxSCI_RUST_COMMENTBLOCKDOC 3
#define wxSCI_RUST_COMMENTLINEDOC 4
#define wxSCI_RUST_NUMBER 5
#define wxSCI_RUST_WORD 6
#define wxSCI_RUST_WORD2 7
#define wxSCI_RUST_WORD3 8
#define wxSCI_RUST_WORD4 9
#define wxSCI_RUST_WORD5 10
#define wxSCI_RUST_WORD6 11
#define wxSCI_RUST_WORD7 12
#define wxSCI_RUST_STRING 13
#define wxSCI_RUST_STRINGR 14
#define wxSCI_RUST_CHARACTER 15
#define wxSCI_RUST_OPERATOR 16
#define wxSCI_RUST_IDENTIFIER 17
#define wxSCI_RUST_LIFETIME 18
#define wxSCI_RUST_MACRO 19
#define wxSCI_RUST_LEXERROR 20
#define wxSCI_RUST_BYTESTRING 21
#define wxSCI_RUST_BYTESTRINGR 22
#define wxSCI_RUST_BYTECHARACTER 23

/// Lexical states for SCLEX_DMAP
#define wxSCI_DMAP_DEFAULT 0
#define wxSCI_DMAP_COMMENT 1
#define wxSCI_DMAP_NUMBER 2
#define wxSCI_DMAP_STRING1 3
#define wxSCI_DMAP_STRING2 4
#define wxSCI_DMAP_STRINGEOL 5
#define wxSCI_DMAP_OPERATOR 6
#define wxSCI_DMAP_IDENTIFIER 7
#define wxSCI_DMAP_WORD 8
#define wxSCI_DMAP_WORD2 9
#define wxSCI_DMAP_WORD3 10

/// Lexical states for SCLEX_DMIS
#define wxSCI_DMIS_DEFAULT 0
#define wxSCI_DMIS_COMMENT 1
#define wxSCI_DMIS_STRING 2
#define wxSCI_DMIS_NUMBER 3
#define wxSCI_DMIS_KEYWORD 4
#define wxSCI_DMIS_MAJORWORD 5
#define wxSCI_DMIS_MINORWORD 6
#define wxSCI_DMIS_UNSUPPORTED_MAJOR 7
#define wxSCI_DMIS_UNSUPPORTED_MINOR 8
#define wxSCI_DMIS_LABEL 9

/// Lexical states for SCLEX_REGISTRY
#define wxSCI_REG_DEFAULT 0
#define wxSCI_REG_COMMENT 1
#define wxSCI_REG_VALUENAME 2
#define wxSCI_REG_STRING 3
#define wxSCI_REG_HEXDIGIT 4
#define wxSCI_REG_VALUETYPE 5
#define wxSCI_REG_ADDEDKEY 6
#define wxSCI_REG_DELETEDKEY 7
#define wxSCI_REG_ESCAPED 8
#define wxSCI_REG_KEYPATH_GUID 9
#define wxSCI_REG_STRING_GUID 10
#define wxSCI_REG_PARAMETER 11
#define wxSCI_REG_OPERATOR 12

/// Lexical state for SCLEX_BIBTEX
#define wxSCI_BIBTEX_DEFAULT 0
#define wxSCI_BIBTEX_ENTRY 1
#define wxSCI_BIBTEX_UNKNOWN_ENTRY 2
#define wxSCI_BIBTEX_KEY 3
#define wxSCI_BIBTEX_PARAMETER 4
#define wxSCI_BIBTEX_VALUE 5
#define wxSCI_BIBTEX_COMMENT 6

/// Lexical state for SCLEX_SREC
#define wxSCI_HEX_DEFAULT 0
#define wxSCI_HEX_RECSTART 1
#define wxSCI_HEX_RECTYPE 2
#define wxSCI_HEX_RECTYPE_UNKNOWN 3
#define wxSCI_HEX_BYTECOUNT 4
#define wxSCI_HEX_BYTECOUNT_WRONG 5
#define wxSCI_HEX_NOADDRESS 6
#define wxSCI_HEX_DATAADDRESS 7
#define wxSCI_HEX_RECCOUNT 8
#define wxSCI_HEX_STARTADDRESS 9
#define wxSCI_HEX_ADDRESSFIELD_UNKNOWN 10
#define wxSCI_HEX_EXTENDEDADDRESS 11
#define wxSCI_HEX_DATA_ODD 12
#define wxSCI_HEX_DATA_EVEN 13
#define wxSCI_HEX_DATA_UNKNOWN 14
#define wxSCI_HEX_DATA_EMPTY 15
#define wxSCI_HEX_CHECKSUM 16
#define wxSCI_HEX_CHECKSUM_WRONG 17
#define wxSCI_HEX_GARBAGE 18

/// Lexical state for SCLEX_IHEX (shared with Srec)
/// Lexical state for SCLEX_TEHEX (shared with Srec)
/// Lexical states for SCLEX_JSON
#define wxSCI_JSON_DEFAULT 0
#define wxSCI_JSON_NUMBER 1
#define wxSCI_JSON_STRING 2
#define wxSCI_JSON_STRINGEOL 3
#define wxSCI_JSON_PROPERTYNAME 4
#define wxSCI_JSON_ESCAPESEQUENCE 5
#define wxSCI_JSON_LINECOMMENT 6
#define wxSCI_JSON_BLOCKCOMMENT 7
#define wxSCI_JSON_OPERATOR 8
#define wxSCI_JSON_URI 9
#define wxSCI_JSON_COMPACTIRI 10
#define wxSCI_JSON_KEYWORD 11
#define wxSCI_JSON_LDKEYWORD 12
#define wxSCI_JSON_ERROR 13
#define wxSCI_EDI_DEFAULT 0
#define wxSCI_EDI_SEGMENTSTART 1
#define wxSCI_EDI_SEGMENTEND 2
#define wxSCI_EDI_SEP_ELEMENT 3
#define wxSCI_EDI_SEP_COMPOSITE 4
#define wxSCI_EDI_SEP_RELEASE 5
#define wxSCI_EDI_UNA 6
#define wxSCI_EDI_UNH 7
#define wxSCI_EDI_BADSEGMENT 8

//}}}
//----------------------------------------------------------------------


#if defined(__clang__) || wxCHECK_GCC_VERSION(4, 5)
    #define wxSCI_STRINGIFY(X) #X
    #define wxSCI_DEPRECATED_MACRO_VALUE(value,msg) \
        _Pragma(wxSCI_STRINGIFY(GCC warning msg)) value
#else
    #define wxSCI_DEPRECATED_MACRO_VALUE(value,msg) value
#endif

//----------------------------------------------------------------------
// Commands that can be bound to keystrokes section {{{


/// Redoes the next action on the undo history.
#define wxSCI_CMD_REDO 2011

/// Select all the text in the document.
#define wxSCI_CMD_SELECTALL 2013

/// Undo one action in the undo history.
#define wxSCI_CMD_UNDO 2176

/// Cut the selection to the clipboard.
#define wxSCI_CMD_CUT 2177

/// Copy the selection to the clipboard.
#define wxSCI_CMD_COPY 2178

/// Paste the contents of the clipboard into the document replacing the selection.
#define wxSCI_CMD_PASTE 2179

/// Clear the selection.
#define wxSCI_CMD_CLEAR 2180

/// Move caret down one line.
#define wxSCI_CMD_LINEDOWN 2300

/// Move caret down one line extending selection to new caret position.
#define wxSCI_CMD_LINEDOWNEXTEND 2301

/// Move caret up one line.
#define wxSCI_CMD_LINEUP 2302

/// Move caret up one line extending selection to new caret position.
#define wxSCI_CMD_LINEUPEXTEND 2303

/// Move caret left one character.
#define wxSCI_CMD_CHARLEFT 2304

/// Move caret left one character extending selection to new caret position.
#define wxSCI_CMD_CHARLEFTEXTEND 2305

/// Move caret right one character.
#define wxSCI_CMD_CHARRIGHT 2306

/// Move caret right one character extending selection to new caret position.
#define wxSCI_CMD_CHARRIGHTEXTEND 2307

/// Move caret left one word.
#define wxSCI_CMD_WORDLEFT 2308

/// Move caret left one word extending selection to new caret position.
#define wxSCI_CMD_WORDLEFTEXTEND 2309

/// Move caret right one word.
#define wxSCI_CMD_WORDRIGHT 2310

/// Move caret right one word extending selection to new caret position.
#define wxSCI_CMD_WORDRIGHTEXTEND 2311

/// Move caret to first position on line.
#define wxSCI_CMD_HOME 2312

/// Move caret to first position on line extending selection to new caret position.
#define wxSCI_CMD_HOMEEXTEND 2313

/// Move caret to last position on line.
#define wxSCI_CMD_LINEEND 2314

/// Move caret to last position on line extending selection to new caret position.
#define wxSCI_CMD_LINEENDEXTEND 2315

/// Move caret to first position in document.
#define wxSCI_CMD_DOCUMENTSTART 2316

/// Move caret to first position in document extending selection to new caret position.
#define wxSCI_CMD_DOCUMENTSTARTEXTEND 2317

/// Move caret to last position in document.
#define wxSCI_CMD_DOCUMENTEND 2318

/// Move caret to last position in document extending selection to new caret position.
#define wxSCI_CMD_DOCUMENTENDEXTEND 2319

/// Move caret one page up.
#define wxSCI_CMD_PAGEUP 2320

/// Move caret one page up extending selection to new caret position.
#define wxSCI_CMD_PAGEUPEXTEND 2321

/// Move caret one page down.
#define wxSCI_CMD_PAGEDOWN 2322

/// Move caret one page down extending selection to new caret position.
#define wxSCI_CMD_PAGEDOWNEXTEND 2323

/// Switch from insert to overtype mode or the reverse.
#define wxSCI_CMD_EDITTOGGLEOVERTYPE 2324

/// Cancel any modes such as call tip or auto-completion list display.
#define wxSCI_CMD_CANCEL 2325

/// Delete the selection or if no selection, the character before the caret.
#define wxSCI_CMD_DELETEBACK 2326

/// If selection is empty or all on one line replace the selection with a tab character.
/// If more than one line selected, indent the lines.
#define wxSCI_CMD_TAB 2327

/// Dedent the selected lines.
#define wxSCI_CMD_BACKTAB 2328

/// Insert a new line, may use a CRLF, CR or LF depending on EOL mode.
#define wxSCI_CMD_NEWLINE 2329

/// Insert a Form Feed character.
#define wxSCI_CMD_FORMFEED 2330

/// Move caret to before first visible character on line.
/// If already there move to first character on line.
#define wxSCI_CMD_VCHOME 2331

/// Like VCHome but extending selection to new caret position.
#define wxSCI_CMD_VCHOMEEXTEND 2332

/// Magnify the displayed text by increasing the sizes by 1 point.
#define wxSCI_CMD_ZOOMIN 2333

/// Make the displayed text smaller by decreasing the sizes by 1 point.
#define wxSCI_CMD_ZOOMOUT 2334

/// Delete the word to the left of the caret.
#define wxSCI_CMD_DELWORDLEFT 2335

/// Delete the word to the right of the caret.
#define wxSCI_CMD_DELWORDRIGHT 2336

/// Delete the word to the right of the caret, but not the trailing non-word characters.
#define wxSCI_CMD_DELWORDRIGHTEND 2518

/// Cut the line containing the caret.
#define wxSCI_CMD_LINECUT 2337

/// Delete the line containing the caret.
#define wxSCI_CMD_LINEDELETE 2338

/// Switch the current line with the previous.
#define wxSCI_CMD_LINETRANSPOSE 2339

/// Duplicate the current line.
#define wxSCI_CMD_LINEDUPLICATE 2404

/// Transform the selection to lower case.
#define wxSCI_CMD_LOWERCASE 2340

/// Transform the selection to upper case.
#define wxSCI_CMD_UPPERCASE 2341

/// Scroll the document down, keeping the caret visible.
#define wxSCI_CMD_LINESCROLLDOWN 2342

/// Scroll the document up, keeping the caret visible.
#define wxSCI_CMD_LINESCROLLUP 2343

/// Delete the selection or if no selection, the character before the caret.
/// Will not delete the character before at the start of a line.
#define wxSCI_CMD_DELETEBACKNOTLINE 2344

/// Move caret to first position on display line.
#define wxSCI_CMD_HOMEDISPLAY 2345

/// Move caret to first position on display line extending selection to
/// new caret position.
#define wxSCI_CMD_HOMEDISPLAYEXTEND 2346

/// Move caret to last position on display line.
#define wxSCI_CMD_LINEENDDISPLAY 2347

/// Move caret to last position on display line extending selection to new
/// caret position.
#define wxSCI_CMD_LINEENDDISPLAYEXTEND 2348

/// Like Home but when word-wrap is enabled goes first to start of display line
/// HomeDisplay, then to start of document line Home.
#define wxSCI_CMD_HOMEWRAP 2349

/// Like HomeExtend but when word-wrap is enabled extends first to start of display line
/// HomeDisplayExtend, then to start of document line HomeExtend.
#define wxSCI_CMD_HOMEWRAPEXTEND 2450

/// Like LineEnd but when word-wrap is enabled goes first to end of display line
/// LineEndDisplay, then to start of document line LineEnd.
#define wxSCI_CMD_LINEENDWRAP 2451

/// Like LineEndExtend but when word-wrap is enabled extends first to end of display line
/// LineEndDisplayExtend, then to start of document line LineEndExtend.
#define wxSCI_CMD_LINEENDWRAPEXTEND 2452

/// Like VCHome but when word-wrap is enabled goes first to start of display line
/// VCHomeDisplay, then behaves like VCHome.
#define wxSCI_CMD_VCHOMEWRAP 2453

/// Like VCHomeExtend but when word-wrap is enabled extends first to start of display line
/// VCHomeDisplayExtend, then behaves like VCHomeExtend.
#define wxSCI_CMD_VCHOMEWRAPEXTEND 2454

/// Copy the line containing the caret.
#define wxSCI_CMD_LINECOPY 2455

/// Move to the previous change in capitalisation.
#define wxSCI_CMD_WORDPARTLEFT 2390

/// Move to the previous change in capitalisation extending selection
/// to new caret position.
#define wxSCI_CMD_WORDPARTLEFTEXTEND 2391

/// Move to the change next in capitalisation.
#define wxSCI_CMD_WORDPARTRIGHT 2392

/// Move to the next change in capitalisation extending selection
/// to new caret position.
#define wxSCI_CMD_WORDPARTRIGHTEXTEND 2393

/// Delete back from the current position to the start of the line.
#define wxSCI_CMD_DELLINELEFT 2395

/// Delete forwards from the current position to the end of the line.
#define wxSCI_CMD_DELLINERIGHT 2396

/// Move caret down one paragraph (delimited by empty lines).
#define wxSCI_CMD_PARADOWN 2413

/// Extend selection down one paragraph (delimited by empty lines).
#define wxSCI_CMD_PARADOWNEXTEND 2414

/// Move caret up one paragraph (delimited by empty lines).
#define wxSCI_CMD_PARAUP 2415

/// Extend selection up one paragraph (delimited by empty lines).
#define wxSCI_CMD_PARAUPEXTEND 2416

/// Move caret down one line, extending rectangular selection to new caret position.
#define wxSCI_CMD_LINEDOWNRECTEXTEND 2426

/// Move caret up one line, extending rectangular selection to new caret position.
#define wxSCI_CMD_LINEUPRECTEXTEND 2427

/// Move caret left one character, extending rectangular selection to new caret position.
#define wxSCI_CMD_CHARLEFTRECTEXTEND 2428

/// Move caret right one character, extending rectangular selection to new caret position.
#define wxSCI_CMD_CHARRIGHTRECTEXTEND 2429

/// Move caret to first position on line, extending rectangular selection to new caret position.
#define wxSCI_CMD_HOMERECTEXTEND 2430

/// Move caret to before first visible character on line.
/// If already there move to first character on line.
/// In either case, extend rectangular selection to new caret position.
#define wxSCI_CMD_VCHOMERECTEXTEND 2431

/// Move caret to last position on line, extending rectangular selection to new caret position.
#define wxSCI_CMD_LINEENDRECTEXTEND 2432

/// Move caret one page up, extending rectangular selection to new caret position.
#define wxSCI_CMD_PAGEUPRECTEXTEND 2433

/// Move caret one page down, extending rectangular selection to new caret position.
#define wxSCI_CMD_PAGEDOWNRECTEXTEND 2434

/// Move caret to top of page, or one page up if already at top of page.
#define wxSCI_CMD_STUTTEREDPAGEUP 2435

/// Move caret to top of page, or one page up if already at top of page, extending selection to new caret position.
#define wxSCI_CMD_STUTTEREDPAGEUPEXTEND 2436

/// Move caret to bottom of page, or one page down if already at bottom of page.
#define wxSCI_CMD_STUTTEREDPAGEDOWN 2437

/// Move caret to bottom of page, or one page down if already at bottom of page, extending selection to new caret position.
#define wxSCI_CMD_STUTTEREDPAGEDOWNEXTEND 2438

/// Move caret left one word, position cursor at end of word.
#define wxSCI_CMD_WORDLEFTEND 2439

/// Move caret left one word, position cursor at end of word, extending selection to new caret position.
#define wxSCI_CMD_WORDLEFTENDEXTEND 2440

/// Move caret right one word, position cursor at end of word.
#define wxSCI_CMD_WORDRIGHTEND 2441

/// Move caret right one word, position cursor at end of word, extending selection to new caret position.
#define wxSCI_CMD_WORDRIGHTENDEXTEND 2442

/// Centre current line in window.
#define wxSCI_CMD_VERTICALCENTRECARET 2619

/// Move the selected lines up one line, shifting the line above after the selection
#define wxSCI_CMD_MOVESELECTEDLINESUP 2620

/// Move the selected lines down one line, shifting the line below before the selection
#define wxSCI_CMD_MOVESELECTEDLINESDOWN 2621

/// Scroll to start of document.
#define wxSCI_CMD_SCROLLTOSTART 2628

/// Scroll to end of document.
#define wxSCI_CMD_SCROLLTOEND 2629

/// Move caret to before first visible character on display line.
/// If already there move to first character on display line.
#define wxSCI_CMD_VCHOMEDISPLAY 2652

/// Like VCHomeDisplay but extending selection to new caret position.
#define wxSCI_CMD_VCHOMEDISPLAYEXTEND 2653

//}}}
//----------------------------------------------------------------------

class  ScintillaWX;                      // forward declare
class  WordList;

#ifdef SCI_NAMESPACE
	#ifndef SCI_NAMESPACE_PREFIX
		#define SCI_NAMESPACE_PREFIX( x ) Scintilla::x
	#endif
namespace Scintilla {
#else
	#ifndef SCI_NAMESPACE_PREFIX
		#define SCI_NAMESPACE_PREFIX( x ) x
	#endif
#endif
struct SCNotification;
#ifdef SCI_NAMESPACE
}
#endif

#ifndef SWIG
extern WXDLLIMPEXP_SCI const wxChar wxSCINameStr[];
class  WXDLLIMPEXP_SCI wxScintilla;
class  WXDLLIMPEXP_SCI wxScintillaEvent;
#endif

//----------------------------------------------------------------------

class WXDLLIMPEXP_SCI wxScintilla : public wxControl {
public:

#ifdef SWIG
    %pythonAppend wxScintilla   "self._setOORInfo(self)"
    %pythonAppend wxScintilla() ""

    wxScintilla (wxWindow *parent, wxWindowID id=wxID_ANY,
                 const wxPoint& pos = wxDefaultPosition,
                 const wxSize& size = wxDefaultSize, long style = 0,
                 const wxString& name = wxPySCINameStr);
    %RenameCtor(PreScintilla, wxScintilla());

#else
    wxScintilla (wxWindow *parent, wxWindowID id=wxID_ANY,
                 const wxPoint& pos = wxDefaultPosition,
                 const wxSize& size = wxDefaultSize, long style = 0,
                 const wxString& name = wxSCINameStr);
    wxScintilla() { m_swx = NULL; }
    ~wxScintilla();

#endif

    bool Create(wxWindow *parent, wxWindowID id=wxID_ANY,
                const wxPoint& pos = wxDefaultPosition,
                const wxSize& size = wxDefaultSize, long style = 0,
                const wxString& name = wxSCINameStr);


    //----------------------------------------------------------------------
    // Generated method declaration section {{{


    // Add text to the document at current position.
    void AddText(const wxString& text);

    // Add array of cells to document.
    void AddStyledText(const wxMemoryBuffer& data);

    // Insert string at a position.
    void InsertText(int pos, const wxString& text);

    // Change the text that is being inserted in response to wxSCI_MOD_INSERTCHECK
    void ChangeInsertion(int length, const wxString& text);

    // Delete all text in the document.
    void ClearAll();

    // Delete a range of text in the document.
    void DeleteRange(int start, int lengthDelete);

    // Set all style bytes to 0, remove all folding information.
    void ClearDocumentStyle();

    // Returns the number of bytes in the document.
    int GetLength() const;

    // Returns the character byte at the position.
    int GetCharAt(int pos) const;

    // Returns the position of the caret.
    int GetCurrentPos() const;

    // Returns the position of the opposite end of the selection to the caret.
    int GetAnchor() const;

    // Returns the style byte at the position.
    int GetStyleAt(int pos) const;

    // Redoes the next action on the undo history.
    void Redo();

    // Choose between collecting actions into the undo
    // history and discarding them.
    void SetUndoCollection(bool collectUndo);

/* CHANGEBAR begin */
    // Choose between collecting actions into the changes
    // history and discarding them.
    void SetChangeCollection(bool collectChange);

    // Find a changed line, if fromLine > toLine search is performed backwards.
    int FindChangedLine (const int fromLine, const int toLine) const;
/* CHANGEBAR end */

    // Select all the text in the document.
    void SelectAll();

    // Remember the current position in the undo history as the position
    // at which the document was saved.
    void SetSavePoint();

    // Retrieve a buffer of cells.
    wxMemoryBuffer GetStyledText(int startPos, int endPos);

    // Are there any redoable actions in the undo history?
    bool CanRedo() const;

    // Retrieve the line number at which a particular marker is located.
    int MarkerLineFromHandle(int markerHandle);

    // Delete a marker.
    void MarkerDeleteHandle(int markerHandle);

    // Is undo history being collected?
    bool GetUndoCollection() const;

    // Are white space characters currently visible?
    // Returns one of wxSCI_WS_* constants.
    int GetViewWhiteSpace() const;

    // Make white space characters invisible, always visible or visible outside indentation.
    void SetViewWhiteSpace(int viewWS);

    // Retrieve the current tab draw mode.
    // Returns one of wxSCI_TD_* constants.
    int GetTabDrawMode() const;

    // Set how tabs are drawn when visible.
    void SetTabDrawMode(int tabDrawMode);

    // Find the position from a point within the window.
    int PositionFromPoint(wxPoint pt) const;

    // Find the position from a point within the window but return
    // wxSCI_INVALID_POSITION if not close to text.
    int PositionFromPointClose(int x, int y);

    // Set caret to start of a line and ensure it is visible.
    void GotoLine(int line);

    // Set caret to a position and ensure it is visible.
    void GotoPos(int caret);

    // Set the selection anchor to a position. The anchor is the opposite
    // end of the selection from the caret.
    void SetAnchor(int anchor);

    // Retrieve the text of the line containing the caret.
    #ifdef SWIG
    wxString GetCurLine(int* OUTPUT);
#else
    wxString GetCurLine(int* linePos=NULL);
#endif

    // Retrieve the position of the last correctly styled character.
    int GetEndStyled() const;

    // Convert all line endings in the document to one mode.
    void ConvertEOLs(int eolMode);

    // Retrieve the current end of line mode - one of wxSCI_EOL_CRLF, wxSCI_EOL_CR, or wxSCI_EOL_LF.
    int GetEOLMode() const;

    // Set the current end of line mode.
    void SetEOLMode(int eolMode);

    // Set the current styling position to start.
    void StartStyling(int start);

    // Change style from current styling position for length characters to a style
    // and move the current styling position to after this newly styled segment.
    void SetStyling(int length, int style);

    // Is drawing done first into a buffer or direct to the screen?
    bool GetBufferedDraw() const;

    // If drawing is buffered then each line of text is drawn into a bitmap buffer
    // before drawing it to the screen to avoid flicker.
    void SetBufferedDraw(bool buffered);

    // Change the visible size of a tab to be a multiple of the width of a space character.
    void SetTabWidth(int tabWidth);

    // Retrieve the visible size of a tab.
    int GetTabWidth() const;

    // Clear explicit tabstops on a line.
    void ClearTabStops(int line);

    // Add an explicit tab stop for a line.
    void AddTabStop(int line, int x);

    // Find the next explicit tab stop position on a line after a position.
    int GetNextTabStop(int line, int x);

    // Set the code page used to interpret the bytes of the document as characters.
    void SetCodePage(int codePage);

    // Is the IME displayed in a window or inline?
    int GetIMEInteraction() const;

    // Choose to display the the IME in a winow or inline.
    void SetIMEInteraction(int imeInteraction);

    // Set the symbol used for a particular marker number,
    // and optionally the fore and background colours.
    void MarkerDefine(int markerNumber, int markerSymbol,
                const wxColour& foreground = wxNullColour,
                const wxColour& background = wxNullColour);

    // Set the foreground colour used for a particular marker number.
    void MarkerSetForeground(int markerNumber, const wxColour& fore);

    // Set the background colour used for a particular marker number.
    void MarkerSetBackground(int markerNumber, const wxColour& back);

    // Set the background colour used for a particular marker number when its folding block is selected.
    void MarkerSetBackgroundSelected(int markerNumber, const wxColour& back);

    // Enable/disable highlight for current folding bloc (smallest one that contains the caret)
    void MarkerEnableHighlight(bool enabled);

    // Add a marker to a line, returning an ID which can be used to find or delete the marker.
    int MarkerAdd(int line, int markerNumber);

    // Delete a marker from a line.
    void MarkerDelete(int line, int markerNumber);

    // Delete all markers with a particular number from all lines.
    void MarkerDeleteAll(int markerNumber);

    // Get a bit mask of all the markers set on a line.
    int MarkerGet(int line);

    // Find the next line at or after lineStart that includes a marker in mask.
    // Return -1 when no more lines.
    int MarkerNext(int lineStart, int markerMask);

    // Find the previous line before lineStart that includes a marker in mask.
    int MarkerPrevious(int lineStart, int markerMask);

    // Define a marker from a bitmap
    void MarkerDefinePixmap(int markerNumber, const char* const* xpmData);

    // Add a set of markers to a line.
    void MarkerAddSet(int line, int markerSet);

    // Set the alpha used for a marker that is drawn in the text area, not the margin.
    void MarkerSetAlpha(int markerNumber, int alpha);

    // Set a margin to be either numeric or symbolic.
    void SetMarginType(int margin, int marginType);

    // Retrieve the type of a margin.
    int GetMarginType(int margin) const;

    // Set the width of a margin to a width expressed in pixels.
    void SetMarginWidth(int margin, int pixelWidth);

    // Retrieve the width of a margin in pixels.
    int GetMarginWidth(int margin) const;

    // Set a mask that determines which markers are displayed in a margin.
    void SetMarginMask(int margin, int mask);

    // Retrieve the marker mask of a margin.
    int GetMarginMask(int margin) const;

    // Make a margin sensitive or insensitive to mouse clicks.
    void SetMarginSensitive(int margin, bool sensitive);

    // Retrieve the mouse click sensitivity of a margin.
    bool GetMarginSensitive(int margin) const;

    // Set the cursor shown when the mouse is inside a margin.
    void SetMarginCursor(int margin, int cursor);

    // Retrieve the cursor shown in a margin.
    int GetMarginCursor(int margin) const;

    // Set the background colour of a margin. Only visible for wxSCI_MARGIN_COLOUR.
    void SetMarginBackground(int margin, const wxColour& back);

    // Retrieve the background colour of a margin
    wxColour GetMarginBackground(int margin) const;

    // Allocate a non-standard number of margins.
    void SetMarginCount(int margins);

    // How many margins are there?.
    int GetMarginCount() const;

    // Clear all the styles and make equivalent to the global default style.
    void StyleClearAll();

    // Set the foreground colour of a style.
    void StyleSetForeground(int style, const wxColour& fore);

    // Set the background colour of a style.
    void StyleSetBackground(int style, const wxColour& back);

    // Set a style to be bold or not.
    void StyleSetBold(int style, bool bold);

    // Set a style to be italic or not.
    void StyleSetItalic(int style, bool italic);

    // Set the size of characters of a style.
    void StyleSetSize(int style, int sizePoints);

    // Set the font of a style.
    void StyleSetFaceName(int style, const wxString& fontName);

    // Set a style to have its end of line filled or not.
    void StyleSetEOLFilled(int style, bool eolFilled);

    // Reset the default style to its state at startup
    void StyleResetDefault();

    // Set a style to be underlined or not.
    void StyleSetUnderline(int style, bool underline);

    // Get the foreground colour of a style.
    wxColour StyleGetForeground(int style) const;

    // Get the background colour of a style.
    wxColour StyleGetBackground(int style) const;

    // Get is a style bold or not.
    bool StyleGetBold(int style) const;

    // Get is a style italic or not.
    bool StyleGetItalic(int style) const;

    // Get the size of characters of a style.
    int StyleGetSize(int style) const;

    // Get the font facename of a style
    wxString StyleGetFaceName(int style);

    // Get is a style to have its end of line filled or not.
    bool StyleGetEOLFilled(int style) const;

    // Get is a style underlined or not.
    bool StyleGetUnderline(int style) const;

    // Get is a style mixed case, or to force upper or lower case.
    int StyleGetCase(int style) const;

    // Get the character get of the font in a style.
    int StyleGetCharacterSet(int style) const;

    // Get is a style visible or not.
    bool StyleGetVisible(int style) const;

    // Get is a style changeable or not (read only).
    // Experimental feature, currently buggy.
    bool StyleGetChangeable(int style) const;

    // Get is a style a hotspot or not.
    bool StyleGetHotSpot(int style) const;

    // Set a style to be mixed case, or to force upper or lower case.
    void StyleSetCase(int style, int caseVisible);

    // Set the size of characters of a style. Size is in points multiplied by 100.
    void StyleSetSizeFractional(int style, int sizeHundredthPoints);

    // Get the size of characters of a style in points multiplied by 100
    int StyleGetSizeFractional(int style) const;

    // Set the weight of characters of a style.
    void StyleSetWeight(int style, int weight);

    // Get the weight of characters of a style.
    int StyleGetWeight(int style) const;

    // Set the character set of the font in a style.
    void StyleSetCharacterSet(int style, int characterSet);

    // Set a style to be a hotspot or not.
    void StyleSetHotSpot(int style, bool hotspot);

    // Set the foreground colour of the main and additional selections and whether to use this setting.
    void SetSelForeground(bool useSetting, const wxColour& fore);

    // Set the background colour of the main and additional selections and whether to use this setting.
    void SetSelBackground(bool useSetting, const wxColour& back);

    // Get the alpha of the selection.
    int GetSelAlpha() const;

    // Set the alpha of the selection.
    void SetSelAlpha(int alpha);

    // Is the selection end of line filled?
    bool GetSelEOLFilled() const;

    // Set the selection to have its end of line filled or not.
    void SetSelEOLFilled(bool filled);

    // Set the foreground colour of the caret.
    void SetCaretForeground(const wxColour& fore);

    // When key+modifier combination keyDefinition is pressed perform sciCommand.
    void CmdKeyAssign(int key, int modifiers, int cmd);

    // When key+modifier combination keyDefinition is pressed do nothing.
    void CmdKeyClear(int key, int modifiers);

    // Drop all key mappings.
    void CmdKeyClearAll();

    // Set the styles for a segment of the document.
    void SetStyleBytes(int length, char* styleBytes);

    // Set a style to be visible or not.
    void StyleSetVisible(int style, bool visible);

    // Get the time in milliseconds that the caret is on and off.
    int GetCaretPeriod() const;

    // Get the time in milliseconds that the caret is on and off. 0 = steady on.
    void SetCaretPeriod(int periodMilliseconds);

    // Set the set of characters making up words for when moving or selecting by word.
    // First sets defaults like SetCharsDefault.
    void SetWordChars(const wxString& characters);

    // Get the set of characters making up words for when moving or selecting by word.
    wxString GetWordChars() const;

    // Start a sequence of actions that is undone and redone as a unit.
    // May be nested.
    void BeginUndoAction();

    // End a sequence of actions that is undone and redone as a unit.
    void EndUndoAction();

    // Set an indicator to plain, squiggle or TT.
    void IndicatorSetStyle(int indicator, int indicatorStyle);

    // Retrieve the style of an indicator.
    int IndicatorGetStyle(int indicator) const;

    // Set the foreground colour of an indicator.
    void IndicatorSetForeground(int indicator, const wxColour& fore);

    // Retrieve the foreground colour of an indicator.
    wxColour IndicatorGetForeground(int indicator) const;

    // Set an indicator to draw under text or over(default).
    void IndicatorSetUnder(int indicator, bool under);

    // Retrieve whether indicator drawn under or over text.
    bool IndicatorGetUnder(int indicator) const;

    // Set a hover indicator to plain, squiggle or TT.
    void IndicatorSetHoverStyle(int indicator, int indicatorStyle);

    // Retrieve the hover style of an indicator.
    int IndicatorGetHoverStyle(int indicator) const;

    // Set the foreground hover colour of an indicator.
    void IndicatorSetHoverForeground(int indicator, const wxColour& fore);

    // Retrieve the foreground hover colour of an indicator.
    wxColour IndicatorGetHoverForeground(int indicator) const;

    // Set the attributes of an indicator.
    void IndicatorSetFlags(int indicator, int flags);

    // Retrieve the attributes of an indicator.
    int IndicatorGetFlags(int indicator) const;

    // Set the foreground colour of all whitespace and whether to use this setting.
    void SetWhitespaceForeground(bool useSetting, const wxColour& fore);

    // Set the background colour of all whitespace and whether to use this setting.
    void SetWhitespaceBackground(bool useSetting, const wxColour& back);

    // Set the size of the dots used to mark space characters.
    void SetWhitespaceSize(int size);

    // Get the size of the dots used to mark space characters.
    int GetWhitespaceSize() const;

    // Divide each styling byte into lexical class bits (default: 5) and indicator
    // bits (default: 3). If a lexer requires more than 32 lexical states, then this
    // is used to expand the possible states.
#if wxCHECK_VERSION(3, 0, 0)
    wxDEPRECATED_MSG( "This method uses a function deprecated in the Scintilla library." )
#endif // wxCHECK_VERSION
    void SetStyleBits(int bits);

    // Retrieve number of bits in style bytes used to hold the lexical state.
#if wxCHECK_VERSION(3, 0, 0)
    wxDEPRECATED_MSG( "This method uses a function deprecated in the Scintilla library." )
#endif // wxCHECK_VERSION
    int GetStyleBits() const;

    // Used to hold extra styling information for each line.
    void SetLineState(int line, int state);

    // Retrieve the extra styling information for a line.
    int GetLineState(int line) const;

    // Retrieve the last line number that has line state.
    int GetMaxLineState() const;

    // Is the background of the line containing the caret in a different colour?
    bool GetCaretLineVisible() const;

    // Display the background of the line containing the caret in a different colour.
    void SetCaretLineVisible(bool show);

    // Get the colour of the background of the line containing the caret.
    wxColour GetCaretLineBackground() const;

    // Set the colour of the background of the line containing the caret.
    void SetCaretLineBackground(const wxColour& back);

    // Set a style to be changeable or not (read only).
    // Experimental feature, currently buggy.
    void StyleSetChangeable(int style, bool changeable);

    // Display a auto-completion list.
    // The lengthEntered parameter indicates how many characters before
    // the caret should be used to provide context.
    void AutoCompShow(int lengthEntered, const wxString& itemList);

    // Remove the auto-completion list from the screen.
    void AutoCompCancel();

    // Is there an auto-completion list visible?
    bool AutoCompActive();

    // Retrieve the position of the caret when the auto-completion list was displayed.
    int AutoCompPosStart();

    // User has selected an item so remove the list and insert the selection.
    void AutoCompComplete();

    // Define a set of character that when typed cancel the auto-completion list.
    void AutoCompStops(const wxString& characterSet);

    // Change the separator character in the string setting up an auto-completion list.
    // Default is space but can be changed if items contain space.
    void AutoCompSetSeparator(int separatorCharacter);

    // Retrieve the auto-completion list separator character.
    int AutoCompGetSeparator() const;

    // Select the item in the auto-completion list that starts with a string.
    void AutoCompSelect(const wxString& select);

    // Should the auto-completion list be cancelled if the user backspaces to a
    // position before where the box was created.
    void AutoCompSetCancelAtStart(bool cancel);

    // Retrieve whether auto-completion cancelled by backspacing before start.
    bool AutoCompGetCancelAtStart() const;

    // Define a set of characters that when typed will cause the autocompletion to
    // choose the selected item.
    void AutoCompSetFillUps(const wxString& characterSet);

    // Should a single item auto-completion list automatically choose the item.
    void AutoCompSetChooseSingle(bool chooseSingle);

    // Retrieve whether a single item auto-completion list automatically choose the item.
    bool AutoCompGetChooseSingle() const;

    // Set whether case is significant when performing auto-completion searches.
    void AutoCompSetIgnoreCase(bool ignoreCase);

    // Retrieve state of ignore case flag.
    bool AutoCompGetIgnoreCase() const;

    // Display a list of strings and send notification when user chooses one.
    void UserListShow(int listType, const wxString& itemList);

    // Set whether or not autocompletion is hidden automatically when nothing matches.
    void AutoCompSetAutoHide(bool autoHide);

    // Retrieve whether or not autocompletion is hidden automatically when nothing matches.
    bool AutoCompGetAutoHide() const;

    // Set whether or not autocompletion deletes any word characters
    // after the inserted text upon completion.
    void AutoCompSetDropRestOfWord(bool dropRestOfWord);

    // Retrieve whether or not autocompletion deletes any word characters
    // after the inserted text upon completion.
    bool AutoCompGetDropRestOfWord() const;

    // Register an image for use in autocompletion lists.
    void RegisterImage(int type, const char* const* xpmData);

    // Clear all the registered images.
    void ClearRegisteredImages();

    // Retrieve the auto-completion list type-separator character.
    int AutoCompGetTypeSeparator() const;

    // Change the type-separator character in the string setting up an auto-completion list.
    // Default is '?' but can be changed if items contain '?'.
    void AutoCompSetTypeSeparator(int separatorCharacter);

    // Set the maximum width, in characters, of auto-completion and user lists.
    // Set to 0 to autosize to fit longest item, which is the default.
    void AutoCompSetMaxWidth(int characterCount);

    // Get the maximum width, in characters, of auto-completion and user lists.
    int AutoCompGetMaxWidth() const;

    // Set the maximum height, in rows, of auto-completion and user lists.
    // The default is 5 rows.
    void AutoCompSetMaxHeight(int rowCount);

    // Set the maximum height, in rows, of auto-completion and user lists.
    int AutoCompGetMaxHeight() const;

    // Set the number of spaces used for one level of indentation.
    void SetIndent(int indentSize);

    // Retrieve indentation size.
    int GetIndent() const;

    // Indentation will only use space characters if useTabs is false, otherwise
    // it will use a combination of tabs and spaces.
    void SetUseTabs(bool useTabs);

    // Retrieve whether tabs will be used in indentation.
    bool GetUseTabs() const;

    // Change the indentation of a line to a number of columns.
    void SetLineIndentation(int line, int indentation);

    // Retrieve the number of columns that a line is indented.
    int GetLineIndentation(int line) const;

    // Retrieve the position before the first non indentation character on a line.
    int GetLineIndentPosition(int line) const;

    // Retrieve the column number of a position, taking tab width into account.
    int GetColumn(int pos) const;

    // Count characters between two positions.
    int CountCharacters(int start, int end);

    // Show or hide the horizontal scroll bar.
    void SetUseHorizontalScrollBar(bool visible);

    // Is the horizontal scroll bar visible?
    bool GetUseHorizontalScrollBar() const;

    // Show or hide indentation guides.
    void SetIndentationGuides(int indentView);

    // Are the indentation guides visible?
    int GetIndentationGuides() const;

    // Set the highlighted indentation guide column.
    // 0 = no highlighted guide.
    void SetHighlightGuide(int column);

    // Get the highlighted indentation guide column.
    int GetHighlightGuide() const;

    // Get the position after the last visible characters on a line.
    int GetLineEndPosition(int line) const;

    // Get the code page used to interpret the bytes of the document as characters.
    int GetCodePage() const;

    // Get the foreground colour of the caret.
    wxColour GetCaretForeground() const;

    // In read-only mode?
    bool GetReadOnly() const;

    // Sets the position of the caret.
    void SetCurrentPos(int caret);

    // Sets the position that starts the selection - this becomes the anchor.
    void SetSelectionStart(int anchor);

    // Returns the position at the start of the selection.
    int GetSelectionStart() const;

    // Sets the position that ends the selection - this becomes the caret.
    void SetSelectionEnd(int caret);

    // Returns the position at the end of the selection.
    int GetSelectionEnd() const;

    // Set caret to a position, while removing any existing selection.
    void SetEmptySelection(int caret);

    // Sets the print magnification added to the point size of each style for printing.
    void SetPrintMagnification(int magnification);

    // Returns the print magnification.
    int GetPrintMagnification() const;

    // Modify colours when printing for clearer printed text.
    void SetPrintColourMode(int mode);

    // Returns the print colour mode.
    int GetPrintColourMode() const;

    // Find some text in the document.
    int FindText(int minPos, int maxPos, const wxString& text, int flags=0,
                 int* findEnd=NULL);

    // On Windows, will draw the document into a display context such as a printer.
    int FormatRange(bool   doDraw,
               int    startPos,
               int    endPos,
               wxDC*  draw,
               wxDC*  target,
               wxRect renderRect,
               wxRect pageRect);

    // Retrieve the display line at the top of the display.
    int GetFirstVisibleLine() const;

    // Retrieve the contents of a line.
    wxString GetLine(int line) const;

    // Returns the number of lines in the document. There is always at least one.
    int GetLineCount() const;

    // Sets the size in pixels of the left margin.
    void SetMarginLeft(int pixelWidth);

    // Returns the size in pixels of the left margin.
    int GetMarginLeft() const;

    // Sets the size in pixels of the right margin.
    void SetMarginRight(int pixelWidth);

    // Returns the size in pixels of the right margin.
    int GetMarginRight() const;

    // Is the document different from when it was last saved?
    bool GetModify() const;

    // Retrieve the selected text.
    wxString GetSelectedText();

    // Retrieve a range of text.
    wxString GetTextRange(int startPos, int endPos);

    // Draw the selection in normal style or with selection highlighted.
    void HideSelection(bool hide);

    // Retrieve the point in the window where a position is displayed.
    wxPoint PointFromPosition(int pos);

    // Retrieve the line containing a position.
    int LineFromPosition(int pos) const;

    // Retrieve the position at the start of a line.
    int PositionFromLine(int line) const;

    // Scroll horizontally and vertically.
    void LineScroll(int columns, int lines);

    // Ensure the caret is visible.
    void EnsureCaretVisible();

    // Scroll the argument positions and the range between them into view giving
    // priority to the primary position then the secondary position.
    // This may be used to make a search match visible.
    void ScrollRange(int secondary, int primary);

    // Replace the selected text with the argument text.
    void ReplaceSelection(const wxString& text);

    // Set to read only or read write.
    void SetReadOnly(bool readOnly);

    // Will a paste succeed?
    bool CanPaste() const;

    // Are there any undoable actions in the undo history?
    bool CanUndo() const;

    // Delete the undo history.
/* CHANGEBAR begin */
    void EmptyUndoBuffer(bool collectChangeHistory=false);
/* CHANGEBAR end */

    // Undo one action in the undo history.
    void Undo();

    // Cut the selection to the clipboard.
    void Cut();

    // Copy the selection to the clipboard.
    void Copy();

    // Paste the contents of the clipboard into the document replacing the selection.
    void Paste();

    // Clear the selection.
    void Clear();

    // Replace the contents of the document with the argument text.
    void SetText(const wxString& text);

    // Retrieve all the text in the document.
    wxString GetText() const;

    // Retrieve the number of characters in the document.
    int GetTextLength() const;

    // Retrieve a pointer to a function that processes messages for this Scintilla.
    void* GetDirectFunction() const;

    // Retrieve a pointer value to use as the first argument when calling
    // the function returned by GetDirectFunction.
    void* GetDirectPointer() const;

    // Set to overtype (true) or insert mode.
    void SetOvertype(bool overType);

    // Returns true if overtype mode is active otherwise false is returned.
    bool GetOvertype() const;

    // Set the width of the insert mode caret.
    void SetCaretWidth(int pixelWidth);

    // Returns the width of the insert mode caret.
    int GetCaretWidth() const;

    // Sets the position that starts the target which is used for updating the
    // document without affecting the scroll position.
    void SetTargetStart(int start);

    // Get the position that starts the target.
    int GetTargetStart() const;

    // Sets the position that ends the target which is used for updating the
    // document without affecting the scroll position.
    void SetTargetEnd(int end);

    // Get the position that ends the target.
    int GetTargetEnd() const;

    // Sets both the start and end of the target in one call.
    void SetTargetRange(int start, int end);

    // Retrieve the text in the target.
    wxString GetTargetText() const;

    // Make the target range start and end be the same as the selection range start and end.
    void TargetFromSelection();

    // Sets the target to the whole document.
    void TargetWholeDocument();

    // Replace the target text with the argument text.
    // Text is counted so it can contain NULs.
    // Returns the length of the replacement text.
    int ReplaceTarget(const wxString& text);

    // Replace the target text with the argument text after \\d processing.
    // Text is counted so it can contain NULs.
    // Looks for \\d where d is between 1 and 9 and replaces these with the strings
    // matched in the last search operation which were surrounded by \\( and \\).
    // Returns the length of the replacement text including any change
    // caused by processing the \\d patterns.
    int ReplaceTargetRE(const wxString& text);

    // Search for a counted string in the target and set the target to the found
    // range. Text is counted so it can contain NULs.
    // Returns length of range or -1 for failure in which case target is not moved.
    int SearchInTarget(const wxString& text);

    // Set the search flags used by SearchInTarget.
    void SetSearchFlags(int searchFlags);

    // Get the search flags used by SearchInTarget.
    int GetSearchFlags() const;

    // Show a call tip containing a definition near position pos.
    void CallTipShow(int pos, const wxString& definition);

    // Remove the call tip from the screen.
    void CallTipCancel();

    // Is there an active call tip?
    bool CallTipActive();

    // Retrieve the position where the caret was before displaying the call tip.
    int CallTipPosAtStart();

    // Set the start position in order to change when backspacing removes the calltip.
    void CallTipSetPosAtStart(int posStart);

    // Highlight a segment of the definition.
    void CallTipSetHighlight(int highlightStart, int highlightEnd);

    // Set the background colour for the call tip.
    void CallTipSetBackground(const wxColour& back);

    // Set the foreground colour for the call tip.
    void CallTipSetForeground(const wxColour& fore);

    // Set the foreground colour for the highlighted part of the call tip.
    void CallTipSetForegroundHighlight(const wxColour& fore);

    // Enable use of wxSCI_STYLE_CALLTIP and set call tip tab size in pixels.
    void CallTipUseStyle(int tabSize);

    // Set position of calltip, above or below text.
    void CallTipSetPosition(bool above);

    // Find the display line of a document line taking hidden lines into account.
    int VisibleFromDocLine(int docLine);

    // Find the document line of a display line taking hidden lines into account.
    int DocLineFromVisible(int displayLine);

    // The number of display lines needed to wrap a document line
    int WrapCount(int docLine);

    // Set the fold level of a line.
    // This encodes an integer level along with flags indicating whether the
    // line is a header and whether it is effectively white space.
    void SetFoldLevel(int line, int level);

    // Retrieve the fold level of a line.
    int GetFoldLevel(int line) const;

    // Find the last child line of a header line.
    int GetLastChild(int line, int level) const;

    // Find the parent line of a child line.
    int GetFoldParent(int line) const;

    // Make a range of lines visible.
    void ShowLines(int lineStart, int lineEnd);

    // Make a range of lines invisible.
    void HideLines(int lineStart, int lineEnd);

    // Is a line visible?
    bool GetLineVisible(int line) const;

    // Are all lines visible?
    bool GetAllLinesVisible() const;

    // Show the children of a header line.
    void SetFoldExpanded(int line, bool expanded);

    // Is a header line expanded?
    bool GetFoldExpanded(int line) const;

    // Switch a header line between expanded and contracted.
    void ToggleFold(int line);

    // Switch a header line between expanded and contracted and show some text after the line.
    void ToggleFoldShowText(int line, const wxString& text);

    // Set the style of fold display text
    void FoldDisplayTextSetStyle(int style);

    // Expand or contract a fold header.
    void FoldLine(int line, int action);

    // Expand or contract a fold header and its children.
    void FoldChildren(int line, int action);

    // Expand a fold header and all children. Use the level argument instead of the line's current level.
    void ExpandChildren(int line, int level);

    // Expand or contract all fold headers.
    void FoldAll(int action);

    // Ensure a particular line is visible by expanding any header line hiding it.
    void EnsureVisible(int line);

    // Set automatic folding behaviours.
    void SetAutomaticFold(int automaticFold);

    // Get automatic folding behaviours.
    int GetAutomaticFold() const;

    // Set some style options for folding.
    void SetFoldFlags(int flags);

    // Ensure a particular line is visible by expanding any header line hiding it.
    // Use the currently set visibility policy to determine which range to display.
    void EnsureVisibleEnforcePolicy(int line);

    // Sets whether a tab pressed when caret is within indentation indents.
    void SetTabIndents(bool tabIndents);

    // Does a tab pressed when caret is within indentation indent?
    bool GetTabIndents() const;

    // Sets whether a backspace pressed when caret is within indentation unindents.
    void SetBackSpaceUnIndents(bool bsUnIndents);

    // Does a backspace pressed when caret is within indentation unindent?
    bool GetBackSpaceUnIndents() const;

    // Sets the time the mouse must sit still to generate a mouse dwell event.
    void SetMouseDwellTime(int periodMilliseconds);

    // Retrieve the time the mouse must sit still to generate a mouse dwell event.
    int GetMouseDwellTime() const;

    // Get position of start of word.
    int WordStartPosition(int pos, bool onlyWordCharacters);

    // Get position of end of word.
    int WordEndPosition(int pos, bool onlyWordCharacters);

    // Is the range start..end considered a word?
    bool IsRangeWord(int start, int end);

    // Sets limits to idle styling.
    void SetIdleStyling(int idleStyling);

    // Retrieve the limits to idle styling.
    int GetIdleStyling() const;

    // Sets whether text is word wrapped.
    void SetWrapMode(int wrapMode);

    // Retrieve whether text is word wrapped.
    int GetWrapMode() const;

    // Set the display mode of visual flags for wrapped lines.
    void SetWrapVisualFlags(int wrapVisualFlags);

    // Retrieve the display mode of visual flags for wrapped lines.
    int GetWrapVisualFlags() const;

    // Set the location of visual flags for wrapped lines.
    void SetWrapVisualFlagsLocation(int wrapVisualFlagsLocation);

    // Retrieve the location of visual flags for wrapped lines.
    int GetWrapVisualFlagsLocation() const;

    // Set the start indent for wrapped lines.
    void SetWrapStartIndent(int indent);

    // Retrieve the start indent for wrapped lines.
    int GetWrapStartIndent() const;

    // Sets how wrapped sublines are placed. Default is wxSCI_WRAPINDENT_FIXED.
    void SetWrapIndentMode(int wrapIndentMode);

    // Retrieve how wrapped sublines are placed. Default is wxSCI_WRAPINDENT_FIXED.
    int GetWrapIndentMode() const;

    // Sets the degree of caching of layout information.
    void SetLayoutCache(int cacheMode);

    // Retrieve the degree of caching of layout information.
    int GetLayoutCache() const;

    // Sets the document width assumed for scrolling.
    void SetScrollWidth(int pixelWidth);

    // Retrieve the document width assumed for scrolling.
    int GetScrollWidth() const;

    // Sets whether the maximum width line displayed is used to set scroll width.
    void SetScrollWidthTracking(bool tracking);

    // Retrieve whether the scroll width tracks wide lines.
    bool GetScrollWidthTracking() const;

    // Measure the pixel width of some text in a particular style.
    // Does not handle tab or control characters.
    int TextWidth(int style, const wxString& text);

    // Sets the scroll range so that maximum scroll position has
    // the last line at the bottom of the view (default).
    // Setting this to false allows scrolling one page below the last line.
    void SetEndAtLastLine(bool endAtLastLine);

    // Retrieve whether the maximum scroll position has the last
    // line at the bottom of the view.
    bool GetEndAtLastLine() const;

    // Retrieve the height of a particular line of text in pixels.
    int TextHeight(int line);

    // Show or hide the vertical scroll bar.
    void SetUseVerticalScrollBar(bool visible);

    // Is the vertical scroll bar visible?
    bool GetUseVerticalScrollBar() const;

    // Append a string to the end of the document without changing the selection.
    void AppendText(const wxString& text);

    // Is drawing done in two phases with backgrounds drawn before foregrounds?
    bool GetTwoPhaseDraw() const;

    // In twoPhaseDraw mode, drawing is performed in two phases, first the background
    // and then the foreground. This avoids chopping off characters that overlap the next run.
    void SetTwoPhaseDraw(bool twoPhase);

    // How many phases is drawing done in?
    int GetPhasesDraw() const;

    // In one phase draw, text is drawn in a series of rectangular blocks with no overlap.
    // In two phase draw, text is drawn in a series of lines allowing runs to overlap horizontally.
    // In multiple phase draw, each element is drawn over the whole drawing area, allowing text
    // to overlap from one line to the next.
    void SetPhasesDraw(int phases);

    // Choose the quality level for text.
    void SetFontQuality(int fontQuality);

    // Retrieve the quality level for text.
    int GetFontQuality() const;

    // Scroll so that a display line is at the top of the display.
    void SetFirstVisibleLine(int displayLine);

    // Change the effect of pasting when there are multiple selections.
    void SetMultiPaste(int multiPaste);

    // Retrieve the effect of pasting when there are multiple selections.
    int GetMultiPaste() const;

    // Retrieve the value of a tag from a regular expression search.
    wxString GetTag(int tagNumber) const;

    // Join the lines in the target.
    void LinesJoin();

    // Split the lines in the target into lines that are less wide than pixelWidth
    // where possible.
    void LinesSplit(int pixelWidth);

    // Set one of the colours used as a chequerboard pattern in the fold margin
    void SetFoldMarginColour(bool useSetting, const wxColour& back);

    // Set the other colour used as a chequerboard pattern in the fold margin
    void SetFoldMarginHiColour(bool useSetting, const wxColour& fore);

    // Move caret down one line.
    void LineDown();

    // Move caret down one line extending selection to new caret position.
    void LineDownExtend();

    // Move caret up one line.
    void LineUp();

    // Move caret up one line extending selection to new caret position.
    void LineUpExtend();

    // Move caret left one character.
    void CharLeft();

    // Move caret left one character extending selection to new caret position.
    void CharLeftExtend();

    // Move caret right one character.
    void CharRight();

    // Move caret right one character extending selection to new caret position.
    void CharRightExtend();

    // Move caret left one word.
    void WordLeft();

    // Move caret left one word extending selection to new caret position.
    void WordLeftExtend();

    // Move caret right one word.
    void WordRight();

    // Move caret right one word extending selection to new caret position.
    void WordRightExtend();

    // Move caret to first position on line.
    void Home();

    // Move caret to first position on line extending selection to new caret position.
    void HomeExtend();

    // Move caret to last position on line.
    void LineEnd();

    // Move caret to last position on line extending selection to new caret position.
    void LineEndExtend();

    // Move caret to first position in document.
    void DocumentStart();

    // Move caret to first position in document extending selection to new caret position.
    void DocumentStartExtend();

    // Move caret to last position in document.
    void DocumentEnd();

    // Move caret to last position in document extending selection to new caret position.
    void DocumentEndExtend();

    // Move caret one page up.
    void PageUp();

    // Move caret one page up extending selection to new caret position.
    void PageUpExtend();

    // Move caret one page down.
    void PageDown();

    // Move caret one page down extending selection to new caret position.
    void PageDownExtend();

    // Switch from insert to overtype mode or the reverse.
    void EditToggleOvertype();

    // Cancel any modes such as call tip or auto-completion list display.
    void Cancel();

    // Delete the selection or if no selection, the character before the caret.
    void DeleteBack();

    // If selection is empty or all on one line replace the selection with a tab character.
    // If more than one line selected, indent the lines.
    void Tab();

    // Dedent the selected lines.
    void BackTab();

    // Insert a new line, may use a CRLF, CR or LF depending on EOL mode.
    void NewLine();

    // Insert a Form Feed character.
    void FormFeed();

    // Move caret to before first visible character on line.
    // If already there move to first character on line.
    void VCHome();

    // Like VCHome but extending selection to new caret position.
    void VCHomeExtend();

    // Magnify the displayed text by increasing the sizes by 1 point.
    void ZoomIn();

    // Make the displayed text smaller by decreasing the sizes by 1 point.
    void ZoomOut();

    // Delete the word to the left of the caret.
    void DelWordLeft();

    // Delete the word to the right of the caret.
    void DelWordRight();

    // Delete the word to the right of the caret, but not the trailing non-word characters.
    void DelWordRightEnd();

    // Cut the line containing the caret.
    void LineCut();

    // Delete the line containing the caret.
    void LineDelete();

    // Switch the current line with the previous.
    void LineTranspose();

    // Duplicate the current line.
    void LineDuplicate();

    // Transform the selection to lower case.
    void LowerCase();

    // Transform the selection to upper case.
    void UpperCase();

    // Scroll the document down, keeping the caret visible.
    void LineScrollDown();

    // Scroll the document up, keeping the caret visible.
    void LineScrollUp();

    // Delete the selection or if no selection, the character before the caret.
    // Will not delete the character before at the start of a line.
    void DeleteBackNotLine();

    // Move caret to first position on display line.
    void HomeDisplay();

    // Move caret to first position on display line extending selection to
    // new caret position.
    void HomeDisplayExtend();

    // Move caret to last position on display line.
    void LineEndDisplay();

    // Move caret to last position on display line extending selection to new
    // caret position.
    void LineEndDisplayExtend();

    // Like Home but when word-wrap is enabled goes first to start of display line
    // HomeDisplay, then to start of document line Home.
    void HomeWrap();

    // Like HomeExtend but when word-wrap is enabled extends first to start of display line
    // HomeDisplayExtend, then to start of document line HomeExtend.
    void HomeWrapExtend();

    // Like LineEnd but when word-wrap is enabled goes first to end of display line
    // LineEndDisplay, then to start of document line LineEnd.
    void LineEndWrap();

    // Like LineEndExtend but when word-wrap is enabled extends first to end of display line
    // LineEndDisplayExtend, then to start of document line LineEndExtend.
    void LineEndWrapExtend();

    // Like VCHome but when word-wrap is enabled goes first to start of display line
    // VCHomeDisplay, then behaves like VCHome.
    void VCHomeWrap();

    // Like VCHomeExtend but when word-wrap is enabled extends first to start of display line
    // VCHomeDisplayExtend, then behaves like VCHomeExtend.
    void VCHomeWrapExtend();

    // Copy the line containing the caret.
    void LineCopy();

    // Move the caret inside current view if it's not there already.
    void MoveCaretInsideView();

    // How many characters are on a line, including end of line characters?
    int LineLength(int line) const;

    // Highlight the characters at two positions.
    void BraceHighlight(int posA, int posB);

    // Use specified indicator to highlight matching braces instead of changing their style.
    void BraceHighlightIndicator(bool useSetting, int indicator);

    // Highlight the character at a position indicating there is no matching brace.
    void BraceBadLight(int pos);

    // Use specified indicator to highlight non matching brace instead of changing its style.
    void BraceBadLightIndicator(bool useSetting, int indicator);

    // Find the position of a matching brace or wxSCI_INVALID_POSITION if no match.
    // The maxReStyle must be 0 for now. It may be defined in a future release.
    int BraceMatch(int pos, int maxReStyle=0);

    // Are the end of line characters visible?
    bool GetViewEOL() const;

    // Make the end of line characters visible or invisible.
    void SetViewEOL(bool visible);

    // Retrieve a pointer to the document object.
    void* GetDocPointer();

    // Change the document object used.
    void SetDocPointer(void* docPointer);

    // Set which document modification events are sent to the container.
    void SetModEventMask(int eventMask);

    // Retrieve the column number which text should be kept within.
    int GetEdgeColumn() const;

    // Set the column number of the edge.
    // If text goes past the edge then it is highlighted.
    void SetEdgeColumn(int column);

    // Retrieve the edge highlight mode.
    int GetEdgeMode() const;

    // The edge may be displayed by a line (wxSCI_EDGE_LINE/wxSCI_EDGE_MULTILINE) or by highlighting text that
    // goes beyond it (wxSCI_EDGE_BACKGROUND) or not displayed at all (wxSCI_EDGE_NONE).
    void SetEdgeMode(int edgeMode);

    // Retrieve the colour used in edge indication.
    wxColour GetEdgeColour() const;

    // Change the colour used in edge indication.
    void SetEdgeColour(const wxColour& edgeColour);

    // Add a new vertical edge to the view.
    void MultiEdgeAddLine(int column, const wxColour& edgeColour);

    // Clear all vertical edges.
    void MultiEdgeClearAll();

    // Sets the current caret position to be the search anchor.
    void SearchAnchor();

    // Find some text starting at the search anchor.
    // Does not ensure the selection is visible.
    int SearchNext(int searchFlags, const wxString& text);

    // Find some text starting at the search anchor and moving backwards.
    // Does not ensure the selection is visible.
    int SearchPrev(int searchFlags, const wxString& text);

    // Retrieves the number of lines completely visible.
    int LinesOnScreen() const;

    // Set whether a pop up menu is displayed automatically when the user presses
    // the wrong mouse button on certain areas.
    void UsePopUp(int popUpMode);

    // Is the selection rectangular? The alternative is the more common stream selection.
    bool SelectionIsRectangle() const;

    // Set the zoom level. This number of points is added to the size of all fonts.
    // It may be positive to magnify or negative to reduce.
    void SetZoom(int zoomInPoints);

    // Retrieve the zoom level.
    int GetZoom() const;

    // Create a new document object.
    // Starts with reference count of 1 and not selected into editor.
    void* CreateDocument();

    // Extend life of document.
    void AddRefDocument(void* docPointer);

    // Release a reference to the document, deleting document if it fades to black.
    void ReleaseDocument(void* docPointer);

    // Get which document modification events are sent to the container.
    int GetModEventMask() const;

    // Change internal focus flag.
    void SetSCIFocus(bool focus);

    // Get internal focus flag.
    bool GetSCIFocus() const;

    // Change error status - 0 = OK.
    void SetStatus(int status);

    // Get error status.
    int GetStatus() const;

    // Set whether the mouse is captured when its button is pressed.
    void SetMouseDownCaptures(bool captures);

    // Get whether mouse gets captured.
    bool GetMouseDownCaptures() const;

    // Set whether the mouse wheel can be active outside the window.
    void SetMouseWheelCaptures(bool captures);

    // Get whether mouse wheel can be active outside the window.
    bool GetMouseWheelCaptures() const;

    // Sets the cursor to one of the wxSCI_CURSOR* values.
    void SetSCICursor(int cursorType);

    // Get cursor type.
    int GetSCICursor() const;

    // Change the way control characters are displayed:
    // If symbol is < 32, keep the drawn way, else, use the given character.
    void SetControlCharSymbol(int symbol);

    // Get the way control characters are displayed.
    int GetControlCharSymbol() const;

    // Move to the previous change in capitalisation.
    void WordPartLeft();

    // Move to the previous change in capitalisation extending selection
    // to new caret position.
    void WordPartLeftExtend();

    // Move to the change next in capitalisation.
    void WordPartRight();

    // Move to the next change in capitalisation extending selection
    // to new caret position.
    void WordPartRightExtend();

    // Set the way the display area is determined when a particular line
    // is to be moved to by Find, FindNext, GotoLine, etc.
    void SetVisiblePolicy(int visiblePolicy, int visibleSlop);

    // Delete back from the current position to the start of the line.
    void DelLineLeft();

    // Delete forwards from the current position to the end of the line.
    void DelLineRight();

    // Set the xOffset (ie, horizontal scroll position).
    void SetXOffset(int xOffset);

    // Get the xOffset (ie, horizontal scroll position).
    int GetXOffset() const;

    // Set the last x chosen value to be the caret x position.
    void ChooseCaretX();

    // Set the way the caret is kept visible when going sideways.
    // The exclusion zone is given in pixels.
    void SetXCaretPolicy(int caretPolicy, int caretSlop);

    // Set the way the line the caret is on is kept visible.
    // The exclusion zone is given in lines.
    void SetYCaretPolicy(int caretPolicy, int caretSlop);

    // Set printing to line wrapped (wxSCI_WRAP_WORD) or not line wrapped (wxSCI_WRAP_NONE).
    void SetPrintWrapMode(int wrapMode);

    // Is printing line wrapped?
    int GetPrintWrapMode() const;

    // Set a fore colour for active hotspots.
    void SetHotspotActiveForeground(bool useSetting, const wxColour& fore);

    // Get the fore colour for active hotspots.
    wxColour GetHotspotActiveForeground() const;

    // Set a back colour for active hotspots.
    void SetHotspotActiveBackground(bool useSetting, const wxColour& back);

    // Get the back colour for active hotspots.
    wxColour GetHotspotActiveBackground() const;

    // Enable / Disable underlining active hotspots.
    void SetHotspotActiveUnderline(bool underline);

    // Get whether underlining for active hotspots.
    bool GetHotspotActiveUnderline() const;

    // Limit hotspots to single line so hotspots on two lines don't merge.
    void SetHotspotSingleLine(bool singleLine);

    // Get the HotspotSingleLine property
    bool GetHotspotSingleLine() const;

    // Move caret down one paragraph (delimited by empty lines).
    void ParaDown();

    // Extend selection down one paragraph (delimited by empty lines).
    void ParaDownExtend();

    // Move caret up one paragraph (delimited by empty lines).
    void ParaUp();

    // Extend selection up one paragraph (delimited by empty lines).
    void ParaUpExtend();

    // Given a valid document position, return the previous position taking code
    // page into account. Returns 0 if passed 0.
    int PositionBefore(int pos);

    // Given a valid document position, return the next position taking code
    // page into account. Maximum value returned is the last position in the document.
    int PositionAfter(int pos);

    // Given a valid document position, return a position that differs in a number
    // of characters. Returned value is always between 0 and last position in document.
    int PositionRelative(int pos, int relative);

    // Copy a range of text to the clipboard. Positions are clipped into the document.
    void CopyRange(int start, int end);

    // Copy argument text to the clipboard.
    void CopyText(int length, const wxString& text);

    // Set the selection mode to stream (wxSCI_SEL_STREAM) or rectangular (wxSCI_SEL_RECTANGLE/wxSCI_SEL_THIN) or
    // by lines (wxSCI_SEL_LINES).
    void SetSelectionMode(int selectionMode);

    // Get the mode of the current selection.
    int GetSelectionMode() const;

    // Retrieve the position of the start of the selection at the given line (wxSCI_INVALID_POSITION if no selection on this line).
    int GetLineSelStartPosition(int line);

    // Retrieve the position of the end of the selection at the given line (wxSCI_INVALID_POSITION if no selection on this line).
    int GetLineSelEndPosition(int line);

    // Move caret down one line, extending rectangular selection to new caret position.
    void LineDownRectExtend();

    // Move caret up one line, extending rectangular selection to new caret position.
    void LineUpRectExtend();

    // Move caret left one character, extending rectangular selection to new caret position.
    void CharLeftRectExtend();

    // Move caret right one character, extending rectangular selection to new caret position.
    void CharRightRectExtend();

    // Move caret to first position on line, extending rectangular selection to new caret position.
    void HomeRectExtend();

    // Move caret to before first visible character on line.
    // If already there move to first character on line.
    // In either case, extend rectangular selection to new caret position.
    void VCHomeRectExtend();

    // Move caret to last position on line, extending rectangular selection to new caret position.
    void LineEndRectExtend();

    // Move caret one page up, extending rectangular selection to new caret position.
    void PageUpRectExtend();

    // Move caret one page down, extending rectangular selection to new caret position.
    void PageDownRectExtend();

    // Move caret to top of page, or one page up if already at top of page.
    void StutteredPageUp();

    // Move caret to top of page, or one page up if already at top of page, extending selection to new caret position.
    void StutteredPageUpExtend();

    // Move caret to bottom of page, or one page down if already at bottom of page.
    void StutteredPageDown();

    // Move caret to bottom of page, or one page down if already at bottom of page, extending selection to new caret position.
    void StutteredPageDownExtend();

    // Move caret left one word, position cursor at end of word.
    void WordLeftEnd();

    // Move caret left one word, position cursor at end of word, extending selection to new caret position.
    void WordLeftEndExtend();

    // Move caret right one word, position cursor at end of word.
    void WordRightEnd();

    // Move caret right one word, position cursor at end of word, extending selection to new caret position.
    void WordRightEndExtend();

    // Set the set of characters making up whitespace for when moving or selecting by word.
    // Should be called after SetWordChars.
    void SetWhitespaceChars(const wxString& characters);

    // Get the set of characters making up whitespace for when moving or selecting by word.
    wxString GetWhitespaceChars() const;

    // Set the set of characters making up punctuation characters
    // Should be called after SetWordChars.
    void SetPunctuationChars(const wxString& characters);

    // Get the set of characters making up punctuation characters
    wxString GetPunctuationChars() const;

    // Reset the set of characters for whitespace and word characters to the defaults.
    void SetCharsDefault();

    // Get currently selected item position in the auto-completion list
    int AutoCompGetCurrent() const;

    // Get currently selected item text in the auto-completion list
    wxString AutoCompGetCurrentText() const;

    // Set auto-completion case insensitive behaviour to either prefer case-sensitive matches or have no preference.
    void AutoCompSetCaseInsensitiveBehaviour(int behaviour);

    // Get auto-completion case insensitive behaviour.
    int AutoCompGetCaseInsensitiveBehaviour() const;

    // Change the effect of autocompleting when there are multiple selections.
    void AutoCompSetMulti(int multi);

    // Retrieve the effect of autocompleting when there are multiple selections.
    int AutoCompGetMulti() const;

    // Set the way autocompletion lists are ordered.
    void AutoCompSetOrder(int order);

    // Get the way autocompletion lists are ordered.
    int AutoCompGetOrder() const;

    // Enlarge the document to a particular size of text bytes.
    void Allocate(int bytes);

    // Find the position of a column on a line taking into account tabs and
    // multi-byte characters. If beyond end of line, return line end position.
    int FindColumn(int line, int column);

    // Can the caret preferred x position only be changed by explicit movement commands?
    int GetCaretSticky() const;

    // Stop the caret preferred x position changing when the user types.
    void SetCaretSticky(int useCaretStickyBehaviour);

    // Switch between sticky and non-sticky: meant to be bound to a key.
    void ToggleCaretSticky();

    // Enable/Disable convert-on-paste for line endings
    void SetPasteConvertEndings(bool convert);

    // Get convert-on-paste setting
    bool GetPasteConvertEndings() const;

    // Duplicate the selection. If selection empty duplicate the line containing the caret.
    void SelectionDuplicate();

    // Set background alpha of the caret line.
    void SetCaretLineBackAlpha(int alpha);

    // Get the background alpha of the caret line.
    int GetCaretLineBackAlpha() const;

    // Set the style of the caret to be drawn.
    void SetCaretStyle(int caretStyle);

    // Returns the current style of the caret.
    int GetCaretStyle() const;

    // Set the indicator used for IndicatorFillRange and IndicatorClearRange
    void SetIndicatorCurrent(int indicator);

    // Get the current indicator
    int GetIndicatorCurrent() const;

    // Set the value used for IndicatorFillRange
    void SetIndicatorValue(int value);

    // Get the current indicator value
    int GetIndicatorValue() const;

    // Turn a indicator on over a range.
    void IndicatorFillRange(int start, int lengthFill);

    // Turn a indicator off over a range.
    void IndicatorClearRange(int start, int lengthClear);

    // Are any indicators present at pos?
    int IndicatorAllOnFor(int pos);

    // What value does a particular indicator have at a position?
    int IndicatorValueAt(int indicator, int pos);

    // Where does a particular indicator start?
    int IndicatorStart(int indicator, int pos);

    // Where does a particular indicator end?
    int IndicatorEnd(int indicator, int pos);

    // Set number of entries in position cache
    void SetPositionCacheSize(int size);

    // How many entries are allocated to the position cache?
    int GetPositionCacheSize() const;

    // Copy the selection, if selection empty copy the line with the caret
    void CopyAllowLine();

    // Compact the document buffer and return a read-only pointer to the
    // characters in the document.
    const char* GetCharacterPointer() const;

    // Return a read-only pointer to a range of characters in the document.
    // May move the gap so that the range is contiguous, but will only move up
    // to rangeLength bytes.
    const char* GetRangePointer(int position, int rangeLength) const;

    // Return a position which, to avoid performance costs, should not be within
    // the range of a call to GetRangePointer.
    int GetGapPosition() const;

    // Set the alpha fill colour of the given indicator.
    void IndicatorSetAlpha(int indicator, int alpha);

    // Get the alpha fill colour of the given indicator.
    int IndicatorGetAlpha(int indicator) const;

    // Set the alpha outline colour of the given indicator.
    void IndicatorSetOutlineAlpha(int indicator, int alpha);

    // Get the alpha outline colour of the given indicator.
    int IndicatorGetOutlineAlpha(int indicator) const;

    // Set extra ascent for each line
    void SetExtraAscent(int extraAscent);

    // Get extra ascent for each line
    int GetExtraAscent() const;

    // Set extra descent for each line
    void SetExtraDescent(int extraDescent);

    // Get extra descent for each line
    int GetExtraDescent() const;

    // Which symbol was defined for markerNumber with MarkerDefine
    int GetMarkerSymbolDefined(int markerNumber);

    // Set the text in the text margin for a line
    void MarginSetText(int line, const wxString& text);

    // Get the text in the text margin for a line
    wxString MarginGetText(int line) const;

    // Set the style number for the text margin for a line
    void MarginSetStyle(int line, int style);

    // Get the style number for the text margin for a line
    int MarginGetStyle(int line) const;

    // Set the style in the text margin for a line
    void MarginSetStyles(int line, const wxString& styles);

    // Get the styles in the text margin for a line
    wxString MarginGetStyles(int line) const;

    // Clear the margin text on all lines
    void MarginTextClearAll();

    // Get the start of the range of style numbers used for margin text
    void MarginSetStyleOffset(int style);

    // Get the start of the range of style numbers used for margin text
    int MarginGetStyleOffset() const;

    // Set the margin options.
    void SetMarginOptions(int marginOptions);

    // Get the margin options.
    int GetMarginOptions() const;

    // Set the annotation text for a line
    void AnnotationSetText(int line, const wxString& text);

    // Get the annotation text for a line
    wxString AnnotationGetText(int line) const;

    // Set the style number for the annotations for a line
    void AnnotationSetStyle(int line, int style);

    // Get the style number for the annotations for a line
    int AnnotationGetStyle(int line) const;

    // Set the annotation styles for a line
    void AnnotationSetStyles(int line, const wxString& styles);

    // Get the annotation styles for a line
    wxString AnnotationGetStyles(int line) const;

    // Get the number of annotation lines for a line
    int AnnotationGetLines(int line) const;

    // Clear the annotations from all lines
    void AnnotationClearAll();

    // Set the visibility for the annotations for a view
    void AnnotationSetVisible(int visible);

    // Get the visibility for the annotations for a view
    int AnnotationGetVisible() const;

    // Get the start of the range of style numbers used for annotations
    void AnnotationSetStyleOffset(int style);

    // Get the start of the range of style numbers used for annotations
    int AnnotationGetStyleOffset() const;

    // Release all extended (>255) style numbers
    void ReleaseAllExtendedStyles();

    // Allocate some extended (>255) style numbers and return the start of the range
    int AllocateExtendedStyles(int numberStyles);

    // Add a container action to the undo stack
    void AddUndoAction(int token, int flags);

    // Find the position of a character from a point within the window.
    int CharPositionFromPoint(int x, int y);

    // Find the position of a character from a point within the window.
    // Return wxSCI_INVALID_POSITION if not close to text.
    int CharPositionFromPointClose(int x, int y);

    // Set whether switching to rectangular mode while selecting with the mouse is allowed.
    void SetMouseSelectionRectangularSwitch(bool mouseSelectionRectangularSwitch);

    // Whether switching to rectangular mode while selecting with the mouse is allowed.
    bool GetMouseSelectionRectangularSwitch() const;

    // Set whether multiple selections can be made
    void SetMultipleSelection(bool multipleSelection);

    // Whether multiple selections can be made
    bool GetMultipleSelection() const;

    // Set whether typing can be performed into multiple selections
    void SetAdditionalSelectionTyping(bool additionalSelectionTyping);

    // Whether typing can be performed into multiple selections
    bool GetAdditionalSelectionTyping() const;

    // Set whether additional carets will blink
    void SetAdditionalCaretsBlink(bool additionalCaretsBlink);

    // Whether additional carets will blink
    bool GetAdditionalCaretsBlink() const;

    // Set whether additional carets are visible
    void SetAdditionalCaretsVisible(bool additionalCaretsVisible);

    // Whether additional carets are visible
    bool GetAdditionalCaretsVisible() const;

    // How many selections are there?
    int GetSelections() const;

    // Is every selected range empty?
    bool GetSelectionEmpty() const;

    // Clear selections to a single empty stream selection
    void ClearSelections();

/* C::B begin */
    // Select a range of text.
    void SetSelectionVoid(int startPos, int endPos);

    // Set a simple selection
    int SetSelectionInt(int caret, int anchor);
/* C::B end */

    // Add a selection
    int AddSelection(int caret, int anchor);

    // Drop one selection
    void DropSelectionN(int selection);

    // Set the main selection
    void SetMainSelection(int selection);

    // Which selection is the main selection
    int GetMainSelection() const;

    // Set the caret position of the nth selection.
    void SetSelectionNCaret(int selection, int caret);

    // Return the caret position of the nth selection.
    int GetSelectionNCaret(int selection) const;

    // Set the anchor position of the nth selection.
    void SetSelectionNAnchor(int selection, int anchor);

    // Return the anchor position of the nth selection.
    int GetSelectionNAnchor(int selection) const;

    // Set the virtual space of the caret of the nth selection.
    void SetSelectionNCaretVirtualSpace(int selection, int space);

    // Return the virtual space of the caret of the nth selection.
    int GetSelectionNCaretVirtualSpace(int selection) const;

    // Set the virtual space of the anchor of the nth selection.
    void SetSelectionNAnchorVirtualSpace(int selection, int space);

    // Return the virtual space of the anchor of the nth selection.
    int GetSelectionNAnchorVirtualSpace(int selection) const;

    // Sets the position that starts the selection - this becomes the anchor.
    void SetSelectionNStart(int selection, int anchor);

    // Returns the position at the start of the selection.
    int GetSelectionNStart(int selection) const;

    // Sets the position that ends the selection - this becomes the currentPosition.
    void SetSelectionNEnd(int selection, int caret);

    // Returns the position at the end of the selection.
    int GetSelectionNEnd(int selection) const;

    // Set the caret position of the rectangular selection.
    void SetRectangularSelectionCaret(int caret);

    // Return the caret position of the rectangular selection.
    int GetRectangularSelectionCaret() const;

    // Set the anchor position of the rectangular selection.
    void SetRectangularSelectionAnchor(int anchor);

    // Return the anchor position of the rectangular selection.
    int GetRectangularSelectionAnchor() const;

    // Set the virtual space of the caret of the rectangular selection.
    void SetRectangularSelectionCaretVirtualSpace(int space);

    // Return the virtual space of the caret of the rectangular selection.
    int GetRectangularSelectionCaretVirtualSpace() const;

    // Set the virtual space of the anchor of the rectangular selection.
    void SetRectangularSelectionAnchorVirtualSpace(int space);

    // Return the virtual space of the anchor of the rectangular selection.
    int GetRectangularSelectionAnchorVirtualSpace() const;

    // Set options for virtual space behaviour.
    void SetVirtualSpaceOptions(int virtualSpaceOptions);

    // Return options for virtual space behaviour.
    int GetVirtualSpaceOptions() const;

    // On GTK+, allow selecting the modifier key to use for mouse-based
    // rectangular selection. Often the window manager requires Alt+Mouse Drag
    // for moving windows.
    // Valid values are wxSCI_KEYMOD_CTRL (default), wxSCI_KEYMOD_ALT, or wxSCI_KEYMOD_SUPER.
    void SetRectangularSelectionModifier(int modifier);

    // Get the modifier key used for rectangular selection.
    int GetRectangularSelectionModifier() const;

    // Set the foreground colour of additional selections.
    // Must have previously called SetSelFore with non-zero first argument for this to have an effect.
    void SetAdditionalSelForeground(const wxColour& fore);

    // Set the background colour of additional selections.
    // Must have previously called SetSelBack with non-zero first argument for this to have an effect.
    void SetAdditionalSelBackground(const wxColour& back);

    // Set the alpha of the selection.
    void SetAdditionalSelAlpha(int alpha);

    // Get the alpha of the selection.
    int GetAdditionalSelAlpha() const;

    // Set the foreground colour of additional carets.
    void SetAdditionalCaretForeground(const wxColour& fore);

    // Get the foreground colour of additional carets.
    wxColour GetAdditionalCaretForeground() const;

    // Set the main selection to the next selection.
    void RotateSelection();

    // Swap that caret and anchor of the main selection.
    void SwapMainAnchorCaret();

    // Add the next occurrence of the main selection to the set of selections as main.
    // If the current selection is empty then select word around caret.
    void MultipleSelectAddNext();

    // Add each occurrence of the main selection in the target to the set of selections.
    // If the current selection is empty then select word around caret.
    void MultipleSelectAddEach();

    // Indicate that the internal state of a lexer has changed over a range and therefore
    // there may be a need to redraw.
    int ChangeLexerState(int start, int end);

    // Find the next line at or after lineStart that is a contracted fold header line.
    // Return -1 when no more lines.
    int ContractedFoldNext(int lineStart);

    // Centre current line in window.
    void VerticalCentreCaret();

    // Move the selected lines up one line, shifting the line above after the selection
    void MoveSelectedLinesUp();

    // Move the selected lines down one line, shifting the line below before the selection
    void MoveSelectedLinesDown();

    // Set the identifier reported as idFrom in notification messages.
    void SetIdentifier(int identifier);

    // Get the identifier.
    int GetIdentifier() const;

    // Set the width for future RGBA image data.
    void RGBAImageSetWidth(int width);

    // Set the height for future RGBA image data.
    void RGBAImageSetHeight(int height);

    // Set the scale factor in percent for future RGBA image data.
    void RGBAImageSetScale(int scalePercent);

    // Define a marker from RGBA data.
    // It has the width and height from RGBAImageSetWidth/Height
    void MarkerDefineRGBAImage(int markerNumber, const unsigned char* pixels);

    // Register an RGBA image for use in autocompletion lists.
    // It has the width and height from RGBAImageSetWidth/Height
    void RegisterRGBAImage(int type, const unsigned char* pixels);

    // Scroll to start of document.
    void ScrollToStart();

    // Scroll to end of document.
    void ScrollToEnd();

    // Set the technology used.
    void SetTechnology(int technology);

    // Get the tech.
    int GetTechnology() const;

    // Create an ILoader*.
    void* CreateLoader(int bytes) const;

    // Move caret to before first visible character on display line.
    // If already there move to first character on display line.
    void VCHomeDisplay();

    // Like VCHomeDisplay but extending selection to new caret position.
    void VCHomeDisplayExtend();

    // Is the caret line always visible?
    bool GetCaretLineVisibleAlways() const;

    // Sets the caret line to always visible.
    void SetCaretLineVisibleAlways(bool alwaysVisible);

    // Set the line end types that the application wants to use. May not be used if incompatible with lexer or encoding.
    void SetLineEndTypesAllowed(int lineEndBitSet);

    // Get the line end types currently allowed.
    int GetLineEndTypesAllowed() const;

    // Get the line end types currently recognised. May be a subset of the allowed types due to lexer limitation.
    int GetLineEndTypesActive() const;

    // Set the way a character is drawn.
    void SetRepresentation(const wxString& encodedCharacter, const wxString& representation);

    // Set the way a character is drawn.
    wxString GetRepresentation(const wxString& encodedCharacter) const;

    // Remove a character representation.
    void ClearRepresentation(const wxString& encodedCharacter);

    // Start notifying the container of all key presses and commands.
    void StartRecord();

    // Stop notifying the container of all key presses and commands.
    void StopRecord();

    // Set the lexing language of the document.
    void SetLexer(int lexer);

    // Retrieve the lexing language of the document.
    int GetLexer() const;

    // Colourise a segment of the document using the current lexing language.
    void Colourise(int start, int end);

    // Set up a value that may be used by a lexer for some optional feature.
    void SetProperty(const wxString& key, const wxString& value);

    // Set up the key words used by the lexer.
    void SetKeyWords(int keyWordSet, const wxString& keyWords);

    // Set the lexing language of the document based on string name.
    void SetLexerLanguage(const wxString& language);

    // Load a lexer library (dll / so).
    void LoadLexerLibrary(const wxString& path);

    // Retrieve a "property" value previously set with SetProperty.
    wxString GetProperty(const wxString& key);

    // Retrieve a "property" value previously set with SetProperty,
    // with "$()" variable replacement on returned buffer.
    wxString GetPropertyExpanded(const wxString& key);

    // Retrieve a "property" value previously set with SetProperty,
    // interpreted as an int AFTER any "$()" variable replacement.
    int GetPropertyInt(const wxString &key, int defaultValue=0) const;

    // Retrieve the number of bits the current lexer needs for styling.
#if wxCHECK_VERSION(3, 0, 0)
    wxDEPRECATED_MSG( "This method uses a function deprecated in the Scintilla library." )
#endif // wxCHECK_VERSION
    int GetStyleBitsNeeded() const;

    // Retrieve the lexing language of the document.
    wxString GetLexerLanguage() const;

    // For private communication between an application and a known lexer.
    void* PrivateLexerCall(int operation, void* pointer);

    // Retrieve a '\\n' separated list of properties understood by the current lexer.
    wxString PropertyNames() const;

    // Retrieve the type of a property.
    int PropertyType(const wxString& name);

    // Describe a property.
    wxString DescribeProperty(const wxString& name) const;

    // Retrieve a '\\n' separated list of descriptions of the keyword sets understood by the current lexer.
    wxString DescribeKeyWordSets() const;

    // Bit set of LineEndType enumertion for which line ends beyond the standard
    // LF, CR, and CRLF are supported by the lexer.
    int GetLineEndTypesSupported() const;

    // Allocate a set of sub styles for a particular base style, returning start of range
    int AllocateSubStyles(int styleBase, int numberStyles);

    // The starting style number for the sub styles associated with a base style
    int GetSubStylesStart(int styleBase) const;

    // The number of sub styles associated with a base style
    int GetSubStylesLength(int styleBase) const;

    // For a sub style, return the base style, else return the argument.
    int GetStyleFromSubStyle(int subStyle) const;

    // For a secondary style, return the primary style, else return the argument.
    int GetPrimaryStyleFromStyle(int style) const;

    // Free allocated sub styles
    void FreeSubStyles();

    // Set the identifiers that are shown in a particular style
    void SetIdentifiers(int style, const wxString& identifiers);

    // Where styles are duplicated by a feature such as active/inactive code
    // return the distance between the two types.
    int DistanceToSecondaryStyles() const;

    // Get the set of base styles that can be extended with sub styles
    wxString GetSubStyleBases() const;

    //}}}
    //----------------------------------------------------------------------

    // Manually declared methods

    // Returns the line number of the line with the caret.
    int GetCurrentLine();

    // Extract style settings from a spec-string which is composed of one or
    // more of the following comma separated elements:
    //
    //      bold                    turns on bold
    //      italic                  turns on italics
    //      fore:[name or #RRGGBB]  sets the foreground colour
    //      back:[name or #RRGGBB]  sets the background colour
    //      face:[facename]         sets the font face name to use
    //      size:[num]              sets the font size in points
    //      eol                     turns on eol filling
    //      underline               turns on underlining
    //
    void StyleSetSpec(int styleNum, const wxString& spec);


    // Get the font of a style.
    wxFont StyleGetFont(int style);


    // Set style size, face, bold, italic, and underline attributes from
    // a wxFont's attributes.
    void StyleSetFont(int styleNum, const wxFont& font);



    // Set all font style attributes at once.
    void StyleSetFontAttr(int styleNum, int size,
                          const wxString& faceName,
                          bool bold, bool italic,
                          bool underline,
                          wxFontEncoding encoding=wxFONTENCODING_DEFAULT);


    // Set the font encoding to be used by a style.
    void StyleSetFontEncoding(int style, wxFontEncoding encoding);


    // Perform one of the operations defined by the wxSCI_CMD_* constants.
    void CmdKeyExecute(int cmd);


    // Set the left and right margin in the edit area, measured in pixels.
    void SetMargins(int left, int right);


    // Scroll enough to make the given line visible
    void ScrollToLine(int line);


    // Scroll enough to make the given column visible
    void ScrollToColumn(int column);


    // Send a message to Scintilla
    //
    // NB: this method is not really const as it can modify the control but it
    //     has to be declared as such as it's called from both const and
    //     non-const methods and we can't distinguish between the two
    wxIntPtr SendMsg(int msg, wxUIntPtr wp=0, wxIntPtr lp=0) const;


    // Set the vertical scrollbar to use instead of the one that's built-in.
    void SetVScrollBar(wxScrollBar* bar);


    // Set the horizontal scrollbar to use instead of the one that's built-in.
    void SetHScrollBar(wxScrollBar* bar);

    // Can be used to prevent the EVT_CHAR handler from adding the char
    bool GetLastKeydownProcessed() { return m_lastKeyDownConsumed; }
    void SetLastKeydownProcessed(bool val) { m_lastKeyDownConsumed = val; }

/* C::B begin */
    // Write the contents of the editor to filename
    bool SaveFile(const wxString& filename);

    // Load the contents of filename into the editor
    bool LoadFile(const wxString& filename);
/* C::B end */

#ifdef SCI_USE_DND
    // Allow for simulating a DnD DragEnter
    wxDragResult DoDragEnter(wxCoord x, wxCoord y, wxDragResult def);

    // Allow for simulating a DnD DragOver
    wxDragResult DoDragOver(wxCoord x, wxCoord y, wxDragResult def);

    // Allow for simulating a DnD DragLeave
    void DoDragLeave();

    // Allow for simulating a DnD DropText
    bool DoDropText(long x, long y, const wxString& data);
#endif

    // Specify whether anti-aliased fonts should be used.  Will have no effect
    // on some platforms, but on some (wxMac for example) can greatly improve
    // performance.
    void SetUseAntiAliasing(bool useAA);

    // Returns the current UseAntiAliasing setting.
    bool GetUseAntiAliasing();

    // Clear annotations from the given line.
    void AnnotationClearLine(int line);

    // Define a marker from a bitmap.
    void MarkerDefineBitmap(int markerNumber, const wxBitmap& bmp);

    // Register an image for use in autocompletion lists.
    void RegisterImage(int type, const wxBitmap& bmp);



    // The following methods are nearly equivalent to their similarly named
    // cousins above.  The difference is that these methods bypass wxString
    // and always use a char* even if used in a unicode build of wxWidgets.
    // In that case the character data will be utf-8 encoded since that is
    // what is used internally by Scintilla in unicode builds.

    // Add text to the document at current position.
    void AddTextRaw(const char* text, int length=-1);

    // Insert string at a position.
    void InsertTextRaw(int pos, const char* text);

    // Retrieve the text of the line containing the caret.
    // Returns the index of the caret on the line.
#ifdef SWIG
    wxCharBuffer GetCurLineRaw(int* OUTPUT);
#else
    wxCharBuffer GetCurLineRaw(int* linePos=NULL);
#endif

    // Retrieve the contents of a line.
    wxCharBuffer GetLineRaw(int line);

    // Retrieve the selected text.
    wxCharBuffer GetSelectedTextRaw();

    // Retrieve the target text.
    wxCharBuffer GetTargetTextRaw();

    // Retrieve a range of text.
    wxCharBuffer GetTextRangeRaw(int startPos, int endPos);

    // Replace the contents of the document with the argument text.
    void SetTextRaw(const char* text);

    // Retrieve all the text in the document.
    wxCharBuffer GetTextRaw();

    // Append a string to the end of the document without changing the selection.
    void AppendTextRaw(const char* text, int length=-1);

#ifdef SWIG
    %pythoncode "_SCI_utf8_methods.py"
#endif


    // implement wxTextEntryBase pure virtual methods
    // ----------------------------------------------

    virtual void WriteText(const wxString& text)
    {
        ReplaceSelection(text);
    }

    virtual void Remove(long from, long to)
    {
        Replace(from, to, wxString());
    }
    virtual void Replace(long from, long to, const wxString& text)
    {
        SetTargetStart((int)from);
        SetTargetEnd((int)to);
        ReplaceTarget(text);
    }

    /*
        These functions are already declared in the generated section.

    virtual void Copy();
    virtual void Cut();
    virtual void Paste();

    virtual void Undo();
    virtual void Redo();

    virtual bool CanUndo() const;
    virtual bool CanRedo() const;

    */

    virtual void SetInsertionPoint(long pos)
    {
        SetCurrentPos(int(pos == -1 ? GetLastPosition() : pos));
    }
    virtual long GetInsertionPoint() const { return GetCurrentPos(); }
    virtual long GetLastPosition() const { return GetTextLength(); }

    virtual void SetSelection(long from, long to)
    {
        if ( from == -1 && to == -1 )
        {
            SelectAll();
        }
        else
        {
            SetSelectionStart((int)from);
            SetSelectionEnd((int)to);
        }
    }

    virtual void SelectNone()
    {
        ClearSelections();
    }

#ifdef SWIG
    void GetSelection(long* OUTPUT, long* OUTPUT) const;
#else
    virtual void GetSelection(long *from, long *to) const
    {
        if ( from )
            *from = GetSelectionStart();
        if ( to )
            *to = GetSelectionEnd();
    }

    // kept for compatibility only
    void GetSelection(int *from, int *to)
    {
        long f, t;
        GetSelection(&f, &t);
        if ( from )
            *from = (int)f;
        if ( to )
            *to = (int)t;
    }
#endif

    virtual bool IsEditable() const { return !GetReadOnly(); }
    virtual void SetEditable(bool editable) { SetReadOnly(!editable); }

/* C::B begin capture mouse assert fix */
    void SetMouseCapture(bool on);
    bool HaveMouseCapture() const;
/* C::B end */

/* C::B begin */
#if wxCHECK_VERSION(3, 0, 0)
    static wxVersionInfo GetLibraryVersionInfo();
#endif
/* C::B end */

protected:
/* C::B begin */
    wxString GetValue() const { return GetText(); }
    void SetValue(const wxString& text) { SetText(text); }
/* C::B end */
    virtual void DoSetValue(const wxString& value, int flags);
    virtual wxString DoGetValue() const { return GetText(); }
    virtual wxWindow *GetEditableWindow() { return this; }

#ifndef SWIG
    virtual bool DoLoadFile(const wxString& file, int fileType);
    virtual bool DoSaveFile(const wxString& file, int fileType);

    // Event handlers
    void OnPaint(wxPaintEvent& evt);
    void OnScrollWin(wxScrollWinEvent& evt);
    void OnScroll(wxScrollEvent& evt);
    void OnSize(wxSizeEvent& evt);
    void OnMouseLeftDown(wxMouseEvent& evt);
    void OnMouseRightDown(wxMouseEvent& evt);
    void OnMouseMove(wxMouseEvent& evt);
    void OnMouseLeftUp(wxMouseEvent& evt);
    void OnMouseRightUp(wxMouseEvent& evt);
    void OnMouseMiddleUp(wxMouseEvent& evt);
    void OnContextMenu(wxContextMenuEvent& evt);
    void OnMouseWheel(wxMouseEvent& evt);
    void OnChar(wxKeyEvent& evt);
    void OnKeyDown(wxKeyEvent& evt);
    void OnLoseFocus(wxFocusEvent& evt);
    void OnGainFocus(wxFocusEvent& evt);
    void OnSysColourChanged(wxSysColourChangedEvent& evt);
    void OnEraseBackground(wxEraseEvent& evt);
    void OnMenu(wxCommandEvent& evt);
    void OnListBox(wxCommandEvent& evt);
    void OnIdle(wxIdleEvent& evt);
    void OnMouseCaptureLost(wxMouseCaptureLostEvent& evt);

    virtual wxSize DoGetBestSize() const override;

    // Turn notifications from Scintilla into events
    void NotifyChange();
    void NotifyParent(SCNotification* scn);

private:
    DECLARE_EVENT_TABLE();
    DECLARE_DYNAMIC_CLASS(wxScintilla);

protected:

    ScintillaWX*        m_swx;
    wxStopWatch         m_stopWatch;
    wxScrollBar*        m_vScrollBar;
    wxScrollBar*        m_hScrollBar;

    bool                m_lastKeyDownConsumed;

    friend class ScintillaWX;
    friend class Platform;
#endif // !SWIG
};

//----------------------------------------------------------------------

class WXDLLIMPEXP_SCI wxScintillaEvent : public wxCommandEvent {
public:
    wxScintillaEvent(wxEventType commandType=0, int id=0);
#ifndef SWIG
    wxScintillaEvent(const wxScintillaEvent& event);
#endif
    ~wxScintillaEvent() {}

    void SetPosition(int pos)             { m_position = pos; }
    void SetKey(int k)                    { m_key = k; }
    void SetModifiers(int m)              { m_modifiers = m; }
    void SetModificationType(int t)       { m_modificationType = t; }
    // Kept for backwards compatibility, use SetString().
    void SetText(const wxString& t)       { SetString(t); }
    void SetLength(int len)               { m_length = len; }
    void SetLinesAdded(int num)           { m_linesAdded = num; }
    void SetLine(int val)                 { m_line = val; }
    void SetFoldLevelNow(int val)         { m_foldLevelNow = val; }
    void SetFoldLevelPrev(int val)        { m_foldLevelPrev = val; }
    void SetMargin(int val)               { m_margin = val; }
    void SetMessage(int val)              { m_message = val; }
    void SetWParam(int val)               { m_wParam = val; }
    void SetLParam(int val)               { m_lParam = val; }
    void SetListType(int val)             { m_listType = val; }
    void SetX(int val)                    { m_x = val; }
    void SetY(int val)                    { m_y = val; }
    void SetToken(int val)                { m_token = val; }
    void SetAnnotationLinesAdded(int val) { m_annotationLinesAdded = val; }
    void SetUpdated(int val)              { m_updated = val; }
    void SetListCompletionMethod(int val) { m_listCompletionMethod = val; }
#ifdef  SCI_USE_DND
    // Kept for backwards compatibility, use SetString().
    void SetDragText(const wxString& val) { SetString(val); }
    void SetDragFlags(int flags)          { m_dragFlags = flags; }
    void SetDragResult(wxDragResult val)  { m_dragResult = val; }

    // This method is kept mainly for backwards compatibility, use
    // SetDragFlags() in the new code.
    void SetDragAllowMove(bool allow)
    {
        if ( allow )
            m_dragFlags |= wxDrag_AllowMove;
        else
            m_dragFlags &= ~(wxDrag_AllowMove | wxDrag_DefaultMove);
    }
#endif

    int  GetPosition() const         { return m_position; }
    int  GetKey()  const             { return m_key; }
    int  GetModifiers() const        { return m_modifiers; }
    int  GetModificationType() const { return m_modificationType; }
    // Kept for backwards compatibility, use GetString().
    wxString GetText() const         { return GetString(); }
    int  GetLength() const           { return m_length; }
    int  GetLinesAdded() const       { return m_linesAdded; }
    int  GetLine() const             { return m_line; }
    int  GetFoldLevelNow() const     { return m_foldLevelNow; }
    int  GetFoldLevelPrev() const    { return m_foldLevelPrev; }
    int  GetMargin() const           { return m_margin; }
    int  GetMessage() const          { return m_message; }
    int  GetWParam() const           { return m_wParam; }
    int  GetLParam() const           { return m_lParam; }
    int  GetListType() const         { return m_listType; }
    int  GetX() const                { return m_x; }
    int  GetY() const                { return m_y; }
    int  GetToken() const                 { return m_token; }
    int  GetAnnotationsLinesAdded() const { return m_annotationLinesAdded; }
    int  GetUpdated() const               { return m_updated; }
    int  GetListCompletionMethod() const  { return m_listCompletionMethod; }

#ifdef SCI_USE_DND
    // Kept for backwards compatibility, use GetString().
    wxString GetDragText()           { return GetString(); }
    int GetDragFlags()               { return m_dragFlags; }
    wxDragResult GetDragResult()     { return m_dragResult; }

    bool GetDragAllowMove() { return (GetDragFlags() & wxDrag_AllowMove) != 0; }
#endif

    bool GetShift() const;
    bool GetControl() const;
    bool GetAlt() const;

    virtual wxEvent* Clone() const { return new wxScintillaEvent(*this); }

#ifndef SWIG
private:
    DECLARE_DYNAMIC_CLASS(wxScintillaEvent)

    int  m_position;
    int  m_key;
    int  m_modifiers;

    int  m_modificationType;    // wxEVT_SCI_MODIFIED
    int  m_length;
    int  m_linesAdded;
    int  m_line;
    int  m_foldLevelNow;
    int  m_foldLevelPrev;

    int  m_margin;              // wxEVT_SCI_MARGINCLICK

    int  m_message;             // wxEVT_SCI_MACRORECORD
    int  m_wParam;
    int  m_lParam;

    int m_listType;
    int m_x;
    int m_y;

    int m_token;                // wxEVT_SCI__MODIFIED with SC_MOD_CONTAINER
    int m_annotationLinesAdded; // wxEVT_SCI_MODIFIED with SC_MOD_CHANGEANNOTATION
    int m_updated;              // wxEVT_SCI_UPDATEUI
    int m_listCompletionMethod;

#if wxUSE_DRAG_AND_DROP
    int      m_dragFlags;       // wxEVT_SCI_START_DRAG
    wxDragResult m_dragResult;  // wxEVT_SCI_DRAG_OVER,wxEVT_SCI_DO_DROP
#endif
#endif
};



#ifndef SWIG
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_CHANGE,               1650)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_STYLENEEDED,          1651)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_CHARADDED,            1652)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_SAVEPOINTREACHED,     1653)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_SAVEPOINTLEFT,        1654)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_ROMODIFYATTEMPT,      1655)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_DOUBLECLICK,          1657)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_UPDATEUI,             1658)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_MODIFIED,             1659)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_MACRORECORD,          1660)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_MARGINCLICK,          1661)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_NEEDSHOWN,            1662)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_PAINTED,              1664)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_USERLISTSELECTION,    1665)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_DWELLSTART,           1667)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_DWELLEND,             1668)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_START_DRAG,           1669)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_DRAG_OVER,            1670)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_DO_DROP,              1671)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_ZOOM,                 1672)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_HOTSPOT_CLICK,        1673)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_HOTSPOT_DCLICK,       1674)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_CALLTIP_CLICK,        1675)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_AUTOCOMP_SELECTION,   1676)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_INDICATOR_CLICK,      1677)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_INDICATOR_RELEASE,    1678)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_AUTOCOMP_CANCELLED,   1679)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_AUTOCOMP_CHAR_DELETED,1680)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_HOTSPOT_RELEASE_CLICK,1681)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_CLIPBOARD_COPY,       1681)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_CLIPBOARD_PASTE,      1682)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_AUTOCOMP_COMPLETED,   1683)
DECLARE_EXPORTED_EVENT_TYPE (WXDLLIMPEXP_SCI, wxEVT_SCI_MARGIN_RIGHT_CLICK,   1684)
END_DECLARE_EVENT_TYPES()
#else
    enum {
        wxEVT_SCI_CHANGE,
        wxEVT_SCI_STYLENEEDED,
        wxEVT_SCI_CHARADDED,
        wxEVT_SCI_SAVEPOINTREACHED,
        wxEVT_SCI_SAVEPOINTLEFT,
        wxEVT_SCI_ROMODIFYATTEMPT,
        wxEVT_SCI_DOUBLECLICK,
        wxEVT_SCI_UPDATEUI,
        wxEVT_SCI_MODIFIED,
        wxEVT_SCI_MACRORECORD,
        wxEVT_SCI_MARGINCLICK,
        wxEVT_SCI_NEEDSHOWN,
        wxEVT_SCI_PAINTED,
        wxEVT_SCI_USERLISTSELECTION,
        wxEVT_SCI_DWELLSTART,
        wxEVT_SCI_DWELLEND,
        wxEVT_SCI_START_DRAG,
        wxEVT_SCI_DRAG_OVER,
        wxEVT_SCI_DO_DROP,
        wxEVT_SCI_ZOOM,
        wxEVT_SCI_HOTSPOT_CLICK,
        wxEVT_SCI_HOTSPOT_DCLICK,
        wxEVT_SCI_CALLTIP_CLICK,
        wxEVT_SCI_AUTOCOMP_SELECTION,
        wxEVT_SCI_INDICATOR_CLICK,
        wxEVT_SCI_INDICATOR_RELEASE,
        wxEVT_SCI_AUTOCOMP_CANCELLED,
        wxEVT_SCI_AUTOCOMP_CHAR_DELETED,
        wxEVT_SCI_HOTSPOT_RELEASE_CLICK,
        wxEVT_SCI_CLIPBOARD_COPY,
        wxEVT_SCI_CLIPBOARD_PASTE,
        wxEVT_SCI_AUTOCOMP_COMPLETED,
        wxEVT_SCI_MARGIN_RIGHT_CLICK
    };
#endif



#ifndef SWIG
typedef void (wxEvtHandler::*wxScintillaEventFunction)(wxScintillaEvent&);

/* C::B begin */
#if !wxCHECK_VERSION(3, 0, 0)
  #define wxEVENT_HANDLER_CAST( functype, func ) \
      ( wxObjectEventFunction )( wxEventFunction )wxStaticCastEvent( functype, &func )
#endif
/* C::B end */

#define wxScintillaEventHandler( func ) \
    wxEVENT_HANDLER_CAST( wxScintillaEventFunction, func )

#define EVT_SCI_CHANGE(id, fn)             DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_CHANGE,                id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_STYLENEEDED(id, fn)        DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_STYLENEEDED,           id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_CHARADDED(id, fn)          DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_CHARADDED,             id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_SAVEPOINTREACHED(id, fn)   DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_SAVEPOINTREACHED,      id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_SAVEPOINTLEFT(id, fn)      DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_SAVEPOINTLEFT,         id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_ROMODIFYATTEMPT(id, fn)    DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_ROMODIFYATTEMPT,       id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_KEY(id, fn)                DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_KEY,                   id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_DOUBLECLICK(id, fn)        DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_DOUBLECLICK,           id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_UPDATEUI(id, fn)           DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_UPDATEUI,              id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_MODIFIED(id, fn)           DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_MODIFIED,              id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_MACRORECORD(id, fn)        DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_MACRORECORD,           id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_MARGINCLICK(id, fn)        DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_MARGINCLICK,           id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_NEEDSHOWN(id, fn)          DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_NEEDSHOWN,             id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_PAINTED(id, fn)            DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_PAINTED,               id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_USERLISTSELECTION(id, fn)  DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_USERLISTSELECTION,     id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_URIDROPPED(id, fn)         DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_URIDROPPED,            id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_DWELLSTART(id, fn)         DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_DWELLSTART,            id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_DWELLEND(id, fn)           DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_DWELLEND,              id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_START_DRAG(id, fn)         DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_START_DRAG,            id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_DRAG_OVER(id, fn)          DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_DRAG_OVER,             id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_DO_DROP(id, fn)            DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_DO_DROP,               id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_ZOOM(id, fn)               DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_ZOOM,                  id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_HOTSPOT_CLICK(id, fn)      DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_HOTSPOT_CLICK,         id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_HOTSPOT_DCLICK(id, fn)     DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_HOTSPOT_DCLICK,        id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_CALLTIP_CLICK(id, fn)      DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_CALLTIP_CLICK,         id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_AUTOCOMP_SELECTION(id, fn) DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_AUTOCOMP_SELECTION,    id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_INDICATOR_CLICK(id, fn)    DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_INDICATOR_CLICK,       id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_INDICATOR_RELEASE(id, fn)  DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_INDICATOR_RELEASE,     id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_AUTOCOMP_CANCELLED(id, fn)    DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_AUTOCOMP_CANCELLED,    id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_AUTOCOMP_CHAR_DELETED(id, fn) DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_AUTOCOMP_CHAR_DELETED, id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_HOTSPOT_RELEASE_CLICK(id, fn) DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_HOTSPOT_RELEASE_CLICK, id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_CLIPBOARD_COPY(id, fn)        DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_CLIPBOARD_COPY,        id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_CLIPBOARD_PASTE(id, fn)       DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_CLIPBOARD_PASTE,       id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_AUTOCOMP_COMPLETED(id, fn)    DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_AUTOCOMP_COMPLETED,    id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),
#define EVT_SCI_MARGIN_RIGHT_CLICK(id, fn)    DECLARE_EVENT_TABLE_ENTRY( wxEVT_SCI_MARGIN_RIGHT_CLICK,    id, wxID_ANY, wxScintillaEventHandler( fn ), (wxObject *) NULL ),

#endif


//----------------------------------------------------------------------
// Utility functions used within wxScintilla

#if wxUSE_UNICODE

extern wxString sci2wx(const char* str);
extern wxString sci2wx(const char* str, size_t len);
extern wxCharBuffer wx2sci(const wxString& str);

// This function takes both wxString and wxCharBuffer because it uses either
// one or the other of them depending on the build mode. In Unicode it uses the
// length of the already converted buffer to avoid doing the conversion again
// just to compute the length.
inline size_t wx2scilen(const wxString& WXUNUSED(str), const wxCharBuffer& buf)
{
#if wxCHECK_VERSION(3, 0, 0)
    return buf.length();
#else
    return strlen(buf);
#endif // wxCHECK_VERSION
}

#else // not UNICODE

inline wxString sci2wx(const char* str) {
    return wxString(str);
}
inline wxString sci2wx(const char* str, size_t len) {
    return wxString(str, len);
}
inline const char* wx2sci(const wxString& str) {
    return str.mbc_str();
}

// As explained above, the buffer argument is only used in Unicode build.
inline size_t wx2scilen(const wxString& str, const char* WXUNUSED(buf))
{
    return str.length();
}

#endif // UNICODE

#endif // __WXSCINTILLA_H__
