/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.checksum;

import java.security.MessageDigest;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.checksum.CheckSumData;
import org.pentaho.di.trans.steps.checksum.CheckSumMeta;
import org.pentaho.di.trans.steps.checksum.Messages;

public class CheckSum
extends BaseStep
implements StepInterface {
    private CheckSumMeta meta;
    private CheckSumData data;

    public CheckSum(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block12: {
            this.meta = (CheckSumMeta)smi;
            this.data = (CheckSumData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                if (this.meta.getFieldName() == null || this.meta.getFieldName().length > 0) {
                    this.data.fieldnrs = new int[this.meta.getFieldName().length];
                    for (i = 0; i < this.meta.getFieldName().length; ++i) {
                        this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldName()[i]);
                        if (this.data.fieldnrs[i] >= 0) continue;
                        this.logError(Messages.getString("CheckSum.Log.CanNotFindField", this.meta.getFieldName()[i]));
                        throw new KettleException(Messages.getString("CheckSum.Log.CanNotFindField", this.meta.getFieldName()[i]));
                    }
                } else {
                    this.data.fieldnrs = new int[r.length];
                    for (i = 0; i < r.length; ++i) {
                        this.data.fieldnrs[i] = i;
                    }
                }
                this.data.fieldnr = this.data.fieldnrs.length;
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] outputRowData = null;
            try {
                if (this.meta.getCheckSumType().equals("ADLER32") || this.meta.getCheckSumType().equals("CRC32")) {
                    Long checksum = this.calculCheckSum(r);
                    outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)checksum);
                } else {
                    String checksumCode = this.createCheckSum(r);
                    outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)checksumCode);
                }
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("CheckSum.Log.LineNumber", "" + this.getLinesRead()));
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("CheckSum.ErrorInStepRunning") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block12;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "CheckSum001");
            }
        }
        return true;
    }

    private String createCheckSum(Object[] r) throws Exception {
        String retval = null;
        StringBuffer Buff = new StringBuffer();
        for (int i = 0; i < this.data.fieldnr; ++i) {
            String fieldvalue = this.getInputRowMeta().getString(r, this.data.fieldnrs[i]);
            Buff.append(fieldvalue);
        }
        MessageDigest digest = this.meta.getCheckSumType().equals("MD5") ? MessageDigest.getInstance("MD5") : MessageDigest.getInstance("SHA-1");
        digest.update(Buff.toString().getBytes());
        byte[] hash = digest.digest();
        retval = CheckSum.getString(hash);
        return retval;
    }

    private static String getString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    private Long calculCheckSum(Object[] r) throws Exception {
        Long retval;
        StringBuffer Buff = new StringBuffer();
        for (int i = 0; i < this.data.fieldnr; ++i) {
            String fieldvalue = this.getInputRowMeta().getString(r, this.data.fieldnrs[i]);
            Buff.append(fieldvalue);
        }
        if (this.meta.getCheckSumType().equals("CRC32")) {
            CRC32 crc32 = new CRC32();
            crc32.update(Buff.toString().getBytes());
            retval = new Long(crc32.getValue());
        } else {
            Adler32 adler32 = new Adler32();
            adler32.update(Buff.toString().getBytes());
            retval = new Long(adler32.getValue());
        }
        return retval;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CheckSumMeta)smi;
        this.data = (CheckSumData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.log.logError(this.toString(), Messages.getString("CheckSum.Error.ResultFieldMissing"), new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

