#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_hostname
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "network",
}

DOCUMENTATION = """
---
module: junos_hostname
version_added: 2.9.0
short_description: Manage Hostname server configuration on Junos devices.
description: This module manages hostname configuration on devices running Junos.
author: Rohit Thakur (@rohitthakur2590)
requirements:
  - ncclient (>=v0.6.4)
  - xmltodict (>=0.12.0)
notes:
  - This module requires the netconf system service be enabled on the device being managed.
  - This module works with connection C(netconf).
  - See L(the Junos OS Platform Options,https://docs.ansible.com/ansible/latest/network/user_guide/platform_junos.html).
  - Tested against JunOS v18.4R1
options:
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the Junos device
      by executing the command B(show system hostname).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  config:
    description: A dictionary of system Hostname configuration.
    type: dict
    suboptions:
      hostname:
        description: Specify the hostname.
        type: str
  state:
    description:
    - The state the configuration should be left in.
    - The states I(rendered), I(gathered) and I(parsed) does not perform any change
      on the device.
    - The state I(rendered) will transform the configuration in C(config) option to
      platform specific CLI commands which will be returned in the I(rendered) key
      within the result. For state I(rendered) active connection to remote host is
      not required.
    - The states I(merged), I(replaced) and I(overridden) have identical
      behaviour for this module.
    - The state I(gathered) will fetch the running configuration from device and transform
      it into structured data in the format as per the resource module argspec and
      the value is returned in the I(gathered) key within the result.
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into JSON format as per the resource module parameters and the
      value is returned in the I(parsed) key within the result. The value of C(running_config)
      option should be the same format as the output of command
      I(show system hostname) executed on device. For state I(parsed) active
      connection to remote host is not required.
    type: str
    choices:
    - merged
    - replaced
    - deleted
    - overridden
    - parsed
    - gathered
    - rendered
    default: merged
"""
EXAMPLES = """
# Using merged
#
# Before state
# ------------
#
# vagrant@vsrx# show system hostname
#
# [edit]
- name: Merge provided HOSTNAME configuration into running configuration.
  junipernetworks.junos.junos_hostname:
    config:
      hostname: 'vsrx-18.4R1'
    state: merged
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "hostname": "vsrx-18.4R1"
#     },
#     "before": {},
#     "changed": true,
#     "commands": [
#           "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
#           "<nc:host-name>vsrx-18.4R1</nc:host-name></nc:system>"
#     ]
# After state
# -----------
#
# vagrant@vsrx-18.4R1# show system host-name
# host-name vsrx-18.4R1;
#
# Using replaced
#
# Before state
# ------------
#
# vagrant@vsrx-18.4R1# show system host-name
# host-name vsrx-18.4R1;
#
# [edit]
- name: Replaced target config with provided config.
  junipernetworks.junos.junos_hostname:
    config:
      hostname: 'vsrx-12'
    state: replaced
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "hostname": "vsrx-12"
#     },
#     "before": {
#         "hostname": "vsrx-18.4R1"
#     },
#     "changed": true,
#     "commands": [
#           "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
#           "<nc:host-name>vsrx-12</nc:host-name></nc:system>"
#     ]
# After state
# -----------
#
# vagrant@vsrx-18.4R1# show system host-name
# host-name vsrx-12;
#
# Using overridden
#
# Before state
# ------------
#
# vagrant@vsrx-18.4R1# show system host-name
# host-name vsrx-18.4R1;
#
# [edit]
- name: Replaced target config with provided config.
  junipernetworks.junos.junos_hostname:
    config:
      hostname: 'vsrx-12'
    state: overridden
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "hostname": "vsrx-12"
#     },
#     "before": {
#         "hostname": "vsrx-18.4R1"
#     },
#     "changed": true,
#     "commands": [
#           "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
#           "<nc:host-name>vsrx-12</nc:host-name></nc:system>"
#     ]
# After state
# -----------
#
# vagrant@vsrx-18.4R1# show system host-name
# host-name vsrx-12;
#
# Using deleted
#
# Before state
# ------------
#
# vagrant@vsrx-18.4R1# show system host-name
# host-name vsrx-12;
#
- name: Delete running HOSTNAME global configuration
  junipernetworks.junos.junos_hostname:
    config:
    state: deleted
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {},
#     "before": {
#         "hostname": "vsrx-12"
#     },
#     "changed": true,
#     "commands": [
#               "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
#                <nc:host-name delete=\"delete\"/></nc:system>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show system ntp
#
# [edit]
# Using gathered
#
# Before state
# ------------
#
# vagrant@vsrx-18.4R1# show system host-name
# host-name vsrx-12;
#
- name: Gather running HOSTNAME global configuration
  junipernetworks.junos.junos_hostname:
    state: gathered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "gathered": {
#         "hostname": "vsrx-12",
#     },
#     "changed": false,
# Using rendered
#
# Before state
# ------------
#
- name: Render xml for provided facts.
  junipernetworks.junos.junos_hostname:
    config:
      boot_server: '78.46.194.186'
    state: rendered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "rendered": [
#           "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#           "<nc:host-name>78.46.194.186</nc:host-name></nc:system>"
#     ]
#
# Using parsed
# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#     <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#         <version>18.4R1-S2.4</version>
#         <system xmlns="http://yang.juniper.net/junos-es/conf/system">
#            <host-name>vsrx-18.4R1</host-name>
#         </system>
#     </configuration>
# </rpc-reply>
#
- name: Parse HOSTNAME running config
  junipernetworks.junos.junos_hostname:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed":  {
#         "hostname": "vsrx-18.4R1"
#     }
#
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
after:
  description: The resulting configuration model invocation.
  returned: when changed
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['"<nc:host-name>78.46.194.186</nc:host-name></nc:system>"']
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.hostname.hostname import (
    HostnameArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.hostname.hostname import (
    Hostname,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    module = AnsibleModule(
        argument_spec=HostnameArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = Hostname(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
