/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) ^ (- uvec3(36u, 32u, 88u))) => uvec3(4294967288u, 4294967232u, 4294967280u)
 * (uvec3(36u, 32u, 88u) ^ (- uvec3(59u, 77u, 68u))) => uvec3(4294967265u, 4294967187u, 4294967268u)
 * (uvec3(59u, 77u, 68u) ^ (- uvec3(36u, 32u, 88u))) => uvec3(4294967271u, 4294967213u, 4294967276u)
 * (uvec3(59u, 77u, 68u) ^ (- uvec3(59u, 77u, 68u))) => uvec3(4294967294u, 4294967294u, 4294967288u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) ^ (- uvec3(36u, 32u, 88u))), uvec3(4294967288u, 4294967232u, 4294967280u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (- uvec3(59u, 77u, 68u))), uvec3(4294967265u, 4294967187u, 4294967268u))) ? 1 : -1] array1;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (- uvec3(36u, 32u, 88u))), uvec3(4294967271u, 4294967213u, 4294967276u))) ? 1 : -1] array2;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (- uvec3(59u, 77u, 68u))), uvec3(4294967294u, 4294967294u, 4294967288u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
