/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.transports.JingleTransportManager;

public final class JingleTransportMethodManager
extends Manager {
    private static final WeakHashMap<XMPPConnection, JingleTransportMethodManager> INSTANCES = new WeakHashMap();
    private final HashMap<String, JingleTransportManager<?>> transportManagers = new HashMap();
    private static final String[] transportPreference = new String[]{"urn:xmpp:jingle:transports:s5b:1", "urn:xmpp:jingle:transports:ibb:1"};

    private JingleTransportMethodManager(XMPPConnection connection) {
        super(connection);
    }

    public static synchronized JingleTransportMethodManager getInstanceFor(XMPPConnection connection) {
        JingleTransportMethodManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new JingleTransportMethodManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public void registerTransportManager(JingleTransportManager<?> manager) {
        this.transportManagers.put(manager.getNamespace(), manager);
    }

    public static JingleTransportManager<?> getTransportManager(XMPPConnection connection, String namespace) {
        return JingleTransportMethodManager.getInstanceFor(connection).getTransportManager(namespace);
    }

    public JingleTransportManager<?> getTransportManager(String namespace) {
        return this.transportManagers.get(namespace);
    }

    public static JingleTransportManager<?> getTransportManager(XMPPConnection connection, Jingle request) {
        return JingleTransportMethodManager.getInstanceFor(connection).getTransportManager(request);
    }

    public JingleTransportManager<?> getTransportManager(Jingle request) {
        JingleContent content2 = request.getContents().get(0);
        if (content2 == null) {
            return null;
        }
        JingleContentTransport transport = content2.getTransport();
        if (transport == null) {
            return null;
        }
        return this.getTransportManager(transport.getNamespace());
    }

    public static JingleTransportManager<?> getBestAvailableTransportManager(XMPPConnection connection) {
        return JingleTransportMethodManager.getInstanceFor(connection).getBestAvailableTransportManager();
    }

    public JingleTransportManager<?> getBestAvailableTransportManager() {
        for (String ns : transportPreference) {
            JingleTransportManager<?> tm = this.getTransportManager(ns);
            if (tm == null) continue;
            return tm;
        }
        Iterator<String> it = this.transportManagers.keySet().iterator();
        if (it.hasNext()) {
            return this.getTransportManager(it.next());
        }
        return null;
    }

    public JingleTransportManager<?> getBestAvailableTransportManager(Set<String> except) {
        for (String ns : transportPreference) {
            JingleTransportManager<?> tm = this.getTransportManager(ns);
            if (tm == null || except.contains(tm.getNamespace())) continue;
            return tm;
        }
        for (String ns : this.transportManagers.keySet()) {
            if (except.contains(ns)) continue;
            return this.getTransportManager(ns);
        }
        return null;
    }
}

