/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

public final class EqualsUtil {
    private EqualsUtil() {
    }

    public static <T> boolean equals(T thisObject, Object other, EqualsComperator<T> equalsComperator) {
        int otherHashCode;
        if (other == null) {
            return false;
        }
        if (thisObject == other) {
            return true;
        }
        Class<?> thisObjectClass = thisObject.getClass();
        if (thisObjectClass != other.getClass()) {
            return false;
        }
        int thisHashCode = thisObject.hashCode();
        if (thisHashCode != (otherHashCode = other.hashCode())) {
            return false;
        }
        Builder equalsBuilder = new Builder();
        equalsComperator.compare(equalsBuilder, thisObjectClass.cast(other));
        return equalsBuilder.isEquals;
    }

    public static final class Builder {
        private boolean isEquals = true;

        private Builder() {
        }

        private void nullSafeCompare(Object left2, Object right, Runnable runnable) {
            if (!this.isEquals) {
                return;
            }
            if (left2 == right) {
                return;
            }
            if (left2 == null || right == null) {
                this.isEquals = false;
                return;
            }
            runnable.run();
        }

        public <O> Builder append(O left2, O right) {
            if (!this.isEquals) {
                return this;
            }
            if (left2 == right) {
                return this;
            }
            if (left2 == null || right == null) {
                this.isEquals = false;
                return this;
            }
            this.isEquals = left2.equals(right);
            return this;
        }

        public Builder append(boolean left2, boolean right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left2 == right;
            return this;
        }

        public Builder append(boolean[] left2, boolean[] right) {
            this.nullSafeCompare(left2, right, () -> {
                if (left2.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left2.length && this.isEquals; ++i) {
                    this.append(left2[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(byte left2, byte right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left2 == right;
            return this;
        }

        public Builder append(byte[] left2, byte[] right) {
            this.nullSafeCompare(left2, right, () -> {
                if (left2.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left2.length && this.isEquals; ++i) {
                    this.append(left2[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(char left2, char right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left2 == right;
            return this;
        }

        public Builder append(char[] left2, char[] right) {
            this.nullSafeCompare(left2, right, () -> {
                if (left2.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left2.length && this.isEquals; ++i) {
                    this.append(left2[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(double left2, double right) {
            if (!this.isEquals) {
                return this;
            }
            return this.append(Double.doubleToLongBits(left2), Double.doubleToLongBits(right));
        }

        public Builder append(double[] left2, double[] right) {
            this.nullSafeCompare(left2, right, () -> {
                if (left2.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left2.length && this.isEquals; ++i) {
                    this.append(left2[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(float left2, float right) {
            if (!this.isEquals) {
                return this;
            }
            return this.append(Float.floatToIntBits(left2), Float.floatToIntBits(right));
        }

        public Builder append(float[] left2, float[] right) {
            this.nullSafeCompare(left2, right, () -> {
                if (left2.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left2.length && this.isEquals; ++i) {
                    this.append(left2[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(int left2, int right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left2 == right;
            return this;
        }

        public Builder append(int[] left2, int[] right) {
            this.nullSafeCompare(left2, right, () -> {
                if (left2.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left2.length && this.isEquals; ++i) {
                    this.append(left2[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(long left2, long right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left2 == right;
            return this;
        }

        public Builder append(long[] left2, long[] right) {
            this.nullSafeCompare(left2, right, () -> {
                if (left2.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left2.length && this.isEquals; ++i) {
                    this.append(left2[i], right[i]);
                }
            });
            return this;
        }
    }

    @FunctionalInterface
    public static interface EqualsComperator<T> {
        public void compare(Builder var1, T var2);
    }
}

