# Orca
#
# Copyright 2014 Igalia, S.L.
#
# Author: Joanmarie Diggs <jdiggs@igalia.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., Franklin Street, Fifth Floor,
# Boston MA  02110-1301 USA.

__id__        = "$Id$"
__version__   = "$Revision$"
__date__      = "$Date$"
__copyright__ = "Copyright (c) 2014 Igalia, S.L."
__license__   = "LGPL"

from .orca_i18n import C_

cssNames = {}

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f0f8ff"] = C_("color name", "alice blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#faebd7"] = C_("color name", "antique white")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#7fffd4"] = C_("color name", "aquamarine")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f0ffff"] = C_("color name", "azure")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f5f5dc"] = C_("color name", "beige")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffe4c4"] = C_("color name", "bisque")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#000000"] = C_("color name", "black")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffebcd"] = C_("color name", "blanched almond")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#0000ff"] = C_("color name", "blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#8a2be2"] = C_("color name", "blue violet")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#a52a2a"] = C_("color name", "brown")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#deb887"] = C_("color name", "burlywood")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#5f9ea0"] = C_("color name", "cadet blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#7fff00"] = C_("color name", "chartreuse")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#d2691e"] = C_("color name", "chocolate")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff7f50"] = C_("color name", "coral")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#6495ed"] = C_("color name", "cornflower blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fff8dc"] = C_("color name", "cornsilk")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#dc143c"] = C_("color name", "crimson")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#00ffff"] = C_("color name", "cyan")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#00008b"] = C_("color name", "dark blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#008b8b"] = C_("color name", "dark cyan")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#b8860b"] = C_("color name", "dark goldenrod")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#a9a9a9"] = C_("color name", "dark gray")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#006400"] = C_("color name", "dark green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#bdb76b"] = C_("color name", "dark khaki")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#8b008b"] = C_("color name", "dark magenta")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#556b2f"] = C_("color name", "dark olive green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff8c00"] = C_("color name", "dark orange")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#9932cc"] = C_("color name", "dark orchid")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#8b0000"] = C_("color name", "dark red")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#e9967a"] = C_("color name", "dark salmon")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#8fbc8f"] = C_("color name", "dark sea green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#483d8b"] = C_("color name", "dark slate blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#2f4f4f"] = C_("color name", "dark slate gray")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#00ced1"] = C_("color name", "dark turquoise")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#9400d3"] = C_("color name", "dark violet")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff1493"] = C_("color name", "deep pink")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#00bfff"] = C_("color name", "deep sky blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#696969"] = C_("color name", "dim gray")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#1e90ff"] = C_("color name", "dodger blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#b22222"] = C_("color name", "fire brick")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fffaf0"] = C_("color name", "floral white")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#228b22"] = C_("color name", "forest green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff00ff"] = C_("color name", "fuchsia")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#dcdcdc"] = C_("color name", "gainsboro")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#HTML_color_names.
cssNames["#f8f8ff"] = C_("color name", "ghost white")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffd700"] = C_("color name", "gold")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#daa520"] = C_("color name", "goldenrod")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#808080"] = C_("color name", "gray")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#008000"] = C_("color name", "green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#adff2f"] = C_("color name", "green yellow")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f0fff0"] = C_("color name", "honeydew")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff69b4"] = C_("color name", "hot pink")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#cd5c5c"] = C_("color name", "indian red")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#4b0082"] = C_("color name", "indigo")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fffff0"] = C_("color name", "ivory")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f0e68c"] = C_("color name", "khaki")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#e6e6fa"] = C_("color name", "lavender")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fff0f5"] = C_("color name", "lavender blush")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#7cfc00"] = C_("color name", "lawn green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fffacd"] = C_("color name", "lemon chiffon")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#add8e6"] = C_("color name", "light blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f08080"] = C_("color name", "light coral")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#e0ffff"] = C_("color name", "light cyan")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fafad2"] = C_("color name", "light goldenrod yellow")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#d3d3d3"] = C_("color name", "light gray")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#90ee90"] = C_("color name", "light green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffb6c1"] = C_("color name", "light pink")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffa07a"] = C_("color name", "light salmon")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#20b2aa"] = C_("color name", "light sea green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#87cefa"] = C_("color name", "light sky blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#778899"] = C_("color name", "light slate gray")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#b0c4de"] = C_("color name", "light steel blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffffe0"] = C_("color name", "light yellow")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#00ff00"] = C_("color name", "lime")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#32cd32"] = C_("color name", "lime green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#faf0e6"] = C_("color name", "linen")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff00ff"] = C_("color name", "magenta")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#800000"] = C_("color name", "maroon")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#66cdaa"] = C_("color name", "medium aquamarine")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#0000cd"] = C_("color name", "medium blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ba55d3"] = C_("color name", "medium orchid")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#9370d8"] = C_("color name", "medium purple")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#3cb371"] = C_("color name", "medium sea green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#7b68ee"] = C_("color name", "medium slate blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#00fa9a"] = C_("color name", "medium spring green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#48d1cc"] = C_("color name", "medium turquoise")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#c71585"] = C_("color name", "medium violet red")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#191970"] = C_("color name", "midnight blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f5fffa"] = C_("color name", "mint cream")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffe4e1"] = C_("color name", "misty rose")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffe4b5"] = C_("color name", "moccasin")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffdead"] = C_("color name", "navajo white")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#000080"] = C_("color name", "navy")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fdf5e6"] = C_("color name", "old lace")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#808000"] = C_("color name", "olive")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#6b8e23"] = C_("color name", "olive drab")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffa500"] = C_("color name", "orange")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff4500"] = C_("color name", "orange red")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#da70d6"] = C_("color name", "orchid")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#eee8aa"] = C_("color name", "pale goldenrod")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#98fb98"] = C_("color name", "pale green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#afeeee"] = C_("color name", "pale turquoise")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#d87093"] = C_("color name", "pale violet red")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffefd5"] = C_("color name", "papaya whip")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffdab9"] = C_("color name", "peach puff")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#cd853f"] = C_("color name", "peru")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffc0cb"] = C_("color name", "pink")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#dda0dd"] = C_("color name", "plum")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#b0e0e6"] = C_("color name", "powder blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#800080"] = C_("color name", "purple")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff0000"] = C_("color name", "red")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#bc8f8f"] = C_("color name", "rosy brown")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#4169e1"] = C_("color name", "royal blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#8b4513"] = C_("color name", "saddle brown")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fa8072"] = C_("color name", "salmon")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f4a460"] = C_("color name", "sandy brown")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#2e8b57"] = C_("color name", "sea green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fff5ee"] = C_("color name", "seashell")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#a0522d"] = C_("color name", "sienna")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#c0c0c0"] = C_("color name", "silver")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#87ceeb"] = C_("color name", "sky blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#6a5acd"] = C_("color name", "slate blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#708090"] = C_("color name", "slate gray")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#fffafa"] = C_("color name", "snow")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#00ff7f"] = C_("color name", "spring green")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#4682b4"] = C_("color name", "steel blue")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#d2b48c"] = C_("color name", "tan")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#008080"] = C_("color name", "teal")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#d8bfd8"] = C_("color name", "thistle")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ff6347"] = C_("color name", "tomato")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#40e0d0"] = C_("color name", "turquoise")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ee82ee"] = C_("color name", "violet")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f5deb3"] = C_("color name", "wheat")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffffff"] = C_("color name", "white")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#f5f5f5"] = C_("color name", "white smoke")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#ffff00"] = C_("color name", "yellow")

# Translators: This refers to a CSS color name. The name, hex value, and color
# can be found at http://www.w3schools.com/cssref/css_colornames.asp and at
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names.
cssNames["#9acd32"] = C_("color name", "yellow green")

def rgbToName(red, green, blue):
    """Returns the localized name for the RGB value."""

    hexString = f'#{red:02x}{green:02x}{blue:02x}'
    cssName = cssNames.get(hexString)
    if cssName:
        return cssName

    # Find the closest match.
    colors = {}
    for key, value in cssNames.items():
        r, g, b = [int(s, 16) for s in (key[1:3], key[3:5], key[5:7])]
        rd = abs(r - red) ** 2
        gd = abs(g - green) ** 2
        bd = abs(b - blue) ** 2
        colors[(rd + gd + bd)] = key

    # Hold black and white to higher standards than the other close colors.
    d1 = min(colors.keys())
    match = colors.pop(d1)
    if match not in ["#000000", "#ffffff"]:
        return cssNames.get(match)

    d2 = min(colors.keys())
    if d2 - d1 < d1:
        match = colors.pop(d2)

    return cssNames.get(match)
