"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _http = require("http");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class OpensearchService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    // TODO: This will be deprecated as we do not want to support accessing alerting indices directly
    //  and that is what this is used for
    _defineProperty(this, "search", async (context, req, res) => {
      try {
        const {
          query,
          index,
          size
        } = req.body;
        const params = {
          index,
          size,
          body: query
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const results = await client('search', params);
        return res.ok({
          body: {
            ok: true,
            resp: results
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - search', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getIndices", async (context, req, res) => {
      try {
        const {
          index
        } = req.body;
        const client = this.getClientBasedOnDataSource(context, req);
        const indices = await client('cat.indices', {
          index,
          format: 'json',
          h: 'health,index,status'
        });
        return res.ok({
          body: {
            ok: true,
            resp: indices
          }
        });
      } catch (err) {
        // Opensearch throws an index_not_found_exception which we'll treat as a success
        if (err.statusCode === 404) {
          return res.ok({
            body: {
              ok: true,
              resp: []
            }
          });
        } else {
          console.error('Alerting - OpensearchService - getIndices:', err);
          return res.ok({
            body: {
              ok: false,
              resp: err.message
            }
          });
        }
      }
    });
    _defineProperty(this, "getAliases", async (context, req, res) => {
      try {
        const {
          alias
        } = req.body;
        const client = this.getClientBasedOnDataSource(context, req);
        const aliases = await client('cat.aliases', {
          alias,
          format: 'json',
          h: 'alias,index'
        });
        return res.ok({
          body: {
            ok: true,
            resp: aliases
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getAliases:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getClusterHealth", async (context, req, res) => {
      try {
        const client = this.getClientBasedOnDataSource(context, req);
        const health = await client('cat.health', {
          format: 'json',
          h: 'cluster,status'
        });
        return res.ok({
          body: {
            ok: true,
            resp: health
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getClusterHealth:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getMappings", async (context, req, res) => {
      try {
        const {
          index
        } = req.body;
        const client = this.getClientBasedOnDataSource(context, req);
        const mappings = await client('indices.getMapping', {
          index
        });
        return res.ok({
          body: {
            ok: true,
            resp: mappings
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getMappings:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getPlugins", async (context, req, res) => {
      try {
        const client = this.getClientBasedOnDataSource(context, req);
        const plugins = await client('cat.plugins', {
          format: 'json',
          h: 'component'
        });
        return res.ok({
          body: {
            ok: true,
            resp: plugins
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getPlugins:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getSettings", async (context, req, res) => {
      try {
        const client = this.getClientBasedOnDataSource(context, req);
        const settings = await client('cluster.getSettings', {
          include_defaults: 'true'
        });
        return res.ok({
          body: {
            ok: true,
            resp: settings
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getSettings:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
  }
}
exports.default = OpensearchService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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