"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    anomalyDetectorService
  } = services;
  router.get({
    path: '/api/alerting/detectors/{detectorId}',
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, anomalyDetectorService.getDetector);
  router.post({
    path: '/api/alerting/detectors/_search',
    validate: false
  }, anomalyDetectorService.getDetectors);
  router.get({
    path: '/api/alerting/detectors/{detectorId}/results',
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, anomalyDetectorService.getDetectorResults);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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