"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiErrorBoundary", {
  enumerable: true,
  get: function get() {
    return _error_boundary.EuiErrorBoundary;
  }
});
exports.OuiErrorBoundary = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _text = require("../text");

var _error_boundary = require("../../eui_components/error_boundary/error_boundary");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } } /*
                                                                                                                                                                                                                                                                                                                                      * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                                      * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                                      * compatible open source license.
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                                      * GitHub history for details.
                                                                                                                                                                                                                                                                                                                                      */ /*
                                                                                                                                                                                                                                                                                                                                          * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                          * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                          * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                          * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                          * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                          * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                          * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                          * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                          * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                          * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                          * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                          * under the License.
                                                                                                                                                                                                                                                                                                                                          */

var OuiErrorBoundary = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(OuiErrorBoundary, _Component);

  var _super = _createSuper(OuiErrorBoundary);

  function OuiErrorBoundary(props) {
    var _this;

    (0, _classCallCheck2.default)(this, OuiErrorBoundary);
    _this = _super.call(this, props);
    var errorState = {
      hasError: false,
      error: undefined
    };
    _this.state = errorState;
    return _this;
  }

  (0, _createClass2.default)(OuiErrorBoundary, [{
    key: "componentDidCatch",
    value: function componentDidCatch(_ref) {
      var message = _ref.message,
          stack = _ref.stack;
      // Display fallback UI
      // Only Chrome includes the `message` property as part of `stack`.
      // For consistency, rebuild the full error text from the Error subparts.
      var idx = (stack === null || stack === void 0 ? void 0 : stack.indexOf(message)) || -1;
      var stackStr = idx > -1 ? stack === null || stack === void 0 ? void 0 : stack.substr(idx + message.length + 1) : stack;
      var error = "Error: ".concat(message, "\n").concat(stackStr);
      this.setState({
        hasError: true,
        error: error
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["children"]);

      if (this.state.hasError) {
        // You can render any custom fallback UI
        return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
          className: "ouiErrorBoundary"
        }, rest), /*#__PURE__*/_react.default.createElement("div", {
          className: "ouiErrorBoundary__text"
        }, /*#__PURE__*/_react.default.createElement(_text.OuiText, {
          size: "xs"
        }, /*#__PURE__*/_react.default.createElement("h1", null, "Error"), /*#__PURE__*/_react.default.createElement("pre", {
          className: "ouiErrorBoundary__stack"
        }, /*#__PURE__*/_react.default.createElement("p", null, this.state.error)))));
      }

      return children;
    }
  }]);
  return OuiErrorBoundary;
}(_react.Component);
/* OUI -> EUI Aliases: Build-Time */


exports.OuiErrorBoundary = OuiErrorBoundary;
(0, _defineProperty2.default)(OuiErrorBoundary, "propTypes", {
  children: _propTypes.default.node
});
OuiErrorBoundary.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * ReactNode to render as this component's content
       */
  children: _propTypes.default.node.isRequired
};
/* OUI -> EUI Aliases: Build-Time */