/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.common.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.openhab.core.common.registry.Registry;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractRegistry<@NonNull E extends Identifiable<K>, @NonNull K, @NonNull P extends Provider<E>>
implements ProviderChangeListener<E>,
Registry<E, K> {
    private final Logger logger = LoggerFactory.getLogger(AbstractRegistry.class);
    private final @Nullable Class<P> providerClazz;
    private @Nullable CompletableFuture<ServiceTracker<P, P>> providerTrackerFuture;
    private final ReentrantReadWriteLock elementLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock elementReadLock = this.elementLock.readLock();
    private final ReentrantReadWriteLock.WriteLock elementWriteLock = this.elementLock.writeLock();
    private final Map<Provider<E>, Collection<E>> providerToElements = new HashMap<Provider<E>, Collection<E>>();
    private final Map<E, Provider<E>> elementToProvider = new HashMap<E, Provider<E>>();
    private final Map<K, E> identifierToElement = new HashMap<K, E>();
    private final Set<E> elements = new HashSet();
    private final Collection<RegistryChangeListener<E>> listeners = new CopyOnWriteArraySet<RegistryChangeListener<E>>();
    private Optional<ManagedProvider<E, K>> managedProvider = Optional.empty();
    private @Nullable EventPublisher eventPublisher;
    private @Nullable ReadyService readyService;

    protected AbstractRegistry(@Nullable Class<P> providerClazz) {
        this.providerClazz = providerClazz;
    }

    protected void activate(BundleContext context) {
        if (this.providerClazz != null) {
            Class<P> providerClazz = this.providerClazz;
            this.providerTrackerFuture = CompletableFuture.supplyAsync(() -> {
                ProviderTracker providerTracker = new ProviderTracker(context, providerClazz);
                providerTracker.open();
                return providerTracker;
            });
        }
    }

    protected void deactivate() {
        CompletableFuture<ServiceTracker<P, P>> future = this.providerTrackerFuture;
        if (future != null) {
            future.join().close();
        }
    }

    public void waitForCompletedAsyncActivationTasks() {
        CompletableFuture<ServiceTracker<P, P>> future = this.providerTrackerFuture;
        if (future != null) {
            future.join();
        }
    }

    @Override
    public void added(Provider<E> provider, E element) {
        this.elementWriteLock.lock();
        try {
            Collection<E> providerElements = this.providerToElements.get(provider);
            if (providerElements == null) {
                this.logger.debug("Cannot add \"{}\" with key \"{}\". Provider \"{}\" unknown.", new Object[]{element.getClass().getSimpleName(), element.getUID(), provider.getClass().getSimpleName()});
                return;
            }
            if (!this.added(provider, element, providerElements)) {
                return;
            }
        }
        finally {
            this.elementWriteLock.unlock();
        }
        this.notifyListenersAboutAddedElement(element);
    }

    private boolean added(Provider<E> provider, E element, Collection<E> providerElements) {
        Object uid = element.getUID();
        @Nullable Identifiable existingElement = (Identifiable)this.identifierToElement.get(uid);
        if (existingElement != null) {
            Provider<E> existingElementProvider = this.elementToProvider.get(existingElement);
            this.logger.debug("Cannot add \"{}\" with key \"{}\". It exists already from provider \"{}\"! Failed to add a second with the same UID from provider \"{}\"!", new Object[]{element.getClass().getSimpleName(), uid, existingElementProvider != null ? existingElementProvider.getClass().getSimpleName() : null, provider.getClass().getSimpleName()});
            return false;
        }
        try {
            this.onAddElement(element);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Cannot add \"{}\" with key \"{}\": {}", new Object[]{element.getClass().getSimpleName(), uid, ex.getMessage(), ex});
            return false;
        }
        this.identifierToElement.put(element.getUID(), element);
        this.elementToProvider.put(element, provider);
        providerElements.add(element);
        this.elements.add(element);
        return true;
    }

    @Override
    public void addRegistryChangeListener(RegistryChangeListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public Collection<E> getAll() {
        this.elementReadLock.lock();
        try {
            HashSet<E> hashSet = new HashSet<E>(this.elements);
            return hashSet;
        }
        finally {
            this.elementReadLock.unlock();
        }
    }

    @Override
    public Stream<E> stream() {
        return this.getAll().stream();
    }

    @Override
    public void removed(Provider<E> provider, E element) {
        Identifiable existingElement;
        this.elementWriteLock.lock();
        try {
            Object uid = element.getUID();
            existingElement = (Identifiable)this.identifierToElement.get(uid);
            if (existingElement == null) {
                this.logger.debug("Cannot remove \"{}\" with key \"{}\" from provider \"{}\" because it does not exist!", new Object[]{element.getClass().getSimpleName(), uid, provider.getClass().getSimpleName()});
                return;
            }
            Provider<E> elementProvider = this.elementToProvider.get(existingElement);
            if (elementProvider != null && !elementProvider.equals(provider)) {
                this.logger.error("Provider '{}' is not allowed to remove element '{}' with key '{}' from the registry because it was added by provider '{}'.", new Object[]{provider.getClass().getSimpleName(), element.getClass().getSimpleName(), uid, elementProvider.getClass().getSimpleName()});
                return;
            }
            try {
                this.onRemoveElement(existingElement);
            }
            catch (RuntimeException ex) {
                this.logger.warn("Cannot remove \"{}\" with key \"{}\": {}", new Object[]{element.getClass().getSimpleName(), uid, ex.getMessage(), ex});
                this.elementWriteLock.unlock();
                return;
            }
            this.identifierToElement.remove(uid);
            this.elementToProvider.remove(existingElement);
            Collection<E> providerElements = this.providerToElements.get(provider);
            if (providerElements != null) {
                providerElements.remove(existingElement);
            }
            this.elements.remove(existingElement);
        }
        finally {
            this.elementWriteLock.unlock();
        }
        this.notifyListenersAboutRemovedElement(existingElement);
    }

    @Override
    public void removeRegistryChangeListener(RegistryChangeListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void updated(Provider<E> provider, E oldElement, E element) {
        Object uid;
        Object uidOld = oldElement.getUID();
        if (!uidOld.equals(uid = element.getUID())) {
            this.logger.debug("Received update event for elements that UID differ (old: \"{}\", new: \"{}\"). Ignore event.", uidOld, uid);
            return;
        }
        this.elementWriteLock.lock();
        try {
            @Nullable Identifiable existingElement = (Identifiable)this.identifierToElement.get(uid);
            if (existingElement == null) {
                this.logger.debug("Cannot update \"{}\" with key \"{}\" for provider \"{}\" because it does not exist!", new Object[]{element.getClass().getSimpleName(), uid, provider.getClass().getSimpleName()});
                return;
            }
            try {
                this.beforeUpdateElement(existingElement);
                this.onUpdateElement(oldElement, element);
            }
            catch (RuntimeException ex) {
                this.logger.warn("Cannot update \"{}\" with key \"{}\": {}", new Object[]{element.getClass().getSimpleName(), uid, ex.getMessage(), ex});
                this.elementWriteLock.unlock();
                return;
            }
            this.identifierToElement.put(uid, element);
            this.elementToProvider.remove(existingElement);
            this.elementToProvider.put(element, provider);
            Collection<E> providerElements = this.providerToElements.get(provider);
            if (providerElements != null) {
                providerElements.remove(existingElement);
                providerElements.add(element);
            }
            this.elements.remove(existingElement);
            this.elements.add(element);
        }
        finally {
            this.elementWriteLock.unlock();
        }
        this.notifyListenersAboutUpdatedElement(oldElement, element);
    }

    @Override
    public @Nullable E get(K key) {
        this.elementReadLock.lock();
        try {
            Identifiable identifiable = (Identifiable)this.identifierToElement.get(key);
            return (E)identifiable;
        }
        finally {
            this.elementReadLock.unlock();
        }
    }

    protected @Nullable Map.Entry<Provider<E>, E> getValueAndProvider(K key) {
        this.elementReadLock.lock();
        try {
            @Nullable Identifiable element = (Identifiable)this.identifierToElement.get(key);
            Provider<E> provider = this.elementToProvider.get(element);
            Map.Entry<Provider<E>, Identifiable> entry = element == null || provider == null ? null : Map.entry(provider, element);
            return entry;
        }
        finally {
            this.elementReadLock.unlock();
        }
    }

    @Override
    public E add(E element) {
        this.managedProvider.orElseThrow(() -> new IllegalStateException("ManagedProvider is not available")).add(element);
        return element;
    }

    @Override
    public @Nullable E update(E element) {
        return this.managedProvider.orElseThrow(() -> new IllegalStateException("ManagedProvider is not available")).update(element);
    }

    @Override
    public @Nullable E remove(K key) {
        return this.managedProvider.orElseThrow(() -> new IllegalStateException("ManagedProvider is not available")).remove(key);
    }

    protected void notifyListeners(E element, EventType eventType) {
        for (RegistryChangeListener<E> listener : this.listeners) {
            try {
                switch (eventType) {
                    case ADDED: {
                        listener.added(element);
                        break;
                    }
                    case REMOVED: {
                        listener.removed(element);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                this.logger.error("Cannot inform the listener \"{}\" about the \"{}\" event: {}", new Object[]{listener, eventType.name(), throwable.getMessage(), throwable});
            }
        }
    }

    protected void notifyListeners(E oldElement, E element, EventType eventType) {
        for (RegistryChangeListener<E> listener : this.listeners) {
            try {
                switch (eventType) {
                    case UPDATED: {
                        listener.updated(oldElement, element);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                this.logger.error("Cannot inform the listener \"{}\" about the \"{}\" event: {}", new Object[]{listener, eventType.name(), throwable.getMessage(), throwable});
            }
        }
    }

    protected void notifyListenersAboutAddedElement(E element) {
        this.notifyListeners(element, EventType.ADDED);
    }

    protected void notifyListenersAboutRemovedElement(E element) {
        this.notifyListeners(element, EventType.REMOVED);
    }

    protected void notifyListenersAboutUpdatedElement(E oldElement, E element) {
        this.notifyListeners(oldElement, element, EventType.UPDATED);
    }

    protected void addProvider(Provider<E> provider) {
        Collection<E> elementsOfAddedProvider = provider.getAll();
        HashSet<Identifiable> elementsAdded = new HashSet<Identifiable>(elementsOfAddedProvider.size());
        this.elementWriteLock.lock();
        try {
            if (this.providerToElements.get(provider) != null) {
                this.logger.warn("Cannot add provider \"{}\" because it already exists.", (Object)provider.getClass().getSimpleName());
                return;
            }
            provider.addProviderChangeListener(this);
            HashSet providerElements = new HashSet();
            this.providerToElements.put(provider, providerElements);
            for (Identifiable element : elementsOfAddedProvider) {
                if (!this.added(provider, element, providerElements)) continue;
                elementsAdded.add(element);
            }
        }
        finally {
            this.elementWriteLock.unlock();
        }
        elementsAdded.forEach(this::notifyListenersAboutAddedElement);
        if (provider instanceof ManagedProvider && this.providerClazz != null && this.readyService != null) {
            this.readyService.markReady(new ReadyMarker("managed", this.providerClazz.getSimpleName().replace("Provider", "").toLowerCase()));
        }
        this.logger.debug("Provider \"{}\" has been added.", (Object)provider.getClass().getName());
    }

    protected @Nullable Provider<E> getProvider(K key) {
        this.elementReadLock.lock();
        try {
            @Nullable Identifiable element = (Identifiable)this.identifierToElement.get(key);
            Provider<E> provider = element == null ? null : this.elementToProvider.get(element);
            return provider;
        }
        finally {
            this.elementReadLock.unlock();
        }
    }

    public @Nullable Provider<E> getProvider(E element) {
        this.elementReadLock.lock();
        try {
            Provider<E> provider = this.elementToProvider.get(element);
            return provider;
        }
        finally {
            this.elementReadLock.unlock();
        }
    }

    protected void forEach(Provider<E> provider, Consumer<E> consumer) {
        this.elementReadLock.lock();
        try {
            Collection<E> providerElements = this.providerToElements.get(provider);
            if (providerElements != null) {
                providerElements.forEach(consumer);
            }
        }
        finally {
            this.elementReadLock.unlock();
        }
    }

    protected void forEach(Consumer<E> consumer) {
        this.elementReadLock.lock();
        try {
            this.elements.forEach(consumer);
        }
        finally {
            this.elementReadLock.unlock();
        }
    }

    protected void forEach(BiConsumer<Provider<E>, E> consumer) {
        this.elementReadLock.lock();
        try {
            for (Map.Entry<Provider<E>, Collection<E>> providerEntries : this.providerToElements.entrySet()) {
                Provider provider = providerEntries.getKey();
                providerEntries.getValue().forEach((? super T element) -> consumer.accept(provider, element));
            }
        }
        finally {
            this.elementReadLock.unlock();
        }
    }

    protected Optional<ManagedProvider<E, K>> getManagedProvider() {
        return this.managedProvider;
    }

    protected void setManagedProvider(ManagedProvider<E, K> provider) {
        this.managedProvider = Optional.ofNullable(provider);
    }

    protected void unsetManagedProvider(ManagedProvider<E, K> provider) {
        if (this.managedProvider.isPresent() && this.managedProvider.get().equals(provider)) {
            this.managedProvider = Optional.empty();
        }
    }

    protected void onAddElement(E element) throws IllegalArgumentException {
    }

    protected void onRemoveElement(E element) {
    }

    protected void beforeUpdateElement(E existingElement) {
    }

    protected void onUpdateElement(E oldElement, E element) throws IllegalArgumentException {
    }

    protected void removeProvider(Provider<E> provider) {
        LinkedList<Identifiable> removedElements = new LinkedList<Identifiable>();
        this.elementWriteLock.lock();
        try {
            Collection<E> providerElements = this.providerToElements.remove(provider);
            if (providerElements == null) {
                this.logger.warn("Cannot remove provider \"{}\" because it is unknown.", (Object)provider.getClass().getSimpleName());
                return;
            }
            for (Identifiable element : providerElements) {
                try {
                    this.onRemoveElement(element);
                }
                catch (RuntimeException ex) {
                    this.logger.warn("Removal of \"{}\" with key \"{}\" should be prevented but we need to remove the element as the provider \"{}\" is gone: {}", new Object[]{element.getClass().getSimpleName(), element.getUID(), provider.getClass().getSimpleName(), ex.getMessage(), ex});
                }
                removedElements.add(element);
                this.elements.remove(element);
                this.elementToProvider.remove(element);
                this.identifierToElement.remove(element.getUID());
            }
        }
        finally {
            this.elementWriteLock.unlock();
        }
        removedElements.forEach(this::notifyListenersAboutRemovedElement);
        provider.removeProviderChangeListener(this);
        this.logger.debug("Provider \"{}\" has been removed.", (Object)provider.getClass().getSimpleName());
    }

    protected @Nullable EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void setReadyService(ReadyService readyService) {
        this.readyService = readyService;
    }

    protected void unsetReadyService(ReadyService readyService) {
        this.readyService = null;
    }

    protected void postEvent(Event event) {
        if (this.eventPublisher != null) {
            try {
                this.eventPublisher.post(event);
            }
            catch (RuntimeException ex) {
                this.logger.error("Cannot post event of type \"{}\".", (Object)event.getType(), (Object)ex);
            }
        }
    }

    private static enum EventType {
        ADDED,
        REMOVED,
        UPDATED;

    }

    private final class ProviderTracker
    extends ServiceTracker<P, P> {
        private final BundleContext context;

        public ProviderTracker(BundleContext context, Class<P> providerClazz) {
            super(context, providerClazz.getName(), null);
            this.context = context;
        }

        public P addingService(@Nullable ServiceReference<P> reference) {
            Provider service = (Provider)this.context.getService(reference);
            AbstractRegistry.this.addProvider(service);
            return service;
        }

        public void removedService(@Nullable ServiceReference<P> reference, P service) {
            AbstractRegistry.this.removeProvider(service);
        }
    }
}

