/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.PreferencesPanel;

public class PreferencesPanelService {
    protected static final PreferencesPanelService PREFERENCES_PANEL_SERVICE = new PreferencesPanelService();
    protected final Collection<PreferencesPanel> providers;

    public static PreferencesPanelService getInstance() {
        return PREFERENCES_PANEL_SERVICE;
    }

    protected PreferencesPanelService() {
        Collection<PreferencesPanel> list = ExtensionService.getInstance().load(PreferencesPanel.class);
        Iterator<PreferencesPanel> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isActivated()) continue;
            iterator.remove();
        }
        HashMap<String, PreferencesPanel> map = new HashMap<String, PreferencesPanel>();
        for (PreferencesPanel panel : list) {
            map.put(panel.getPreferencesGroupTitle() + '$' + panel.getPreferencesPanelTitle(), panel);
        }
        this.providers = map.values();
    }

    public Collection<PreferencesPanel> getProviders() {
        return this.providers;
    }
}

