/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.clsp;

import jadx.core.clsp.ClsSet;
import jadx.core.clsp.ClspClass;
import jadx.core.clsp.ClspMethod;
import jadx.core.clsp.SimpleMethodDetails;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClspGraph {
    private static final Logger LOG = LoggerFactory.getLogger(ClspGraph.class);
    private final RootNode root;
    private Map<String, ClspClass> nameMap;
    private Map<String, Set<String>> superTypesCache;
    private Map<String, List<String>> implementsCache;
    private final Set<String> missingClasses = new HashSet<String>();

    public ClspGraph(RootNode rootNode) {
        this.root = rootNode;
    }

    public void load() throws IOException, DecodeException {
        ClsSet set = new ClsSet(this.root);
        set.loadFromClstFile();
        this.addClasspath(set);
    }

    public void addClasspath(ClsSet set) {
        if (this.nameMap != null) {
            throw new JadxRuntimeException("Classpath already loaded");
        }
        this.nameMap = new HashMap<String, ClspClass>(set.getClassesCount());
        set.addToMap(this.nameMap);
    }

    public void addApp(List<ClassNode> classes) {
        if (this.nameMap == null) {
            throw new JadxRuntimeException("Classpath must be loaded first");
        }
        for (ClassNode cls : classes) {
            this.addClass(cls);
        }
    }

    public void initCache() {
        this.fillSuperTypesCache();
        this.fillImplementsCache();
    }

    public boolean isClsKnown(String fullName) {
        return this.nameMap.containsKey(fullName);
    }

    public ClspClass getClsDetails(ArgType type) {
        return this.nameMap.get(type.getObject());
    }

    @Nullable
    public IMethodDetails getMethodDetails(MethodInfo methodInfo) {
        ClspClass cls = this.nameMap.get(methodInfo.getDeclClass().getRawName());
        if (cls == null) {
            return null;
        }
        ClspMethod clspMethod = this.getMethodFromClass(cls, methodInfo);
        if (clspMethod != null) {
            return clspMethod;
        }
        for (ArgType parent : cls.getParents()) {
            ClspMethod methodFromParent;
            ClspClass clspParent = this.getClspClass(parent);
            if (clspParent == null || (methodFromParent = this.getMethodFromClass(clspParent, methodInfo)) == null) continue;
            return methodFromParent;
        }
        return new SimpleMethodDetails(methodInfo);
    }

    private ClspMethod getMethodFromClass(ClspClass cls, MethodInfo methodInfo) {
        return cls.getMethodsMap().get(methodInfo.getShortId());
    }

    private void addClass(ClassNode cls) {
        ArgType clsType = cls.getClassInfo().getType();
        String rawName = clsType.getObject();
        ClspClass clspClass = new ClspClass(clsType, -1);
        clspClass.setParents(ClsSet.makeParentsArray(cls));
        this.nameMap.put(rawName, clspClass);
    }

    public boolean isImplements(String clsName, String implClsName) {
        Set<String> anc = this.getSuperTypes(clsName);
        return anc.contains(implClsName);
    }

    public List<String> getImplementations(String clsName) {
        List<String> list = this.implementsCache.get(clsName);
        return list == null ? Collections.emptyList() : list;
    }

    private void fillImplementsCache() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(this.nameMap.size());
        ArrayList<String> classes = new ArrayList<String>(this.nameMap.keySet());
        Collections.sort(classes);
        for (String cls : classes) {
            for (String st : this.getSuperTypes(cls)) {
                map.computeIfAbsent(st, v -> new ArrayList()).add(cls);
            }
        }
        this.implementsCache = map;
    }

    public String getCommonAncestor(String clsName, String implClsName) {
        if (clsName.equals(implClsName)) {
            return clsName;
        }
        ClspClass cls = this.nameMap.get(implClsName);
        if (cls == null) {
            this.missingClasses.add(clsName);
            return null;
        }
        if (this.isImplements(clsName, implClsName)) {
            return implClsName;
        }
        Set<String> anc = this.getSuperTypes(clsName);
        return this.searchCommonParent(anc, cls);
    }

    private String searchCommonParent(Set<String> anc, ClspClass cls) {
        for (ArgType p : cls.getParents()) {
            String r;
            String name = p.getObject();
            if (anc.contains(name)) {
                return name;
            }
            ClspClass nCls = this.getClspClass(p);
            if (nCls == null || (r = this.searchCommonParent(anc, nCls)) == null) continue;
            return r;
        }
        return null;
    }

    public Set<String> getSuperTypes(String clsName) {
        Set<String> result = this.superTypesCache.get(clsName);
        return result == null ? Collections.emptySet() : result;
    }

    private void fillSuperTypesCache() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(this.nameMap.size());
        HashSet<String> tmpSet = new HashSet<String>();
        for (Map.Entry<String, ClspClass> entry : this.nameMap.entrySet()) {
            ClspClass cls = entry.getValue();
            tmpSet.clear();
            this.addSuperTypes(cls, tmpSet);
            Set<Object> result = tmpSet.isEmpty() ? Collections.emptySet() : new HashSet<String>(tmpSet);
            map.put(cls.getName(), result);
        }
        this.superTypesCache = map;
    }

    private void addSuperTypes(ClspClass cls, Set<String> result) {
        for (ArgType parentType : cls.getParents()) {
            if (parentType == null) continue;
            ClspClass parentCls = this.getClspClass(parentType);
            if (parentCls != null) {
                boolean isNew = result.add(parentCls.getName());
                if (!isNew) continue;
                this.addSuperTypes(parentCls, result);
                continue;
            }
            result.add(parentType.getObject());
        }
    }

    @Nullable
    private ClspClass getClspClass(ArgType clsType) {
        ClspClass clspClass = this.nameMap.get(clsType.getObject());
        if (clspClass == null) {
            this.missingClasses.add(clsType.getObject());
        }
        return clspClass;
    }

    public void printMissingClasses() {
        int count = this.missingClasses.size();
        if (count == 0) {
            return;
        }
        LOG.warn("Found {} references to unknown classes", (Object)count);
        if (LOG.isDebugEnabled()) {
            ArrayList<String> clsNames = new ArrayList<String>(this.missingClasses);
            Collections.sort(clsNames);
            for (String cls : clsNames) {
                LOG.debug("  {}", (Object)cls);
            }
        }
    }
}

