'''OpenGL extension EXT.texture_rg

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.texture_rg to provide a more 
Python-friendly API

Overview (from the spec)
	
	Historically one- and two-component textures have been specified in OpenGL
	ES using the luminance or luminance-alpha (L/LA) formats. With the advent
	of programmable shaders and render-to-texture capabilities these legacy
	formats carry some historical artifacts which are no longer useful.
	
	For example, when sampling from such textures, the luminance values are
	replicated across the color components. This is no longer necessary with
	programmable shaders.
	
	It is also desirable to be able to render to one- and two-component format
	textures using capabilities such as framebuffer objects (FBO), but
	rendering to L/LA formats is under-specified (specifically how to map
	R/G/B/A values to L/A texture channels).
	
	This extension adds new base internal formats for one-component RED and
	two-component RG (red green) textures as well as sized RED and RG internal
	formats for renderbuffers. The RED and RG texture formats can be used for
	both texturing and rendering into with framebuffer objects.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture_rg.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.texture_rg import *
from OpenGL.raw.GLES2.EXT.texture_rg import _EXTENSION_NAME

def glInitTextureRgEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
from OpenGL import images as _images
_images.COMPONENT_COUNTS.update( {
GL_R8_EXT:1,
GL_RED_EXT:1,
GL_RG8_EXT:2,
GL_RG_EXT:2,
})
