'''OpenGL extension EXT.shader_io_blocks

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.shader_io_blocks to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension extends the functionality of interface blocks to
	support input and output interfaces in the OpenGL ES Shading Language.
	
	Input and output interface blocks are used for forming the
	interfaces between vertex, tessellation control, tessellation
	evaluation, geometry and fragment shaders. This accommodates passing
	arrays between stages, which otherwise would require multi-dimensional
	array support for tessellation control outputs and for tessellation
	control, tessellation evaluation, and geometry shader inputs.
	
	This extension provides support for application defined
	interface blocks which are used for passing application-specific
	information between shader stages.
	
	This extension moves the built-in "per-vertex" in/out variables
	to a new built-in gl_PerVertex block. This is necessary for
	tessellation and geometry shaders which require a separate
	instance for each vertex, but it can also be useful for vertex
	shaders.
	
	Finally, this extension allows the redeclaration of the
	gl_PerVertex block in order to reduce the set of variables that must
	be passed between shaders.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/shader_io_blocks.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.shader_io_blocks import *
from OpenGL.raw.GLES2.EXT.shader_io_blocks import _EXTENSION_NAME

def glInitShaderIoBlocksEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION