'''OpenGL extension ARB.vertex_type_2_10_10_10_rev

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.vertex_type_2_10_10_10_rev to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds the following data formats:
	
	Two new vertex attribute data formats: a signed 2.10.10.10 and an
	unsigned 2.10.10.10 vertex data format. These vertex data formats
	describe a 4 component stream which can be used to store normals or
	other attributes in a quantized form. Normals, tangents, binormals
	and other vertex attributes can often be specified at reduced
	precision without introducing noticeable artifacts, reducing the
	amount of memory and memory bandwidth they consume.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/vertex_type_2_10_10_10_rev.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.vertex_type_2_10_10_10_rev import *
from OpenGL.raw.GL.ARB.vertex_type_2_10_10_10_rev import _EXTENSION_NAME

def glInitVertexType2101010RevARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glVertexAttribP1uiv=wrapper.wrapper(glVertexAttribP1uiv).setInputArraySize(
    'value', 1
)
glVertexAttribP2uiv=wrapper.wrapper(glVertexAttribP2uiv).setInputArraySize(
    'value', 1
)
glVertexAttribP3uiv=wrapper.wrapper(glVertexAttribP3uiv).setInputArraySize(
    'value', 1
)
glVertexAttribP4uiv=wrapper.wrapper(glVertexAttribP4uiv).setInputArraySize(
    'value', 1
)
glVertexP2uiv=wrapper.wrapper(glVertexP2uiv).setInputArraySize(
    'value', 1
)
glVertexP3uiv=wrapper.wrapper(glVertexP3uiv).setInputArraySize(
    'value', 1
)
glVertexP4uiv=wrapper.wrapper(glVertexP4uiv).setInputArraySize(
    'value', 1
)
glTexCoordP1uiv=wrapper.wrapper(glTexCoordP1uiv).setInputArraySize(
    'coords', 1
)
glTexCoordP2uiv=wrapper.wrapper(glTexCoordP2uiv).setInputArraySize(
    'coords', 1
)
glTexCoordP3uiv=wrapper.wrapper(glTexCoordP3uiv).setInputArraySize(
    'coords', 1
)
glTexCoordP4uiv=wrapper.wrapper(glTexCoordP4uiv).setInputArraySize(
    'coords', 1
)
glMultiTexCoordP1uiv=wrapper.wrapper(glMultiTexCoordP1uiv).setInputArraySize(
    'coords', 1
)
glMultiTexCoordP2uiv=wrapper.wrapper(glMultiTexCoordP2uiv).setInputArraySize(
    'coords', 1
)
glMultiTexCoordP3uiv=wrapper.wrapper(glMultiTexCoordP3uiv).setInputArraySize(
    'coords', 1
)
glMultiTexCoordP4uiv=wrapper.wrapper(glMultiTexCoordP4uiv).setInputArraySize(
    'coords', 1
)
glNormalP3uiv=wrapper.wrapper(glNormalP3uiv).setInputArraySize(
    'coords', 1
)
glColorP3uiv=wrapper.wrapper(glColorP3uiv).setInputArraySize(
    'color', 1
)
glColorP4uiv=wrapper.wrapper(glColorP4uiv).setInputArraySize(
    'color', 1
)
glSecondaryColorP3uiv=wrapper.wrapper(glSecondaryColorP3uiv).setInputArraySize(
    'color', 1
)
### END AUTOGENERATED SECTION