'''OpenGL extension ARB.point_sprite

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.point_sprite to provide a more 
Python-friendly API

Overview (from the spec)
	
	Applications such as particle systems have tended to use OpenGL quads
	rather than points to render their geometry, since they would like
	to use a custom-drawn texture for each particle, rather than the
	traditional OpenGL round antialiased points, and each fragment in
	a point has the same texture coordinates as every other fragment.
	
	Unfortunately, specifying the geometry for these quads can be
	expensive, since it quadruples the amount of geometry required, and
	may also require the application to do extra processing to compute
	the location of each vertex.
	
	The purpose of this extension is to allow such applications to use
	points rather than quads.  When GL_POINT_SPRITE_ARB is enabled,
	the state of point antialiasing is ignored.  For each texture unit,
	the app can then specify whether to replace the existing texture
	coordinates with point sprite texture coordinates, which are
	interpolated across the point.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/point_sprite.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.point_sprite import *
from OpenGL.raw.GL.ARB.point_sprite import _EXTENSION_NAME

def glInitPointSpriteARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION