from typing import IO, Any, AnyStr, Callable, Generic, Iterable, Iterator, Text

def input(
    files: Text | Iterable[Text] | None = ...,
    inplace: bool = ...,
    backup: str = ...,
    bufsize: int = ...,
    mode: str = ...,
    openhook: Callable[[Text, str], IO[AnyStr]] = ...,
) -> FileInput[AnyStr]: ...
def close() -> None: ...
def nextfile() -> None: ...
def filename() -> str: ...
def lineno() -> int: ...
def filelineno() -> int: ...
def fileno() -> int: ...
def isfirstline() -> bool: ...
def isstdin() -> bool: ...

class FileInput(Iterable[AnyStr], Generic[AnyStr]):
    def __init__(
        self,
        files: None | Text | Iterable[Text] = ...,
        inplace: bool = ...,
        backup: str = ...,
        bufsize: int = ...,
        mode: str = ...,
        openhook: Callable[[Text, str], IO[AnyStr]] = ...,
    ) -> None: ...
    def __del__(self) -> None: ...
    def close(self) -> None: ...
    def __iter__(self) -> Iterator[AnyStr]: ...
    def __next__(self) -> AnyStr: ...
    def __getitem__(self, i: int) -> AnyStr: ...
    def nextfile(self) -> None: ...
    def readline(self) -> AnyStr: ...
    def filename(self) -> str: ...
    def lineno(self) -> int: ...
    def filelineno(self) -> int: ...
    def fileno(self) -> int: ...
    def isfirstline(self) -> bool: ...
    def isstdin(self) -> bool: ...

def hook_compressed(filename: Text, mode: str) -> IO[Any]: ...
def hook_encoded(encoding: str) -> Callable[[Text, str], IO[Any]]: ...
