info = {
    "name": "bg",
    "date_order": "DMY",
    "january": [
        "яну",
        "януари",
        "ян"
    ],
    "february": [
        "фев",
        "февруари",
        "фв"
    ],
    "march": [
        "март"
    ],
    "april": [
        "апр",
        "април",
        "ап"
    ],
    "may": [
        "май"
    ],
    "june": [
        "юни",
        "юн"
    ],
    "july": [
        "юли",
        "юл"
    ],
    "august": [
        "авг",
        "август"
    ],
    "september": [
        "сеп",
        "септември",
        "септ",
        "септм"
    ],
    "october": [
        "окт",
        "октомври"
    ],
    "november": [
        "ное",
        "ноември"
    ],
    "december": [
        "дек",
        "декември"
    ],
    "monday": [
        "пн",
        "понеделник",
        "пон"
    ],
    "tuesday": [
        "вт",
        "вторник",
        "вто"
    ],
    "wednesday": [
        "ср",
        "сряда",
        "сря"
    ],
    "thursday": [
        "четвъртък",
        "чт"
    ],
    "friday": [
        "петък",
        "пт"
    ],
    "saturday": [
        "сб",
        "събота"
    ],
    "sunday": [
        "нд",
        "неделя"
    ],
    "am": [
        "am",
        "проб"
    ],
    "pm": [
        "pm",
        "слоб"
    ],
    "year": [
        "г",
        "година",
        "год",
        "години"
    ],
    "month": [
        "м",
        "месец",
        "мес",
        "месеци"
    ],
    "week": [
        "седм",
        "седмица",
        "с",
        "сед",
        "седмици"
    ],
    "day": [
        "д",
        "ден",
        "дни",
        "дена"
    ],
    "hour": [
        "ч",
        "час",
        "часа"
    ],
    "minute": [
        "мин",
        "минута",
        "минути"
    ],
    "second": [
        "с",
        "секунда",
        "сек",
        "секунди"
    ],
    "relative-type": {
        "0 day ago": [
            "днес"
        ],
        "0 hour ago": [
            "в този час"
        ],
        "0 minute ago": [
            "в тази минута"
        ],
        "0 month ago": [
            "т м",
            "този мес",
            "този месец"
        ],
        "0 second ago": [
            "сега"
        ],
        "0 week ago": [
            "тази седм",
            "тази седмица"
        ],
        "0 year ago": [
            "т г",
            "тази година"
        ],
        "1 day ago": [
            "вчера",
            "снощи",
            "преди ден"
        ],
        "1 month ago": [
            "мин м",
            "мин мес",
            "предходен месец"
        ],
        "1 week ago": [
            "мин седм",
            "миналата седмица",
            "предходната седмица",
            "преди седмица"
        ],
        "1 year ago": [
            "мин г",
            "миналата година",
            "преди година"
        ],
        "in 1 day": [
            "утре",
            "след ден"
        ],
        "in 1 month": [
            "сл м",
            "следв мес",
            "следващ месец"
        ],
        "in 1 week": [
            "сл седм",
            "следв седм",
            "следващата седмица"
        ],
        "in 1 year": [
            "сл г",
            "следв г",
            "следващата година"
        ],
        "10 year ago": [
            "преди десетилетие"
        ],
        "in 10 year": [
            "след 1 десетилетие"
        ],
        "2 day ago": [
            "онзи ден"
        ],
        "in 2 day": [
            "вдругиден"
        ],
        "1 hour ago": [
            "преди час"
        ],
        "in 1 hour": [
            "след час"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "пр (\\d+[.,]?\\d*) д",
            "преди (\\d+[.,]?\\d*) ден",
            "преди (\\d+[.,]?\\d*) дни"
        ],
        "\\1 hour ago": [
            "пр (\\d+[.,]?\\d*) ч",
            "преди (\\d+[.,]?\\d*) ч",
            "преди (\\d+[.,]?\\d*) час",
            "преди (\\d+[.,]?\\d*) часа"
        ],
        "\\1 minute ago": [
            "пр (\\d+[.,]?\\d*) мин",
            "преди (\\d+[.,]?\\d*) мин",
            "преди (\\d+[.,]?\\d*) минута",
            "преди (\\d+[.,]?\\d*) минути"
        ],
        "\\1 month ago": [
            "пр (\\d+[.,]?\\d*) м",
            "преди (\\d+[.,]?\\d*) м",
            "преди (\\d+[.,]?\\d*) месец",
            "преди (\\d+[.,]?\\d*) месеца"
        ],
        "\\1 second ago": [
            "пр (\\d+[.,]?\\d*) сек",
            "преди (\\d+[.,]?\\d*) сек",
            "преди (\\d+[.,]?\\d*) секунда",
            "преди (\\d+[.,]?\\d*) секунди"
        ],
        "\\1 week ago": [
            "пр (\\d+[.,]?\\d*) седм",
            "преди (\\d+[.,]?\\d*) седм",
            "преди (\\d+[.,]?\\d*) седмица",
            "преди (\\d+[.,]?\\d*) седмици"
        ],
        "\\1 year ago": [
            "пр (\\d+[.,]?\\d*) г",
            "преди (\\d+[.,]?\\d*) г",
            "преди (\\d+[.,]?\\d*) година",
            "преди (\\d+[.,]?\\d*) години"
        ],
        "in \\1 day": [
            "сл (\\d+[.,]?\\d*) д",
            "след (\\d+[.,]?\\d*) ден",
            "след (\\d+[.,]?\\d*) дни"
        ],
        "in \\1 hour": [
            "сл (\\d+[.,]?\\d*) ч",
            "след (\\d+[.,]?\\d*) ч",
            "след (\\d+[.,]?\\d*) час",
            "след (\\d+[.,]?\\d*) часа"
        ],
        "in \\1 minute": [
            "сл (\\d+[.,]?\\d*) мин",
            "след (\\d+[.,]?\\d*) мин",
            "след (\\d+[.,]?\\d*) минута",
            "след (\\d+[.,]?\\d*) минути"
        ],
        "in \\1 month": [
            "сл (\\d+[.,]?\\d*) м",
            "след (\\d+[.,]?\\d*) м",
            "след (\\d+[.,]?\\d*) месец",
            "след (\\d+[.,]?\\d*) месеца"
        ],
        "in \\1 second": [
            "сл (\\d+[.,]?\\d*) сек",
            "след (\\d+[.,]?\\d*) сек",
            "след (\\d+[.,]?\\d*) секунда",
            "след (\\d+[.,]?\\d*) секунди"
        ],
        "in \\1 week": [
            "сл (\\d+[.,]?\\d*) седм",
            "след (\\d+[.,]?\\d*) седм",
            "след (\\d+[.,]?\\d*) седмица",
            "след (\\d+[.,]?\\d*) седмици"
        ],
        "in \\1 year": [
            "сл (\\d+[.,]?\\d*) г",
            "след (\\d+[.,]?\\d*) г",
            "след (\\d+[.,]?\\d*) година",
            "след (\\d+[.,]?\\d*) години"
        ]
    },
    "locale_specific": {},
    "skip": [
        "върху",
        "до",
        "на",
        "около",
        "от",
        "под",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "преди"
    ],
    "in": [
        "след",
        "после",
        "подир"
    ],
    "simplifications": [
        {
            "един": "1"
        },
        {
            "два": "2"
        },
        {
            "три": "3"
        }
    ]
}
