/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioSignal;
import processing.core.PApplet;

public class WhiteNoise
implements AudioSignal {
    protected float amp;
    protected float pan;
    protected float leftScale;
    protected float rightScale;

    public WhiteNoise() {
        this.amp = 1.0f;
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
    }

    public WhiteNoise(float amp) {
        this.setAmp(amp);
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
    }

    public void setAmp(float a) {
        this.amp = PApplet.constrain((float)a, (float)0.0f, (float)1.0f);
    }

    public void setPan(float p) {
        this.pan = PApplet.constrain((float)p, (float)-1.0f, (float)1.0f);
        this.calcLRScale();
    }

    public void generate(float[] signal) {
        int i = 0;
        while (i < signal.length) {
            signal[i] = this.amp * (2.0f * (float)Math.random() - 1.0f);
            ++i;
        }
    }

    public void generate(float[] left, float[] right) {
        int i = 0;
        while (i < left.length) {
            left[i] = this.leftScale * this.amp * (2.0f * (float)Math.random() - 1.0f);
            right[i] = this.rightScale * this.amp * (2.0f * (float)Math.random() - 1.0f);
            ++i;
        }
    }

    private void calcLRScale() {
        if (this.pan <= 0.0f) {
            this.rightScale = PApplet.map((float)this.pan, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.leftScale = 1.0f;
        }
        if (this.pan >= 0.0f) {
            this.leftScale = PApplet.map((float)this.pan, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            this.rightScale = 1.0f;
        }
        if (this.pan == 0.0f) {
            this.rightScale = 1.0f;
            this.leftScale = 1.0f;
        }
    }
}

