/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.syntax.PdeKeywords;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaEditor;
import processing.mode.java.runner.Runner;

public class JavaMode
extends Mode {
    public Editor createEditor(Base base, String path, int[] location) {
        return new JavaEditor(base, path, location, this);
    }

    public JavaMode(Base base, File folder) {
        super(base, folder);
        try {
            this.loadKeywords();
        }
        catch (IOException e) {
            Base.showError("Problem loading keywords", "Could not load keywords.txt, please re-install Processing.", e);
        }
    }

    protected void loadKeywords() throws IOException {
        File file = new File(this.folder, "keywords.txt");
        BufferedReader reader = PApplet.createReader((File)file);
        this.tokenMarker = new PdeKeywords();
        this.keywordToReference = new HashMap();
        String line = null;
        while ((line = reader.readLine()) != null) {
            String htmlFilename;
            String[] pieces = PApplet.trim((String[])PApplet.split((String)line, (char)'\t'));
            if (pieces.length < 2) continue;
            String keyword = pieces[0];
            String coloring = pieces[1];
            if (coloring.length() > 0) {
                this.tokenMarker.addColoring(keyword, coloring);
            }
            if (pieces.length != 3 || (htmlFilename = pieces[2]).length() <= 0) continue;
            this.keywordToReference.put(keyword, htmlFilename);
        }
    }

    public String getTitle() {
        return "Standard";
    }

    public File[] getExampleCategoryFolders() {
        return new File[]{new File(this.examplesFolder, "Basics"), new File(this.examplesFolder, "Topics"), new File(this.examplesFolder, "3D"), new File(this.examplesFolder, "Books")};
    }

    public String getDefaultExtension() {
        return "pde";
    }

    public String[] getExtensions() {
        return new String[]{"pde", "java"};
    }

    public String[] getIgnorable() {
        return new String[]{"applet", "application.macosx", "application.windows", "application.linux"};
    }

    public Runner handleRun(Sketch sketch, RunnerListener listener) throws SketchException {
        JavaBuild build = new JavaBuild(sketch);
        String appletClassName = build.build();
        if (appletClassName != null) {
            final Runner runtime = new Runner(build, listener);
            new Thread(new Runnable(){

                public void run() {
                    runtime.launch(false);
                }
            }).start();
            return runtime;
        }
        return null;
    }

    public Runner handlePresent(Sketch sketch, RunnerListener listener) throws SketchException {
        JavaBuild build = new JavaBuild(sketch);
        String appletClassName = build.build();
        if (appletClassName != null) {
            final Runner runtime = new Runner(build, listener);
            new Thread(new Runnable(){

                public void run() {
                    runtime.launch(true);
                }
            }).start();
            return runtime;
        }
        return null;
    }

    public boolean handleExportApplet(Sketch sketch) throws SketchException, IOException {
        JavaBuild build = new JavaBuild(sketch);
        return build.exportApplet();
    }

    public boolean handleExportApplication(Sketch sketch) throws SketchException, IOException {
        JavaBuild build = new JavaBuild(sketch);
        return build.exportApplication();
    }
}

