/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import processing.app.exec.ProcessResult;
import processing.app.tools.android.AndroidDevice;
import processing.app.tools.android.AndroidSDK;
import processing.app.tools.android.EmulatorController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AndroidEnvironment {
    private static final String ADB_DEVICES_ERROR = "Received unfamiliar output from \u201cadb devices\u201d.\nThe device list may have errors.";
    private static final AndroidEnvironment INSTANCE = new AndroidEnvironment();
    private final Map<String, AndroidDevice> devices = new ConcurrentHashMap<String, AndroidDevice>();
    private final ExecutorService deviceLaunchThread = Executors.newSingleThreadExecutor();

    public static AndroidEnvironment getInstance() {
        return INSTANCE;
    }

    public static void killAdbServer() {
        System.err.println("Shutting down any existing adb server...");
        System.err.flush();
        try {
            AndroidSDK.runADB("kill-server");
        }
        catch (Exception exception) {
            System.err.println("failed.");
            System.err.println();
            exception.printStackTrace(System.err);
        }
    }

    private AndroidEnvironment() {
        System.out.println("Starting up AndroidEnvironment");
        Runtime.getRuntime().addShutdownHook(new Thread("AndroidEnvironment Shutdown"){

            public void run() {
                AndroidEnvironment.this.shutdown();
            }
        });
    }

    private void shutdown() {
        System.out.println("Shutting down AndroidEnvironment");
        for (AndroidDevice androidDevice : new ArrayList<AndroidDevice>(this.devices.values())) {
            androidDevice.shutdown();
        }
        AndroidEnvironment.killAdbServer();
    }

    public Future<AndroidDevice> getEmulator() {
        Callable<AndroidDevice> callable = new Callable<AndroidDevice>(){

            @Override
            public AndroidDevice call() throws Exception {
                return AndroidEnvironment.this.blockingGetEmulator();
            }
        };
        FutureTask<AndroidDevice> futureTask = new FutureTask<AndroidDevice>(callable);
        this.deviceLaunchThread.execute(futureTask);
        return futureTask;
    }

    private final AndroidDevice blockingGetEmulator() {
        AndroidDevice androidDevice = this.find(true);
        if (androidDevice != null) {
            return androidDevice;
        }
        EmulatorController emulatorController = EmulatorController.getInstance();
        if (emulatorController.getState() == EmulatorController.State.NOT_RUNNING) {
            try {
                emulatorController.launch();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                return null;
            }
        }
        while (!Thread.currentThread().isInterrupted()) {
            if (emulatorController.getState() == EmulatorController.State.NOT_RUNNING) {
                System.err.println("Ouch. Emulator got killed, I think.");
                return null;
            }
            androidDevice = this.find(true);
            if (androidDevice != null) {
                return androidDevice;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("AndroidEnvironment: interrupted in loop.");
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AndroidDevice find(boolean bl) {
        this.refresh();
        Map<String, AndroidDevice> map = this.devices;
        synchronized (map) {
            for (AndroidDevice androidDevice : this.devices.values()) {
                boolean bl2 = androidDevice.getId().contains("emulator");
                if ((!bl2 || !bl) && (bl2 || bl)) continue;
                return androidDevice;
            }
        }
        return null;
    }

    public Future<AndroidDevice> getHardware() {
        Callable<AndroidDevice> callable = new Callable<AndroidDevice>(){

            @Override
            public AndroidDevice call() throws Exception {
                return AndroidEnvironment.this.blockingGetHardware();
            }
        };
        FutureTask<AndroidDevice> futureTask = new FutureTask<AndroidDevice>(callable);
        this.deviceLaunchThread.execute(futureTask);
        return futureTask;
    }

    private final AndroidDevice blockingGetHardware() {
        AndroidDevice androidDevice = this.find(false);
        if (androidDevice != null) {
            return androidDevice;
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            androidDevice = this.find(false);
            if (androidDevice == null) continue;
            return androidDevice;
        }
        return null;
    }

    private void refresh() {
        List<String> list = AndroidEnvironment.listDevices();
        for (String string : list) {
            if (this.devices.containsKey(string)) continue;
            this.addDevice(new AndroidDevice(this, string));
        }
    }

    private void addDevice(AndroidDevice androidDevice) {
        try {
            androidDevice.initialize();
            if (this.devices.put(androidDevice.getId(), androidDevice) != null) {
                throw new IllegalStateException("Adding " + androidDevice + ", which already exists!");
            }
        }
        catch (Exception exception) {
            System.err.println("While initializing " + androidDevice.getId() + ": " + exception);
        }
    }

    void deviceRemoved(AndroidDevice androidDevice) {
        if (this.devices.remove(androidDevice.getId()) == null) {
            throw new IllegalStateException("I didn't know about device " + androidDevice.getId() + "!");
        }
    }

    public static List<String> listDevices() {
        ProcessResult processResult;
        try {
            processResult = AndroidSDK.runADB("devices");
        }
        catch (InterruptedException interruptedException) {
            return Collections.emptyList();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return Collections.emptyList();
        }
        if (!processResult.succeeded()) {
            if (processResult.getStderr().contains("protocol fault (no status)")) {
                System.err.println("bleh: " + processResult);
            } else {
                System.err.println("nope: " + processResult);
            }
            return Collections.emptyList();
        }
        String string = processResult.getStdout();
        if (!string.startsWith("List of devices") && string.trim().length() != 0) {
            System.err.println(ADB_DEVICES_ERROR);
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : processResult) {
            String[] stringArray;
            if (!string2.contains("\t") || !(stringArray = string2.split("\t"))[1].equals("device")) continue;
            arrayList.add(stringArray[0]);
        }
        return arrayList;
    }
}

