/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.Dxf14Converter;
import de.escape.quincunx.dxf.reader.DxfBLOCK;
import de.escape.quincunx.dxf.reader.DxfBlocks;
import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfEntities;
import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfGroups;
import de.escape.quincunx.dxf.reader.DxfHeader;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.dxf.reader.DxfLTYPE;
import de.escape.quincunx.dxf.reader.DxfReaderReporter;
import de.escape.quincunx.dxf.reader.DxfReporter;
import de.escape.quincunx.dxf.reader.DxfSTYLE;
import de.escape.quincunx.dxf.reader.DxfSection;
import de.escape.quincunx.dxf.reader.DxfTables;
import de.escape.quincunx.i18n.I18n;
import java.io.InputStream;
import java.util.Hashtable;

public class DxfFile
implements DxfReaderReporter {
    static final int DEBUG_LEVEL = 0;
    protected DxfHeader header;
    protected DxfTables tables;
    protected DxfBlocks blocks;
    protected DxfEntities entities;
    protected DxfGroups grp;
    protected DxfReporter reporter;
    protected Hashtable countHash = new Hashtable();

    public DxfFile(String path, DxfReporter report) throws DxfException {
        this.reporter = report;
        this.grp = new DxfGroups(path, this, (DxfReaderReporter)this);
        this.read();
    }

    public DxfFile(String path) throws DxfException {
        this(path, null);
    }

    public DxfFile(InputStream is, DxfReporter report) throws DxfException {
        this.reporter = report;
        this.grp = new DxfGroups(is, this, (DxfReaderReporter)this);
        this.read();
    }

    public DxfFile(InputStream is) throws DxfException {
        this(is, null);
    }

    private void read() throws DxfException {
        block15: {
            while (true) {
                this.grp.read();
                if (this.grp.number != 0) break block15;
                String code = this.grp.valToString();
                if (code.equals("SECTION")) {
                    this.grp.read();
                    if (this.grp.number != 2) {
                        throw new DxfException("err!FpFormat", new String[]{String.valueOf(this.grp.getLineNr())});
                    }
                    code = this.grp.valToString();
                    if (code.equals("HEADER")) {
                        this.showStatusRes("msgReading", new String[]{"HEADER"});
                        this.header = new DxfHeader();
                        this.header.read(this.grp, this);
                        continue;
                    }
                    if (code.equals("TABLES")) {
                        this.showStatusRes("msgReading", new String[]{"TABLES"});
                        this.tables = new DxfTables();
                        this.tables.read(this.grp, this);
                        continue;
                    }
                    if (code.equals("CLASSES")) {
                        this.showStatusRes("msgReading", new String[]{"CLASSES"});
                        new DxfSection(false).read(this.grp, this);
                        continue;
                    }
                    if (code.equals("OBJECTS")) {
                        this.showStatusRes("msgReading", new String[]{"OBJECTS"});
                        new DxfSection(false).read(this.grp, this);
                        continue;
                    }
                    if (code.equals("BLOCKS")) {
                        this.showStatusRes("msgReading", new String[]{"BLOCKS"});
                        this.blocks = new DxfBlocks();
                        this.blocks.read(this.grp, this);
                        continue;
                    }
                    if (code.equals("ENTITIES")) {
                        this.showStatusRes("msgReading", new String[]{"ENTITIES"});
                        this.entities = new DxfEntities();
                        this.entities.read(this.grp, this);
                        continue;
                    }
                    DxfSection foo = new DxfSection();
                    foo.read(this.grp, this);
                    continue;
                }
                if (code.equals("EOF")) break;
            }
            this.showStatusRes("msgEOF");
            if (this.getLayer("0", false) == null) {
                this.getTables().createLayer0(this);
            }
            if (this.getLtype("CONTINUOUS") == null) {
                this.getTables().createLtypeContinuous(this);
            }
            if (this.getStyle("STANDARD") == null) {
                this.getTables().createStyleStd(this);
            }
            if (this.header == null) {
                this.showWarningRes("warnNoHeader");
                this.header = new DxfHeader();
            } else if (this.header.getACADVER() == null) {
                this.showWarningRes("warnNoAcadver");
            }
            return;
        }
        throw new DxfException("err!Syntax", new String[]{String.valueOf(this.grp.getLineNr())});
    }

    public void showStatus(String msg) {
        if (this.reporter != null) {
            this.reporter.showStatus(msg);
        }
    }

    public void showStatusRes(String tag) {
        if (this.reporter != null) {
            this.reporter.showStatusRes(tag);
        }
    }

    public void showStatusRes(String tag, String[] args) {
        if (this.reporter != null) {
            this.reporter.showStatusRes(tag, args);
        }
    }

    public void showWarning(String msg) {
        if (this.reporter != null) {
            this.reporter.showWarning(msg);
        }
    }

    public void showWarningRes(String tag) {
        if (this.reporter != null) {
            this.reporter.showWarningRes(tag);
        }
    }

    public void showWarningRes(String tag, String[] args) {
        if (this.reporter != null) {
            this.reporter.showWarningRes(tag, args);
        }
    }

    public void countEntity(String name) {
        Counter nr = (Counter)this.countHash.get(name);
        if (nr != null) {
            nr.increase();
        } else {
            nr = new Counter();
            nr.increase();
            this.countHash.put(name, nr);
        }
    }

    public void warnUnknownEntity(String name) {
        Counter nr = (Counter)this.countHash.get(name);
        if (nr != null) {
            nr.increase();
        } else {
            nr = new Counter();
            nr.increase();
            this.countHash.put(name, nr);
            this.showWarningRes("warnUnknownEntity", new String[]{name});
        }
    }

    public void showProgress() {
        if (this.reporter != null) {
            this.reporter.showProgress();
        }
    }

    public void showProgress(float level) {
        if (this.reporter != null) {
            this.reporter.showProgress(level);
        }
    }

    public void showProgress(float level, float maxLevel) {
        if (this.reporter != null) {
            this.reporter.showProgress(level, maxLevel);
        }
    }

    public void showProgress(long level, long maxLevel) {
        if (this.reporter != null) {
            this.reporter.showProgress(level, maxLevel);
        }
    }

    public DxfLAYER getLayer(String name, boolean refer) {
        return this.getTables().getLayer(name, refer);
    }

    public DxfLAYER getLayer(String name) {
        return this.getTables().getLayer(name, true);
    }

    public DxfLTYPE getLtype(String name) {
        return this.getTables().getLtype(name);
    }

    public DxfLTYPE[] getLtypes() {
        return this.getTables().getLtypes();
    }

    public DxfBLOCK getBlock(String name) {
        return this.blocks != null ? (DxfBLOCK)this.blocks.getBlock(name) : null;
    }

    public DxfSTYLE getStyle(String name) {
        return this.getTables().getStyle(name);
    }

    public Hashtable getLayerTable() {
        return this.getTables().getLayerTable();
    }

    public int getLayerTableLength() {
        return this.getTables().getLayerTableLength();
    }

    public void convert(DxfConverter converter) {
        converter.convert(this);
    }

    public void convert(Dxf14Converter converter) {
        converter.convert(this);
    }

    public int getCodePage() {
        return this.header.getCodePage();
    }

    public DxfHeader getHeader() {
        return this.header;
    }

    public DxfTables getTables() {
        if (this.tables == null) {
            this.tables = new DxfTables();
        }
        return this.tables;
    }

    public DxfBlocks getBlocks() {
        return this.blocks;
    }

    public DxfEntities getEntities() {
        return this.entities;
    }

    static {
        I18n.addAppResourceBase("de.escape.quincunx.dxf.reader.DxfReaderResourceBundle");
    }

    static class Counter {
        private int count;

        public void increase() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return Integer.toString(this.count);
        }

        Counter() {
        }
    }
}

