/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import java.awt.event.MouseEvent;

public class SelectionTool
extends AbstractTool {
    private Tool fChild = null;

    public SelectionTool(DrawingView drawingView) {
        super(drawingView);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            return;
        }
        this.view().freezeView();
        Handle handle = this.view().findHandle(mouseEvent.getX(), mouseEvent.getY());
        if (handle != null) {
            this.fChild = this.createHandleTracker(this.view(), handle);
        } else {
            Figure figure = this.drawing().findFigure(mouseEvent.getX(), mouseEvent.getY());
            if (figure != null) {
                this.fChild = this.createDragTracker(this.view(), figure);
            } else {
                if (!mouseEvent.isShiftDown()) {
                    this.view().clearSelection();
                }
                this.fChild = this.createAreaTracker(this.view());
            }
        }
        this.fChild.mouseDown(mouseEvent, n, n2);
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(mouseEvent, n, n2);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        this.view().unfreezeView();
        if (this.fChild != null) {
            this.fChild.mouseUp(mouseEvent, n, n2);
        }
        this.fChild = null;
    }

    protected Tool createHandleTracker(DrawingView drawingView, Handle handle) {
        return new HandleTracker(drawingView, handle);
    }

    protected Tool createDragTracker(DrawingView drawingView, Figure figure) {
        return new DragTracker(drawingView, figure);
    }

    protected Tool createAreaTracker(DrawingView drawingView) {
        return new SelectAreaTracker(drawingView);
    }
}

